<?php
/**
 * Font awesome icons array array file.
 *
 * @author  Brainstorm Force
 * @package Astra
 * @todo    If this icon file updates via grunt, it's default version is minified. But to get the icons label available on translate wordpress.org we need to unminify it. Use tool: https://beautifytools.com/php-beautifier.php
 */

/**
 * Returns font awesome icons array
 */
return array(
	'cross'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M383.1 160v64c0 17.62-14.37 32-31.1 32h-96v224c0 17.62-14.38 32-31.1 32H160c-17.62 0-32-14.38-32-32V256h-96C14.37 256-.0008 241.6-.0008 224V160c0-17.62 14.38-32 32-32h96V32c0-17.62 14.38-32 32-32h64c17.62 0 31.1 14.38 31.1 32v96h96C369.6 128 383.1 142.4 383.1 160z',
			),
		),
		'label'             => __( 'Cross', 'astra' ),
		'custom_categories' => array(),
	),
	'crosshairs'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M224 256C224 238.3 238.3 224 256 224C273.7 224 288 238.3 288 256C288 273.7 273.7 288 256 288C238.3 288 224 273.7 224 256zM256 0C273.7 0 288 14.33 288 32V42.35C381.7 56.27 455.7 130.3 469.6 224H480C497.7 224 512 238.3 512 256C512 273.7 497.7 288 480 288H469.6C455.7 381.7 381.7 455.7 288 469.6V480C288 497.7 273.7 512 256 512C238.3 512 224 497.7 224 480V469.6C130.3 455.7 56.27 381.7 42.35 288H32C14.33 288 0 273.7 0 256C0 238.3 14.33 224 32 224H42.35C56.27 130.3 130.3 56.27 224 42.35V32C224 14.33 238.3 0 256 0V0zM224 404.6V384C224 366.3 238.3 352 256 352C273.7 352 288 366.3 288 384V404.6C346.3 392.1 392.1 346.3 404.6 288H384C366.3 288 352 273.7 352 256C352 238.3 366.3 224 384 224H404.6C392.1 165.7 346.3 119.9 288 107.4V128C288 145.7 273.7 160 256 160C238.3 160 224 145.7 224 128V107.4C165.7 119.9 119.9 165.7 107.4 224H128C145.7 224 160 238.3 160 256C160 273.7 145.7 288 128 288H107.4C119.9 346.3 165.7 392.1 224 404.6z',
			),
		),
		'label'             => __( 'Crosshairs', 'astra' ),
		'custom_categories' => array(
			'design',
			'travel',
		),
	),
	'crow'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M523.9 31.1H574C603.4 31.1 628.1 51.99 636.1 80.48L640 95.1L544 119.1V191.1C544 279.1 484.9 354.1 404.2 376.8L446.2 478.9C451.2 491.1 445.4 505.1 433.1 510.2C420.9 515.2 406.9 509.4 401.8 497.1L355.2 383.1C354.1 383.1 353.1 384 352 384H311.1L350.2 478.9C355.2 491.1 349.4 505.1 337.1 510.2C324.9 515.2 310.9 509.4 305.8 497.1L259.2 384H126.1L51.51 441.4C37.5 452.1 17.41 449.5 6.638 435.5C-4.138 421.5-1.517 401.4 12.49 390.6L368 117.2V88C368 39.4 407.4 0 456 0C483.3 0 507.7 12.46 523.9 32V31.1zM456 111.1C469.3 111.1 480 101.3 480 87.1C480 74.74 469.3 63.1 456 63.1C442.7 63.1 432 74.74 432 87.1C432 101.3 442.7 111.1 456 111.1z',
			),
		),
		'label'             => __( 'Crow', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'crown'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M576 136c0 22.09-17.91 40-40 40c-.248 0-.4551-.1266-.7031-.1305l-50.52 277.9C482 468.9 468.8 480 453.3 480H122.7c-15.46 0-28.72-11.06-31.48-26.27L40.71 175.9C40.46 175.9 40.25 176 39.1 176c-22.09 0-40-17.91-40-40S17.91 96 39.1 96s40 17.91 40 40c0 8.998-3.521 16.89-8.537 23.57l89.63 71.7c15.91 12.73 39.5 7.544 48.61-10.68l57.6-115.2C255.1 98.34 247.1 86.34 247.1 72C247.1 49.91 265.9 32 288 32s39.1 17.91 39.1 40c0 14.34-7.963 26.34-19.3 33.4l57.6 115.2c9.111 18.22 32.71 23.4 48.61 10.68l89.63-71.7C499.5 152.9 496 144.1 496 136C496 113.9 513.9 96 536 96S576 113.9 576 136z',
			),
		),
		'label'             => __( 'Crown', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'crutch'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M502.6 168.1l-159.6-159.5c-12.54-12.54-32.85-12.6-45.46-.1256c-12.68 12.54-12.73 33.1-.1256 45.71l159.6 159.5c12.6 12.59 33.03 12.57 45.59-.0628C515.1 201.9 515.1 181.5 502.6 168.1zM334.4 245.4l-67.88-67.87l55.13-55.12l-45.25-45.25L166.7 186.8C154.1 199.6 145.2 215.6 141.1 233.2L113.3 353.4l-108.6 108.6c-6.25 6.25-6.25 16.37 0 22.62l22.63 22.62c6.25 6.25 16.38 6.25 22.63 0l108.6-108.6l120.3-27.75c17.5-4.125 33.63-13 46.38-25.62l109.6-109.7l-45.25-45.25L334.4 245.4zM279.9 300.1C275.7 304.2 270.3 307.2 264.4 308.6l-79.25 18.25l18.25-79.25c1.375-5.875 4.375-11.25 8.5-15.5l9.375-9.25l67.88 67.87L279.9 300.1z',
			),
		),
		'label'             => __( 'Crutch', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'cruzeiro-sign'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M159.1 402.7V256C159.1 238.3 174.3 224 191.1 224C199.7 224 206.8 226.7 212.3 231.3C223 226.6 234.8 224 247.3 224C264.5 224 281.3 229.1 295.7 238.7L305.8 245.4C320.5 255.2 324.4 275 314.6 289.8C304.8 304.5 284.1 308.4 270.2 298.6L260.2 291.9C256.3 289.4 251.9 288 247.3 288C234.4 288 224 298.4 224 311.3V416C264.1 416 302.3 400.6 330.7 375.3C343.8 363.5 364.1 364.6 375.8 377.8C387.6 390.9 386.5 411.2 373.3 422.1C333.7 458.4 281.4 480 224 480C100.3 480 0 379.7 0 256C0 132.3 100.3 32 224 32C281.4 32 333.7 53.59 373.3 89.04C386.5 100.8 387.6 121.1 375.8 134.2C364.1 147.4 343.8 148.5 330.7 136.7C302.3 111.4 264.1 96 224 96C135.6 96 63.1 167.6 63.1 256C63.1 321.6 103.5 377.1 159.1 402.7V402.7z',
			),
		),
		'label'             => __( 'Cruzeiro Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'css3'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M480 32l-64 368-223.3 80L0 400l19.6-94.8h82l-8 40.6L210 390.2l134.1-44.4 18.8-97.1H29.5l16-82h333.7l10.5-52.7H56.3l16.3-82H480z',
			),
		),
		'label'             => __( 'CSS 3 Logo', 'astra' ),
		'custom_categories' => array(),
	),
	'css3-alt'                             => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M0 32l34.9 395.8L192 480l157.1-52.2L384 32H0zm313.1 80l-4.8 47.3L193 208.6l-.3 .1h111.5l-12.8 146.6-98.2 28.7-98.8-29.2-6.4-73.9h48.9l3.2 38.3 52.6 13.3 54.7-15.4 3.7-61.6-166.3-.5v-.1l-.2 .1-3.6-46.3L193.1 162l6.5-2.7H76.7L70.9 112h242.2z',
			),
		),
		'label'             => __( 'Alternate CSS3 Logo', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'cube'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M234.5 5.709C248.4 .7377 263.6 .7377 277.5 5.709L469.5 74.28C494.1 83.38 512 107.5 512 134.6V377.4C512 404.5 494.1 428.6 469.5 437.7L277.5 506.3C263.6 511.3 248.4 511.3 234.5 506.3L42.47 437.7C17 428.6 0 404.5 0 377.4V134.6C0 107.5 17 83.38 42.47 74.28L234.5 5.709zM256 65.98L82.34 128L256 190L429.7 128L256 65.98zM288 434.6L448 377.4V189.4L288 246.6V434.6z',
			),
		),
		'label'             => __( 'Cube', 'astra' ),
		'custom_categories' => array(
			'design',
			'science-and-technology',
		),
	),
	'cubes'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M172.1 40.16L268.1 3.76C280.9-1.089 295.1-1.089 307.9 3.76L403.9 40.16C425.6 48.41 440 69.25 440 92.52V204.7C441.3 205.1 442.6 205.5 443.9 205.1L539.9 242.4C561.6 250.6 576 271.5 576 294.7V413.9C576 436.1 562.9 456.2 542.5 465.1L446.5 507.3C432.2 513.7 415.8 513.7 401.5 507.3L288 457.5L174.5 507.3C160.2 513.7 143.8 513.7 129.5 507.3L33.46 465.1C13.13 456.2 0 436.1 0 413.9V294.7C0 271.5 14.39 250.6 36.15 242.4L132.1 205.1C133.4 205.5 134.7 205.1 136 204.7V92.52C136 69.25 150.4 48.41 172.1 40.16V40.16zM290.8 48.64C289 47.95 286.1 47.95 285.2 48.64L206.8 78.35L287.1 109.5L369.2 78.35L290.8 48.64zM392 210.6V121L309.6 152.6V241.8L392 210.6zM154.8 250.9C153 250.2 150.1 250.2 149.2 250.9L70.81 280.6L152 311.7L233.2 280.6L154.8 250.9zM173.6 455.3L256 419.1V323.2L173.6 354.8V455.3zM342.8 280.6L424 311.7L505.2 280.6L426.8 250.9C425 250.2 422.1 250.2 421.2 250.9L342.8 280.6zM528 413.9V323.2L445.6 354.8V455.3L523.2 421.2C526.1 419.9 528 417.1 528 413.9V413.9z',
			),
		),
		'label'             => __( 'Cubes', 'astra' ),
		'custom_categories' => array(
			'design',
			'science-and-technology',
		),
	),
	'cubes-stacked'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M192 64C192 46.33 206.3 32 224 32H288C305.7 32 320 46.33 320 64V128C320 145.7 305.7 160 288 160H224C206.3 160 192 145.7 192 128V64zM138.1 174.1C153.4 166.1 172.1 171.4 181.8 186.7L213.8 242.1C222.6 257.4 217.4 276.1 202.1 285.8L146.7 317.8C131.4 326.6 111.8 321.4 102.1 306.1L70.96 250.7C62.12 235.4 67.37 215.8 82.67 206.1L138.1 174.1zM352 192C369.7 192 384 206.3 384 224V288C384 305.7 369.7 320 352 320H288C270.3 320 256 305.7 256 288V224C256 206.3 270.3 192 288 192H352zM416 352C433.7 352 448 366.3 448 384V448C448 465.7 433.7 480 416 480H352C334.3 480 320 465.7 320 448V384C320 366.3 334.3 352 352 352H416zM160 384C160 366.3 174.3 352 192 352H256C273.7 352 288 366.3 288 384V448C288 465.7 273.7 480 256 480H192C174.3 480 160 465.7 160 448V384zM96 352C113.7 352 128 366.3 128 384V448C128 465.7 113.7 480 96 480H32C14.33 480 0 465.7 0 448V384C0 366.3 14.33 352 32 352H96z',
			),
		),
		'label'             => __( 'Cubes Stacked', 'astra' ),
		'custom_categories' => array(
			'design',
			'education',
			'lifestyle-and-hobbies',
		),
	),
	'cuttlefish'                           => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 440,
				'height' => 512,
				'path'   => 'M344 305.5c-17.5 31.6-57.4 54.5-96 54.5-56.6 0-104-47.4-104-104s47.4-104 104-104c38.6 0 78.5 22.9 96 54.5 13.7-50.9 41.7-93.3 87-117.8C385.7 39.1 320.5 8 248 8 111 8 0 119 0 256s111 248 248 248c72.5 0 137.7-31.1 183-80.7-45.3-24.5-73.3-66.9-87-117.8z',
			),
		),
		'label'             => __( 'Cuttlefish', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'd'                                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M160 32.01L32 32.01c-17.67 0-32 14.33-32 32v384c0 17.67 14.33 32 32 32l128-.0073c123.5 0 224-100.5 224-224S283.5 32.01 160 32.01zM160 416H64v-320h96c88.22 0 160 71.78 160 159.1S248.2 416 160 416z',
			),
		),
		'label'             => __( 'D', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'd-and-d'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M82.5 98.9c-.6-17.2 2-33.8 12.7-48.2 .3 7.4 1.2 14.5 4.2 21.6 5.9-27.5 19.7-49.3 42.3-65.5-1.9 5.9-3.5 11.8-3 17.7 8.7-7.4 18.8-17.8 44.4-22.7 14.7-2.8 29.7-2 42.1 1 38.5 9.3 61 34.3 69.7 72.3 5.3 23.1 .7 45-8.3 66.4-5.2 12.4-12 24.4-20.7 35.1-2-1.9-3.9-3.8-5.8-5.6-42.8-40.8-26.8-25.2-37.4-37.4-1.1-1.2-1-2.2-.1-3.6 8.3-13.5 11.8-28.2 10-44-1.1-9.8-4.3-18.9-11.3-26.2-14.5-15.3-39.2-15-53.5 .6-11.4 12.5-14.1 27.4-10.9 43.6 .2 1.3 .4 2.7 0 3.9-3.4 13.7-4.6 27.6-2.5 41.6 .1 .5 .1 1.1 .1 1.6 0 .3-.1 .5-.2 1.1-21.8-11-36-28.3-43.2-52.2-8.3 17.8-11.1 35.5-6.6 54.1-15.6-15.2-21.3-34.3-22-55.2zm469.6 123.2c-11.6-11.6-25-20.4-40.1-26.6-12.8-5.2-26-7.9-39.9-7.1-10 .6-19.6 3.1-29 6.4-2.5 .9-5.1 1.6-7.7 2.2-4.9 1.2-7.3-3.1-4.7-6.8 3.2-4.6 3.4-4.2 15-12 .6-.4 1.2-.8 2.2-1.5h-2.5c-.6 0-1.2 .2-1.9 .3-19.3 3.3-30.7 15.5-48.9 29.6-10.4 8.1-13.8 3.8-12-.5 1.4-3.5 3.3-6.7 5.1-10 1-1.8 2.3-3.4 3.5-5.1-.2-.2-.5-.3-.7-.5-27 18.3-46.7 42.4-57.7 73.3 .3 .3 .7 .6 1 .9 .3-.6 .5-1.2 .9-1.7 10.4-12.1 22.8-21.8 36.6-29.8 18.2-10.6 37.5-18.3 58.7-20.2 4.3-.4 8.7-.1 13.1-.1-1.8 .7-3.5 .9-5.3 1.1-18.5 2.4-35.5 9-51.5 18.5-30.2 17.9-54.5 42.2-75.1 70.4-.3 .4-.4 .9-.7 1.3 14.5 5.3 24 17.3 36.1 25.6 .2-.1 .3-.2 .4-.4l1.2-2.7c12.2-26.9 27-52.3 46.7-74.5 16.7-18.8 38-25.3 62.5-20 5.9 1.3 11.4 4.4 17.2 6.8 2.3-1.4 5.1-3.2 8-4.7 8.4-4.3 17.4-7 26.7-9 14.7-3.1 29.5-4.9 44.5-1.3v-.5c-.5-.4-1.2-.8-1.7-1.4zM316.7 397.6c-39.4-33-22.8-19.5-42.7-35.6-.8 .9 0-.2-1.9 3-11.2 19.1-25.5 35.3-44 47.6-10.3 6.8-21.5 11.8-34.1 11.8-21.6 0-38.2-9.5-49.4-27.8-12-19.5-13.3-40.7-8.2-62.6 7.8-33.8 30.1-55.2 38.6-64.3-18.7-6.2-33 1.7-46.4 13.9 .8-13.9 4.3-26.2 11.8-37.3-24.3 10.6-45.9 25-64.8 43.9-.3-5.8 5.4-43.7 5.6-44.7 .3-2.7-.6-5.3-3-7.4-24.2 24.7-44.5 51.8-56.1 84.6 7.4-5.9 14.9-11.4 23.6-16.2-8.3 22.3-19.6 52.8-7.8 101.1 4.6 19 11.9 36.8 24.1 52.3 2.9 3.7 6.3 6.9 9.5 10.3 .2-.2 .4-.3 .6-.5-1.4-7-2.2-14.1-1.5-21.9 2.2 3.2 3.9 6 5.9 8.6 12.6 16 28.7 27.4 47.2 35.6 25 11.3 51.1 13.3 77.9 8.6 54.9-9.7 90.7-48.6 116-98.8 1-1.8 .6-2.9-.9-4.2zm172-46.4c-9.5-3.1-22.2-4.2-28.7-2.9 9.9 4 14.1 6.6 18.8 12 12.6 14.4 10.4 34.7-5.4 45.6-11.7 8.1-24.9 10.5-38.9 9.1-1.2-.1-2.3-.4-3-.6 2.8-3.7 6-7 8.1-10.8 9.4-16.8 5.4-42.1-8.7-56.1-2.1-2.1-4.6-3.9-7-5.9-.3 1.3-.1 2.1 .1 2.8 4.2 16.6-8.1 32.4-24.8 31.8-7.6-.3-13.9-3.8-19.6-8.5-19.5-16.1-39.1-32.1-58.5-48.3-5.9-4.9-12.5-8.1-20.1-8.7-4.6-.4-9.3-.6-13.9-.9-5.9-.4-8.8-2.8-10.4-8.4-.9-3.4-1.5-6.8-2.2-10.2-1.5-8.1-6.2-13-14.3-14.2-4.4-.7-8.9-1-13.3-1.5-13-1.4-19.8-7.4-22.6-20.3-5 11-1.6 22.4 7.3 29.9 4.5 3.8 9.3 7.3 13.8 11.2 4.6 3.8 7.4 8.7 7.9 14.8 .4 4.7 .8 9.5 1.8 14.1 2.2 10.6 8.9 18.4 17 25.1 16.5 13.7 33 27.3 49.5 41.1 17.9 15 13.9 32.8 13 56-.9 22.9 12.2 42.9 33.5 51.2 1 .4 2 .6 3.6 1.1-15.7-18.2-10.1-44.1 .7-52.3 .3 2.2 .4 4.3 .9 6.4 9.4 44.1 45.4 64.2 85 56.9 16-2.9 30.6-8.9 42.9-19.8 2-1.8 3.7-4.1 5.9-6.5-19.3 4.6-35.8 .1-50.9-10.6 .7-.3 1.3-.3 1.9-.3 21.3 1.8 40.6-3.4 57-17.4 19.5-16.6 26.6-42.9 17.4-66-8.3-20.1-23.6-32.3-43.8-38.9zM99.4 179.3c-5.3-9.2-13.2-15.6-22.1-21.3 13.7-.5 26.6 .2 39.6 3.7-7-12.2-8.5-24.7-5-38.7 5.3 11.9 13.7 20.1 23.6 26.8 19.7 13.2 35.7 19.6 46.7 30.2 3.4 3.3 6.3 7.1 9.6 10.9-.8-2.1-1.4-4.1-2.2-6-5-10.6-13-18.6-22.6-25-1.8-1.2-2.8-2.5-3.4-4.5-3.3-12.5-3-25.1-.7-37.6 1-5.5 2.8-10.9 4.5-16.3 .8-2.4 2.3-4.6 4-6.6 .6 6.9 0 25.5 19.6 46 10.8 11.3 22.4 21.9 33.9 32.7 9 8.5 18.3 16.7 25.5 26.8 1.1 1.6 2.2 3.3 3.8 4.7-5-13-14.2-24.1-24.2-33.8-9.6-9.3-19.4-18.4-29.2-27.4-3.3-3-4.6-6.7-5.1-10.9-1.2-10.4 0-20.6 4.3-30.2 .5-1 1.1-2 1.9-3.3 .5 4.2 .6 7.9 1.4 11.6 4.8 23.1 20.4 36.3 49.3 63.5 10 9.4 19.3 19.2 25.6 31.6 4.8 9.3 7.3 19 5.7 29.6-.1 .6 .5 1.7 1.1 2 6.2 2.6 10 6.9 9.7 14.3 7.7-2.6 12.5-8 16.4-14.5 4.2 20.2-9.1 50.3-27.2 58.7 .4-4.5 5-23.4-16.5-27.7-6.8-1.3-12.8-1.3-22.9-2.1 4.7-9 10.4-20.6 .5-22.4-24.9-4.6-52.8 1.9-57.8 4.6 8.2 .4 16.3 1 23.5 3.3-2 6.5-4 12.7-5.8 18.9-1.9 6.5 2.1 14.6 9.3 9.6 1.2-.9 2.3-1.9 3.3-2.7-3.1 17.9-2.9 15.9-2.8 18.3 .3 10.2 9.5 7.8 15.7 7.3-2.5 11.8-29.5 27.3-45.4 25.8 7-4.7 12.7-10.3 15.9-17.9-6.5 .8-12.9 1.6-19.2 2.4l-.3-.9c4.7-3.4 8-7.8 10.2-13.1 8.7-21.1-3.6-38-25-39.9-9.1-.8-17.8 .8-25.9 5.5 6.2-15.6 17.2-26.6 32.6-34.5-15.2-4.3-8.9-2.7-24.6-6.3 14.6-9.3 30.2-13.2 46.5-14.6-5.2-3.2-48.1-3.6-70.2 20.9 7.9 1.4 15.5 2.8 23.2 4.2-23.8 7-44 19.7-62.4 35.6 1.1-4.8 2.7-9.5 3.3-14.3 .6-4.5 .8-9.2 .1-13.6-1.5-9.4-8.9-15.1-19.7-16.3-7.9-.9-15.6 .1-23.3 1.3-.9 .1-1.7 .3-2.9 0 15.8-14.8 36-21.7 53.1-33.5 6-4.5 6.8-8.2 3-14.9zm128.4 26.8c3.3 16 12.6 25.5 23.8 24.3-4.6-11.3-12.1-19.5-23.8-24.3z',
			),
		),
		'label'             => __( 'Dungeons & Dragons', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'd-and-d-beyond'                       => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M313.8 241.5c13.8 0 21-10.1 24.8-17.9-1-1.1-5-4.2-7.4-6.6-2.4 4.3-8.2 10.7-13.9 10.7-10.2 0-15.4-14.7-3.2-26.6-.5-.2-4.3-1.8-8 2.4 0-3 1-5.1 2.1-6.6-3.5 1.3-9.8 5.6-11.4 7.9 .2-5.8 1.6-7.5 .6-9l-.2-.2s-8.5 5.6-9.3 14.7c0 0 1.1-1.6 2.1-1.9 .6-.3 1.3 0 .6 1.9-.2 .6-5.8 15.7 5.1 26-.6-1.6-1.9-7.6 2.4-1.9-.3 .1 5.8 7.1 15.7 7.1zm52.4-21.1c0-4-4.9-4.4-5.6-4.5 2 3.9 .9 7.5 .2 9 2.5-.4 5.4-1.6 5.4-4.5zm10.3 5.2c0-6.4-6.2-11.4-13.5-10.7 8 1.3 5.6 13.8-5 11.4 3.7-2.6 3.2-9.9-1.3-12.5 1.4 4.2-3 8.2-7.4 4.6-2.4-1.9-8-6.6-10.6-8.6-2.4-2.1-5.5-1-6.6-1.8-1.3-1.1-.5-3.8-2.2-5-1.6-.8-3-.3-4.8-1-1.6-.6-2.7-1.9-2.6-3.5-2.5 4.4 3.4 6.3 4.5 8.5 1 1.9-.8 4.8 4 8.5 14.8 11.6 9.1 8 10.4 18.1 .6 4.3 4.2 6.7 6.4 7.4-2.1-1.9-2.9-6.4 0-9.3 0 13.9 19.2 13.3 23.1 6.4-2.4 1.1-7-.2-9-1.9 7.7 1 14.2-4.1 14.6-10.6zm-39.4-18.4c2 .8 1.6 .7 6.4 4.5 10.2-24.5 21.7-15.7 22-15.5 2.2-1.9 9.8-3.8 13.8-2.7-2.4-2.7-7.5-6.2-13.3-6.2-4.7 0-7.4 2.2-8 1.3-.8-1.4 3.2-3.4 3.2-3.4-5.4 .2-9.6 6.7-11.2 5.9-1.1-.5 1.4-3.7 1.4-3.7-5.1 2.9-9.3 9.1-10.2 13 4.6-5.8 13.8-9.8 19.7-9-10.5 .5-19.5 9.7-23.8 15.8zm242.5 51.9c-20.7 0-40 1.3-50.3 2.1l7.4 8.2v77.2l-7.4 8.2c10.4 .8 30.9 2.1 51.6 2.1 42.1 0 59.1-20.7 59.1-48.9 0-29.3-23.2-48.9-60.4-48.9zm-15.1 75.6v-53.3c30.1-3.3 46.8 3.8 46.8 26.3 0 25.6-21.4 30.2-46.8 27zM301.6 181c-1-3.4-.2-6.9 1.1-9.4 1 3 2.6 6.4 7.5 9-.5-2.4-.2-5.6 .5-8-1.4-5.4 2.1-9.9 6.4-9.9 6.9 0 8.5 8.8 4.7 14.4 2.1 3.2 5.5 5.6 7.7 7.8 3.2-3.7 5.5-9.5 5.5-13.8 0-8.2-5.5-15.9-16.7-16.5-20-.9-20.2 16.6-20 18.9 .5 5.2 3.4 7.8 3.3 7.5zm-.4 6c-.5 1.8-7 3.7-10.2 6.9 4.8-1 7-.2 7.8 1.8 .5 1.4-.2 3.4-.5 5.6 1.6-1.8 7-5.5 11-6.2-1-.3-3.4-.8-4.3-.8 2.9-3.4 9.3-4.5 12.8-3.7-2.2-.2-6.7 1.1-8.5 2.6 1.6 .3 3 .6 4.3 1.1-2.1 .8-4.8 3.4-5.8 6.1 7-5 13.1 5.2 7 8.2 .8 .2 2.7 0 3.5-.5-.3 1.1-1.9 3-3 3.4 2.9 0 7-1.9 8.2-4.6 0 0-1.8 .6-2.6-.2s.3-4.3 .3-4.3c-2.3 2.9-3.4-1.3-1.3-4.2-1-.3-3.5-.6-4.6-.5 3.2-1.1 10.4-1.8 11.2-.3 .6 1.1-1 3.4-1 3.4 4-.5 8.3 1.1 6.7 5.1 2.9-1.4 5.5-5.9 4.8-10.4-.3 1-1.6 2.4-2.9 2.7 .2-1.4-1-2.2-1.9-2.6 1.7-9.6-14.6-14.2-14.1-23.9-1 1.3-1.8 5-.8 7.1 2.7 3.2 8.7 6.7 10.1 12.2-2.6-6.4-15.1-11.4-14.6-20.2-1.6 1.6-2.6 7.8-1.3 11 2.4 1.4 4.5 3.8 4.8 6.1-2.2-5.1-11.4-6.1-13.9-12.2-.6 2.2-.3 5 1 6.7 0 0-2.2-.8-7-.6 1.7 .6 5.1 3.5 4.8 5.2zm25.9 7.4c-2.7 0-3.5-2.1-4.2-4.3 3.3 1.3 4.2 4.3 4.2 4.3zm38.9 3.7l-1-.6c-1.1-1-2.9-1.4-4.7-1.4-2.9 0-5.8 1.3-7.5 3.4-.8 .8-1.4 1.8-2.1 2.6v15.7c3.5 2.6 7.1-2.9 3-7.2 1.5 .3 4.6 2.7 5.1 3.2 0 0 2.6-.5 5-.5 2.1 0 3.9 .3 5.6 1.1V196c-1.1 .5-2.2 1-2.7 1.4zM79.9 305.9c17.2-4.6 16.2-18 16.2-19.9 0-20.6-24.1-25-37-25H3l8.3 8.6v29.5H0l11.4 14.6V346L3 354.6c61.7 0 73.8 1.5 86.4-5.9 6.7-4 9.9-9.8 9.9-17.6 0-5.1 2.6-18.8-19.4-25.2zm-41.3-27.5c20 0 29.6-.8 29.6 9.1v3c0 12.1-19 8.8-29.6 8.8zm0 59.2V315c12.2 0 32.7-2.3 32.7 8.8v4.5h.2c0 11.2-12.5 9.3-32.9 9.3zm101.2-19.3l23.1 .2v-.2l14.1-21.2h-37.2v-14.9h52.4l-14.1-21v-.2l-73.5 .2 7.4 8.2v77.1l-7.4 8.2h81.2l14.1-21.2-60.1 .2zm214.7-60.1c-73.9 0-77.5 99.3-.3 99.3 77.9 0 74.1-99.3 .3-99.3zm-.3 77.5c-37.4 0-36.9-55.3 .2-55.3 36.8 .1 38.8 55.3-.2 55.3zm-91.3-8.3l44.1-66.2h-41.7l6.1 7.2-20.5 37.2h-.3l-21-37.2 6.4-7.2h-44.9l44.1 65.8 .2 19.4-7.7 8.2h42.6l-7.2-8.2zm-28.4-151.3c1.6 1.3 2.9 2.4 2.9 6.6v38.8c0 4.2-.8 5.3-2.7 6.4-.1 .1-7.5 4.5-7.9 4.6h35.1c10 0 17.4-1.5 26-8.6-.6-5 .2-9.5 .8-12 0-.2-1.8 1.4-2.7 3.5 0-5.7 1.6-15.4 9.6-20.5-.1 0-3.7-.8-9 1.1 2-3.1 10-7.9 10.4-7.9-8.2-26-38-22.9-32.2-22.9-30.9 0-32.6 .3-39.9-4 .1 .8 .5 8.2 9.6 14.9zm21.5 5.5c4.6 0 23.1-3.3 23.1 17.3 0 20.7-18.4 17.3-23.1 17.3zm228.9 79.6l7 8.3V312h-.3c-5.4-14.4-42.3-41.5-45.2-50.9h-31.6l7.4 8.5v76.9l-7.2 8.3h39l-7.4-8.2v-47.4h.3c3.7 10.6 44.5 42.9 48.5 55.6h21.3v-85.2l7.4-8.3zm-106.7-96.1c-32.2 0-32.8 .2-39.9-4 .1 .7 .5 8.3 9.6 14.9 3.1 2 2.9 4.3 2.9 9.5 1.8-1.1 3.8-2.2 6.1-3-1.1 1.1-2.7 2.7-3.5 4.5 1-1.1 7.5-5.1 14.6-3.5-1.6 .3-4 1.1-6.1 2.9 .1 0 2.1-1.1 7.5-.3v-4.3c4.7 0 23.1-3.4 23.1 17.3 0 20.5-18.5 17.3-19.7 17.3 5.7 4.4 5.8 12 2.2 16.3h.3c33.4 0 36.7-27.3 36.7-34 0-3.8-1.1-32-33.8-33.6z',
			),
		),
		'label'             => __( 'D&D Beyond', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'brands',
			'brands',
			'social',
		),
	),
	'dailymotion'                          => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M298.9 267a48.4 48.4 0 0 0 -24.36-6.21q-19.83 0-33.44 13.27t-13.61 33.42q0 21.16 13.28 34.6t33.43 13.44q20.5 0 34.11-13.78T322 307.5A47.13 47.13 0 0 0 315.9 284 44.13 44.13 0 0 0 298.9 267zM0 32V480H448V32zM374.7 405.3h-53.1V381.4h-.67q-15.79 26.2-55.78 26.2-27.56 0-48.89-13.1a88.29 88.29 0 0 1 -32.94-35.77q-11.6-22.68-11.59-50.89 0-27.56 11.76-50.22a89.9 89.9 0 0 1 32.93-35.78q21.18-13.09 47.72-13.1a80.87 80.87 0 0 1 29.74 5.21q13.28 5.21 25 17V153l55.79-12.09z',
			),
		),
		'label'             => __( 'dailymotion', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'dashcube'                             => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M326.6 104H110.4c-51.1 0-91.2 43.3-91.2 93.5V427c0 50.5 40.1 85 91.2 85h227.2c51.1 0 91.2-34.5 91.2-85V0L326.6 104zM153.9 416.5c-17.7 0-32.4-15.1-32.4-32.8V240.8c0-17.7 14.7-32.5 32.4-32.5h140.7c17.7 0 32 14.8 32 32.5v123.5l51.1 52.3H153.9z',
			),
		),
		'label'             => __( 'DashCube', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'database'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M448 80V128C448 172.2 347.7 208 224 208C100.3 208 0 172.2 0 128V80C0 35.82 100.3 0 224 0C347.7 0 448 35.82 448 80zM393.2 214.7C413.1 207.3 433.1 197.8 448 186.1V288C448 332.2 347.7 368 224 368C100.3 368 0 332.2 0 288V186.1C14.93 197.8 34.02 207.3 54.85 214.7C99.66 230.7 159.5 240 224 240C288.5 240 348.3 230.7 393.2 214.7V214.7zM54.85 374.7C99.66 390.7 159.5 400 224 400C288.5 400 348.3 390.7 393.2 374.7C413.1 367.3 433.1 357.8 448 346.1V432C448 476.2 347.7 512 224 512C100.3 512 0 476.2 0 432V346.1C14.93 357.8 34.02 367.3 54.85 374.7z',
			),
		),
		'label'             => __( 'Database', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'deezer'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M451.5 244.7H576V172H451.5zm0-173.9v72.67H576V70.82zm0 275.1H576V273.2H451.5zM0 447.1H124.5V374.4H0zm150.5 0H275V374.4H150.5zm150.5 0H425.5V374.4H301zm150.5 0H576V374.4H451.5zM301 345.9H425.5V273.2H301zm-150.5 0H275V273.2H150.5zm0-101.2H275V172H150.5z',
			),
		),
		'label'             => __( 'Deezer', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'delete-left'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M576 384C576 419.3 547.3 448 512 448H205.3C188.3 448 172 441.3 160 429.3L9.372 278.6C3.371 272.6 0 264.5 0 256C0 247.5 3.372 239.4 9.372 233.4L160 82.75C172 70.74 188.3 64 205.3 64H512C547.3 64 576 92.65 576 128V384zM271 208.1L318.1 256L271 303C261.7 312.4 261.7 327.6 271 336.1C280.4 346.3 295.6 346.3 304.1 336.1L352 289.9L399 336.1C408.4 346.3 423.6 346.3 432.1 336.1C442.3 327.6 442.3 312.4 432.1 303L385.9 256L432.1 208.1C442.3 199.6 442.3 184.4 432.1 175C423.6 165.7 408.4 165.7 399 175L352 222.1L304.1 175C295.6 165.7 280.4 165.7 271 175C261.7 184.4 261.7 199.6 271 208.1V208.1z',
			),
		),
		'label'             => __( 'Delete Left', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'delicious'                            => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M446.5 68c-.4-1.5-.9-3-1.4-4.5-.9-2.5-2-4.8-3.3-7.1-1.4-2.4-3-4.8-4.7-6.9-2.1-2.5-4.4-4.8-6.9-6.8-1.1-.9-2.2-1.7-3.3-2.5-1.3-.9-2.6-1.7-4-2.4-1.8-1-3.6-1.8-5.5-2.5-1.7-.7-3.5-1.3-5.4-1.7-3.8-1-7.9-1.5-12-1.5H48C21.5 32 0 53.5 0 80v352c0 4.1 .5 8.2 1.5 12 2 7.7 5.8 14.6 11 20.3 1 1.1 2.1 2.2 3.3 3.3 5.7 5.2 12.6 9 20.3 11 3.8 1 7.9 1.5 12 1.5h352c26.5 0 48-21.5 48-48V80c-.1-4.1-.6-8.2-1.6-12zM416 432c0 8.8-7.2 16-16 16H224V256H32V80c0-8.8 7.2-16 16-16h176v192h192z',
			),
		),
		'label'             => __( 'Delicious', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'democrat'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M191.1 479.1C191.1 497.6 206.4 512 223.1 512h32c17.6 0 32-14.4 32-32v-64h160v64c0 17.6 14.41 32 32.01 32L511.1 512c17.6 0 32-14.4 32-32l.0102-128H192L191.1 479.1zM637.2 256.9l-19.5-29.38c-28.25-42.25-75.38-67.5-126.1-67.5H255.1L174.7 78.75c20.13-20 22.63-51 7.5-73.88C178.9-.2552 171.5-1.005 167.1 3.37L125.2 45.25L82.36 2.37C78.74-1.255 72.74-.6302 69.99 3.62c-12.25 18.63-10.25 44 6.125 60.38c3.25 3.25 7.25 5.25 11.25 7.5c-2.125 1.75-4.625 3.125-6.375 5.375l-74.63 99.38C-.8895 185.9-2.014 198.9 3.361 209.7l14.38 28.5c5.375 10.88 16.5 17.75 28.5 17.75H77.24c8.5 0 16.63-3.375 22.63-9.375l38.13-34.63l54.04 108h351.1l-.0102-77.75c16.25 12.13 18.25 17.5 40.13 50.25c4.875 7.375 14.75 9.25 22.13 4.375l26.63-17.63C640.2 274.2 642.2 264.2 637.2 256.9zM296.2 243.2L279.7 259.4l3.875 22.75c.625 4.125-3.625 7.125-7.25 5.25L255.1 276.7L235.6 287.4C231.1 289.2 227.7 286.2 228.4 282.1l3.875-22.75L215.7 243.2c-3-2.875-1.25-7.875 2.875-8.5l22.75-3.25l10.25-20.75c1.75-3.625 7.125-3.625 9 0l10.13 20.75l22.88 3.25C297.6 235.4 299.2 240.4 296.2 243.2zM408.2 243.2l-16.5 16.13l3.875 22.75c.625 4.125-3.625 7.125-7.25 5.25L367.1 276.7l-20.38 10.63c-3.625 1.875-7.875-1.125-7.25-5.25l3.875-22.75l-16.5-16.13c-3-2.875-1.25-7.875 2.875-8.5l22.75-3.25l10.25-20.75c1.75-3.625 7.125-3.625 9 0l10.13 20.75l22.88 3.25C409.6 235.4 411.2 240.4 408.2 243.2zM520.2 243.2l-16.5 16.13l3.875 22.75c.625 4.125-3.625 7.125-7.25 5.25l-20.38-10.63l-20.38 10.63c-3.625 1.875-7.875-1.125-7.25-5.25l3.875-22.75l-16.5-16.13c-3-2.875-1.25-7.875 2.875-8.5l22.75-3.25l10.25-20.75c1.75-3.625 7.125-3.625 9 0l10.13 20.75l22.88 3.25C521.6 235.4 523.2 240.4 520.2 243.2z',
			),
		),
		'label'             => __( 'Democrat', 'astra' ),
		'custom_categories' => array(),
	),
	'deploydog'                            => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M382.2 136h51.7v239.6h-51.7v-20.7c-19.8 24.8-52.8 24.1-73.8 14.7-26.2-11.7-44.3-38.1-44.3-71.8 0-29.8 14.8-57.9 43.3-70.8 20.2-9.1 52.7-10.6 74.8 12.9V136zm-64.7 161.8c0 18.2 13.6 33.5 33.2 33.5 19.8 0 33.2-16.4 33.2-32.9 0-17.1-13.7-33.2-33.2-33.2-19.6 0-33.2 16.4-33.2 32.6zM188.5 136h51.7v239.6h-51.7v-20.7c-19.8 24.8-52.8 24.1-73.8 14.7-26.2-11.7-44.3-38.1-44.3-71.8 0-29.8 14.8-57.9 43.3-70.8 20.2-9.1 52.7-10.6 74.8 12.9V136zm-64.7 161.8c0 18.2 13.6 33.5 33.2 33.5 19.8 0 33.2-16.4 33.2-32.9 0-17.1-13.7-33.2-33.2-33.2-19.7 0-33.2 16.4-33.2 32.6zM448 96c17.5 0 32 14.4 32 32v256c0 17.5-14.4 32-32 32H64c-17.5 0-32-14.4-32-32V128c0-17.5 14.4-32 32-32h384m0-32H64C28.8 64 0 92.8 0 128v256c0 35.2 28.8 64 64 64h384c35.2 0 64-28.8 64-64V128c0-35.2-28.8-64-64-64z',
			),
		),
		'label'             => __( 'deploy.dog', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'deskpro'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 480,
				'height' => 512,
				'path'   => 'M205.9 512l31.1-38.4c12.3-.2 25.6-1.4 36.5-6.6 38.9-18.6 38.4-61.9 38.3-63.8-.1-5-.8-4.4-28.9-37.4H362c-.2 50.1-7.3 68.5-10.2 75.7-9.4 23.7-43.9 62.8-95.2 69.4-8.7 1.1-32.8 1.2-50.7 1.1zm200.4-167.7c38.6 0 58.5-13.6 73.7-30.9l-175.5-.3-17.4 31.3 119.2-.1zm-43.6-223.9v168.3h-73.5l-32.7 55.5H250c-52.3 0-58.1-56.5-58.3-58.9-1.2-13.2-21.3-11.6-20.1 1.8 1.4 15.8 8.8 40 26.4 57.1h-91c-25.5 0-110.8-26.8-107-114V16.9C0 .9 9.7 .3 15 .1h82c.2 0 .3 .1 .5 .1 4.3-.4 50.1-2.1 50.1 43.7 0 13.3 20.2 13.4 20.2 0 0-18.2-5.5-32.8-15.8-43.7h84.2c108.7-.4 126.5 79.4 126.5 120.2zm-132.5 56l64 29.3c13.3-45.5-42.2-71.7-64-29.3z',
			),
		),
		'label'             => __( 'Deskpro', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'desktop'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M528 0h-480C21.5 0 0 21.5 0 48v320C0 394.5 21.5 416 48 416h192L224 464H152C138.8 464 128 474.8 128 488S138.8 512 152 512h272c13.25 0 24-10.75 24-24s-10.75-24-24-24H352L336 416h192c26.5 0 48-21.5 48-48v-320C576 21.5 554.5 0 528 0zM512 288H64V64h448V288z',
			),
		),
		'label'             => __( 'Desktop', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'dev'                                  => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M120.1 208.3c-3.88-2.9-7.77-4.35-11.65-4.35H91.03v104.5h17.45c3.88 0 7.77-1.45 11.65-4.35 3.88-2.9 5.82-7.25 5.82-13.06v-69.65c-.01-5.8-1.96-10.16-5.83-13.06zM404.1 32H43.9C19.7 32 .06 51.59 0 75.8v360.4C.06 460.4 19.7 480 43.9 480h360.2c24.21 0 43.84-19.59 43.9-43.8V75.8c-.06-24.21-19.7-43.8-43.9-43.8zM154.2 291.2c0 18.81-11.61 47.31-48.36 47.25h-46.4V172.1h47.38c35.44 0 47.36 28.46 47.37 47.28l.01 70.93zm100.7-88.66H201.6v38.42h32.57v29.57H201.6v38.41h53.29v29.57h-62.18c-11.16 .29-20.44-8.53-20.72-19.69V193.7c-.27-11.15 8.56-20.41 19.71-20.69h63.19l-.01 29.52zm103.6 115.3c-13.2 30.75-36.85 24.63-47.44 0l-38.53-144.8h32.57l29.71 113.7 29.57-113.7h32.58l-38.46 144.8z',
			),
		),
		'label'             => __( 'DEV', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'deviantart'                           => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M320 93.2l-98.2 179.1 7.4 9.5H320v127.7H159.1l-13.5 9.2-43.7 84c-.3 0-8.6 8.6-9.2 9.2H0v-93.2l93.2-179.4-7.4-9.2H0V102.5h156l13.5-9.2 43.7-84c.3 0 8.6-8.6 9.2-9.2H320v93.1z',
			),
		),
		'label'             => __( 'deviantART', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'dharmachakra'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M495 225l-17.24 1.124c-5.25-39.5-20.76-75.63-43.89-105.9l12.1-11.37c6.875-6.125 7.25-16.75 .75-23.38L426.5 64.38c-6.625-6.5-17.25-6.125-23.38 .75l-11.37 12.1c-30.25-23.12-66.38-38.64-105.9-43.89L287 17C287.5 7.75 280.2 0 271 0h-30c-9.25 0-16.5 7.75-16 17l1.124 17.24c-39.5 5.25-75.63 20.76-105.9 43.89L108.9 65.13C102.8 58.25 92.13 57.88 85.63 64.38L64.38 85.5C57.88 92.12 58.25 102.8 65.13 108.9l12.1 11.37C54.1 150.5 39.49 186.6 34.24 226.1L17 225C7.75 224.5 0 231.8 0 241v30c0 9.25 7.75 16.5 17 16l17.24-1.124c5.25 39.5 20.76 75.63 43.89 105.9l-12.1 11.37c-6.875 6.125-7.25 16.75-.75 23.25l21.25 21.25c6.5 6.5 17.13 6.125 23.25-.75l11.37-12.1c30.25 23.12 66.38 38.64 105.9 43.89L225 495C224.5 504.2 231.8 512 241 512h30c9.25 0 16.5-7.75 16-17l-1.124-17.24c39.5-5.25 75.63-20.76 105.9-43.89l11.37 12.1c6.125 6.875 16.75 7.25 23.38 .75l21.12-21.25c6.5-6.5 6.125-17.13-.75-23.25l-12.1-11.37c23.12-30.25 38.64-66.38 43.89-105.9L495 287C504.3 287.5 512 280.2 512 271v-30C512 231.8 504.3 224.5 495 225zM281.9 98.68c24.75 4 47.61 13.59 67.24 27.71L306.5 174.6c-8.75-5.375-18.38-9.507-28.62-11.88L281.9 98.68zM230.1 98.68l3.996 64.06C223.9 165.1 214.3 169.2 205.5 174.6L162.9 126.4C182.5 112.3 205.4 102.7 230.1 98.68zM126.4 163l48.35 42.48c-5.5 8.75-9.606 18.4-11.98 28.65L98.68 230.1C102.7 205.4 112.2 182.5 126.4 163zM98.68 281.9l64.06-3.996C165.1 288.1 169.3 297.8 174.6 306.5l-48.23 42.61C112.3 329.5 102.7 306.6 98.68 281.9zM230.1 413.3c-24.75-4-47.61-13.59-67.24-27.71l42.58-48.33c8.75 5.5 18.4 9.606 28.65 11.98L230.1 413.3zM256 288C238.4 288 224 273.6 224 256s14.38-32 32-32s32 14.38 32 32S273.6 288 256 288zM281.9 413.3l-3.996-64.06c10.25-2.375 19.9-6.48 28.65-11.98l42.48 48.35C329.5 399.8 306.6 409.3 281.9 413.3zM385.6 349l-48.25-42.5c5.375-8.75 9.507-18.38 11.88-28.62l64.06 3.996C409.3 306.6 399.8 329.5 385.6 349zM349.3 234.1c-2.375-10.25-6.48-19.9-11.98-28.65L385.6 163c14.13 19.5 23.69 42.38 27.69 67.13L349.3 234.1z',
			),
		),
		'label'             => __( 'Dharmachakra', 'astra' ),
		'custom_categories' => array(),
	),
	'dhl'                                  => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M238 301.2h58.7L319 271h-58.7L238 301.2zM0 282.9v6.4h81.8l4.7-6.4H0zM172.9 271c-8.7 0-6-3.6-4.6-5.5 2.8-3.8 7.6-10.4 10.4-14.1 2.8-3.7 2.8-5.9-2.8-5.9h-51l-41.1 55.8h100.1c33.1 0 51.5-22.5 57.2-30.3h-68.2zm317.5-6.9l39.3-53.4h-62.2l-39.3 53.4h62.2zM95.3 271H0v6.4h90.6l4.7-6.4zm111-26.6c-2.8 3.8-7.5 10.4-10.3 14.2-1.4 2-4.1 5.5 4.6 5.5h45.6s7.3-10 13.5-18.4c8.4-11.4 .7-35-29.2-35H112.6l-20.4 27.8h111.4c5.6 0 5.5 2.2 2.7 5.9zM0 301.2h73.1l4.7-6.4H0v6.4zm323 0h58.7L404 271h-58.7c-.1 0-22.3 30.2-22.3 30.2zm222 .1h95v-6.4h-90.3l-4.7 6.4zm22.3-30.3l-4.7 6.4H640V271h-72.7zm-13.5 18.3H640v-6.4h-81.5l-4.7 6.4zm-164.2-78.6l-22.5 30.6h-26.2l22.5-30.6h-58.7l-39.3 53.4H409l39.3-53.4h-58.7zm33.5 60.3s-4.3 5.9-6.4 8.7c-7.4 10-.9 21.6 23.2 21.6h94.3l22.3-30.3H423.1z',
			),
		),
		'label'             => __( 'DHL', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'diagram-next'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 160C512 195.3 483.3 224 448 224H280V288H326.1C347.4 288 358.1 313.9 343 328.1L272.1 399C263.6 408.4 248.4 408.4 239 399L168.1 328.1C153.9 313.9 164.6 288 185.9 288H232V224H64C28.65 224 0 195.3 0 160V96C0 60.65 28.65 32 64 32H448C483.3 32 512 60.65 512 96V160zM312.6 416H448V352H376.6L384.1 343.6C401 327.6 404.6 306.4 399 288H448C483.3 288 512 316.7 512 352V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V352C0 316.7 28.65 288 64 288H112.1C107.4 306.4 110.1 327.6 127 343.6L135.4 352H64V416H199.4L216.4 432.1C238.3 454.8 273.7 454.8 295.6 432.1L312.6 416z',
			),
		),
		'label'             => __( 'Diagram Next', 'astra' ),
		'custom_categories' => array(),
	),
	'diagram-predecessor'                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M64 480C28.65 480 0 451.3 0 416V352C0 316.7 28.65 288 64 288H448C483.3 288 512 316.7 512 352V416C512 451.3 483.3 480 448 480H64zM448 416V352H64V416H448zM288 160C288 195.3 259.3 224 224 224H64C28.65 224 0 195.3 0 160V96C0 60.65 28.65 32 64 32H368C412.2 32 448 67.82 448 112V128H486.1C507.4 128 518.1 153.9 503 168.1L432.1 239C423.6 248.4 408.4 248.4 399 239L328.1 168.1C313.9 153.9 324.6 128 345.9 128H384V112C384 103.2 376.8 96 368 96H288V160z',
			),
		),
		'label'             => __( 'Diagram Predecessor', 'astra' ),
		'custom_categories' => array(),
	),
	'diagram-project'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M0 80C0 53.49 21.49 32 48 32H144C170.5 32 192 53.49 192 80V96H384V80C384 53.49 405.5 32 432 32H528C554.5 32 576 53.49 576 80V176C576 202.5 554.5 224 528 224H432C405.5 224 384 202.5 384 176V160H192V176C192 177.7 191.9 179.4 191.7 180.1L272 288H368C394.5 288 416 309.5 416 336V432C416 458.5 394.5 480 368 480H272C245.5 480 224 458.5 224 432V336C224 334.3 224.1 332.6 224.3 331L144 224H48C21.49 224 0 202.5 0 176V80z',
			),
		),
		'label'             => __( 'Diagram Project', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'diagram-successor'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V352C0 316.7 28.65 288 64 288H448C483.3 288 512 316.7 512 352V416zM224 224H64C28.65 224 0 195.3 0 160V96C0 60.65 28.65 32 64 32H368C412.2 32 448 67.82 448 112V128H486.1C507.4 128 518.1 153.9 503 168.1L432.1 239C423.6 248.4 408.4 248.4 399 239L328.1 168.1C313.9 153.9 324.6 128 345.9 128H384V112C384 103.2 376.8 96 368 96H288V160C288 195.3 259.3 224 224 224V224zM64 160H224V96H64V160z',
			),
		),
		'label'             => __( 'Diagram Successor', 'astra' ),
		'custom_categories' => array(),
	),
	'diamond'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M500.3 227.7C515.9 243.3 515.9 268.7 500.3 284.3L284.3 500.3C268.7 515.9 243.3 515.9 227.7 500.3L11.72 284.3C-3.905 268.7-3.905 243.3 11.72 227.7L227.7 11.72C243.3-3.905 268.7-3.905 284.3 11.72L500.3 227.7z',
			),
		),
		'label'             => __( 'Diamond', 'astra' ),
		'custom_categories' => array(
			'design',
			'lifestyle-and-hobbies',
		),
	),
	'diamond-turn-right'                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M497.1 222.1l-208.1-208.1c-9.364-9.364-21.62-14.04-33.89-14.03C243.7 .0092 231.5 4.686 222.1 14.03L14.03 222.1C4.676 231.5 .0002 243.7 .0004 255.1c.0002 12.26 4.676 24.52 14.03 33.87l208.1 208.1C231.5 507.3 243.7 511.1 256 511.1c12.26 0 24.52-4.677 33.87-14.03l208.1-208.1c9.352-9.353 14.03-21.61 14.03-33.87C511.1 243.7 507.3 231.5 497.1 222.1zM410.5 252l-96 84c-10.79 9.545-26.53 .9824-26.53-12.03V272H223.1l-.0001 48C223.1 337.6 209.6 352 191.1 352S159.1 337.6 159.1 320V240c0-17.6 14.4-32 32-32h95.1V156c0-13.85 16.39-20.99 26.53-12.03l96 84C414 231 415.1 235.4 415.1 240S414 249 410.5 252z',
			),
		),
		'label'             => __( 'Diamond Turn Right', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'diaspora'                             => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M251.6 354.5c-1.4 0-88 119.9-88.7 119.9S76.34 414 76 413.3s86.6-125.7 86.6-127.4c0-2.2-129.6-44-137.6-47.1-1.3-.5 31.4-101.8 31.7-102.1 .6-.7 144.4 47 145.5 47 .4 0 .9-.6 1-1.3 .4-2 1-148.6 1.7-149.6 .8-1.2 104.5-.7 105.1-.3 1.5 1 3.5 156.1 6.1 156.1 1.4 0 138.7-47 139.3-46.3 .8 .9 31.9 102.2 31.5 102.6-.9 .9-140.2 47.1-140.6 48.8-.3 1.4 82.8 122.1 82.5 122.9s-85.5 63.5-86.3 63.5c-1-.2-89-125.5-90.9-125.5z',
			),
		),
		'label'             => __( 'Diaspora', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'dice'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M447.1 224c0-12.56-4.781-25.13-14.35-34.76l-174.9-174.9C249.1 4.786 236.5 0 223.1 0C211.4 0 198.9 4.786 189.2 14.35L14.35 189.2C4.783 198.9-.0011 211.4-.0011 223.1c0 12.56 4.785 25.17 14.35 34.8l174.9 174.9c9.625 9.562 22.19 14.35 34.75 14.35s25.13-4.783 34.75-14.35l174.9-174.9C443.2 249.1 447.1 236.6 447.1 224zM96 248c-13.25 0-23.1-10.75-23.1-23.1s10.75-23.1 23.1-23.1S120 210.8 120 224S109.3 248 96 248zM224 376c-13.25 0-23.1-10.75-23.1-23.1s10.75-23.1 23.1-23.1s23.1 10.75 23.1 23.1S237.3 376 224 376zM224 248c-13.25 0-23.1-10.75-23.1-23.1s10.75-23.1 23.1-23.1S248 210.8 248 224S237.3 248 224 248zM224 120c-13.25 0-23.1-10.75-23.1-23.1s10.75-23.1 23.1-23.1s23.1 10.75 23.1 23.1S237.3 120 224 120zM352 248c-13.25 0-23.1-10.75-23.1-23.1s10.75-23.1 23.1-23.1s23.1 10.75 23.1 23.1S365.3 248 352 248zM591.1 192l-118.7 0c4.418 10.27 6.604 21.25 6.604 32.23c0 20.7-7.865 41.38-23.63 57.14l-136.2 136.2v46.37C320 490.5 341.5 512 368 512h223.1c26.5 0 47.1-21.5 47.1-47.1V240C639.1 213.5 618.5 192 591.1 192zM479.1 376c-13.25 0-23.1-10.75-23.1-23.1s10.75-23.1 23.1-23.1s23.1 10.75 23.1 23.1S493.2 376 479.1 376z',
			),
		),
		'label'             => __( 'Dice', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'dice-d20'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M20.04 317.3C18 317.3 16 315.8 16 313.3V150.5c0-2.351 1.91-4.012 4.001-4.012c.6882 0 1.396 .18 2.062 .5748l76.62 45.1l-75.28 122.3C22.59 316.8 21.31 317.3 20.04 317.3zM231.4 405.2l-208.2-22.06c-4.27-.4821-7.123-4.117-7.123-7.995c0-1.401 .3725-2.834 1.185-4.161L122.7 215.1L231.4 405.2zM31.1 420.1c0-2.039 1.508-4.068 3.93-4.068c.1654 0 .3351 .0095 .5089 .0291l203.6 22.31v65.66C239.1 508.6 236.2 512 232 512c-1.113 0-2.255-.2387-3.363-.7565L34.25 423.6C32.69 422.8 31.1 421.4 31.1 420.1zM33.94 117.1c-1.289-.7641-1.938-2.088-1.938-3.417c0-1.281 .6019-2.567 1.813-3.364l150.8-98.59C185.1 10.98 187.3 10.64 188.6 10.64c4.32 0 8.003 3.721 8.003 8.022c0 1.379-.3788 2.818-1.237 4.214L115.5 165.8L33.94 117.1zM146.8 175.1l95.59-168.4C245.5 2.53 250.7 0 255.1 0s10.5 2.53 13.62 7.624l95.59 168.4H146.8zM356.4 207.1l-100.4 175.7L155.6 207.1H356.4zM476.1 415.1c2.422 0 3.93 2.029 3.93 4.068c0 1.378-.6893 2.761-2.252 3.524l-194.4 87.66c-1.103 .5092-2.241 .7443-3.35 .7443c-4.2 0-7.994-3.371-7.994-7.994v-65.69l203.6-22.28C475.7 416 475.9 415.1 476.1 415.1zM494.8 370.9C495.6 372.3 496 373.7 496 375.1c0 3.872-2.841 7.499-7.128 7.98l-208.2 22.06l108.6-190.1L494.8 370.9zM316.6 22.87c-.8581-1.395-1.237-2.834-1.237-4.214c0-4.301 3.683-8.022 8.003-8.022c1.308 0 2.675 .3411 4.015 1.11l150.8 98.59c1.211 .7973 1.813 2.076 1.813 3.353c0 1.325-.6488 2.649-1.938 3.429L396.5 165.8L316.6 22.87zM491.1 146.5c2.091 0 4.001 1.661 4.001 4.012v162.8c0 2.483-2.016 4.006-4.053 4.006c-1.27 0-2.549-.5919-3.353-1.912l-75.28-122.3l76.62-45.1C490.6 146.7 491.3 146.5 491.1 146.5z',
			),
		),
		'label'             => __( 'Dice D20', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'dice-d6'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M7.994 153.5c1.326 0 2.687 .3508 3.975 1.119L208 271.5v223.8c0 9.741-7.656 16.71-16.01 16.71c-2.688 0-5.449-.7212-8.05-2.303l-152.2-92.47C12.13 405.3 0 383.3 0 359.5v-197.7C0 156.1 3.817 153.5 7.994 153.5zM426.2 117.2c0 2.825-1.352 5.647-4.051 7.248L224 242.6L25.88 124.4C23.19 122.8 21.85 119.1 21.85 117.2c0-2.8 1.32-5.603 3.965-7.221l165.1-100.9C201.7 3.023 212.9 0 224 0s22.27 3.023 32.22 9.07l165.1 100.9C424.8 111.6 426.2 114.4 426.2 117.2zM440 153.5C444.2 153.5 448 156.1 448 161.8v197.7c0 23.75-12.12 45.75-31.78 57.69l-152.2 92.5C261.5 511.3 258.7 512 256 512C247.7 512 240 505 240 495.3V271.5l196-116.9C437.3 153.8 438.7 153.5 440 153.5z',
			),
		),
		'label'             => __( 'Dice D6', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'dice-five'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M384 32H64C28.62 32 0 60.62 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.62 419.4 32 384 32zM128 384c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S145.6 384 128 384zM128 192C110.4 192 96 177.6 96 160s14.38-32 32-32s32 14.38 32 32S145.6 192 128 192zM224 288C206.4 288 192 273.6 192 256s14.38-32 32-32s32 14.38 32 32S241.6 288 224 288zM320 384c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S337.6 384 320 384zM320 192c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S337.6 192 320 192z',
			),
		),
		'label'             => __( 'Dice Five', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'dice-four'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M384 32H64C28.62 32 0 60.62 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.62 419.4 32 384 32zM128 384c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S145.6 384 128 384zM128 192C110.4 192 96 177.6 96 160s14.38-32 32-32s32 14.38 32 32S145.6 192 128 192zM320 384c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S337.6 384 320 384zM320 192c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S337.6 192 320 192z',
			),
		),
		'label'             => __( 'Dice Four', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'dice-one'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M384 32H64C28.62 32 0 60.62 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.62 419.4 32 384 32zM224 288C206.4 288 192 273.6 192 256s14.38-32 32-32s32 14.38 32 32S241.6 288 224 288z',
			),
		),
		'label'             => __( 'Dice One', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'dice-six'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M384 32H64C28.62 32 0 60.62 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.62 419.4 32 384 32zM128 384c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S145.6 384 128 384zM128 288C110.4 288 96 273.6 96 256s14.38-32 32-32s32 14.38 32 32S145.6 288 128 288zM128 192C110.4 192 96 177.6 96 160s14.38-32 32-32s32 14.38 32 32S145.6 192 128 192zM320 384c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S337.6 384 320 384zM320 288c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S337.6 288 320 288zM320 192c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S337.6 192 320 192z',
			),
		),
		'label'             => __( 'Dice Six', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'dice-three'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M384 32H64C28.62 32 0 60.62 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.62 419.4 32 384 32zM128 192C110.4 192 96 177.6 96 160s14.38-32 32-32s32 14.38 32 32S145.6 192 128 192zM224 288C206.4 288 192 273.6 192 256s14.38-32 32-32s32 14.38 32 32S241.6 288 224 288zM320 384c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S337.6 384 320 384z',
			),
		),
		'label'             => __( 'Dice Three', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'dice-two'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M384 32H64C28.62 32 0 60.62 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.62 419.4 32 384 32zM128 192C110.4 192 96 177.6 96 160s14.38-32 32-32s32 14.38 32 32S145.6 192 128 192zM320 384c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S337.6 384 320 384z',
			),
		),
		'label'             => __( 'Dice Two', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'digg'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M81.7 172.3H0v174.4h132.7V96h-51v76.3zm0 133.4H50.9v-92.3h30.8v92.3zm297.2-133.4v174.4h81.8v28.5h-81.8V416H512V172.3H378.9zm81.8 133.4h-30.8v-92.3h30.8v92.3zm-235.6 41h82.1v28.5h-82.1V416h133.3V172.3H225.1v174.4zm51.2-133.3h30.8v92.3h-30.8v-92.3zM153.3 96h51.3v51h-51.3V96zm0 76.3h51.3v174.4h-51.3V172.3z',
			),
		),
		'label'             => __( 'Digg Logo', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'digital-ocean'                        => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M87 481.8h73.7v-73.6H87zM25.4 346.6v61.6H87v-61.6zm466.2-169.7c-23-74.2-82.4-133.3-156.6-156.6C164.9-32.8 8 93.7 8 255.9h95.8c0-101.8 101-180.5 208.1-141.7 39.7 14.3 71.5 46.1 85.8 85.7 39.1 107-39.7 207.8-141.4 208v.3h-.3V504c162.6 0 288.8-156.8 235.6-327.1zm-235.3 231v-95.3h-95.6v95.6H256v-.3z',
			),
		),
		'label'             => __( 'Digital Ocean', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'discord'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M524.5 69.84a1.5 1.5 0 0 0 -.764-.7A485.1 485.1 0 0 0 404.1 32.03a1.816 1.816 0 0 0 -1.923 .91 337.5 337.5 0 0 0 -14.9 30.6 447.8 447.8 0 0 0 -134.4 0 309.5 309.5 0 0 0 -15.14-30.6 1.89 1.89 0 0 0 -1.924-.91A483.7 483.7 0 0 0 116.1 69.14a1.712 1.712 0 0 0 -.788 .676C39.07 183.7 18.19 294.7 28.43 404.4a2.016 2.016 0 0 0 .765 1.375A487.7 487.7 0 0 0 176 479.9a1.9 1.9 0 0 0 2.063-.676A348.2 348.2 0 0 0 208.1 430.4a1.86 1.86 0 0 0 -1.019-2.588 321.2 321.2 0 0 1 -45.87-21.85 1.885 1.885 0 0 1 -.185-3.126c3.082-2.309 6.166-4.711 9.109-7.137a1.819 1.819 0 0 1 1.9-.256c96.23 43.92 200.4 43.92 295.5 0a1.812 1.812 0 0 1 1.924 .233c2.944 2.426 6.027 4.851 9.132 7.16a1.884 1.884 0 0 1 -.162 3.126 301.4 301.4 0 0 1 -45.89 21.83 1.875 1.875 0 0 0 -1 2.611 391.1 391.1 0 0 0 30.01 48.81 1.864 1.864 0 0 0 2.063 .7A486 486 0 0 0 610.7 405.7a1.882 1.882 0 0 0 .765-1.352C623.7 277.6 590.9 167.5 524.5 69.84zM222.5 337.6c-28.97 0-52.84-26.59-52.84-59.24S193.1 219.1 222.5 219.1c29.67 0 53.31 26.82 52.84 59.24C275.3 310.1 251.9 337.6 222.5 337.6zm195.4 0c-28.97 0-52.84-26.59-52.84-59.24S388.4 219.1 417.9 219.1c29.67 0 53.31 26.82 52.84 59.24C470.7 310.1 447.5 337.6 417.9 337.6z',
			),
		),
		'label'             => __( 'Discord', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'brands',
			'social',
			'social',
		),
	),
	'discourse'                            => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M225.9 32C103.3 32 0 130.5 0 252.1 0 256 .1 480 .1 480l225.8-.2c122.7 0 222.1-102.3 222.1-223.9C448 134.3 348.6 32 225.9 32zM224 384c-19.4 0-37.9-4.3-54.4-12.1L88.5 392l22.9-75c-9.8-18.1-15.4-38.9-15.4-61 0-70.7 57.3-128 128-128s128 57.3 128 128-57.3 128-128 128z',
			),
		),
		'label'             => __( 'Discourse', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'brands',
			'social',
			'social',
		),
	),
	'disease'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M472.2 195.9l-66.1-22.1c-19.25-6.624-33.5-20.87-38.13-38.24l-16-60.49c-11.62-43.74-76.63-57.11-110-22.62L194.1 99.3c-13.25 13.75-33.5 20.87-54.25 19.25L68.86 112.9c-52-3.999-86.88 44.99-59 82.86l38.63 52.49c11 14.1 12.75 33.74 4.625 50.12l-28.5 56.99c-20.62 41.24 22.88 84.86 73.5 73.86l69.1-15.25c20.12-4.499 41.38 .0001 57 11.62l54.38 40.87c39.38 29.62 101 7.623 104.5-37.24l4.625-61.86c1.375-17.75 12.88-33.87 30.62-42.99l61.1-31.62C526.1 269.8 520.9 212.5 472.2 195.9zM159.1 256c-17.62 0-31.1-14.37-31.1-31.1s14.37-31.1 31.1-31.1s31.1 14.37 31.1 31.1S177.6 256 159.1 256zM287.1 351.1c-17.62 0-31.1-14.37-31.1-31.1c0-17.62 14.37-31.1 31.1-31.1s31.1 14.37 31.1 31.1C319.1 337.6 305.6 351.1 287.1 351.1zM303.1 224c-8.875 0-15.1-7.125-15.1-15.1c0-8.873 7.125-15.1 15.1-15.1s15.1 7.125 15.1 15.1C319.1 216.9 312.9 224 303.1 224z',
			),
		),
		'label'             => __( 'Disease', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'display'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M528 0h-480C21.5 0 0 21.5 0 48v320C0 394.5 21.5 416 48 416h192L224 464H152C138.8 464 128 474.8 128 488S138.8 512 152 512h272c13.25 0 24-10.75 24-24s-10.75-24-24-24H352L336 416h192c26.5 0 48-21.5 48-48v-320C576 21.5 554.5 0 528 0zM512 352H64V64h448V352z',
			),
		),
		'label'             => __( 'Display', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'divide'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M400 224h-352c-17.69 0-32 14.31-32 31.1s14.31 32 32 32h352c17.69 0 32-14.31 32-32S417.7 224 400 224zM224 144c26.47 0 48-21.53 48-48s-21.53-48-48-48s-48 21.53-48 48S197.5 144 224 144zM224 368c-26.47 0-48 21.53-48 48s21.53 48 48 48s48-21.53 48-48S250.5 368 224 368z',
			),
		),
		'label'             => __( 'Divide', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'dna'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M.1193 494.1c-1.125 9.5 6.312 17.87 15.94 17.87l32.06 .0635c8.125 0 15.21-5.833 16.21-13.83c.7501-4.875 1.869-11.17 3.494-18.17h312c1.625 6.875 2.904 13.31 3.529 18.18c1.125 7.1 7.84 13.94 15.97 13.82l32.46-.0625c9.625 0 17.12-8.374 15.99-17.87c-4.625-37.87-25.75-128.1-119.1-207.7c-17.5 12.37-36.98 24.37-58.48 35.49c6.25 4.625 11.56 9.405 17.06 14.15H159.7c21.25-18.12 47.03-35.63 78.65-51.38c172.1-85.5 203.7-218.8 209.5-266.7c1.125-9.5-6.297-17.88-15.92-17.88L399.6 .001c-8.125 0-14.84 5.832-15.96 13.83c-.7501 4.875-1.869 11.17-3.369 18.17H67.74C66.24 25 65.08 18.81 64.33 13.81C63.21 5.813 56.48-.124 48.36 .001L16.1 .1338c-9.625 0-17.09 8.354-15.96 17.85c5.125 42.87 31.29 153.8 159.9 238.1C31.55 340.3 5.245 451.2 .1193 494.1zM223.9 219.7C198.8 205.9 177.6 191.3 159.7 176h128.5C270.4 191.3 249 206.1 223.9 219.7zM355.1 96c-5.875 10.37-12.88 21.12-21 31.1H113.1c-8.25-10.87-15.3-21.63-21.05-32L355.1 96zM93 415.1c5.875-10.37 12.74-21.13 20.87-32h219.4c8.375 10.87 15.48 21.63 21.23 32H93z',
			),
		),
		'label'             => __( 'Dna', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'dochub'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 416,
				'height' => 512,
				'path'   => 'M397.9 160H256V19.6L397.9 160zM304 192v130c0 66.8-36.5 100.1-113.3 100.1H96V84.8h94.7c12 0 23.1 .8 33.1 2.5v-84C212.9 1.1 201.4 0 189.2 0H0v512h189.2C329.7 512 400 447.4 400 318.1V192h-96z',
			),
		),
		'label'             => __( 'DocHub', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'docker'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M349.9 236.3h-66.1v-59.4h66.1v59.4zm0-204.3h-66.1v60.7h66.1V32zm78.2 144.8H362v59.4h66.1v-59.4zm-156.3-72.1h-66.1v60.1h66.1v-60.1zm78.1 0h-66.1v60.1h66.1v-60.1zm276.8 100c-14.4-9.7-47.6-13.2-73.1-8.4-3.3-24-16.7-44.9-41.1-63.7l-14-9.3-9.3 14c-18.4 27.8-23.4 73.6-3.7 103.8-8.7 4.7-25.8 11.1-48.4 10.7H2.4c-8.7 50.8 5.8 116.8 44 162.1 37.1 43.9 92.7 66.2 165.4 66.2 157.4 0 273.9-72.5 328.4-204.2 21.4 .4 67.6 .1 91.3-45.2 1.5-2.5 6.6-13.2 8.5-17.1l-13.3-8.9zm-511.1-27.9h-66v59.4h66.1v-59.4zm78.1 0h-66.1v59.4h66.1v-59.4zm78.1 0h-66.1v59.4h66.1v-59.4zm-78.1-72.1h-66.1v60.1h66.1v-60.1z',
			),
		),
		'label'             => __( 'Docker', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'dog'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M332.7 19.85C334.6 8.395 344.5 0 356.1 0C363.6 0 370.6 3.52 375.1 9.502L392 32H444.1C456.8 32 469.1 37.06 478.1 46.06L496 64H552C565.3 64 576 74.75 576 88V112C576 156.2 540.2 192 496 192H426.7L421.6 222.5L309.6 158.5L332.7 19.85zM448 64C439.2 64 432 71.16 432 80C432 88.84 439.2 96 448 96C456.8 96 464 88.84 464 80C464 71.16 456.8 64 448 64zM416 256.1V480C416 497.7 401.7 512 384 512H352C334.3 512 320 497.7 320 480V364.8C295.1 377.1 268.8 384 240 384C211.2 384 184 377.1 160 364.8V480C160 497.7 145.7 512 128 512H96C78.33 512 64 497.7 64 480V249.8C35.23 238.9 12.64 214.5 4.836 183.3L.9558 167.8C-3.331 150.6 7.094 133.2 24.24 128.1C41.38 124.7 58.76 135.1 63.05 152.2L66.93 167.8C70.49 182 83.29 191.1 97.97 191.1H303.8L416 256.1z',
			),
		),
		'label'             => __( 'Dog', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'dollar-sign'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M160 0C177.7 0 192 14.33 192 32V67.68C193.6 67.89 195.1 68.12 196.7 68.35C207.3 69.93 238.9 75.02 251.9 78.31C268.1 82.65 279.4 100.1 275 117.2C270.7 134.3 253.3 144.7 236.1 140.4C226.8 137.1 198.5 133.3 187.3 131.7C155.2 126.9 127.7 129.3 108.8 136.5C90.52 143.5 82.93 153.4 80.92 164.5C78.98 175.2 80.45 181.3 82.21 185.1C84.1 189.1 87.79 193.6 95.14 198.5C111.4 209.2 136.2 216.4 168.4 225.1L171.2 225.9C199.6 233.6 234.4 243.1 260.2 260.2C274.3 269.6 287.6 282.3 295.8 299.9C304.1 317.7 305.9 337.7 302.1 358.1C295.1 397 268.1 422.4 236.4 435.6C222.8 441.2 207.8 444.8 192 446.6V480C192 497.7 177.7 512 160 512C142.3 512 128 497.7 128 480V445.1C127.6 445.1 127.1 444.1 126.7 444.9L126.5 444.9C102.2 441.1 62.07 430.6 35 418.6C18.85 411.4 11.58 392.5 18.76 376.3C25.94 360.2 44.85 352.9 60.1 360.1C81.9 369.4 116.3 378.5 136.2 381.6C168.2 386.4 194.5 383.6 212.3 376.4C229.2 369.5 236.9 359.5 239.1 347.5C241 336.8 239.6 330.7 237.8 326.9C235.9 322.9 232.2 318.4 224.9 313.5C208.6 302.8 183.8 295.6 151.6 286.9L148.8 286.1C120.4 278.4 85.58 268.9 59.76 251.8C45.65 242.4 32.43 229.7 24.22 212.1C15.89 194.3 14.08 174.3 17.95 153C25.03 114.1 53.05 89.29 85.96 76.73C98.98 71.76 113.1 68.49 128 66.73V32C128 14.33 142.3 0 160 0V0z',
			),
		),
		'label'             => __( 'Dollar Sign', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'dolly'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M294.2 277.8c17.1 5 34.62 13.38 49.5 24.62l161.5-53.75c8.375-2.875 12.88-11.88 10-20.25L454.8 47.25c-2.748-8.502-11.88-13-20.12-10.12l-61.13 20.37l33.12 99.38l-60.75 20.13l-33.12-99.38L251.2 98.13c-8.373 2.75-12.87 11.88-9.998 20.12L294.2 277.8zM574.4 309.9c-5.594-16.75-23.67-25.91-40.48-20.23l-202.5 67.51c-17.22-22.01-43.57-36.41-73.54-36.97L165.7 43.75C156.9 17.58 132.5 0 104.9 0H32C14.33 0 0 14.33 0 32s14.33 32 32 32h72.94l92.22 276.7C174.7 358.2 160 385.3 160 416c0 53.02 42.98 96 96 96c52.4 0 94.84-42.03 95.82-94.2l202.3-67.44C570.9 344.8 579.1 326.6 574.4 309.9zM256 448c-17.67 0-32-14.33-32-32c0-17.67 14.33-31.1 32-31.1S288 398.3 288 416C288 433.7 273.7 448 256 448z',
			),
		),
		'label'             => __( 'Dolly', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'dong-sign'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M320 64C337.7 64 352 78.33 352 96C352 113.7 337.7 128 320 128V384C320 401.7 305.7 416 288 416C275 416 263.9 408.3 258.8 397.2C239.4 409.1 216.5 416 192 416C121.3 416 64 358.7 64 288C64 217.3 121.3 160 192 160C215.3 160 237.2 166.2 256 177.1V128H224C206.3 128 192 113.7 192 96C192 78.33 206.3 64 224 64H256C256 46.33 270.3 32 288 32C305.7 32 320 46.33 320 64V64zM256 288C256 252.7 227.3 224 192 224C156.7 224 128 252.7 128 288C128 323.3 156.7 352 192 352C227.3 352 256 323.3 256 288zM352 448C369.7 448 384 462.3 384 480C384 497.7 369.7 512 352 512H32C14.33 512 0 497.7 0 480C0 462.3 14.33 448 32 448H352z',
			),
		),
		'label'             => __( 'Dong Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'door-closed'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M560 448H480V50.75C480 22.75 458.5 0 432 0h-288C117.5 0 96 22.75 96 50.75V448H16C7.125 448 0 455.1 0 464v32C0 504.9 7.125 512 16 512h544c8.875 0 16-7.125 16-16v-32C576 455.1 568.9 448 560 448zM384 288c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S401.6 288 384 288z',
			),
		),
		'label'             => __( 'Door Closed', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'science-and-technology',
			'travel',
		),
	),
	'door-open'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M560 448H512V113.5c0-27.25-21.5-49.5-48-49.5L352 64.01V128h96V512h112c8.875 0 16-7.125 16-15.1v-31.1C576 455.1 568.9 448 560 448zM280.3 1.007l-192 49.75C73.1 54.51 64 67.76 64 82.88V448H16c-8.875 0-16 7.125-16 15.1v31.1C0 504.9 7.125 512 16 512H320V33.13C320 11.63 300.5-4.243 280.3 1.007zM232 288c-13.25 0-24-14.37-24-31.1c0-17.62 10.75-31.1 24-31.1S256 238.4 256 256C256 273.6 245.3 288 232 288z',
			),
		),
		'label'             => __( 'Door Open', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'science-and-technology',
			'travel',
		),
	),
	'dove'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M288 167.2V139.1c-28.25-36.38-47.13-79.29-54.13-125.2C231.7 .4054 214.8-5.02 206.1 5.481C184.1 30.36 168.4 59.7 157.2 92.07C191.4 130.3 237.2 156.7 288 167.2zM400 63.97c-44.25 0-79.1 35.82-79.1 80.08l.0014 59.44c-104.4-6.251-193-70.46-233-161.7C81.48 29.25 63.76 28.58 58.01 40.83C41.38 75.96 32.01 115.2 32.01 156.6c0 70.76 34.11 136.9 85.11 185.9c13.12 12.75 26.13 23.27 38.88 32.77L12.12 411.2c-10.75 2.75-15.5 15.09-9.5 24.47c17.38 26.88 60.42 72.54 153.2 76.29c8 .25 15.99-2.633 22.12-7.883l65.23-56.12l76.84 .0561c88.38 0 160-71.49 160-159.9l.0013-160.2l31.1-63.99L400 63.97zM400 160.1c-8.75 0-16.01-7.259-16.01-16.01c0-8.876 7.261-16.05 16.01-16.05s15.99 7.136 15.99 16.01C416 152.8 408.8 160.1 400 160.1z',
			),
		),
		'label'             => __( 'Dove', 'astra' ),
		'custom_categories' => array(
			'business',
			'environment',
		),
	),
	'down-left-and-up-right-to-center'     => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M215.1 272h-136c-12.94 0-24.63 7.797-29.56 19.75C45.47 303.7 48.22 317.5 57.37 326.6l30.06 30.06l-78.06 78.07c-12.5 12.5-12.5 32.75-.0012 45.25l22.62 22.62c12.5 12.5 32.76 12.5 45.26 .0013l78.06-78.07l30.06 30.06c6.125 6.125 14.31 9.367 22.63 9.367c4.125 0 8.279-.7891 12.25-2.43c11.97-4.953 19.75-16.62 19.75-29.56V296C239.1 282.7 229.3 272 215.1 272zM296 240h136c12.94 0 24.63-7.797 29.56-19.75c4.969-11.97 2.219-25.72-6.938-34.87l-30.06-30.06l78.06-78.07c12.5-12.5 12.5-32.76 .0002-45.26l-22.62-22.62c-12.5-12.5-32.76-12.5-45.26-.0003l-78.06 78.07l-30.06-30.06c-9.156-9.141-22.87-11.84-34.87-6.937c-11.97 4.953-19.75 16.62-19.75 29.56v135.1C272 229.3 282.7 240 296 240z',
			),
		),
		'label'             => __( 'Down Left And Up Right To Center', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
		),
	),
	'down-long'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M281.6 392.3l-104 112.1c-9.498 10.24-25.69 10.24-35.19 0l-104-112.1c-6.484-6.992-8.219-17.18-4.404-25.94c3.811-8.758 12.45-14.42 21.1-14.42H128V32c0-17.69 14.33-32 32-32S192 14.31 192 32v319.9h72c9.547 0 18.19 5.66 22 14.42C289.8 375.1 288.1 385.3 281.6 392.3z',
			),
		),
		'label'             => __( 'Down Long', 'astra' ),
		'custom_categories' => array(),
	),
	'download'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M480 352h-133.5l-45.25 45.25C289.2 409.3 273.1 416 256 416s-33.16-6.656-45.25-18.75L165.5 352H32c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h448c17.67 0 32-14.33 32-32v-96C512 366.3 497.7 352 480 352zM432 456c-13.2 0-24-10.8-24-24c0-13.2 10.8-24 24-24s24 10.8 24 24C456 445.2 445.2 456 432 456zM233.4 374.6C239.6 380.9 247.8 384 256 384s16.38-3.125 22.62-9.375l128-128c12.49-12.5 12.49-32.75 0-45.25c-12.5-12.5-32.76-12.5-45.25 0L288 274.8V32c0-17.67-14.33-32-32-32C238.3 0 224 14.33 224 32v242.8L150.6 201.4c-12.49-12.5-32.75-12.5-45.25 0c-12.49 12.5-12.49 32.75 0 45.25L233.4 374.6z',
			),
		),
		'label'             => __( 'Download', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'draft2digital'                        => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 480,
				'height' => 512,
				'path'   => 'M480 398.1l-144-82.2v64.7h-91.3c30.8-35 81.8-95.9 111.8-149.3 35.2-62.6 16.1-123.4-12.8-153.3-4.4-4.6-62.2-62.9-166-41.2-59.1 12.4-89.4 43.4-104.3 67.3-13.1 20.9-17 39.8-18.2 47.7-5.5 33 19.4 67.1 56.7 67.1 31.7 0 57.3-25.7 57.3-57.4 0-27.1-19.7-52.1-48-56.8 1.8-7.3 17.7-21.1 26.3-24.7 41.1-17.3 78 5.2 83.3 33.5 8.3 44.3-37.1 90.4-69.7 127.6C84.5 328.1 18.3 396.8 0 415.9l336-.1V480zM369.9 371l47.1 27.2-47.1 27.2zM134.2 161.4c0 12.4-10 22.4-22.4 22.4s-22.4-10-22.4-22.4 10-22.4 22.4-22.4 22.4 10.1 22.4 22.4zM82.5 380.5c25.6-27.4 97.7-104.7 150.8-169.9 35.1-43.1 40.3-82.4 28.4-112.7-7.4-18.8-17.5-30.2-24.3-35.7 45.3 2.1 68 23.4 82.2 38.3 0 0 42.4 48.2 5.8 113.3-37 65.9-110.9 147.5-128.5 166.7z',
			),
		),
		'label'             => __( 'Draft2digital', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'dragon'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M18.43 255.8L192 224L100.8 292.6C90.67 302.8 97.8 320 112 320h222.7c-9.499-26.5-14.75-54.5-14.75-83.38V194.2L200.3 106.8C176.5 90.88 145 92.75 123.3 111.2l-117.5 116.4C-6.562 238 2.436 258 18.43 255.8zM575.2 289.9l-100.7-50.25c-16.25-8.125-26.5-24.75-26.5-43V160h63.99l28.12 22.62C546.1 188.6 554.2 192 562.7 192h30.1c11.1 0 23.12-6.875 28.5-17.75l14.37-28.62c5.374-10.87 4.25-23.75-2.999-33.5l-74.49-99.37C552.1 4.75 543.5 0 533.5 0H296C288.9 0 285.4 8.625 290.4 13.62L351.1 64L292.4 88.75c-5.874 3-5.874 11.37 0 14.37L351.1 128l-.0011 108.6c0 72 35.99 139.4 95.99 179.4c-195.6 6.75-344.4 41-434.1 60.88c-8.124 1.75-13.87 9-13.87 17.38C.0463 504 8.045 512 17.79 512h499.1c63.24 0 119.6-47.5 122.1-110.8C642.3 354 617.1 310.9 575.2 289.9zM489.1 66.25l45.74 11.38c-2.75 11-12.5 18.88-24.12 18.25C497.7 95.25 484.8 83.38 489.1 66.25z',
			),
		),
		'label'             => __( 'Dragon', 'astra' ),
		'custom_categories' => array(
			'environment',
			'lifestyle-and-hobbies',
		),
	),
	'draw-polygon'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M384.3 352C419.5 352.2 448 380.7 448 416C448 451.3 419.3 480 384 480C360.3 480 339.6 467.1 328.6 448H119.4C108.4 467.1 87.69 480 64 480C28.65 480 0 451.3 0 416C0 392.3 12.87 371.6 32 360.6V151.4C12.87 140.4 0 119.7 0 96C0 60.65 28.65 32 64 32C87.69 32 108.4 44.87 119.4 64H328.6C339.6 44.87 360.3 32 384 32C419.3 32 448 60.65 448 96C448 131.3 419.5 159.8 384.3 159.1L345.5 227.9C349.7 236.4 352 245.9 352 256C352 266.1 349.7 275.6 345.5 284.1L384.3 352zM96 360.6C105.7 366.2 113.8 374.3 119.4 384H328.6C328.6 383.9 328.7 383.8 328.7 383.7L292.2 319.9C290.8 319.1 289.4 320 288 320C252.7 320 224 291.3 224 256C224 220.7 252.7 192 288 192C289.4 192 290.8 192 292.2 192.1L328.7 128.3L328.6 128H119.4C113.8 137.7 105.7 145.8 96 151.4L96 360.6z',
			),
		),
		'label'             => __( 'Draw Polygon', 'astra' ),
		'custom_categories' => array(
			'design',
			'travel',
		),
	),
	'dribbble'                             => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 8C119.3 8 8 119.3 8 256s111.3 248 248 248 248-111.3 248-248S392.7 8 256 8zm163.1 114.4c29.5 36.05 47.37 81.96 47.83 131.1-6.984-1.477-77.02-15.68-147.5-6.818-5.752-14.04-11.18-26.39-18.62-41.61 78.32-31.98 113.8-77.48 118.3-83.52zM396.4 97.87c-3.81 5.427-35.7 48.29-111 76.52-34.71-63.78-73.18-116.2-79.04-124 67.18-16.19 137.1 1.27 190.1 47.49zm-230.5-33.25c5.585 7.659 43.44 60.12 78.54 122.5-99.09 26.31-186.4 25.93-195.8 25.81C62.38 147.2 106.7 92.57 165.9 64.62zM44.17 256.3c0-2.166 .043-4.322 .108-6.473 9.268 .19 111.9 1.513 217.7-30.15 6.064 11.87 11.86 23.92 17.17 35.95-76.6 21.58-146.2 83.53-180.5 142.3C64.79 360.4 44.17 310.7 44.17 256.3zm81.81 167.1c22.13-45.23 82.18-103.6 167.6-132.8 29.74 77.28 42.04 142.1 45.19 160.6-68.11 29.01-150 21.05-212.8-27.88zm248.4 8.489c-2.171-12.89-13.45-74.9-41.15-151 66.38-10.63 124.7 6.768 131.9 9.055-9.442 58.94-43.27 109.8-90.79 141.1z',
			),
		),
		'label'             => __( 'Dribbble', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'brands',
			'social',
			'social',
		),
	),
	'dribbble-square'                      => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M90.2 228.2c8.9-42.4 37.4-77.7 75.7-95.7 3.6 4.9 28 38.8 50.7 79-64 17-120.3 16.8-126.4 16.7zM314.6 154c-33.6-29.8-79.3-41.1-122.6-30.6 3.8 5.1 28.6 38.9 51 80 48.6-18.3 69.1-45.9 71.6-49.4zM140.1 364c40.5 31.6 93.3 36.7 137.3 18-2-12-10-53.8-29.2-103.6-55.1 18.8-93.8 56.4-108.1 85.6zm98.8-108.2c-3.4-7.8-7.2-15.5-11.1-23.2C159.6 253 93.4 252.2 87.4 252c0 1.4-.1 2.8-.1 4.2 0 35.1 13.3 67.1 35.1 91.4 22.2-37.9 67.1-77.9 116.5-91.8zm34.9 16.3c17.9 49.1 25.1 89.1 26.5 97.4 30.7-20.7 52.5-53.6 58.6-91.6-4.6-1.5-42.3-12.7-85.1-5.8zm-20.3-48.4c4.8 9.8 8.3 17.8 12 26.8 45.5-5.7 90.7 3.4 95.2 4.4-.3-32.3-11.8-61.9-30.9-85.1-2.9 3.9-25.8 33.2-76.3 53.9zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-64 176c0-88.2-71.8-160-160-160S64 167.8 64 256s71.8 160 160 160 160-71.8 160-160z',
			),
		),
		'label'             => __( 'Dribbble Square', 'astra' ),
		'custom_categories' => array(),
	),
	'dropbox'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 528,
				'height' => 512,
				'path'   => 'M264.4 116.3l-132 84.3 132 84.3-132 84.3L0 284.1l132.3-84.3L0 116.3 132.3 32l132.1 84.3zM131.6 395.7l132-84.3 132 84.3-132 84.3-132-84.3zm132.8-111.6l132-84.3-132-83.6L395.7 32 528 116.3l-132.3 84.3L528 284.8l-132.3 84.3-131.3-85z',
			),
		),
		'label'             => __( 'Dropbox', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'droplet'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M16 319.1C16 245.9 118.3 89.43 166.9 19.3C179.2 1.585 204.8 1.585 217.1 19.3C265.7 89.43 368 245.9 368 319.1C368 417.2 289.2 496 192 496C94.8 496 16 417.2 16 319.1zM112 319.1C112 311.2 104.8 303.1 96 303.1C87.16 303.1 80 311.2 80 319.1C80 381.9 130.1 432 192 432C200.8 432 208 424.8 208 416C208 407.2 200.8 400 192 400C147.8 400 112 364.2 112 319.1z',
			),
		),
		'label'             => __( 'Droplet', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
			'travel',
		),
	),
	'droplet-slash'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M215.3 143.4C243.5 95.07 274.2 49.29 294.9 19.3C307.2 1.585 332.8 1.585 345.1 19.3C393.7 89.43 496 245.9 496 319.1C496 333.7 494.4 347.1 491.5 359.9L630.8 469.1C641.2 477.3 643.1 492.4 634.9 502.8C626.7 513.2 611.6 515.1 601.2 506.9L9.196 42.89C-1.236 34.71-3.065 19.63 5.112 9.196C13.29-1.236 28.37-3.065 38.81 5.112L215.3 143.4zM143.1 319.1C143.1 296.5 154.3 264.6 169.1 229.9L443.5 445.4C411.7 476.7 368.1 496 319.1 496C222.8 496 143.1 417.2 143.1 319.1V319.1zM239.1 319.1C239.1 311.2 232.8 303.1 223.1 303.1C215.2 303.1 207.1 311.2 207.1 319.1C207.1 381.9 258.1 432 319.1 432C328.8 432 336 424.8 336 416C336 407.2 328.8 400 319.1 400C275.8 400 239.1 364.2 239.1 319.1V319.1z',
			),
		),
		'label'             => __( 'Droplet Slash', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'drum'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M431.1 122l70.02-45.91c11.09-7.273 14.19-22.14 6.906-33.25c-7.219-11.07-22.09-14.23-33.22-6.924l-106.4 69.73c-49.81-8.787-97.18-9.669-112.4-9.669c-.002 0 .002 0 0 0C219.5 96 0 100.6 0 208.3v160.1c0 30.27 27.5 57.68 71.1 77.85v-101.9c0-13.27 10.75-24.03 24-24.03s23.1 10.76 23.1 24.03v118.9C153 472.4 191.1 478.3 231.1 480v-103.6c0-13.27 10.75-24.03 24-24.03c.002 0-.002 0 0 0c13.25 0 24 10.76 24 24.03V480c40.93-1.668 78.95-7.615 111.1-16.72v-118.9c0-13.27 10.75-24.03 24-24.03s24 10.76 24 24.03v101.9c44.49-20.17 71.1-47.58 71.1-77.85V208.3C511.1 164.9 476.1 138.4 431.1 122zM255.1 272.5C255.1 272.5 255.1 272.5 255.1 272.5c-114.9 0-207.1-28.97-207.1-64.39s93.12-63.1 207.1-63.1c.002 0-.002 0 0 0c17.5 0 34.47 .7139 50.71 1.966L242.8 187.1c-11.09 7.273-14.19 22.14-6.906 33.25C240.5 228.3 248.2 232.1 256 232.1c4.5 0 9.062-1.265 13.12-3.923l109.3-71.67c51.77 11.65 85.5 30.38 85.5 51.67C463.1 243.6 370.9 272.5 255.1 272.5z',
			),
		),
		'label'             => __( 'Drum', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'drum-steelpan'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M288 32C129 32 0 89.25 0 160v192c0 70.75 129 128 288 128s288-57.25 288-128V160C576 89.25 447 32 288 32zM205 190.4c-4.5 16.62-14.5 30.5-28.25 40.5C100.2 217.5 48 190.8 48 160c0-30.12 50.12-56.38 124-69.1l25.62 44.25C207.5 151.4 210.1 171.2 205 190.4zM288 240c-21.12 0-41.38-.1-60.88-2.75C235.1 211.1 259.2 192 288 192s52.88 19.12 60.88 45.25C329.4 239 309.1 240 288 240zM352 96c0 35.25-28.75 64-64 64S224 131.2 224 96V83C244.4 81.12 265.8 80 288 80s43.63 1.125 64 3V96zM398.9 230.9c-13.75-9.875-23.88-23.88-28.38-40.5c-5.125-19.13-2.5-39 7.375-56l25.62-44.5C477.8 103.5 528 129.8 528 160C528 190.9 475.6 217.5 398.9 230.9z',
			),
		),
		'label'             => __( 'Drum Steelpan', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'drumstick-bite'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 168.9c0 1.766-.0229 3.398-.0768 5.164c-16.91-9.132-35.51-13.76-53.96-13.76c-82.65 0-105.5 74.17-105.5 105.4c0 27.04 9.923 54.43 29.63 76.25c-19.52 6.629-39.99 9.997-60.62 9.997l-87.18 .0038l-40.59 40.49c-6.104 6.103-8.921 14.01-8.921 22.17c0 13.98 7.244 17.1 7.244 37.03C192.1 485.4 164.6 512 131.7 512c-15.63 0-31.11-6.055-42.72-17.8c-11.55-11.46-16.82-26.31-16.82-41.26c0-4.948 .575-9.903 1.695-14.75c-4.842 1.11-9.793 1.681-14.72 1.681c-42.15 0-59.13-36.64-59.13-59.5c0-33.43 27.15-60.34 60.39-60.34c18.97 0 22.97 7.219 36.96 7.219c8.159 0 16.04-2.811 22.14-8.914l40.57-40.47L160.1 191.1c0-63.1 27.79-107 63.17-142.4c33.13-33.06 76.39-49.59 119.7-49.59s86.79 16.53 119.9 49.59C495.9 82.5 512 125.7 512 168.9z',
			),
		),
		'label'             => __( 'Drumstick Bite', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'drupal'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M303.1 108.1C268.2 72.46 234.2 38.35 224 0c-9.957 38.35-44.25 72.46-80.02 108.1C90.47 161.7 29.72 222.4 29.72 313.4c-2.337 107.3 82.75 196.2 190.1 198.5S415.9 429.2 418.3 321.9q.091-4.231 0-8.464C418.3 222.4 357.5 161.7 303.1 108.1zm-174.3 223a130.3 130.3 0 0 0 -15.21 24.15 4.978 4.978 0 0 1 -3.319 2.766h-1.659c-4.333 0-9.219-8.481-9.219-8.481h0c-1.29-2.028-2.489-4.149-3.687-6.361l-.83-1.752c-11.25-25.72-1.475-62.32-1.475-62.32h0a160.6 160.6 0 0 1 23.23-49.87A290.8 290.8 0 0 1 138.5 201.6l9.219 9.219 43.51 44.43a4.979 4.979 0 0 1 0 6.638L145.8 312.3h0zm96.61 127.3a67.2 67.2 0 0 1 -49.78-111.9c14.2-16.87 31.53-33.46 50.33-55.31 22.31 23.78 36.88 40.1 51.16 57.99a28.41 28.41 0 0 1 2.95 4.425 65.9 65.9 0 0 1 11.98 37.98 66.65 66.65 0 0 1 -66.47 66.84zM352.4 351.6h0a7.743 7.743 0 0 1 -6.176 5.347H344.9a11.25 11.25 0 0 1 -6.269-5.07h0a348.2 348.2 0 0 0 -39.46-48.95L281.4 284.5 222.3 223.2a497.9 497.9 0 0 1 -35.4-36.32 12.03 12.03 0 0 0 -.922-1.382 35.4 35.4 0 0 1 -4.7-9.219V174.5a31.35 31.35 0 0 1 9.218-27.66c11.43-11.43 22.95-22.95 33.83-34.94 11.98 13.27 24.8 26 37.43 38.63h0a530.1 530.1 0 0 1 69.6 79.1 147.5 147.5 0 0 1 27.01 83.8A134.1 134.1 0 0 1 352.4 351.6z',
			),
		),
		'label'             => __( 'Drupal Logo', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'dumbbell'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M104 96h-48C42.75 96 32 106.8 32 120V224C14.33 224 0 238.3 0 256c0 17.67 14.33 32 31.1 32L32 392C32 405.3 42.75 416 56 416h48C117.3 416 128 405.3 128 392v-272C128 106.8 117.3 96 104 96zM456 32h-48C394.8 32 384 42.75 384 56V224H256V56C256 42.75 245.3 32 232 32h-48C170.8 32 160 42.75 160 56v400C160 469.3 170.8 480 184 480h48C245.3 480 256 469.3 256 456V288h128v168c0 13.25 10.75 24 24 24h48c13.25 0 24-10.75 24-24V56C480 42.75 469.3 32 456 32zM608 224V120C608 106.8 597.3 96 584 96h-48C522.8 96 512 106.8 512 120v272c0 13.25 10.75 24 24 24h48c13.25 0 24-10.75 24-24V288c17.67 0 32-14.33 32-32C640 238.3 625.7 224 608 224z',
			),
		),
		'label'             => __( 'Dumbbell', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'dumpster'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M560 160c10.38 0 17.1-9.75 15.5-19.88l-24-95.1C549.8 37 543.3 32 536 32h-98.88l25.62 128H560zM272 32H171.5L145.9 160H272V32zM404.5 32H304v128h126.1L404.5 32zM16 160h97.25l25.63-128H40C32.75 32 26.25 37 24.5 44.12l-24 95.1C-2.001 150.2 5.625 160 16 160zM560 224h-20L544 192H32l4 32H16C7.25 224 0 231.2 0 240v32C0 280.8 7.25 288 16 288h28L64 448v16C64 472.8 71.25 480 80 480h32C120.8 480 128 472.8 128 464V448h320v16c0 8.75 7.25 16 16 16h32c8.75 0 16-7.25 16-16V448l20-160H560C568.8 288 576 280.8 576 272v-32C576 231.2 568.8 224 560 224z',
			),
		),
		'label'             => __( 'Dumpster', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'dumpster-fire'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M418.8 104.2L404.6 32H304.1L304 159.1h60.77C381.1 140.7 399.1 121.8 418.8 104.2zM272.1 32.12H171.5L145.9 160.1h126.1L272.1 32.12zM461.3 104.2c18.25 16.25 35.51 33.62 51.14 51.49c5.751-5.623 11.38-11.12 17.38-16.37l21.26-18.98l21.25 18.98c1.125 .9997 2.125 2.124 3.126 3.124c-.125-.7498 .2501-1.5 0-2.249l-24-95.97c-1.625-7.123-8.127-12.12-15.38-12.12H437.2l12.25 61.5L461.3 104.2zM16 160.1l97.26-.0223l25.64-127.9h-98.89c-7.251 0-13.75 4.999-15.5 12.12L.5001 140.2C-2.001 150.3 5.626 160.1 16 160.1zM340.6 192.1L32.01 192.1l4.001 31.99L16 224.1C7.252 224.1 0 231.3 0 240.1V272c0 8.748 7.251 15.1 16 15.1l28.01 .0177l20 159.1L64.01 464C64.01 472.8 71.26 480 80.01 480h32.01c8.752 0 16-7.248 16-15.1v-15.1l208.8-.002c-30.13-33.74-48.73-77.85-48.73-126.3C288.1 285.8 307.9 238.8 340.6 192.1zM551.2 163.3c-14.88 13.25-28.38 27.12-40.26 41.12c-19.5-25.74-43.63-51.99-71.01-76.36c-70.14 62.73-120 144.2-120 193.6C319.1 409.1 391.6 480 479.1 480s160-70.87 160-158.3C640.1 285 602.1 209.4 551.2 163.3zM532.6 392.6c-14.75 10.62-32.88 16.1-52.51 16.1c-49.01 0-88.89-33.49-88.89-87.98c0-27.12 16.5-50.99 49.38-91.85c4.751 5.498 67.14 87.98 67.14 87.98l39.76-46.99c2.876 4.874 5.375 9.497 7.75 13.1C573.9 321.5 565.1 368.4 532.6 392.6z',
			),
		),
		'label'             => __( 'Dumpster Fire', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'dungeon'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M336.6 156.5C327.3 148.1 322.6 136.5 327.1 125.3L357.6 49.18C362.7 36.27 377.8 30.36 389.7 37.63C410.9 50.63 430 66.62 446.5 85.02C455.7 95.21 452.9 110.9 441.5 118.5L373.9 163.5C363.6 170.4 349.8 168.1 340.5 159.9C339.2 158.7 337.9 157.6 336.6 156.5H336.6zM297.7 112.6C293.2 123.1 280.9 129.8 268.7 128.6C264.6 128.2 260.3 128 256 128C251.7 128 247.4 128.2 243.3 128.6C231.1 129.8 218.8 123.1 214.3 112.6L183.1 36.82C178.8 24.02 185.5 9.433 198.1 6.374C217.3 2.203 236.4 0 256 0C275.6 0 294.7 2.203 313 6.374C326.5 9.433 333.2 24.02 328 36.82L297.7 112.6zM122.3 37.63C134.2 30.36 149.3 36.27 154.4 49.18L184.9 125.3C189.4 136.5 184.7 148.1 175.4 156.5C174.1 157.6 172.8 158.7 171.5 159.9C162.2 168.1 148.4 170.4 138.1 163.5L70.52 118.5C59.13 110.9 56.32 95.21 65.46 85.02C81.99 66.62 101.1 50.63 122.3 37.63H122.3zM379.5 222.1C376.3 210.7 379.7 198.1 389.5 191.6L458.1 145.8C469.7 138.1 485.6 141.9 491.2 154.7C501.6 178.8 508.4 204.8 510.9 232C512.1 245.2 501.3 255.1 488 255.1H408C394.7 255.1 384.2 245.2 381.8 232.1C381.1 228.7 380.4 225.4 379.5 222.1V222.1zM122.5 191.6C132.3 198.1 135.7 210.7 132.5 222.1C131.6 225.4 130.9 228.7 130.2 232.1C127.8 245.2 117.3 256 104 256H24C10.75 256-.1184 245.2 1.107 232C3.636 204.8 10.43 178.8 20.82 154.7C26.36 141.9 42.26 138.1 53.91 145.8L122.5 191.6zM104 288C117.3 288 128 298.7 128 312V360C128 373.3 117.3 384 104 384H24C10.75 384 0 373.3 0 360V312C0 298.7 10.75 288 24 288H104zM488 288C501.3 288 512 298.7 512 312V360C512 373.3 501.3 384 488 384H408C394.7 384 384 373.3 384 360V312C384 298.7 394.7 288 408 288H488zM104 416C117.3 416 128 426.7 128 440V488C128 501.3 117.3 512 104 512H24C10.75 512 0 501.3 0 488V440C0 426.7 10.75 416 24 416H104zM488 416C501.3 416 512 426.7 512 440V488C512 501.3 501.3 512 488 512H408C394.7 512 384 501.3 384 488V440C384 426.7 394.7 416 408 416H488zM272 464C272 472.8 264.8 480 256 480C247.2 480 240 472.8 240 464V192C240 183.2 247.2 176 256 176C264.8 176 272 183.2 272 192V464zM208 464C208 472.8 200.8 480 192 480C183.2 480 176 472.8 176 464V224C176 215.2 183.2 208 192 208C200.8 208 208 215.2 208 224V464zM336 464C336 472.8 328.8 480 320 480C311.2 480 304 472.8 304 464V224C304 215.2 311.2 208 320 208C328.8 208 336 215.2 336 224V464z',
			),
		),
		'label'             => __( 'Dungeon', 'astra' ),
		'custom_categories' => array(
			'business',
			'lifestyle-and-hobbies',
			'science-and-technology',
		),
	),
	'dyalog'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 416,
				'height' => 512,
				'path'   => 'M0 32v119.2h64V96h107.2C284.6 96 352 176.2 352 255.9 352 332 293.4 416 171.2 416H0v64h171.2C331.9 480 416 367.3 416 255.9c0-58.7-22.1-113.4-62.3-154.3C308.9 56 245.7 32 171.2 32H0z',
			),
		),
		'label'             => __( 'Dyalog', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'e'                                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M320 448c0 17.67-14.33 32-32 32H32c-17.67 0-32-14.33-32-32v-384C0 46.34 14.33 32.01 32 32.01h256c17.67 0 32 14.33 32 32s-14.33 32-32 32H64v128h160c17.67 0 32 14.32 32 31.99s-14.33 32.01-32 32.01H64v128h224C305.7 416 320 430.3 320 448z',
			),
		),
		'label'             => __( 'E', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'ear-deaf'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M192 319.1C185.8 313.7 177.6 310.6 169.4 310.6S153 313.7 146.8 319.1l-137.4 137.4C3.124 463.6 0 471.8 0 480c0 18.3 14.96 31.1 31.1 31.1c8.188 0 16.38-3.124 22.62-9.371l137.4-137.4c6.247-6.247 9.371-14.44 9.371-22.62S198.3 326.2 192 319.1zM200 240c0-22.06 17.94-40 40-40s40 17.94 40 40c0 13.25 10.75 24 24 24s24-10.75 24-24c0-48.53-39.47-88-88-88S152 191.5 152 240c0 13.25 10.75 24 24 24S200 253.3 200 240zM511.1 31.1c0-8.188-3.124-16.38-9.371-22.62s-14.44-9.372-22.63-9.372s-16.38 3.124-22.62 9.372L416 50.75c-6.248 6.248-9.372 14.44-9.372 22.63c0 8.188 3.123 16.38 9.37 22.62c6.247 6.248 14.44 9.372 22.63 9.372s16.38-3.124 22.63-9.372l41.38-41.38C508.9 48.37 511.1 40.18 511.1 31.1zM415.1 241.6c0-57.78-42.91-177.6-175.1-177.6c-153.6 0-175.2 150.8-175.2 160.4c0 17.32 14.99 31.58 32.75 31.58c16.61 0 29.25-13.07 31.24-29.55c6.711-55.39 54.02-98.45 111.2-98.45c80.45 0 111.2 75.56 111.2 119.6c0 57.94-38.22 98.14-46.37 106.3L288 370.7v13.25c0 31.4-22.71 57.58-52.58 62.98C220.4 449.7 208 463.3 208 478.6c0 17.95 14.72 32.09 32.03 32.09c4.805 0 100.5-14.34 111.2-112.7C412.6 335.8 415.1 263.4 415.1 241.6z',
			),
		),
		'label'             => __( 'Ear Deaf', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'ear-listen'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M160.1 320c-17.64 0-32.02 14.37-32.02 31.1s14.38 31.1 32.02 31.1s32.02-14.37 32.02-31.1S177.8 320 160.1 320zM86.66 361.4c-12.51-12.49-32.77-12.49-45.27 0c-12.51 12.5-12.51 32.78 0 45.27l63.96 63.99c12.51 12.49 32.77 12.49 45.27 .002c12.51-12.5 12.51-32.78 0-45.27L86.66 361.4zM32.02 448C14.38 448 0 462.4 0 480S14.38 512 32.02 512c17.64 0 32.02-14.37 32.02-31.1S49.66 448 32.02 448zM287.7 70.31c-110.9-29.38-211.7 47.53-222.8 150.9C62.1 239.9 78.73 255.1 97.57 255.1c16.61 0 29.25-13.07 31.24-29.55c6.934-57.22 57.21-101.3 116.9-98.3c71.71 3.594 117.1 76.82 102.5 146.9c-6.551 29.65-21.4 56.87-43.38 78.87L288 370.7v13.25c0 31.4-22.71 57.58-52.58 62.98C220.4 449.7 208 463.3 208 478.6c0 19.78 17.88 34.94 37.38 31.64c55.92-9.443 99.63-55.28 105.9-112.2c40.11-40.68 62.89-93.95 64.65-150.9C418.4 166.4 365.8 91 287.7 70.31zM240 200c22.06 0 40 17.94 40 40c0 13.25 10.75 24 24 24s24-10.75 24-24c0-48.53-39.47-88-88-88S152 191.5 152 240c0 13.25 10.75 24 24 24S200 253.3 200 240C200 217.9 217.9 200 240 200zM397.8 3.125c-15.91-7.594-35.05-.8438-42.66 15.09c-7.594 15.97-.8281 35.06 15.12 42.66C417.5 83.41 448 134.9 448 192c0 17.69 14.33 32 32 32S512 209.7 512 192C512 110.3 467.2 36.19 397.8 3.125z',
			),
		),
		'label'             => __( 'Ear Listen', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
		),
	),
	'earlybirds'                           => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 480,
				'height' => 512,
				'path'   => 'M313.2 47.5c1.2-13 21.3-14 36.6-8.7 .9 .3 26.2 9.7 19 15.2-27.9-7.4-56.4 18.2-55.6-6.5zm-201 6.9c30.7-8.1 62 20 61.1-7.1-1.3-14.2-23.4-15.3-40.2-9.6-1 .3-28.7 10.5-20.9 16.7zM319.4 160c-8.8 0-16 7.2-16 16s7.2 16 16 16 16-7.2 16-16-7.2-16-16-16zm-159.7 0c-8.8 0-16 7.2-16 16s7.2 16 16 16 16-7.2 16-16-7.2-16-16-16zm318.5 163.2c-9.9 24-40.7 11-63.9-1.2-13.5 69.1-58.1 111.4-126.3 124.2 .3 .9-2-.1 24 1 33.6 1.4 63.8-3.1 97.4-8-19.8-13.8-11.4-37.1-9.8-38.1 1.4-.9 14.7 1.7 21.6 11.5 8.6-12.5 28.4-14.8 30.2-13.6 1.6 1.1 6.6 20.9-6.9 34.6 4.7-.9 8.2-1.6 9.8-2.1 2.6-.8 17.7 11.3 3.1 13.3-14.3 2.3-22.6 5.1-47.1 10.8-45.9 10.7-85.9 11.8-117.7 12.8l1 11.6c3.8 18.1-23.4 24.3-27.6 6.2 .8 17.9-27.1 21.8-28.4-1l-.5 5.3c-.7 18.4-28.4 17.9-28.3-.6-7.5 13.5-28.1 6.8-26.4-8.5l1.2-12.4c-36.7 .9-59.7 3.1-61.8 3.1-20.9 0-20.9-31.6 0-31.6 2.4 0 27.7 1.3 63.2 2.8-61.1-15.5-103.7-55-114.9-118.2-25 12.8-57.5 26.8-68.2 .8-10.5-25.4 21.5-42.6 66.8-73.4 .7-6.6 1.6-13.3 2.7-19.8-14.4-19.6-11.6-36.3-16.1-60.4-16.8 2.4-23.2-9.1-23.6-23.1 .3-7.3 2.1-14.9 2.4-15.4 1.1-1.8 10.1-2 12.7-2.6 6-31.7 50.6-33.2 90.9-34.5 19.7-21.8 45.2-41.5 80.9-48.3C203.3 29 215.2 8.5 216.2 8c1.7-.8 21.2 4.3 26.3 23.2 5.2-8.8 18.3-11.4 19.6-10.7 1.1 .6 6.4 15-4.9 25.9 40.3 3.5 72.2 24.7 96 50.7 36.1 1.5 71.8 5.9 77.1 34 2.7 .6 11.6 .8 12.7 2.6 .3 .5 2.1 8.1 2.4 15.4-.5 13.9-6.8 25.4-23.6 23.1-3.2 17.3-2.7 32.9-8.7 47.7 2.4 11.7 4 23.8 4.8 36.4 37 25.4 70.3 42.5 60.3 66.9zM207.4 159.9c.9-44-37.9-42.2-78.6-40.3-21.7 1-38.9 1.9-45.5 13.9-11.4 20.9 5.9 92.9 23.2 101.2 9.8 4.7 73.4 7.9 86.3-7.1 8.2-9.4 15-49.4 14.6-67.7zm52 58.3c-4.3-12.4-6-30.1-15.3-32.7-2-.5-9-.5-11 0-10 2.8-10.8 22.1-17 37.2 15.4 0 19.3 9.7 23.7 9.7 4.3 0 6.3-11.3 19.6-14.2zm135.7-84.7c-6.6-12.1-24.8-12.9-46.5-13.9-40.2-1.9-78.2-3.8-77.3 40.3-.5 18.3 5 58.3 13.2 67.8 13 14.9 76.6 11.8 86.3 7.1 15.8-7.6 36.5-78.9 24.3-101.3z',
			),
		),
		'label'             => __( 'Earlybirds', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'earth-africa'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM177.8 63.19L187.8 80.62C190.5 85.46 192 90.93 192 96.5V137.9C192 141.8 193.6 145.6 196.3 148.3C202.6 154.6 212.8 153.1 218.3 147.1L231.9 130.1C236.6 124.2 244.8 122.4 251.6 125.8L266.8 133.4C270.2 135.1 273.1 136 277.8 136C284.3 136 290.6 133.4 295.2 128.8L299.1 124.9C302 121.1 306.5 121.2 310.1 123.1L339.4 137.7C347.1 141.6 352 149.5 352 158.1C352 168.6 344.9 177.8 334.7 180.3L299.3 189.2C291.9 191 284.2 190.7 276.1 188.3L244.1 177.7C241.7 176.6 238.2 176 234.8 176C227.8 176 220.1 178.3 215.4 182.5L176 212C165.9 219.6 160 231.4 160 244V272C160 298.5 181.5 320 208 320H240C248.8 320 256 327.2 256 336V384C256 401.7 270.3 416 288 416C298.1 416 307.6 411.3 313.6 403.2L339.2 369.1C347.5 357.1 352 344.5 352 330.7V318.6C352 314.7 354.6 311.3 358.4 310.4L363.7 309.1C375.6 306.1 384 295.4 384 283.1C384 275.1 381.2 269.2 376.2 264.2L342.7 230.7C338.1 226.1 338.1 221 342.7 217.3C348.4 211.6 356.8 209.6 364.5 212.2L378.6 216.9C390.9 220.1 404.3 215.4 410.1 203.8C413.6 196.8 421.3 193.1 428.1 194.6L456.4 200.1C431.1 112.4 351.5 48 256 48C228.3 48 201.1 53.4 177.8 63.19L177.8 63.19z',
			),
		),
		'label'             => __( 'Earth Africa', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'earth-americas'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM57.71 192.1L67.07 209.4C75.36 223.9 88.99 234.6 105.1 239.2L162.1 255.7C180.2 260.6 192 276.3 192 294.2V334.1C192 345.1 198.2 355.1 208 359.1C217.8 364.9 224 374.9 224 385.9V424.9C224 440.5 238.9 451.7 253.9 447.4C270.1 442.8 282.5 429.1 286.6 413.7L289.4 402.5C293.6 385.6 304.6 371.1 319.7 362.4L327.8 357.8C342.8 349.3 352 333.4 352 316.1V307.9C352 295.1 346.9 282.9 337.9 273.9L334.1 270.1C325.1 261.1 312.8 255.1 300.1 255.1H256.1C245.9 255.1 234.9 253.1 225.2 247.6L190.7 227.8C186.4 225.4 183.1 221.4 181.6 216.7C178.4 207.1 182.7 196.7 191.7 192.1L197.7 189.2C204.3 185.9 211.9 185.3 218.1 187.7L242.2 195.4C250.3 198.1 259.3 195 264.1 187.9C268.8 180.8 268.3 171.5 262.9 165L249.3 148.8C239.3 136.8 239.4 119.3 249.6 107.5L265.3 89.12C274.1 78.85 275.5 64.16 268.8 52.42L266.4 48.26C262.1 48.09 259.5 48 256 48C163.1 48 84.4 108.9 57.71 192.1L57.71 192.1zM437.6 154.5L412 164.8C396.3 171.1 388.2 188.5 393.5 204.6L410.4 255.3C413.9 265.7 422.4 273.6 433 276.3L462.2 283.5C463.4 274.5 464 265.3 464 256C464 219.2 454.4 184.6 437.6 154.5H437.6z',
			),
		),
		'label'             => __( 'Earth Americas', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'earth-asia'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM51.68 295.1L83.41 301.5C91.27 303.1 99.41 300.6 105.1 294.9L120.5 279.5C132 267.1 151.6 271.1 158.9 285.8L168.2 304.3C172.1 313.9 182.8 319.1 193.5 319.1C208.7 319.1 219.6 305.4 215.2 290.8L209.3 270.9C204.6 255.5 216.2 240 232.3 240H234.6C247.1 240 260.5 233.3 267.9 222.2L278.6 206.1C284.2 197.7 283.9 186.6 277.8 178.4L261.7 156.9C251.4 143.2 258.4 123.4 275.1 119.2L292.1 114.1C299.6 113.1 305.7 107.8 308.6 100.6L324.9 59.69C303.4 52.12 280.2 48 255.1 48C141.1 48 47.1 141.1 47.1 256C47.1 269.4 49.26 282.5 51.68 295.1L51.68 295.1zM450.4 300.4L434.6 304.9C427.9 306.7 420.8 304 417.1 298.2L415.1 295.1C409.1 285.7 398.7 279.1 387.5 279.1C376.4 279.1 365.1 285.7 359.9 295.1L353.8 304.6C352.4 306.8 350.5 308.7 348.2 309.1L311.1 330.1C293.9 340.2 286.5 362.5 294.1 381.4L300.5 393.8C309.1 413 331.2 422.3 350.1 414.9L353.5 413.1C363.6 410.2 374.8 411.8 383.5 418.1L385 419.2C422.2 389.7 449.1 347.8 459.4 299.7C456.4 299.4 453.4 299.6 450.4 300.4H450.4zM156.1 367.5L188.1 375.5C196.7 377.7 205.4 372.5 207.5 363.9C209.7 355.3 204.5 346.6 195.9 344.5L163.9 336.5C155.3 334.3 146.6 339.5 144.5 348.1C142.3 356.7 147.5 365.4 156.1 367.5V367.5zM236.5 328.1C234.3 336.7 239.5 345.4 248.1 347.5C256.7 349.7 265.4 344.5 267.5 335.9L275.5 303.9C277.7 295.3 272.5 286.6 263.9 284.5C255.3 282.3 246.6 287.5 244.5 296.1L236.5 328.1zM321.7 120.8L305.7 152.8C301.7 160.7 304.9 170.4 312.8 174.3C320.7 178.3 330.4 175.1 334.3 167.2L350.3 135.2C354.3 127.3 351.1 117.6 343.2 113.7C335.3 109.7 325.6 112.9 321.7 120.8V120.8z',
			),
		),
		'label'             => __( 'Earth Asia', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'earth-europe'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM266.3 48.25L232.5 73.6C227.2 77.63 224 83.95 224 90.67V99.72C224 106.5 229.5 112 236.3 112C238.7 112 241.1 111.3 243.1 109.9L284.9 82.06C286.9 80.72 289.3 80 291.7 80H292.7C298.9 80 304 85.07 304 91.31C304 94.31 302.8 97.19 300.7 99.31L280.8 119.2C275 124.1 267.9 129.4 260.2 131.9L233.6 140.8C227.9 142.7 224 148.1 224 154.2C224 157.9 222.5 161.5 219.9 164.1L201.9 182.1C195.6 188.4 192 197.1 192 206.1V210.3C192 226.7 205.6 240 221.9 240C232.9 240 243.1 233.8 248 224L252 215.9C254.5 211.1 259.4 208 264.8 208C269.4 208 273.6 210.1 276.3 213.7L292.6 235.5C294.7 238.3 298.1 240 301.7 240C310.1 240 315.6 231.1 311.8 223.6L310.7 221.3C307.1 214.3 310.7 205.8 318.1 203.3L339.3 196.2C346.9 193.7 352 186.6 352 178.6C352 168.3 360.3 160 370.6 160H400C408.8 160 416 167.2 416 176C416 184.8 408.8 192 400 192H379.3C372.1 192 365.1 194.9 360 200L355.3 204.7C353.2 206.8 352 209.7 352 212.7C352 218.9 357.1 224 363.3 224H374.6C380.6 224 386.4 226.4 390.6 230.6L397.2 237.2C398.1 238.1 400 241.4 400 244C400 246.6 398.1 249 397.2 250.8L389.7 258.3C386 261.1 384 266.9 384 272C384 277.1 386 282 389.7 285.7L408 304C418.2 314.2 432.1 320 446.6 320H453.1C460.5 299.8 464 278.3 464 256C464 144.6 376.4 53.64 266.3 48.25V48.25zM438.4 356.1C434.7 353.5 430.2 352 425.4 352C419.4 352 413.6 349.6 409.4 345.4L395.1 331.1C388.3 324.3 377.9 320 367.1 320C357.4 320 347.9 316.5 340.5 310.2L313.1 287.4C302.4 277.5 287.6 271.1 272.3 271.1H251.4C238.7 271.1 226.4 275.7 215.9 282.7L188.5 301C170.7 312.9 160 332.9 160 354.3V357.5C160 374.5 166.7 390.7 178.7 402.7L194.7 418.7C203.2 427.2 214.7 432 226.7 432H248C261.3 432 272 442.7 272 456C272 458.5 272.4 461 273.1 463.3C344.5 457.5 405.6 415.7 438.4 356.1L438.4 356.1zM164.7 100.7L132.7 132.7C126.4 138.9 126.4 149.1 132.7 155.3C138.9 161.6 149.1 161.6 155.3 155.3L187.3 123.3C193.6 117.1 193.6 106.9 187.3 100.7C181.1 94.44 170.9 94.44 164.7 100.7V100.7z',
			),
		),
		'label'             => __( 'Earth Europe', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'earth-oceania'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM215.5 360.6L240.9 377C247.1 381.6 256.2 384 264.6 384C278 384 290.7 377.8 298.1 367.2L311 351.8C316.8 344.4 320 335.2 320 325.8C320 316.4 316.8 307.2 311 299.8L293.1 276.9C288.3 270.7 284.4 263.1 281.6 256.7L271.5 230.8C269.9 226.7 265.9 224 261.5 224C258 224 254.8 225.6 252.8 228.4L242.4 242.6C237.7 248.1 229.7 252.1 221.9 250.5C218.7 249.8 215.8 247.1 213.8 245.4L209.3 239.3C202.1 229.7 190.7 224 178.7 224C166.7 224 155.3 229.7 148.1 239.3L142.8 246.3C141.3 248.4 139.2 250 136.9 251.1L101.6 267.9C81.08 277.7 72.8 302.6 83.37 322.7L86.65 328.9C95.67 346.1 115.7 354.3 134.1 348.4L149.5 343.6C156 341.5 163.1 341.6 169.6 343.8L208.6 357.3C211 358.1 213.4 359.2 215.5 360.6H215.5zM273.8 142.5C264.3 132.1 250.8 128.9 237.6 131.5L199.1 139.2C183.8 142.3 181.5 163.2 195.7 169.5L238.5 188.6C243.7 190.8 249.2 192 254.8 192H284.7C298.9 192 306.1 174.8 296 164.7L273.8 142.5zM264 448H280C288.8 448 296 440.8 296 432C296 423.2 288.8 416 280 416H264C255.2 416 248 423.2 248 432C248 440.8 255.2 448 264 448zM431.2 298.9C428.4 290.6 419.3 286 410.9 288.8C402.6 291.6 398 300.7 400.8 309.1L408.8 333.1C411.6 341.4 420.7 345.1 429.1 343.2C437.4 340.4 441.1 331.3 439.2 322.9L431.2 298.9zM411.3 379.3C417.6 373.1 417.6 362.9 411.3 356.7C405.1 350.4 394.9 350.4 388.7 356.7L356.7 388.7C350.4 394.9 350.4 405.1 356.7 411.3C362.9 417.6 373.1 417.6 379.3 411.3L411.3 379.3z',
			),
		),
		'label'             => __( 'Earth Oceania', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'ebay'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M606 189.5l-54.8 109.9-54.9-109.9h-37.5l10.9 20.6c-11.5-19-35.9-26-63.3-26-31.8 0-67.9 8.7-71.5 43.1h33.7c1.4-13.8 15.7-21.8 35-21.8 26 0 41 9.6 41 33v3.4c-12.7 0-28 .1-41.7 .4-42.4 .9-69.6 10-76.7 34.4 1-5.2 1.5-10.6 1.5-16.2 0-52.1-39.7-76.2-75.4-76.2-21.3 0-43 5.5-58.7 24.2v-80.6h-32.1v169.5c0 10.3-.6 22.9-1.1 33.1h31.5c.7-6.3 1.1-12.9 1.1-19.5 13.6 16.6 35.4 24.9 58.7 24.9 36.9 0 64.9-21.9 73.3-54.2-.5 2.8-.7 5.8-.7 9 0 24.1 21.1 45 60.6 45 26.6 0 45.8-5.7 61.9-25.5 0 6.6 .3 13.3 1.1 20.2h29.8c-.7-8.2-1-17.5-1-26.8v-65.6c0-9.3-1.7-17.2-4.8-23.8l61.5 116.1-28.5 54.1h35.9L640 189.5zM243.7 313.8c-29.6 0-50.2-21.5-50.2-53.8 0-32.4 20.6-53.8 50.2-53.8 29.8 0 50.2 21.4 50.2 53.8 0 32.3-20.4 53.8-50.2 53.8zm200.9-47.3c0 30-17.9 48.4-51.6 48.4-25.1 0-35-13.4-35-25.8 0-19.1 18.1-24.4 47.2-25.3 13.1-.5 27.6-.6 39.4-.6zm-411.9 1.6h128.8v-8.5c0-51.7-33.1-75.4-78.4-75.4-56.8 0-83 30.8-83 77.6 0 42.5 25.3 74 82.5 74 31.4 0 68-11.7 74.4-46.1h-33.1c-12 35.8-87.7 36.7-91.2-21.6zm95-21.4H33.3c6.9-56.6 92.1-54.7 94.4 0z',
			),
		),
		'label'             => __( 'eBay', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'edge'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M481.9 134.5C440.9 54.18 352.3 8 255.9 8 137.1 8 37.51 91.68 13.47 203.7c26-46.49 86.22-79.14 149.5-79.14 79.27 0 121.1 48.93 122.3 50.18 22 23.8 33 50.39 33 83.1 0 10.4-5.31 25.82-15.11 38.57-1.57 2-6.39 4.84-6.39 11 0 5.06 3.29 9.92 9.14 14 27.86 19.37 80.37 16.81 80.51 16.81A115.4 115.4 0 0 0 444.9 322a118.9 118.9 0 0 0 58.95-102.4C504.4 176.1 488.4 147.3 481.9 134.5zM212.8 475.7a154.9 154.9 0 0 1 -46.64-45c-32.94-47.42-34.24-95.6-20.1-136A155.5 155.5 0 0 1 203 215.8c59-45.2 94.84-5.65 99.06-1a80 80 0 0 0 -4.89-10.14c-9.24-15.93-24-36.41-56.56-53.51-33.72-17.69-70.59-18.59-77.64-18.59-38.71 0-77.9 13-107.5 35.69C35.68 183.3 12.77 208.7 8.6 243c-1.08 12.31-2.75 62.8 23 118.3a248 248 0 0 0 248.3 141.6C241.8 496.3 214.1 476.2 212.8 475.7zm250.7-98.33a7.76 7.76 0 0 0 -7.92-.23 181.7 181.7 0 0 1 -20.41 9.12 197.5 197.5 0 0 1 -69.55 12.52c-91.67 0-171.5-63.06-171.5-144A61.12 61.12 0 0 1 200.6 228 168.7 168.7 0 0 0 161.9 278c-14.92 29.37-33 88.13 13.33 151.7 6.51 8.91 23 30 56 47.67 23.57 12.65 49 19.61 71.7 19.61 35.14 0 115.4-33.44 163-108.9A7.75 7.75 0 0 0 463.5 377.3z',
			),
		),
		'label'             => __( 'Edge Browser', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'edge-legacy'                          => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M25.71 228.2l.35-.48c0 .16 0 .32-.07 .48zm460.6 15.51c0-44-7.76-84.46-28.81-122.4C416.5 47.88 343.9 8 258.9 8 119 7.72 40.62 113.2 26.06 227.7c42.42-61.31 117.1-121.4 220.4-125 0 0 109.7 0 99.42 105H170c6.37-37.39 18.55-59 34.34-78.93-75.05 34.9-121.8 96.1-120.8 188.3 .83 71.45 50.13 144.8 120.8 172 83.35 31.84 192.8 7.2 240.1-21.33V363.3C363.6 419.8 173.6 424.2 172.2 295.7H486.3V243.7z',
			),
		),
		'label'             => __( 'Edge Legacy Browser', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'egg'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M192 16c-106 0-192 182-192 288c0 106 85.1 192 192 192c105.1 0 192-85.1 192-192C384 198 297.1 16 192 16zM160.1 138C128.6 177.1 96 249.8 96 304C96 312.8 88.84 320 80 320S64 312.8 64 304c0-63.56 36.7-143.3 71.22-186c5.562-6.906 15.64-7.969 22.5-2.406C164.6 121.1 165.7 131.2 160.1 138z',
			),
		),
		'label'             => __( 'Egg', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'eject'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M48.01 319.1h351.1c41.62 0 63.49-49.63 35.37-80.38l-175.1-192.1c-19-20.62-51.75-20.62-70.75 0L12.64 239.6C-15.48 270.2 6.393 319.1 48.01 319.1zM399.1 384H48.01c-26.39 0-47.99 21.59-47.99 47.98C.0117 458.4 21.61 480 48.01 480h351.1c26.39 0 47.99-21.6 47.99-47.99C447.1 405.6 426.4 384 399.1 384z',
			),
		),
		'label'             => __( 'Eject', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
		),
	),
	'elementor'                            => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M.361 256C.361 397 114 511 255 511C397 511 511 397 511 256C511 116 397 2.05 255 2.05C114 2.05 .361 116 .361 256zM192 150V363H149V150H192zM234 150H362V193H234V150zM362 235V278H234V235H362zM234 320H362V363H234V320z',
			),
		),
		'label'             => __( 'Elementor', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'elevator'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M79 96h130c5.967 0 11.37-3.402 13.75-8.662c2.385-5.262 1.299-11.39-2.754-15.59l-65-67.34c-5.684-5.881-16.31-5.881-21.99 0l-65 67.34C63.95 75.95 62.87 82.08 65.25 87.34C67.63 92.6 73.03 96 79 96zM357 91.59c5.686 5.881 16.31 5.881 21.99 0l65-67.34c4.053-4.199 5.137-10.32 2.754-15.59C444.4 3.402 438.1 0 433 0h-130c-5.967 0-11.37 3.402-13.75 8.662c-2.385 5.262-1.301 11.39 2.752 15.59L357 91.59zM448 128H64c-35.35 0-64 28.65-64 63.1v255.1C0 483.3 28.65 512 64 512h384c35.35 0 64-28.65 64-63.1V192C512 156.7 483.3 128 448 128zM352 224C378.5 224.1 400 245.5 400 272c0 26.46-21.47 47.9-48 48C325.5 319.9 304 298.5 304 272C304 245.5 325.5 224.1 352 224zM160 224C186.5 224.1 208 245.5 208 272c0 26.46-21.47 47.9-48 48C133.5 319.9 112 298.5 112 272C112 245.5 133.5 224.1 160 224zM240 448h-160v-48C80 373.5 101.5 352 128 352h64c26.51 0 48 21.49 48 48V448zM432 448h-160v-48c0-26.51 21.49-48 48-48h64c26.51 0 48 21.49 48 48V448z',
			),
		),
		'label'             => __( 'Elevator', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'ellipsis'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M120 256C120 286.9 94.93 312 64 312C33.07 312 8 286.9 8 256C8 225.1 33.07 200 64 200C94.93 200 120 225.1 120 256zM280 256C280 286.9 254.9 312 224 312C193.1 312 168 286.9 168 256C168 225.1 193.1 200 224 200C254.9 200 280 225.1 280 256zM328 256C328 225.1 353.1 200 384 200C414.9 200 440 225.1 440 256C440 286.9 414.9 312 384 312C353.1 312 328 286.9 328 256z',
			),
		),
		'label'             => __( 'Ellipsis', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'ellipsis-vertical'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 128,
				'height' => 512,
				'path'   => 'M64 360C94.93 360 120 385.1 120 416C120 446.9 94.93 472 64 472C33.07 472 8 446.9 8 416C8 385.1 33.07 360 64 360zM64 200C94.93 200 120 225.1 120 256C120 286.9 94.93 312 64 312C33.07 312 8 286.9 8 256C8 225.1 33.07 200 64 200zM64 152C33.07 152 8 126.9 8 96C8 65.07 33.07 40 64 40C94.93 40 120 65.07 120 96C120 126.9 94.93 152 64 152z',
			),
		),
		'label'             => __( 'Ellipsis Vertical', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'ello'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S384.1 8 248 8zm143.8 285.2C375.3 358.5 315.8 404.8 248 404.8s-127.3-46.29-143.8-111.6c-1.65-7.44 2.48-15.71 9.92-17.36 7.44-1.65 15.71 2.48 17.36 9.92 14.05 52.91 62 90.11 116.6 90.11s102.5-37.2 116.6-90.11c1.65-7.44 9.92-12.4 17.36-9.92 7.44 1.65 12.4 9.92 9.92 17.36z',
			),
		),
		'label'             => __( 'Ello', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'ember'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M639.9 254.6c-1.1-10.7-10.7-6.8-10.7-6.8s-15.6 12.1-29.3 10.7c-13.7-1.3-9.4-32-9.4-32s3-28.1-5.1-30.4c-8.1-2.4-18 7.3-18 7.3s-12.4 13.7-18.3 31.2l-1.6 .5s1.9-30.6-.3-37.6c-1.6-3.5-16.4-3.2-18.8 3s-14.2 49.2-15 67.2c0 0-23.1 19.6-43.3 22.8s-25-9.4-25-9.4 54.8-15.3 52.9-59.1-44.2-27.6-49-24c-4.6 3.5-29.4 18.4-36.6 59.7-.2 1.4-.7 7.5-.7 7.5s-21.2 14.2-33 18c0 0 33-55.6-7.3-80.9-11.4-6.8-21.3-.5-27.2 5.3 13.6-17.3 46.4-64.2 36.9-105.2-5.8-24.4-18-27.1-29.2-23.1-17 6.7-23.5 16.7-23.5 16.7s-22 32-27.1 79.5-12.6 105.1-12.6 105.1-10.5 10.2-20.2 10.7-5.4-28.7-5.4-28.7 7.5-44.6 7-52.1-1.1-11.6-9.9-14.2c-8.9-2.7-18.5 8.6-18.5 8.6s-25.5 38.7-27.7 44.6l-1.3 2.4-1.3-1.6s18-52.7 .8-53.5-28.5 18.8-28.5 18.8-19.6 32.8-20.4 36.5l-1.3-1.6s8.1-38.2 6.4-47.6c-1.6-9.4-10.5-7.5-10.5-7.5s-11.3-1.3-14.2 5.9-13.7 55.3-15 70.7c0 0-28.2 20.2-46.8 20.4-18.5 .3-16.7-11.8-16.7-11.8s68-23.3 49.4-69.2c-8.3-11.8-18-15.5-31.7-15.3-13.7 .3-30.3 8.6-41.3 33.3-5.3 11.8-6.8 23-7.8 31.5 0 0-12.3 2.4-18.8-2.9s-10 0-10 0-11.2 14-.1 18.3 28.1 6.1 28.1 6.1c1.6 7.5 6.2 19.5 19.6 29.7 20.2 15.3 58.8-1.3 58.8-1.3l15.9-8.8s.5 14.6 12.1 16.7 16.4 1 36.5-47.9c11.8-25 12.6-23.6 12.6-23.6l1.3-.3s-9.1 46.8-5.6 59.7C187.7 319.4 203 318 203 318s8.3 2.4 15-21.2 19.6-49.9 19.6-49.9h1.6s-5.6 48.1 3 63.7 30.9 5.3 30.9 5.3 15.6-7.8 18-10.2c0 0 18.5 15.8 44.6 12.9 58.3-11.5 79.1-25.9 79.1-25.9s10 24.4 41.1 26.7c35.5 2.7 54.8-18.6 54.8-18.6s-.3 13.5 12.1 18.6 20.7-22.8 20.7-22.8l20.7-57.2h1.9s1.1 37.3 21.5 43.2 47-13.7 47-13.7 6.4-3.5 5.3-14.3zm-578 5.3c.8-32 21.8-45.9 29-39 7.3 7 4.6 22-9.1 31.4-13.7 9.5-19.9 7.6-19.9 7.6zm272.8-123.8s19.1-49.7 23.6-25.5-40 96.2-40 96.2c.5-16.2 16.4-70.7 16.4-70.7zm22.8 138.4c-12.6 33-43.3 19.6-43.3 19.6s-3.5-11.8 6.4-44.9 33.3-20.2 33.3-20.2 16.2 12.4 3.6 45.5zm84.6-14.6s-3-10.5 8.1-30.6c11-20.2 19.6-9.1 19.6-9.1s9.4 10.2-1.3 25.5-26.4 14.2-26.4 14.2z',
			),
		),
		'label'             => __( 'Ember', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'empire'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M287.6 54.2c-10.8-2.2-22.1-3.3-33.5-3.6V32.4c78.1 2.2 146.1 44 184.6 106.6l-15.8 9.1c-6.1-9.7-12.7-18.8-20.2-27.1l-18 15.5c-26-29.6-61.4-50.7-101.9-58.4l4.8-23.9zM53.4 322.4l23-7.7c-6.4-18.3-10-38.2-10-58.7s3.3-40.4 9.7-58.7l-22.7-7.7c3.6-10.8 8.3-21.3 13.6-31l-15.8-9.1C34 181 24.1 217.5 24.1 256s10 75 27.1 106.6l15.8-9.1c-5.3-10-9.7-20.3-13.6-31.1zM213.1 434c-40.4-8-75.8-29.1-101.9-58.7l-18 15.8c-7.5-8.6-14.4-17.7-20.2-27.4l-16 9.4c38.5 62.3 106.8 104.3 184.9 106.6v-18.3c-11.3-.3-22.7-1.7-33.5-3.6l4.7-23.8zM93.3 120.9l18 15.5c26-29.6 61.4-50.7 101.9-58.4l-4.7-23.8c10.8-2.2 22.1-3.3 33.5-3.6V32.4C163.9 34.6 95.9 76.4 57.4 139l15.8 9.1c6-9.7 12.6-18.9 20.1-27.2zm309.4 270.2l-18-15.8c-26 29.6-61.4 50.7-101.9 58.7l4.7 23.8c-10.8 1.9-22.1 3.3-33.5 3.6v18.3c78.1-2.2 146.4-44.3 184.9-106.6l-16.1-9.4c-5.7 9.7-12.6 18.8-20.1 27.4zM496 256c0 137-111 248-248 248S0 393 0 256 111 8 248 8s248 111 248 248zm-12.2 0c0-130.1-105.7-235.8-235.8-235.8S12.2 125.9 12.2 256 117.9 491.8 248 491.8 483.8 386.1 483.8 256zm-39-106.6l-15.8 9.1c5.3 9.7 10 20.2 13.6 31l-22.7 7.7c6.4 18.3 9.7 38.2 9.7 58.7s-3.6 40.4-10 58.7l23 7.7c-3.9 10.8-8.3 21-13.6 31l15.8 9.1C462 331 471.9 294.5 471.9 256s-9.9-75-27.1-106.6zm-183 177.7c16.3-3.3 30.4-11.6 40.7-23.5l51.2 44.8c11.9-13.6 21.3-29.3 27.1-46.8l-64.2-22.1c2.5-7.5 3.9-15.2 3.9-23.5s-1.4-16.1-3.9-23.5l64.5-22.1c-6.1-17.4-15.5-33.2-27.4-46.8l-51.2 44.8c-10.2-11.9-24.4-20.5-40.7-23.8l13.3-66.4c-8.6-1.9-17.7-2.8-27.1-2.8-9.4 0-18.5 .8-27.1 2.8l13.3 66.4c-16.3 3.3-30.4 11.9-40.7 23.8l-51.2-44.8c-11.9 13.6-21.3 29.3-27.4 46.8l64.5 22.1c-2.5 7.5-3.9 15.2-3.9 23.5s1.4 16.1 3.9 23.5l-64.2 22.1c5.8 17.4 15.2 33.2 27.1 46.8l51.2-44.8c10.2 11.9 24.4 20.2 40.7 23.5l-13.3 66.7c8.6 1.7 17.7 2.8 27.1 2.8 9.4 0 18.5-1.1 27.1-2.8l-13.3-66.7z',
			),
		),
		'label'             => __( 'Galactic Empire', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'brands',
			'social',
			'social',
		),
	),
	'envelope'                             => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M464 64C490.5 64 512 85.49 512 112C512 127.1 504.9 141.3 492.8 150.4L275.2 313.6C263.8 322.1 248.2 322.1 236.8 313.6L19.2 150.4C7.113 141.3 0 127.1 0 112C0 85.49 21.49 64 48 64H464zM217.6 339.2C240.4 356.3 271.6 356.3 294.4 339.2L512 176V384C512 419.3 483.3 448 448 448H64C28.65 448 0 419.3 0 384V176L217.6 339.2z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 128C0 92.65 28.65 64 64 64H448C483.3 64 512 92.65 512 128V384C512 419.3 483.3 448 448 448H64C28.65 448 0 419.3 0 384V128zM48 128V150.1L220.5 291.7C241.1 308.7 270.9 308.7 291.5 291.7L464 150.1V127.1C464 119.2 456.8 111.1 448 111.1H64C55.16 111.1 48 119.2 48 127.1L48 128zM48 212.2V384C48 392.8 55.16 400 64 400H448C456.8 400 464 392.8 464 384V212.2L322 328.8C283.6 360.3 228.4 360.3 189.1 328.8L48 212.2z',
			),
		),
		'label'             => __( 'Envelope', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
			'social',
		),
	),
	'envelope-circle-check'                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M464 64C490.5 64 512 85.49 512 112C512 127.1 504.9 141.3 492.8 150.4L478.9 160.8C412.3 167.2 356.5 210.8 332.6 270.6L275.2 313.6C263.8 322.1 248.2 322.1 236.8 313.6L19.2 150.4C7.113 141.3 0 127.1 0 112C0 85.49 21.49 64 48 64H464zM294.4 339.2L320.8 319.4C320.3 324.9 320 330.4 320 336C320 378.5 335.1 417.6 360.2 448H64C28.65 448 0 419.3 0 384V176L217.6 339.2C240.4 356.3 271.6 356.3 294.4 339.2zM640 336C640 415.5 575.5 480 496 480C416.5 480 352 415.5 352 336C352 256.5 416.5 192 496 192C575.5 192 640 256.5 640 336zM540.7 292.7L480 353.4L451.3 324.7C445.1 318.4 434.9 318.4 428.7 324.7C422.4 330.9 422.4 341.1 428.7 347.3L468.7 387.3C474.9 393.6 485.1 393.6 491.3 387.3L563.3 315.3C569.6 309.1 569.6 298.9 563.3 292.7C557.1 286.4 546.9 286.4 540.7 292.7H540.7z',
			),
		),
		'label'             => __( 'Envelope Circle Check', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
		),
	),
	'envelope-open'                        => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M493.6 163c-24.88-19.62-45.5-35.37-164.3-121.6C312.7 29.21 279.7 0 256.4 0H255.6C232.3 0 199.3 29.21 182.6 41.38c-118.8 86.25-139.4 101.1-164.3 121.6C6.75 172 0 186 0 200.8v263.2C0 490.5 21.49 512 48 512h416c26.51 0 48-21.49 48-47.1V200.8C512 186 505.3 172 493.6 163zM303.2 367.5C289.1 378.5 272.5 384 256 384s-33.06-5.484-47.16-16.47L64 254.9V208.5c21.16-16.59 46.48-35.66 156.4-115.5c3.18-2.328 6.891-5.187 10.98-8.353C236.9 80.44 247.8 71.97 256 66.84c8.207 5.131 19.14 13.6 24.61 17.84c4.09 3.166 7.801 6.027 11.15 8.478C400.9 172.5 426.6 191.7 448 208.5v46.32L303.2 367.5z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M493.6 163c-24.88-19.62-45.5-35.37-164.3-121.6C312.7 29.21 279.7 0 256.4 0H255.6C232.3 0 199.3 29.21 182.6 41.38C63.88 127.6 43.25 143.4 18.38 163C6.75 172 0 186 0 200.8v247.2C0 483.3 28.65 512 64 512h384c35.35 0 64-28.67 64-64.01V200.8C512 186 505.3 172 493.6 163zM464 448c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V276.7l136.1 113.4C204.3 406.8 229.8 416 256 416s51.75-9.211 71.97-26.01L464 276.7V448zM464 214.2l-166.8 138.1c-23.19 19.28-59.34 19.27-82.47 .0156L48 214.2l.1055-13.48c23.24-18.33 42.25-32.97 162.9-120.6c3.082-2.254 6.674-5.027 10.63-8.094C229.4 65.99 246.7 52.59 256 48.62c9.312 3.973 26.62 17.37 34.41 23.41c3.959 3.066 7.553 5.84 10.76 8.186C421.6 167.7 440.7 182.4 464 200.8V214.2z',
			),
		),
		'label'             => __( 'Envelope Open', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
		),
	),
	'envelope-open-text'                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 417.1c-16.38 0-32.88-4.1-46.88-15.12L0 250.9v213.1C0 490.5 21.5 512 48 512h416c26.5 0 48-21.5 48-47.1V250.9l-209.1 151.1C288.9 412 272.4 417.1 256 417.1zM493.6 163C484.8 156 476.4 149.5 464 140.1v-44.12c0-26.5-21.5-48-48-48l-77.5 .0016c-3.125-2.25-5.875-4.25-9.125-6.5C312.6 29.13 279.3-.3732 256 .0018C232.8-.3732 199.4 29.13 182.6 41.5c-3.25 2.25-6 4.25-9.125 6.5L96 48c-26.5 0-48 21.5-48 48v44.12C35.63 149.5 27.25 156 18.38 163C6.75 172 0 186 0 200.8v10.62l96 69.37V96h320v184.7l96-69.37V200.8C512 186 505.3 172 493.6 163zM176 255.1h160c8.836 0 16-7.164 16-15.1c0-8.838-7.164-16-16-16h-160c-8.836 0-16 7.162-16 16C160 248.8 167.2 255.1 176 255.1zM176 191.1h160c8.836 0 16-7.164 16-16c0-8.838-7.164-15.1-16-15.1h-160c-8.836 0-16 7.162-16 15.1C160 184.8 167.2 191.1 176 191.1z',
			),
		),
		'label'             => __( 'Envelope Open Text', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'envelopes-bulk'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M191.9 448.6c-9.766 0-19.48-2.969-27.78-8.891L32 340.2V480c0 17.62 14.38 32 32 32h256c17.62 0 32-14.38 32-32v-139.8L220.2 439.5C211.7 445.6 201.8 448.6 191.9 448.6zM192 192c0-35.25 28.75-64 64-64h224V32c0-17.62-14.38-32-32-32H128C110.4 0 96 14.38 96 32v192h96V192zM320 256H64C46.38 256 32 270.4 32 288v12.18l151 113.8c5.25 3.719 12.7 3.734 18.27-.25L352 300.2V288C352 270.4 337.6 256 320 256zM576 160H256C238.4 160 224 174.4 224 192v32h96c33.25 0 60.63 25.38 63.75 57.88L384 416h192c17.62 0 32-14.38 32-32V192C608 174.4 593.6 160 576 160zM544 288h-64V224h64V288z',
			),
		),
		'label'             => __( 'Envelopes Bulk', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'envira'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M0 32c477.6 0 366.6 317.3 367.1 366.3L448 480h-26l-70.4-71.2c-39 4.2-124.4 34.5-214.4-37C47 300.3 52 214.7 0 32zm79.7 46c-49.7-23.5-5.2 9.2-5.2 9.2 45.2 31.2 66 73.7 90.2 119.9 31.5 60.2 79 139.7 144.2 167.7 65 28 34.2 12.5 6-8.5-28.2-21.2-68.2-87-91-130.2-31.7-60-61-118.6-144.2-158.1z',
			),
		),
		'label'             => __( 'Envira Gallery', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'equals'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M48 192h352c17.69 0 32-14.32 32-32s-14.31-31.1-32-31.1h-352c-17.69 0-32 14.31-32 31.1S30.31 192 48 192zM400 320h-352c-17.69 0-32 14.31-32 31.1s14.31 32 32 32h352c17.69 0 32-14.32 32-32S417.7 320 400 320z',
			),
		),
		'label'             => __( 'Equals', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'eraser'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M480 416C497.7 416 512 430.3 512 448C512 465.7 497.7 480 480 480H150.6C133.7 480 117.4 473.3 105.4 461.3L25.37 381.3C.3786 356.3 .3786 315.7 25.37 290.7L258.7 57.37C283.7 32.38 324.3 32.38 349.3 57.37L486.6 194.7C511.6 219.7 511.6 260.3 486.6 285.3L355.9 416H480zM265.4 416L332.7 348.7L195.3 211.3L70.63 336L150.6 416L265.4 416z',
			),
		),
		'label'             => __( 'Eraser', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
			'design',
		),
	),
	'erlang'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M87.2 53.5H0v405h100.4c-49.7-52.6-78.8-125.3-78.7-212.1-.1-76.7 24-142.7 65.5-192.9zm238.2 9.7c-45.9 .1-85.1 33.5-89.2 83.2h169.9c-1.1-49.7-34.5-83.1-80.7-83.2zm230.7-9.6h.3l-.1-.1zm.3 0c31.4 42.7 48.7 97.5 46.2 162.7 .5 6 .5 11.7 0 24.1H230.2c-.2 109.7 38.9 194.9 138.6 195.3 68.5-.3 118-51 151.9-106.1l96.4 48.2c-17.4 30.9-36.5 57.8-57.9 80.8H640v-405z',
			),
		),
		'label'             => __( 'Erlang', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'ethereum'                             => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M311.9 260.8L160 353.6 8 260.8 160 0l151.9 260.8zM160 383.4L8 290.6 160 512l152-221.4-152 92.8z',
			),
		),
		'label'             => __( 'Ethereum', 'astra' ),
		'custom_categories' => array(
			'business',
			'lifestyle-and-hobbies',
			'brands',
			'brands',
			'social',
		),
	),
	'ethernet'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 208v224c0 8.75-7.25 16-16 16H416v-128h-32v128h-64v-128h-32v128H224v-128H192v128H128v-128H96v128H16C7.25 448 0 440.8 0 432v-224C0 199.2 7.25 192 16 192H64V144C64 135.2 71.25 128 80 128H128V80C128 71.25 135.2 64 144 64h224C376.8 64 384 71.25 384 80V128h48C440.8 128 448 135.2 448 144V192h48C504.8 192 512 199.2 512 208z',
			),
		),
		'label'             => __( 'Ethernet', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
			'travel',
		),
	),
	'etsy'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M384 348c-1.75 10.75-13.75 110-15.5 132-117.9-4.299-219.9-4.743-368.5 0v-25.5c45.46-8.948 60.63-8.019 61-35.25 1.793-72.32 3.524-244.1 0-322-1.029-28.46-12.13-26.76-61-36v-25.5c73.89 2.358 255.9 8.551 362.1-3.75-3.5 38.25-7.75 126.5-7.75 126.5H332C320.9 115.7 313.2 68 277.3 68h-137c-10.25 0-10.75 3.5-10.75 9.75V241.5c58 .5 88.5-2.5 88.5-2.5 29.77-.951 27.56-8.502 40.75-65.25h25.75c-4.407 101.4-3.91 61.83-1.75 160.3H257c-9.155-40.09-9.065-61.04-39.5-61.5 0 0-21.5-2-88-2v139c0 26 14.25 38.25 44.25 38.25H263c63.64 0 66.56-24.1 98.75-99.75H384z',
			),
		),
		'label'             => __( 'Etsy', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'euro-sign'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M64 240C46.33 240 32 225.7 32 208C32 190.3 46.33 176 64 176H92.29C121.9 92.11 201.1 32 296 32H320C337.7 32 352 46.33 352 64C352 81.67 337.7 96 320 96H296C238.1 96 187.8 128.4 162.1 176H288C305.7 176 320 190.3 320 208C320 225.7 305.7 240 288 240H144.2C144.1 242.6 144 245.3 144 248V264C144 266.7 144.1 269.4 144.2 272H288C305.7 272 320 286.3 320 304C320 321.7 305.7 336 288 336H162.1C187.8 383.6 238.1 416 296 416H320C337.7 416 352 430.3 352 448C352 465.7 337.7 480 320 480H296C201.1 480 121.9 419.9 92.29 336H64C46.33 336 32 321.7 32 304C32 286.3 46.33 272 64 272H80.15C80.05 269.3 80 266.7 80 264V248C80 245.3 80.05 242.7 80.15 240H64z',
			),
		),
		'label'             => __( 'Euro Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'evernote'                             => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M120.8 132.2c1.6 22.31-17.55 21.59-21.61 21.59-68.93 0-73.64-1-83.58 3.34-.56 .22-.74 0-.37-.37L123.8 46.45c.38-.37 .6-.22 .38 .37-4.35 9.99-3.35 15.09-3.35 85.39zm79 308c-14.68-37.08 13-76.93 52.52-76.62 17.49 0 22.6 23.21 7.95 31.42-6.19 3.3-24.95 1.74-25.14 19.2-.05 17.09 19.67 25 31.2 24.89A45.64 45.64 0 0 0 312 393.5v-.08c0-11.63-7.79-47.22-47.54-55.34-7.72-1.54-65-6.35-68.35-50.52-3.74 16.93-17.4 63.49-43.11 69.09-8.74 1.94-69.68 7.64-112.9-36.77 0 0-18.57-15.23-28.23-57.95-3.38-15.75-9.28-39.7-11.14-62 0-18 11.14-30.45 25.07-32.2 81 0 90 2.32 101-7.8 9.82-9.24 7.8-15.5 7.8-102.8 1-8.3 7.79-30.81 53.41-24.14 6 .86 31.91 4.18 37.48 30.64l64.26 11.15c20.43 3.71 70.94 7 80.6 57.94 22.66 121.1 8.91 238.5 7.8 238.5C362.1 485.5 267.1 480 267.1 480c-18.95-.23-54.25-9.4-67.27-39.83zm80.94-204.8c-1 1.92-2.2 6 .85 7 14.09 4.93 39.75 6.84 45.88 5.53 3.11-.25 3.05-4.43 2.48-6.65-3.53-21.85-40.83-26.5-49.24-5.92z',
			),
		),
		'label'             => __( 'Evernote', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'exclamation'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 128,
				'height' => 512,
				'path'   => 'M64 352c17.69 0 32-14.32 32-31.1V64.01c0-17.67-14.31-32.01-32-32.01S32 46.34 32 64.01v255.1C32 337.7 46.31 352 64 352zM64 400c-22.09 0-40 17.91-40 40s17.91 39.1 40 39.1s40-17.9 40-39.1S86.09 400 64 400z',
			),
		),
		'label'             => __( 'Exclamation', 'astra' ),
		'custom_categories' => array(),
	),
	'expand'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M128 32H32C14.31 32 0 46.31 0 64v96c0 17.69 14.31 32 32 32s32-14.31 32-32V96h64c17.69 0 32-14.31 32-32S145.7 32 128 32zM416 32h-96c-17.69 0-32 14.31-32 32s14.31 32 32 32h64v64c0 17.69 14.31 32 32 32s32-14.31 32-32V64C448 46.31 433.7 32 416 32zM128 416H64v-64c0-17.69-14.31-32-32-32s-32 14.31-32 32v96c0 17.69 14.31 32 32 32h96c17.69 0 32-14.31 32-32S145.7 416 128 416zM416 320c-17.69 0-32 14.31-32 32v64h-64c-17.69 0-32 14.31-32 32s14.31 32 32 32h96c17.69 0 32-14.31 32-32v-96C448 334.3 433.7 320 416 320z',
			),
		),
		'label'             => __( 'Expand', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
		),
	),
	'expeditedssl'                         => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M248 43.4C130.6 43.4 35.4 138.6 35.4 256S130.6 468.6 248 468.6 460.6 373.4 460.6 256 365.4 43.4 248 43.4zm-97.4 132.9c0-53.7 43.7-97.4 97.4-97.4s97.4 43.7 97.4 97.4v26.6c0 5-3.9 8.9-8.9 8.9h-17.7c-5 0-8.9-3.9-8.9-8.9v-26.6c0-82.1-124-82.1-124 0v26.6c0 5-3.9 8.9-8.9 8.9h-17.7c-5 0-8.9-3.9-8.9-8.9v-26.6zM389.7 380c0 9.7-8 17.7-17.7 17.7H124c-9.7 0-17.7-8-17.7-17.7V238.3c0-9.7 8-17.7 17.7-17.7h248c9.7 0 17.7 8 17.7 17.7V380zm-248-137.3v132.9c0 2.5-1.9 4.4-4.4 4.4h-8.9c-2.5 0-4.4-1.9-4.4-4.4V242.7c0-2.5 1.9-4.4 4.4-4.4h8.9c2.5 0 4.4 1.9 4.4 4.4zm141.7 48.7c0 13-7.2 24.4-17.7 30.4v31.6c0 5-3.9 8.9-8.9 8.9h-17.7c-5 0-8.9-3.9-8.9-8.9v-31.6c-10.5-6.1-17.7-17.4-17.7-30.4 0-19.7 15.8-35.4 35.4-35.4s35.5 15.8 35.5 35.4zM248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 478.3C121 486.3 17.7 383 17.7 256S121 25.7 248 25.7 478.3 129 478.3 256 375 486.3 248 486.3z',
			),
		),
		'label'             => __( 'ExpeditedSSL', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'explosion'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M499.6 11.32C506.3 .5948 520.1-3.127 531.3 2.814C542.4 8.754 547.1 22.32 541.9 33.84L404.8 338.6C406.9 340.9 409 343.3 411.1 345.7L508.2 291.1C518.7 285.2 531.9 287.9 539.1 297.5C546.4 307 545.4 320.5 536.1 328.1L449.9 415.1H378.5C365.4 378.7 329.8 351.1 288 351.1C246.2 351.1 210.6 378.7 197.5 415.1H117.8L42.34 363.7C32.59 356.1 29.23 344.1 34.43 333.5C39.64 322.8 51.84 317.6 63.16 321.1L160.4 351.5C163.3 347.6 166.5 343.8 169.7 340.2L107.4 236.3C101.4 226.3 103.5 213.3 112.5 205.7C121.5 198.1 134.7 198.1 143.6 205.8L246 293.6C247.5 293.2 249 292.8 250.5 292.4L264.1 149.7C265.3 137.4 275.6 127.1 288 127.1C300.4 127.1 310.7 137.4 311.9 149.7L325.4 291.6L499.6 11.32zM544 447.1C561.7 447.1 576 462.3 576 479.1C576 497.7 561.7 511.1 544 511.1H32C14.33 511.1 0 497.7 0 479.1C0 462.3 14.33 447.1 32 447.1H544zM288-.0046C301.3-.0046 312 10.74 312 23.1V71.1C312 85.25 301.3 95.1 288 95.1C274.7 95.1 264 85.25 264 71.1V23.1C264 10.74 274.7-.0046 288-.0046V-.0046z',
			),
		),
		'label'             => __( 'Explosion', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'eye'                                  => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M279.6 160.4C282.4 160.1 285.2 160 288 160C341 160 384 202.1 384 256C384 309 341 352 288 352C234.1 352 192 309 192 256C192 253.2 192.1 250.4 192.4 247.6C201.7 252.1 212.5 256 224 256C259.3 256 288 227.3 288 192C288 180.5 284.1 169.7 279.6 160.4zM480.6 112.6C527.4 156 558.7 207.1 573.5 243.7C576.8 251.6 576.8 260.4 573.5 268.3C558.7 304 527.4 355.1 480.6 399.4C433.5 443.2 368.8 480 288 480C207.2 480 142.5 443.2 95.42 399.4C48.62 355.1 17.34 304 2.461 268.3C-.8205 260.4-.8205 251.6 2.461 243.7C17.34 207.1 48.62 156 95.42 112.6C142.5 68.84 207.2 32 288 32C368.8 32 433.5 68.84 480.6 112.6V112.6zM288 112C208.5 112 144 176.5 144 256C144 335.5 208.5 400 288 400C367.5 400 432 335.5 432 256C432 176.5 367.5 112 288 112z',
			),
			'regular' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M160 256C160 185.3 217.3 128 288 128C358.7 128 416 185.3 416 256C416 326.7 358.7 384 288 384C217.3 384 160 326.7 160 256zM288 336C332.2 336 368 300.2 368 256C368 211.8 332.2 176 288 176C287.3 176 286.7 176 285.1 176C287.3 181.1 288 186.5 288 192C288 227.3 259.3 256 224 256C218.5 256 213.1 255.3 208 253.1C208 254.7 208 255.3 208 255.1C208 300.2 243.8 336 288 336L288 336zM95.42 112.6C142.5 68.84 207.2 32 288 32C368.8 32 433.5 68.84 480.6 112.6C527.4 156 558.7 207.1 573.5 243.7C576.8 251.6 576.8 260.4 573.5 268.3C558.7 304 527.4 355.1 480.6 399.4C433.5 443.2 368.8 480 288 480C207.2 480 142.5 443.2 95.42 399.4C48.62 355.1 17.34 304 2.461 268.3C-.8205 260.4-.8205 251.6 2.461 243.7C17.34 207.1 48.62 156 95.42 112.6V112.6zM288 80C222.8 80 169.2 109.6 128.1 147.7C89.6 183.5 63.02 225.1 49.44 256C63.02 286 89.6 328.5 128.1 364.3C169.2 402.4 222.8 432 288 432C353.2 432 406.8 402.4 447.9 364.3C486.4 328.5 512.1 286 526.6 256C512.1 225.1 486.4 183.5 447.9 147.7C406.8 109.6 353.2 80 288 80V80z',
			),
		),
		'label'             => __( 'Eye', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
			'science-and-technology',
			'travel',
		),
	),
	'eye-dropper'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M482.8 29.23C521.7 68.21 521.7 131.4 482.8 170.4L381.2 271.9L390.6 281.4C403.1 293.9 403.1 314.1 390.6 326.6C378.1 339.1 357.9 339.1 345.4 326.6L185.4 166.6C172.9 154.1 172.9 133.9 185.4 121.4C197.9 108.9 218.1 108.9 230.6 121.4L240.1 130.8L341.6 29.23C380.6-9.744 443.8-9.744 482.8 29.23L482.8 29.23zM55.43 323.3L176.1 202.6L221.4 247.9L100.7 368.6C97.69 371.6 96 375.6 96 379.9V416H132.1C136.4 416 140.4 414.3 143.4 411.3L264.1 290.6L309.4 335.9L188.7 456.6C173.7 471.6 153.3 480 132.1 480H89.69L49.75 506.6C37.06 515.1 20.16 513.4 9.373 502.6C-1.413 491.8-3.086 474.9 5.375 462.2L32 422.3V379.9C32 358.7 40.43 338.3 55.43 323.3L55.43 323.3z',
			),
		),
		'label'             => __( 'Eye Dropper', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
			'science-and-technology',
		),
	),
	'eye-low-vision'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M150.7 92.77C195 58.27 251.8 32 320 32C400.8 32 465.5 68.84 512.6 112.6C559.4 156 590.7 207.1 605.5 243.7C608.8 251.6 608.8 260.4 605.5 268.3C592.1 300.6 565.2 346.1 525.6 386.7L630.8 469.1C641.2 477.3 643.1 492.4 634.9 502.8C626.7 513.2 611.6 515.1 601.2 506.9L9.196 42.89C-1.236 34.71-3.065 19.63 5.112 9.196C13.29-1.236 28.37-3.065 38.81 5.112L150.7 92.77zM223.1 149.5L313.4 220.3C317.6 211.8 320 202.2 320 191.1C320 180.5 316.1 169.7 311.6 160.4C314.4 160.1 317.2 159.1 320 159.1C373 159.1 416 202.1 416 255.1C416 269.7 413.1 282.7 407.1 294.5L446.6 324.7C457.7 304.3 464 280.9 464 255.1C464 176.5 399.5 111.1 320 111.1C282.7 111.1 248.6 126.2 223.1 149.5zM393.6 469.4L54.65 203.7C62.6 190.1 72.08 175.8 83.09 161.5L446.2 447.5C429.8 456.4 412.3 463.8 393.6 469.4V469.4zM34.46 268.3C31.74 261.8 31.27 254.5 33.08 247.8L329.2 479.8C326.1 479.9 323.1 480 320 480C239.2 480 174.5 443.2 127.4 399.4C80.62 355.1 49.34 304 34.46 268.3H34.46z',
			),
		),
		'label'             => __( 'Eye Low Vision', 'astra' ),
		'custom_categories' => array(
			'design',
			'travel',
		),
	),
	'eye-slash'                            => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M150.7 92.77C195 58.27 251.8 32 320 32C400.8 32 465.5 68.84 512.6 112.6C559.4 156 590.7 207.1 605.5 243.7C608.8 251.6 608.8 260.4 605.5 268.3C592.1 300.6 565.2 346.1 525.6 386.7L630.8 469.1C641.2 477.3 643.1 492.4 634.9 502.8C626.7 513.2 611.6 515.1 601.2 506.9L9.196 42.89C-1.236 34.71-3.065 19.63 5.112 9.196C13.29-1.236 28.37-3.065 38.81 5.112L150.7 92.77zM223.1 149.5L313.4 220.3C317.6 211.8 320 202.2 320 191.1C320 180.5 316.1 169.7 311.6 160.4C314.4 160.1 317.2 159.1 320 159.1C373 159.1 416 202.1 416 255.1C416 269.7 413.1 282.7 407.1 294.5L446.6 324.7C457.7 304.3 464 280.9 464 255.1C464 176.5 399.5 111.1 320 111.1C282.7 111.1 248.6 126.2 223.1 149.5zM320 480C239.2 480 174.5 443.2 127.4 399.4C80.62 355.1 49.34 304 34.46 268.3C31.18 260.4 31.18 251.6 34.46 243.7C44 220.8 60.29 191.2 83.09 161.5L177.4 235.8C176.5 242.4 176 249.1 176 255.1C176 335.5 240.5 400 320 400C338.7 400 356.6 396.4 373 389.9L446.2 447.5C409.9 467.1 367.8 480 320 480H320z',
			),
			'regular' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M150.7 92.77C195 58.27 251.8 32 320 32C400.8 32 465.5 68.84 512.6 112.6C559.4 156 590.7 207.1 605.5 243.7C608.8 251.6 608.8 260.4 605.5 268.3C592.1 300.6 565.2 346.1 525.6 386.7L630.8 469.1C641.2 477.3 643.1 492.4 634.9 502.8C626.7 513.2 611.6 515.1 601.2 506.9L9.196 42.89C-1.236 34.71-3.065 19.63 5.112 9.196C13.29-1.236 28.37-3.065 38.81 5.112L150.7 92.77zM189.8 123.5L235.8 159.5C258.3 139.9 287.8 128 320 128C390.7 128 448 185.3 448 256C448 277.2 442.9 297.1 433.8 314.7L487.6 356.9C521.1 322.8 545.9 283.1 558.6 256C544.1 225.1 518.4 183.5 479.9 147.7C438.8 109.6 385.2 79.1 320 79.1C269.5 79.1 225.1 97.73 189.8 123.5L189.8 123.5zM394.9 284.2C398.2 275.4 400 265.9 400 255.1C400 211.8 364.2 175.1 320 175.1C319.3 175.1 318.7 176 317.1 176C319.3 181.1 320 186.5 320 191.1C320 202.2 317.6 211.8 313.4 220.3L394.9 284.2zM404.3 414.5L446.2 447.5C409.9 467.1 367.8 480 320 480C239.2 480 174.5 443.2 127.4 399.4C80.62 355.1 49.34 304 34.46 268.3C31.18 260.4 31.18 251.6 34.46 243.7C44 220.8 60.29 191.2 83.09 161.5L120.8 191.2C102.1 214.5 89.76 237.6 81.45 255.1C95.02 286 121.6 328.5 160.1 364.3C201.2 402.4 254.8 432 320 432C350.7 432 378.8 425.4 404.3 414.5H404.3zM192 255.1C192 253.1 192.1 250.3 192.3 247.5L248.4 291.7C258.9 312.8 278.5 328.6 302 333.1L358.2 378.2C346.1 381.1 333.3 384 319.1 384C249.3 384 191.1 326.7 191.1 255.1H192z',
			),
		),
		'label'             => __( 'Eye Slash', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
			'science-and-technology',
			'travel',
		),
	),
	'f'                                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M320 64.01c0 17.67-14.33 32-32 32H64v128h160c17.67 0 32 14.32 32 31.1s-14.33 32-32 32H64v160c0 17.67-14.33 32-32 32s-32-14.33-32-32v-384C0 46.34 14.33 32.01 32 32.01h256C305.7 32.01 320 46.34 320 64.01z',
			),
		),
		'label'             => __( 'F', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'face-angry'                           => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM339.9 373.3C323.8 355.4 295.7 336 256 336C216.3 336 188.2 355.4 172.1 373.3C166.2 379.9 166.7 389.1 173.3 395.9C179.9 401.8 189.1 401.3 195.9 394.7C207.6 381.7 227.5 368 255.1 368C284.5 368 304.4 381.7 316.1 394.7C322 401.3 332.1 401.8 338.7 395.9C345.3 389.1 345.8 379.9 339.9 373.3H339.9zM176.4 272C194 272 208.4 257.7 208.4 240C208.4 238.5 208.3 237 208.1 235.6L218.9 239.2C227.3 241.1 236.4 237.4 239.2 229.1C241.1 220.7 237.4 211.6 229.1 208.8L133.1 176.8C124.7 174 115.6 178.6 112.8 186.9C110 195.3 114.6 204.4 122.9 207.2L153.7 217.4C147.9 223.2 144.4 231.2 144.4 240C144.4 257.7 158.7 272 176.4 272zM358.9 217.2L389.1 207.2C397.4 204.4 401.1 195.3 399.2 186.9C396.4 178.6 387.3 174 378.9 176.8L282.9 208.8C274.6 211.6 270 220.7 272.8 229.1C275.6 237.4 284.7 241.1 293.1 239.2L304.7 235.3C304.5 236.8 304.4 238.4 304.4 240C304.4 257.7 318.7 272 336.4 272C354 272 368.4 257.7 368.4 240C368.4 231.1 364.7 223 358.9 217.2H358.9z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M328.4 393.5C318.7 402.6 303.5 402.1 294.5 392.4C287.1 384.5 274.4 376 256 376C237.6 376 224.9 384.5 217.5 392.4C208.5 402.1 193.3 402.6 183.6 393.5C173.9 384.5 173.4 369.3 182.5 359.6C196.7 344.3 221.4 328 256 328C290.6 328 315.3 344.3 329.5 359.6C338.6 369.3 338.1 384.5 328.4 393.5zM144.4 240C144.4 231.2 147.9 223.2 153.7 217.4L122.9 207.2C114.6 204.4 110 195.3 112.8 186.9C115.6 178.6 124.7 174 133.1 176.8L229.1 208.8C237.4 211.6 241.1 220.7 239.2 229.1C236.4 237.4 227.3 241.1 218.9 239.2L208.1 235.6C208.3 237 208.4 238.5 208.4 240C208.4 257.7 194 272 176.4 272C158.7 272 144.4 257.7 144.4 240V240zM368.4 240C368.4 257.7 354 272 336.4 272C318.7 272 304.4 257.7 304.4 240C304.4 238.4 304.5 236.8 304.7 235.3L293.1 239.2C284.7 241.1 275.6 237.4 272.8 229.1C270 220.7 274.6 211.6 282.9 208.8L378.9 176.8C387.3 174 396.4 178.6 399.2 186.9C401.1 195.3 397.4 204.4 389.1 207.2L358.9 217.2C364.7 223 368.4 231.1 368.4 240H368.4zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464z',
			),
		),
		'label'             => __( 'Face Angry', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-dizzy'                           => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 416C291.3 416 320 387.3 320 352C320 316.7 291.3 288 256 288C220.7 288 192 316.7 192 352C192 387.3 220.7 416 256 416zM100.7 155.3L137.4 192L100.7 228.7C94.44 234.9 94.44 245.1 100.7 251.3C106.9 257.6 117.1 257.6 123.3 251.3L160 214.6L196.7 251.3C202.9 257.6 213.1 257.6 219.3 251.3C225.6 245.1 225.6 234.9 219.3 228.7L182.6 192L219.3 155.3C225.6 149.1 225.6 138.9 219.3 132.7C213.1 126.4 202.9 126.4 196.7 132.7L160 169.4L123.3 132.7C117.1 126.4 106.9 126.4 100.7 132.7C94.44 138.9 94.44 149.1 100.7 155.3zM292.7 155.3L329.4 192L292.7 228.7C286.4 234.9 286.4 245.1 292.7 251.3C298.9 257.6 309.1 257.6 315.3 251.3L352 214.6L388.7 251.3C394.9 257.6 405.1 257.6 411.3 251.3C417.6 245.1 417.6 234.9 411.3 228.7L374.6 192L411.3 155.3C417.6 149.1 417.6 138.9 411.3 132.7C405.1 126.4 394.9 126.4 388.7 132.7L352 169.4L315.3 132.7C309.1 126.4 298.9 126.4 292.7 132.7C286.4 138.9 286.4 149.1 292.7 155.3z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M192 352C192 316.7 220.7 288 256 288C291.3 288 320 316.7 320 352C320 387.3 291.3 416 256 416C220.7 416 192 387.3 192 352zM103 135C112.4 125.7 127.6 125.7 136.1 135L160 158.1L183 135C192.4 125.7 207.6 125.7 216.1 135C226.3 144.4 226.3 159.6 216.1 168.1L193.9 192L216.1 215C226.3 224.4 226.3 239.6 216.1 248.1C207.6 258.3 192.4 258.3 183 248.1L160 225.9L136.1 248.1C127.6 258.3 112.4 258.3 103 248.1C93.66 239.6 93.66 224.4 103 215L126.1 192L103 168.1C93.66 159.6 93.66 144.4 103 135V135zM295 135C304.4 125.7 319.6 125.7 328.1 135L352 158.1L375 135C384.4 125.7 399.6 125.7 408.1 135C418.3 144.4 418.3 159.6 408.1 168.1L385.9 192L408.1 215C418.3 224.4 418.3 239.6 408.1 248.1C399.6 258.3 384.4 258.3 375 248.1L352 225.9L328.1 248.1C319.6 258.3 304.4 258.3 295 248.1C285.7 239.6 285.7 224.4 295 215L318.1 192L295 168.1C285.7 159.6 285.7 144.4 295 135V135zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Dizzy', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-flushed'                         => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M184 224C184 237.3 173.3 248 160 248C146.7 248 136 237.3 136 224C136 210.7 146.7 200 160 200C173.3 200 184 210.7 184 224zM376 224C376 237.3 365.3 248 352 248C338.7 248 328 237.3 328 224C328 210.7 338.7 200 352 200C365.3 200 376 210.7 376 224zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM192 400H320C328.8 400 336 392.8 336 384C336 375.2 328.8 368 320 368H192C183.2 368 176 375.2 176 384C176 392.8 183.2 400 192 400zM160 296C199.8 296 232 263.8 232 224C232 184.2 199.8 152 160 152C120.2 152 88 184.2 88 224C88 263.8 120.2 296 160 296zM352 152C312.2 152 280 184.2 280 224C280 263.8 312.2 296 352 296C391.8 296 424 263.8 424 224C424 184.2 391.8 152 352 152z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M320 336C333.3 336 344 346.7 344 360C344 373.3 333.3 384 320 384H192C178.7 384 168 373.3 168 360C168 346.7 178.7 336 192 336H320zM136.4 224C136.4 210.7 147.1 200 160.4 200C173.6 200 184.4 210.7 184.4 224C184.4 237.3 173.6 248 160.4 248C147.1 248 136.4 237.3 136.4 224zM80 224C80 179.8 115.8 144 160 144C204.2 144 240 179.8 240 224C240 268.2 204.2 304 160 304C115.8 304 80 268.2 80 224zM160 272C186.5 272 208 250.5 208 224C208 197.5 186.5 176 160 176C133.5 176 112 197.5 112 224C112 250.5 133.5 272 160 272zM376.4 224C376.4 237.3 365.6 248 352.4 248C339.1 248 328.4 237.3 328.4 224C328.4 210.7 339.1 200 352.4 200C365.6 200 376.4 210.7 376.4 224zM432 224C432 268.2 396.2 304 352 304C307.8 304 272 268.2 272 224C272 179.8 307.8 144 352 144C396.2 144 432 179.8 432 224zM352 176C325.5 176 304 197.5 304 224C304 250.5 325.5 272 352 272C378.5 272 400 250.5 400 224C400 197.5 378.5 176 352 176zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464z',
			),
		),
		'label'             => __( 'Face Flushed', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-frown'                           => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM159.3 388.7C171.5 349.4 209.9 320 256 320C302.1 320 340.5 349.4 352.7 388.7C355.3 397.2 364.3 401.9 372.7 399.3C381.2 396.7 385.9 387.7 383.3 379.3C366.8 326.1 315.8 287.1 256 287.1C196.3 287.1 145.2 326.1 128.7 379.3C126.1 387.7 130.8 396.7 139.3 399.3C147.7 401.9 156.7 397.2 159.3 388.7H159.3zM176.4 176C158.7 176 144.4 190.3 144.4 208C144.4 225.7 158.7 240 176.4 240C194 240 208.4 225.7 208.4 208C208.4 190.3 194 176 176.4 176zM336.4 240C354 240 368.4 225.7 368.4 208C368.4 190.3 354 176 336.4 176C318.7 176 304.4 190.3 304.4 208C304.4 225.7 318.7 240 336.4 240z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M143.9 398.6C131.4 394.1 124.9 380.3 129.4 367.9C146.9 319.4 198.9 288 256 288C313.1 288 365.1 319.4 382.6 367.9C387.1 380.3 380.6 394.1 368.1 398.6C355.7 403.1 341.9 396.6 337.4 384.1C328.2 358.5 297.2 336 256 336C214.8 336 183.8 358.5 174.6 384.1C170.1 396.6 156.3 403.1 143.9 398.6V398.6zM208.4 208C208.4 225.7 194 240 176.4 240C158.7 240 144.4 225.7 144.4 208C144.4 190.3 158.7 176 176.4 176C194 176 208.4 190.3 208.4 208zM304.4 208C304.4 190.3 318.7 176 336.4 176C354 176 368.4 190.3 368.4 208C368.4 225.7 354 240 336.4 240C318.7 240 304.4 225.7 304.4 208zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Frown', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
		),
	),
	'face-frown-open'                      => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM176.4 240C194 240 208.4 225.7 208.4 208C208.4 190.3 194 176 176.4 176C158.7 176 144.4 190.3 144.4 208C144.4 225.7 158.7 240 176.4 240zM336.4 176C318.7 176 304.4 190.3 304.4 208C304.4 225.7 318.7 240 336.4 240C354 240 368.4 225.7 368.4 208C368.4 190.3 354 176 336.4 176zM259.9 369.4C288.8 369.4 316.2 375.2 340.6 385.5C352.9 390.7 366.7 381.3 361.4 369.1C344.8 330.9 305.6 303.1 259.9 303.1C214.3 303.1 175.1 330.8 158.4 369.1C153.1 381.3 166.1 390.6 179.3 385.4C203.7 375.1 231 369.4 259.9 369.4L259.9 369.4z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M179.3 369.3C166.1 374.5 153.1 365.1 158.4 352.9C175.1 314.7 214.3 287.8 259.9 287.8C305.6 287.8 344.8 314.7 361.4 352.1C366.7 365.2 352.9 374.5 340.6 369.3C316.2 359 288.8 353.2 259.9 353.2C231 353.2 203.7 358.1 179.3 369.3L179.3 369.3zM208.4 208C208.4 225.7 194 240 176.4 240C158.7 240 144.4 225.7 144.4 208C144.4 190.3 158.7 176 176.4 176C194 176 208.4 190.3 208.4 208zM304.4 208C304.4 190.3 318.7 176 336.4 176C354 176 368.4 190.3 368.4 208C368.4 225.7 354 240 336.4 240C318.7 240 304.4 225.7 304.4 208zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Frown Open', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-grimace'                         => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM399.3 360H344V400H352C375.8 400 395.5 382.7 399.3 360zM352 304H344V344H399.3C395.5 321.3 375.8 304 352 304zM328 344V304H264V344H328zM328 400V360H264V400H328zM184 304V344H248V304H184zM184 360V400H248V360H184zM168 344V304H160C136.2 304 116.5 321.3 112.7 344H168zM168 400V360H112.7C116.5 382.7 136.2 400 160 400H168zM176.4 176C158.7 176 144.4 190.3 144.4 208C144.4 225.7 158.7 240 176.4 240C194 240 208.4 225.7 208.4 208C208.4 190.3 194 176 176.4 176zM336.4 240C354 240 368.4 225.7 368.4 208C368.4 190.3 354 176 336.4 176C318.7 176 304.4 190.3 304.4 208C304.4 225.7 318.7 240 336.4 240z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M344 288C374.9 288 400 313.1 400 344C400 374.9 374.9 400 344 400H168C137.1 400 112 374.9 112 344C112 313.1 137.1 288 168 288H344zM168 320C154.7 320 144 330.7 144 344C144 357.3 154.7 368 168 368H176V320H168zM208 368H240V320H208V368zM304 320H272V368H304V320zM336 368H344C357.3 368 368 357.3 368 344C368 330.7 357.3 320 344 320H336V368zM208.4 208C208.4 225.7 194 240 176.4 240C158.7 240 144.4 225.7 144.4 208C144.4 190.3 158.7 176 176.4 176C194 176 208.4 190.3 208.4 208zM304.4 208C304.4 190.3 318.7 176 336.4 176C354 176 368.4 190.3 368.4 208C368.4 225.7 354 240 336.4 240C318.7 240 304.4 225.7 304.4 208zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Grimace', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-grin'                            => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256.3 331.8C208.9 331.8 164.1 324.9 124.5 312.8C112.2 309 100.2 319.7 105.2 331.5C130.1 390.6 188.4 432 256.3 432C324.2 432 382.4 390.6 407.4 331.5C412.4 319.7 400.4 309 388.1 312.8C348.4 324.9 303.7 331.8 256.3 331.8H256.3zM176.4 176C158.7 176 144.4 190.3 144.4 208C144.4 225.7 158.7 240 176.4 240C194 240 208.4 225.7 208.4 208C208.4 190.3 194 176 176.4 176zM336.4 240C354 240 368.4 225.7 368.4 208C368.4 190.3 354 176 336.4 176C318.7 176 304.4 190.3 304.4 208C304.4 225.7 318.7 240 336.4 240z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M349.5 308.4C368.2 303.1 385.4 320.4 374.1 336.5C350.4 374.6 306.3 399.1 255.9 399.1C205.6 399.1 161.5 374.6 136.9 336.5C126.5 320.4 143.7 303.1 162.3 308.4C191.3 315.1 222.8 318.8 255.9 318.8C289 318.8 320.6 315.1 349.5 308.4zM208.4 208C208.4 225.7 194 240 176.4 240C158.7 240 144.4 225.7 144.4 208C144.4 190.3 158.7 176 176.4 176C194 176 208.4 190.3 208.4 208zM304.4 208C304.4 190.3 318.7 176 336.4 176C354 176 368.4 190.3 368.4 208C368.4 225.7 354 240 336.4 240C318.7 240 304.4 225.7 304.4 208zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Grin', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-grin-beam'                       => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256.3 331.8C208.9 331.8 164.1 324.9 124.5 312.8C112.2 309 100.2 319.7 105.2 331.5C130.1 390.6 188.4 432 256.3 432C324.2 432 382.4 390.6 407.4 331.5C412.4 319.7 400.4 309 388.1 312.8C348.4 324.9 303.7 331.8 256.3 331.8H256.3zM226.5 231.6C229.8 230.5 232 227.4 232 224C232 206.1 225.3 188.4 215.4 175.2C205.6 162.2 191.5 152 176 152C160.5 152 146.4 162.2 136.6 175.2C126.7 188.4 120 206.1 120 224C120 227.4 122.2 230.5 125.5 231.6C128.7 232.7 132.3 231.6 134.4 228.8L134.4 228.8L134.6 228.5C134.8 228.3 134.1 228 135.3 227.6C135.1 226.8 136.9 225.7 138.1 224.3C140.6 221.4 144.1 217.7 148.3 213.1C157.1 206.2 167.2 200 176 200C184.8 200 194.9 206.2 203.7 213.1C207.9 217.7 211.4 221.4 213.9 224.3C215.1 225.7 216 226.8 216.7 227.6C217 228 217.2 228.3 217.4 228.5L217.6 228.8L217.6 228.8C219.7 231.6 223.3 232.7 226.5 231.6V231.6zM377.6 228.8C379.7 231.6 383.3 232.7 386.5 231.6C389.8 230.5 392 227.4 392 224C392 206.1 385.3 188.4 375.4 175.2C365.6 162.2 351.5 152 336 152C320.5 152 306.4 162.2 296.6 175.2C286.7 188.4 280 206.1 280 224C280 227.4 282.2 230.5 285.5 231.6C288.7 232.7 292.3 231.6 294.4 228.8L294.4 228.8L294.6 228.5C294.8 228.3 294.1 228 295.3 227.6C295.1 226.8 296.9 225.7 298.1 224.3C300.6 221.4 304.1 217.7 308.3 213.1C317.1 206.2 327.2 200 336 200C344.8 200 354.9 206.2 363.7 213.1C367.9 217.7 371.4 221.4 373.9 224.3C375.1 225.7 376 226.8 376.7 227.6C377 228 377.2 228.3 377.4 228.5L377.6 228.8L377.6 228.8z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M349.5 308.4C368.2 303.1 385.4 320.4 374.1 336.5C350.4 374.6 306.3 399.1 255.9 399.1C205.6 399.1 161.5 374.6 136.9 336.5C126.5 320.4 143.7 303.1 162.3 308.4C191.3 315.1 222.8 318.8 255.9 318.8C289 318.8 320.6 315.1 349.5 308.4zM217.6 228.8L217.6 228.8L217.4 228.5C217.2 228.3 217 228 216.7 227.6C216 226.8 215.1 225.7 213.9 224.3C211.4 221.4 207.9 217.7 203.7 213.1C194.9 206.2 184.8 200 176 200C167.2 200 157.1 206.2 148.3 213.1C144.1 217.7 140.6 221.4 138.1 224.3C136.9 225.7 135.1 226.8 135.3 227.6C134.1 228 134.8 228.3 134.6 228.5L134.4 228.8L134.4 228.8C132.3 231.6 128.7 232.7 125.5 231.6C122.2 230.5 120 227.4 120 224C120 206.1 126.7 188.4 136.6 175.2C146.4 162.2 160.5 152 176 152C191.5 152 205.6 162.2 215.4 175.2C225.3 188.4 232 206.1 232 224C232 227.4 229.8 230.5 226.5 231.6C223.3 232.7 219.7 231.6 217.6 228.8V228.8zM377.6 228.8L377.4 228.5C377.2 228.3 377 228 376.7 227.6C376 226.8 375.1 225.7 373.9 224.3C371.4 221.4 367.9 217.7 363.7 213.1C354.9 206.2 344.8 200 336 200C327.2 200 317.1 206.2 308.3 213.1C304.1 217.7 300.6 221.4 298.1 224.3C296.9 225.7 295.1 226.8 295.3 227.6C294.1 228 294.8 228.3 294.6 228.5L294.4 228.8L294.4 228.8C292.3 231.6 288.7 232.7 285.5 231.6C282.2 230.5 280 227.4 280 224C280 206.1 286.7 188.4 296.6 175.2C306.4 162.2 320.5 152 336 152C351.5 152 365.6 162.2 375.4 175.2C385.3 188.4 392 206.1 392 224C392 227.4 389.8 230.5 386.5 231.6C383.3 232.7 379.7 231.6 377.6 228.8L377.6 228.8zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Grin Beam', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-grin-beam-sweat'                 => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M464 128C437.5 128 416 107 416 81.01C416 76.01 417.8 69.74 420.6 62.87C420.9 62.17 421.2 61.46 421.6 60.74C430.5 40.51 448.1 15.86 457.6 3.282C460.8-1.093 467.2-1.094 470.4 3.281C483.4 20.65 512 61.02 512 81.01C512 102.7 497.1 120.8 476.8 126.3C472.7 127.4 468.4 128 464 128L464 128zM256 .0003C307.4 .0003 355.3 15.15 395.4 41.23C393.9 44.32 392.4 47.43 391.1 50.53C387.8 58.57 384 69.57 384 81.01C384 125.4 420.6 160 464 160C473.6 160 482.8 158.3 491.4 155.2C504.7 186.1 512 220.2 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0V.0003zM256.3 331.8C208.9 331.8 164.1 324.9 124.5 312.8C112.2 309 100.2 319.7 105.2 331.5C130.1 390.6 188.4 432 256.3 432C324.2 432 382.4 390.6 407.4 331.5C412.4 319.7 400.4 309 388.1 312.8C348.4 324.9 303.7 331.8 256.3 331.8H256.3zM226.5 231.6C229.8 230.5 232 227.4 232 224C232 206.1 225.3 188.4 215.4 175.2C205.6 162.2 191.5 152 176 152C160.5 152 146.4 162.2 136.6 175.2C126.7 188.4 120 206.1 120 224C120 227.4 122.2 230.5 125.5 231.6C128.7 232.7 132.3 231.6 134.4 228.8L134.4 228.8L134.6 228.5C134.8 228.3 134.1 228 135.3 227.6C135.1 226.8 136.9 225.7 138.1 224.3C140.6 221.4 144.1 217.7 148.3 213.1C157.1 206.2 167.2 200 176 200C184.8 200 194.9 206.2 203.7 213.1C207.9 217.7 211.4 221.4 213.9 224.3C215.1 225.7 216 226.8 216.7 227.6C217 228 217.2 228.3 217.4 228.5L217.6 228.8L217.6 228.8C219.7 231.6 223.3 232.7 226.5 231.6V231.6zM377.6 228.8C379.7 231.6 383.3 232.7 386.5 231.6C389.8 230.5 392 227.4 392 224C392 206.1 385.3 188.4 375.4 175.2C365.6 162.2 351.5 152 336 152C320.5 152 306.4 162.2 296.6 175.2C286.7 188.4 280 206.1 280 224C280 227.4 282.2 230.5 285.5 231.6C288.7 232.7 292.3 231.6 294.4 228.8L294.4 228.8L294.6 228.5C294.8 228.3 294.1 228 295.3 227.6C295.1 226.8 296.9 225.7 298.1 224.3C300.6 221.4 304.1 217.7 308.3 213.1C317.1 206.2 327.2 200 336 200C344.8 200 354.9 206.2 363.7 213.1C367.9 217.7 371.4 221.4 373.9 224.3C375.1 225.7 376 226.8 376.7 227.6C377 228 377.2 228.3 377.4 228.5L377.6 228.8L377.6 228.8z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M464 128C437.5 128 416 107 416 81.01C416 76.01 417.8 69.74 420.6 62.87C420.9 62.17 421.2 61.46 421.6 60.74C430.5 40.51 448.1 15.86 457.6 3.281C460.8-1.094 467.2-1.094 470.4 3.281C483.4 20.65 512 61.02 512 81.01C512 102.7 497.1 120.8 476.8 126.3C472.7 127.4 468.4 128 464 128L464 128zM391.1 50.53C387.8 58.57 384 69.57 384 81.01C384 84.1 384.3 88.91 384.9 92.72C349.4 64.71 304.7 48 256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 219.7 454.7 185.5 438.3 155.8C446.4 158.5 455.1 160 464 160C473.6 160 482.8 158.3 491.4 155.2C504.7 186.2 512 220.2 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 .0002 256 .0002C307.4 .0002 355.3 15.15 395.4 41.23C393.9 44.32 392.4 47.43 391.1 50.53V50.53zM255.9 399.1C205.6 399.1 161.5 374.6 136.9 336.5C126.5 320.4 143.7 303.1 162.3 308.4C191.3 315.1 222.8 318.9 255.9 318.9C289 318.9 320.6 315.1 349.5 308.4C368.2 303.1 385.4 320.4 374.1 336.5C350.4 374.6 306.3 399.1 255.9 399.1zM217.6 228.8L217.4 228.5C217.2 228.3 217 228 216.7 227.6C216 226.8 215.1 225.7 213.9 224.3C211.4 221.4 207.9 217.7 203.7 213.1C194.9 206.2 184.8 200 176 200C167.2 200 157.1 206.2 148.3 213.1C144.1 217.7 140.6 221.4 138.1 224.3C136.9 225.7 135.1 226.8 135.3 227.6C134.1 228 134.8 228.3 134.6 228.5L134.4 228.8L134.4 228.8C132.3 231.6 128.7 232.7 125.5 231.6C122.2 230.5 119.1 227.4 119.1 224C119.1 206.1 126.7 188.4 136.6 175.2C146.4 162.2 160.5 152 175.1 152C191.5 152 205.6 162.2 215.4 175.2C225.3 188.4 231.1 206.1 231.1 224C231.1 227.4 229.8 230.5 226.5 231.6C223.3 232.7 219.7 231.6 217.6 228.8L217.6 228.8zM377.6 228.8L377.6 228.8L377.4 228.5C377.2 228.3 377 228 376.7 227.6C376 226.8 375.1 225.7 373.9 224.3C371.4 221.4 367.9 217.7 363.7 213.1C354.9 206.2 344.8 200 336 200C327.2 200 317.1 206.2 308.3 213.1C304.1 217.7 300.6 221.4 298.1 224.3C296.9 225.7 295.1 226.8 295.3 227.6C294.1 228 294.8 228.3 294.6 228.5L294.4 228.8L294.4 228.8C292.3 231.6 288.7 232.7 285.5 231.6C282.2 230.5 280 227.4 280 224C280 206.1 286.7 188.4 296.6 175.2C306.4 162.2 320.5 152 336 152C351.5 152 365.6 162.2 375.4 175.2C385.3 188.4 392 206.1 392 224C392 227.4 389.8 230.5 386.5 231.6C383.3 232.7 379.7 231.6 377.6 228.8V228.8z',
			),
		),
		'label'             => __( 'Face Grin Beam Sweat', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-grin-hearts'                     => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256.3 331.8C208.9 331.8 164.1 324.9 124.5 312.8C112.2 309 100.2 319.7 105.2 331.5C130.1 390.6 188.4 432 256.3 432C324.2 432 382.4 390.6 407.4 331.5C412.4 319.7 400.4 309 388.1 312.8C348.4 324.9 303.7 331.8 256.3 331.8H256.3zM199.3 129.1C181.5 124.4 163.2 134.9 158.4 152.7L154.1 168.8L137.1 164.5C120.2 159.7 101.9 170.3 97.14 188.1C92.38 205.8 102.9 224.1 120.7 228.9L185.8 246.3C194.4 248.6 203.1 243.6 205.4 235L222.9 169.1C227.6 152.2 217.1 133.9 199.3 129.1H199.3zM353.6 152.7C348.8 134.9 330.5 124.4 312.7 129.1C294.9 133.9 284.4 152.2 289.1 169.1L306.6 235C308.9 243.6 317.6 248.6 326.2 246.3L391.3 228.9C409.1 224.1 419.6 205.8 414.9 188.1C410.1 170.3 391.8 159.7 374 164.5L357.9 168.8L353.6 152.7z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M349.5 308.4C368.2 303.1 385.4 320.4 374.1 336.5C350.4 374.6 306.3 399.1 255.9 399.1C205.6 399.1 161.5 374.6 136.9 336.5C126.5 320.4 143.7 303.1 162.3 308.4C191.3 315.1 222.8 318.8 255.9 318.8C289 318.8 320.6 315.1 349.5 308.4zM238.9 177.1L221.4 243C219.1 251.6 210.4 256.6 201.8 254.3L136.7 236.9C118.9 232.1 108.4 213.8 113.1 196.1C117.9 178.3 136.2 167.7 153.1 172.5L170.1 176.8L174.4 160.7C179.2 142.9 197.5 132.4 215.3 137.1C233.1 141.9 243.6 160.2 238.9 177.1H238.9zM341.9 176.8L358 172.5C375.8 167.7 394.1 178.3 398.9 196.1C403.6 213.8 393.1 232.1 375.3 236.9L310.2 254.3C301.6 256.6 292.9 251.6 290.6 243L273.1 177.1C268.4 160.2 278.9 141.9 296.7 137.1C314.5 132.4 332.8 142.9 337.6 160.7L341.9 176.8zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Grin Hearts', 'astra' ),
		'custom_categories' => array(
			'design',
			'lifestyle-and-hobbies',
		),
	),
	'face-grin-squint'                     => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256.3 331.8C208.9 331.8 164.1 324.9 124.5 312.8C112.2 309 100.2 319.7 105.2 331.5C130.1 390.6 188.4 432 256.3 432C324.2 432 382.4 390.6 407.4 331.5C412.4 319.7 400.4 309 388.1 312.8C348.4 324.9 303.7 331.8 256.3 331.8H256.3zM133.5 146.7C125.6 142.4 116 148.2 116 157.1C116 159.9 116.1 162.6 118.8 164.8L154.8 208L118.8 251.2C116.1 253.4 116 256.1 116 258.9C116 267.8 125.6 273.6 133.5 269.3L223.4 221.4C234.1 215.7 234.1 200.3 223.4 194.6L133.5 146.7zM396 157.1C396 148.2 386.4 142.4 378.5 146.7L288.6 194.6C277.9 200.3 277.9 215.7 288.6 221.4L378.5 269.3C386.4 273.6 396 267.8 396 258.9C396 256.1 395 253.4 393.2 251.2L357.2 208L393.2 164.8C395 162.6 396 159.9 396 157.1V157.1z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M349.5 308.4C368.2 303.1 385.4 320.4 374.1 336.5C350.4 374.6 306.3 399.1 255.9 399.1C205.6 399.1 161.5 374.6 136.9 336.5C126.5 320.4 143.7 303.1 162.3 308.4C191.3 315.1 222.8 318.8 255.9 318.8C289 318.8 320.6 315.1 349.5 308.4zM223.4 194.6C234.1 200.3 234.1 215.7 223.4 221.4L133.5 269.3C125.6 273.6 116 267.8 116 258.9C116 256.1 116.1 253.4 118.8 251.2L154.8 208L118.8 164.8C116.1 162.6 116 159.9 116 157.1C116 148.2 125.6 142.4 133.5 146.7L223.4 194.6zM393.2 164.8L357.2 208L393.2 251.2C395 253.4 396 256.1 396 258.9C396 267.8 386.4 273.6 378.5 269.3L288.6 221.4C277.9 215.7 277.9 200.3 288.6 194.6L378.5 146.7C386.4 142.4 396 148.2 396 157.1C396 159.9 395 162.6 393.2 164.8zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Grin Squint', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-grin-squint-tears'               => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M426.8 14.18C446-5.046 477.5-4.645 497.1 14.92C516.6 34.49 517 65.95 497.8 85.18C490.1 92.02 476.4 97.59 460.5 101.9C444.1 106.3 426.4 109.4 414.1 111.2C412.5 111.5 410.1 111.7 409.6 111.9C403.1 112.8 399.2 108 400.1 102.4C401.7 91.19 404.7 72.82 409.1 55.42C409.4 54.12 409.8 52.84 410.1 51.56C414.4 35.62 419.1 21.02 426.8 14.18L426.8 14.18zM382.2 33.17C380.6 37.96 379.3 42.81 378.1 47.52C373.3 66.46 370.1 86.05 368.4 97.79C364.5 124.6 387.4 147.5 414.1 143.6C426 141.9 445.6 138.8 464.5 133.9C469.2 132.7 474.1 131.4 478.8 129.9C534.2 227.5 520.2 353.8 437 437C353.8 520.3 227.5 534.2 129.8 478.8C131.3 474 132.7 469.2 133.9 464.5C138.7 445.5 141.9 425.1 143.6 414.2C147.5 387.4 124.6 364.5 97.89 368.4C85.97 370.1 66.39 373.2 47.46 378.1C42.76 379.3 37.93 380.6 33.15 382.1C-22.19 284.5-8.245 158.2 74.98 74.98C158.2-8.253 284.5-22.19 382.2 33.17V33.17zM416.4 202.3C411.6 190.4 395.6 191.4 389.6 202.7C370.1 239.4 343.3 275.9 309.8 309.4C276.3 342.9 239.8 369.7 203.1 389.2C191.8 395.2 190.8 411.2 202.7 416C262.1 440.2 332.6 428.3 380.7 380.3C428.7 332.2 440.6 261.7 416.4 202.3H416.4zM94.43 288.5L150.5 293.6L155.6 349.7C155.8 352.5 157.1 355 159 357C165.4 363.4 176.2 360.7 178.8 352.1L208.5 254.6C211.1 242.1 201.1 232.1 189.5 235.7L92.05 265.3C83.46 267.9 80.76 278.7 87.1 285.1C89.07 287.1 91.66 288.3 94.43 288.5V288.5zM235.7 189.5C232.1 201.1 242.1 211.1 254.6 208.5L352.1 178.8C360.7 176.2 363.4 165.4 357 159C355 157.1 352.5 155.8 349.7 155.6L293.6 150.5L288.5 94.43C288.3 91.66 287.1 89.07 285.1 87.1C278.7 80.76 267.9 83.46 265.3 92.05L235.7 189.5zM51.53 410.1C70.01 405.1 90.3 401.8 102.4 400.1C108 399.2 112.8 403.1 111.9 409.6C110.2 421.7 106.9 441.9 101.9 460.4C97.57 476.4 92.02 490.1 85.18 497.8C65.95 517 34.49 516.6 14.92 497.1C-4.645 477.5-5.046 446 14.18 426.8C21.02 419.1 35.6 414.4 51.53 410.1V410.1z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M426.8 14.18C446-5.046 477.5-4.646 497.1 14.92C516.6 34.49 517 65.95 497.8 85.18C483 99.97 432.2 108.8 409.6 111.9C403.1 112.8 399.2 108 400.1 102.4C403.3 79.94 412 28.97 426.8 14.18H426.8zM74.98 74.98C158.2-8.253 284.5-22.19 382.2 33.17C380.6 37.96 379.3 42.81 378.1 47.52C375 59.67 372.6 72.08 370.8 82.52C290.1 28.93 180.1 37.74 108.9 108.9C37.75 180.1 28.94 290 82.49 370.8C72.01 372.6 59.6 374.1 47.46 378.1C42.76 379.3 37.93 380.6 33.15 382.1C-22.19 284.5-8.245 158.2 74.98 74.98V74.98zM478.8 129.9C534.2 227.5 520.2 353.8 437 437C353.8 520.3 227.5 534.2 129.8 478.8C131.3 474 132.7 469.2 133.9 464.5C136.1 452.3 139.4 439.9 141.2 429.5C221.9 483.1 331.9 474.3 403.1 403.1C474.3 331.9 483.1 221.1 429.5 141.2C439.1 139.4 452.4 137 464.5 133.9C469.2 132.7 474.1 131.4 478.8 129.9L478.8 129.9zM359.2 226.9C369.3 210.6 393 210 397 228.8C406.6 273.1 393.4 322.3 357.8 357.9C322.2 393.5 273 406.7 228.6 397.1C209.9 393.1 210.5 369.4 226.8 359.3C252 343.6 276.1 323.9 300.4 300.5C323.8 277.1 343.5 252.1 359.2 226.9L359.2 226.9zM189.5 235.7C201.1 232.1 211.1 242.1 208.5 254.6L178.8 352.1C176.2 360.7 165.4 363.4 159 357C157.1 355 155.8 352.5 155.6 349.7L150.5 293.6L94.43 288.5C91.66 288.3 89.07 287.1 87.1 285.1C80.76 278.7 83.46 267.9 92.05 265.3L189.5 235.7zM288.5 94.43L293.6 150.5L349.7 155.6C352.5 155.8 355 157.1 357 159C363.4 165.4 360.7 176.2 352.1 178.8L254.6 208.5C242.1 211.1 232.1 201.1 235.7 189.5L265.3 92.05C267.9 83.46 278.7 80.76 285.1 87.1C287.1 89.07 288.3 91.66 288.5 94.43V94.43zM14.18 426.8C28.97 412 79.85 403.2 102.4 400.1C108 399.2 112.8 403.1 111.9 409.6C108.7 432.1 99.97 483 85.18 497.8C65.95 517 34.5 516.6 14.93 497.1C-4.645 477.5-5.046 446 14.18 426.8H14.18z',
			),
		),
		'label'             => __( 'Face Grin Squint Tears', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-grin-stars'                      => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM407.4 331.5C412.4 319.7 400.4 309 388.1 312.8C348.4 324.9 303.7 331.8 256.3 331.8C208.9 331.8 164.1 324.9 124.5 312.8C112.2 309 100.2 319.7 105.2 331.5C130.1 390.6 188.4 432 256.3 432C324.2 432 382.4 390.6 407.4 331.5H407.4zM152.8 124.6L136.2 159.3L98.09 164.3C95.03 164.7 92.48 166.8 91.52 169.8C90.57 172.7 91.39 175.9 93.62 178L121.5 204.5L114.5 242.3C113.1 245.4 115.2 248.4 117.7 250.2C120.2 252.1 123.5 252.3 126.2 250.8L159.1 232.5L193.8 250.8C196.5 252.3 199.8 252.1 202.3 250.2C204.8 248.4 206 245.4 205.5 242.3L198.5 204.5L226.4 178C228.6 175.9 229.4 172.7 228.5 169.8C227.5 166.8 224.1 164.7 221.9 164.3L183.8 159.3L167.2 124.6C165.9 121.8 163.1 120 159.1 120C156.9 120 154.1 121.8 152.8 124.6V124.6zM344.8 124.6L328.2 159.3L290.1 164.3C287 164.7 284.5 166.8 283.5 169.8C282.6 172.7 283.4 175.9 285.6 178L313.5 204.5L306.5 242.3C305.1 245.4 307.2 248.4 309.7 250.2C312.2 252.1 315.5 252.3 318.2 250.8L352 232.5L385.8 250.8C388.5 252.3 391.8 252.1 394.3 250.2C396.8 248.4 398 245.4 397.5 242.3L390.5 204.5L418.4 178C420.6 175.9 421.4 172.7 420.5 169.8C419.5 166.8 416.1 164.7 413.9 164.3L375.8 159.3L359.2 124.6C357.9 121.8 355.1 120 352 120C348.9 120 346.1 121.8 344.8 124.6H344.8z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M199.8 167.3L237.9 172.3C240.1 172.7 243.5 174.8 244.5 177.8C245.4 180.7 244.6 183.9 242.4 186L214.5 212.5L221.5 250.3C222 253.4 220.8 256.4 218.3 258.2C215.8 260.1 212.5 260.3 209.8 258.8L175.1 240.5L142.2 258.8C139.5 260.3 136.2 260.1 133.7 258.2C131.2 256.4 129.1 253.4 130.5 250.3L137.5 212.5L109.6 186C107.4 183.9 106.6 180.7 107.5 177.8C108.5 174.8 111 172.7 114.1 172.3L152.2 167.3L168.8 132.6C170.1 129.8 172.9 128 175.1 128C179.1 128 181.9 129.8 183.2 132.6L199.8 167.3zM359.8 167.3L397.9 172.3C400.1 172.7 403.5 174.8 404.5 177.8C405.4 180.7 404.6 183.9 402.4 186L374.5 212.5L381.5 250.3C382 253.4 380.8 256.4 378.3 258.2C375.8 260.1 372.5 260.3 369.8 258.8L336 240.5L302.2 258.8C299.5 260.3 296.2 260.1 293.7 258.2C291.2 256.4 289.1 253.4 290.5 250.3L297.5 212.5L269.6 186C267.4 183.9 266.6 180.7 267.5 177.8C268.5 174.8 271 172.7 274.1 172.3L312.2 167.3L328.8 132.6C330.1 129.8 332.9 128 336 128C339.1 128 341.9 129.8 343.2 132.6L359.8 167.3zM349.5 308.4C368.2 303.1 385.4 320.4 374.1 336.5C350.4 374.6 306.3 399.1 255.9 399.1C205.6 399.1 161.5 374.6 136.9 336.5C126.5 320.4 143.7 303.1 162.3 308.4C191.3 315.1 222.8 318.8 255.9 318.8C289 318.8 320.6 315.1 349.5 308.4zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464z',
			),
		),
		'label'             => __( 'Face Grin Stars', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-grin-tears'                      => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M548.6 371.4C506.4 454.8 419.9 512 319.1 512C220.1 512 133.6 454.8 91.4 371.4C95.87 368.4 100.1 365 104.1 361.1C112.2 352.1 117.3 342.5 120.6 334.4C124.2 325.7 127.1 316 129.4 306.9C134 288.7 137 269.1 138.6 258.7C142.6 232.2 119.9 209.5 93.4 213.3C86.59 214.3 77.18 215.7 66.84 217.7C85.31 94.5 191.6 0 319.1 0C448.4 0 554.7 94.5 573.2 217.7C562.8 215.7 553.4 214.3 546.6 213.3C520.1 209.5 497.4 232.2 501.4 258.7C502.1 269.1 505.1 288.7 510.6 306.9C512.9 316 515.8 325.7 519.4 334.4C522.7 342.5 527.8 352.1 535.9 361.1C539.9 365 544.1 368.4 548.6 371.4V371.4zM471.4 331.5C476.4 319.7 464.4 309 452.1 312.8C412.4 324.9 367.7 331.8 320.3 331.8C272.9 331.8 228.1 324.9 188.5 312.8C176.2 309 164.2 319.7 169.2 331.5C194.1 390.6 252.4 432 320.3 432C388.2 432 446.4 390.6 471.4 331.5H471.4zM281.6 228.8C283.7 231.6 287.3 232.7 290.5 231.6C293.8 230.5 295.1 227.4 295.1 224C295.1 206.1 289.3 188.4 279.4 175.2C269.6 162.2 255.5 152 239.1 152C224.5 152 210.4 162.2 200.6 175.2C190.7 188.4 183.1 206.1 183.1 224C183.1 227.4 186.2 230.5 189.5 231.6C192.7 232.7 196.3 231.6 198.4 228.8L198.4 228.8L198.6 228.5C198.8 228.3 198.1 228 199.3 227.6C199.1 226.8 200.9 225.7 202.1 224.3C204.6 221.4 208.1 217.7 212.3 213.1C221.1 206.2 231.2 200 239.1 200C248.8 200 258.9 206.2 267.7 213.1C271.9 217.7 275.4 221.4 277.9 224.3C279.1 225.7 280 226.8 280.7 227.6C281 228 281.2 228.3 281.4 228.5L281.6 228.8L281.6 228.8zM450.5 231.6C453.8 230.5 456 227.4 456 224C456 206.1 449.3 188.4 439.4 175.2C429.6 162.2 415.5 152 400 152C384.5 152 370.4 162.2 360.6 175.2C350.7 188.4 344 206.1 344 224C344 227.4 346.2 230.5 349.5 231.6C352.7 232.7 356.3 231.6 358.4 228.8L358.4 228.8L358.6 228.5C358.8 228.3 358.1 228 359.3 227.6C359.1 226.8 360.9 225.7 362.1 224.3C364.6 221.4 368.1 217.7 372.3 213.1C381.1 206.2 391.2 200 400 200C408.8 200 418.9 206.2 427.7 213.1C431.9 217.7 435.4 221.4 437.9 224.3C439.1 225.7 440 226.8 440.7 227.6C441 228 441.2 228.3 441.4 228.5L441.6 228.8L441.6 228.8C443.7 231.6 447.3 232.7 450.5 231.6V231.6zM106.1 254.1C103.9 275.6 95.58 324.3 81.43 338.4C80.49 339.4 79.51 340.3 78.5 341.1C59.98 356.7 32.01 355.5 14.27 337.7C-4.442 319-4.825 288.9 13.55 270.6C22.19 261.9 43.69 255.4 64.05 250.1C77.02 248.2 89.53 246.2 97.94 245C103.3 244.2 107.8 248.7 106.1 254.1V254.1zM561.5 341.1C560.7 340.5 559.1 339.8 559.2 339.1C559 338.9 558.8 338.7 558.6 338.4C544.4 324.3 536.1 275.6 533 254.1C532.2 248.7 536.7 244.2 542.1 245C543.1 245.2 544.2 245.3 545.4 245.5C553.6 246.7 564.6 248.5 575.1 250.1C596.3 255.4 617.8 261.9 626.4 270.6C644.8 288.9 644.4 319 625.7 337.7C607.1 355.5 580 356.7 561.5 341.1L561.5 341.1z',
			),
			'regular' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M519.4 334.4C522.7 342.5 527.8 352.1 535.9 361.1C539.9 365 544.1 368.4 548.6 371.4C506.4 454.8 419.9 512 319.1 512C220.1 512 133.6 454.8 91.4 371.4C95.87 368.4 100.1 365 104.1 361.1C112.2 352.1 117.3 342.5 120.6 334.4C121.8 331.5 122.9 328.6 123.9 325.5C152.5 406.2 229.5 464 319.1 464C410.5 464 487.5 406.2 516.1 325.5C517.1 328.6 518.2 331.5 519.4 334.4V334.4zM319.1 47.1C218.6 47.1 134.2 120.5 115.7 216.5C109.1 213.4 101.4 212.2 93.4 213.3C86.59 214.3 77.18 215.7 66.84 217.7C85.31 94.5 191.6 0 319.1 0C448.4 0 554.7 94.5 573.2 217.7C562.8 215.7 553.4 214.3 546.6 213.3C538.6 212.2 530.9 213.4 524.2 216.5C505.8 120.5 421.4 48 319.1 48V47.1zM78.5 341.1C59.98 356.7 32.01 355.5 14.27 337.7C-4.442 319-4.825 288.9 13.55 270.6C22.19 261.9 43.69 255.4 64.05 250.1C77.02 248.2 89.53 246.2 97.94 245C103.3 244.2 107.8 248.7 106.1 254.1C103.9 275.6 95.58 324.3 81.43 338.4C80.49 339.4 79.51 340.3 78.5 341.1V341.1zM561.5 341.1C560.7 340.5 559.1 339.8 559.2 339.1C559 338.9 558.8 338.7 558.6 338.4C544.4 324.3 536.1 275.6 533 254.1C532.2 248.7 536.7 244.2 542.1 245C543.1 245.2 544.2 245.3 545.4 245.5C553.6 246.7 564.6 248.5 575.1 250.1C596.3 255.4 617.8 261.9 626.4 270.6C644.8 288.9 644.4 319 625.7 337.7C607.1 355.5 580 356.7 561.5 341.1L561.5 341.1zM319.9 399.1C269.6 399.1 225.5 374.6 200.9 336.5C190.5 320.4 207.7 303.1 226.3 308.4C255.3 315.1 286.8 318.8 319.9 318.8C353 318.8 384.6 315.1 413.5 308.4C432.2 303.1 449.4 320.4 438.1 336.5C414.4 374.6 370.3 399.1 319.9 399.1zM281.6 228.8L281.4 228.5C281.2 228.3 281 228 280.7 227.6C280 226.8 279.1 225.7 277.9 224.3C275.4 221.4 271.9 217.7 267.7 213.1C258.9 206.2 248.8 200 239.1 200C231.2 200 221.1 206.2 212.3 213.1C208.1 217.7 204.6 221.4 202.1 224.3C200.9 225.7 199.1 226.8 199.3 227.6C198.1 228 198.8 228.3 198.6 228.5L198.4 228.8L198.4 228.8C196.3 231.6 192.7 232.7 189.5 231.6C186.2 230.5 183.1 227.4 183.1 224C183.1 206.1 190.7 188.4 200.6 175.2C210.4 162.2 224.5 152 239.1 152C255.5 152 269.6 162.2 279.4 175.2C289.3 188.4 295.1 206.1 295.1 224C295.1 227.4 293.8 230.5 290.5 231.6C287.3 232.7 283.7 231.6 281.6 228.8L281.6 228.8zM441.6 228.8L441.6 228.8L441.4 228.5C441.2 228.3 441 228 440.7 227.6C440 226.8 439.1 225.7 437.9 224.3C435.4 221.4 431.9 217.7 427.7 213.1C418.9 206.2 408.8 200 400 200C391.2 200 381.1 206.2 372.3 213.1C368.1 217.7 364.6 221.4 362.1 224.3C360.9 225.7 359.1 226.8 359.3 227.6C358.1 228 358.8 228.3 358.6 228.5L358.4 228.8L358.4 228.8C356.3 231.6 352.7 232.7 349.5 231.6C346.2 230.5 344 227.4 344 223.1C344 206.1 350.7 188.4 360.6 175.2C370.4 162.2 384.5 151.1 400 151.1C415.5 151.1 429.6 162.2 439.4 175.2C449.3 188.4 456 206.1 456 223.1C456 227.4 453.8 230.5 450.5 231.6C447.3 232.7 443.7 231.6 441.6 228.8V228.8z',
			),
		),
		'label'             => __( 'Face Grin Tears', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-grin-tongue'                     => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 0C397.4 0 512 114.6 512 256C512 368.9 438.9 464.7 337.5 498.8C346.7 484 352 466.6 352 448V401.1C376.3 383.5 395.6 359.5 407.4 331.5C412.4 319.7 400.4 309 388.1 312.8C348.4 324.9 303.7 331.8 256.3 331.8C208.9 331.8 164.1 324.9 124.5 312.8C112.2 309 100.2 319.7 105.2 331.5C116.9 359.3 135.1 383.1 160 400.7V448C160 466.6 165.3 484 174.5 498.8C73.07 464.7 0 368.9 0 256C0 114.6 114.6 .0003 256 .0003L256 0zM176.4 240C194 240 208.4 225.7 208.4 208C208.4 190.3 194 176 176.4 176C158.7 176 144.4 190.3 144.4 208C144.4 225.7 158.7 240 176.4 240zM336.4 176C318.7 176 304.4 190.3 304.4 208C304.4 225.7 318.7 240 336.4 240C354 240 368.4 225.7 368.4 208C368.4 190.3 354 176 336.4 176zM256 512C220.7 512 192 483.3 192 448V402.6C192 387.9 203.9 376 218.6 376H220.6C231.9 376 241.7 383.9 244.2 394.9C247 407.5 264.1 407.5 267.8 394.9C270.3 383.9 280.1 376 291.4 376H293.4C308.1 376 320 387.9 320 402.6V448C320 483.3 291.3 512 256 512V512z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M144.4 208C144.4 190.3 158.7 176 176.4 176C194 176 208.4 190.3 208.4 208C208.4 225.7 194 240 176.4 240C158.7 240 144.4 225.7 144.4 208zM368.4 208C368.4 225.7 354 240 336.4 240C318.7 240 304.4 225.7 304.4 208C304.4 190.3 318.7 176 336.4 176C354 176 368.4 190.3 368.4 208zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 337.7 95.13 408.4 163.7 442.4C161.3 434 160 425.2 160 416V363.6C151.1 355.6 143.3 346.5 136.9 336.5C126.5 320.4 143.7 303.1 162.3 308.4C191.3 315.1 222.8 318.8 255.9 318.8C289 318.8 320.6 315.1 349.5 308.4C368.2 303.1 385.4 320.4 374.1 336.5C368.6 346.4 360.8 355.5 352 363.5V416C352 425.2 350.7 434 348.3 442.4C416.9 408.4 464 337.7 464 256C464 141.1 370.9 48 255.1 48H256zM320 416V378.6C320 363.9 308.1 352 293.4 352H291.4C280.1 352 270.3 359.9 267.8 370.9C264.1 383.5 247 383.5 244.2 370.9C241.7 359.9 231.9 352 220.6 352H218.6C203.9 352 192 363.9 192 378.6V416C192 451.3 220.7 480 256 480C291.3 480 320 451.3 320 416z',
			),
		),
		'label'             => __( 'Face Grin Tongue', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-grin-tongue-squint'              => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 0C397.4 0 512 114.6 512 256C512 368.9 438.9 464.7 337.5 498.8C346.7 484 352 466.6 352 448V401.1C376.3 383.5 395.6 359.5 407.4 331.5C412.4 319.7 400.4 309 388.1 312.8C348.4 324.9 303.7 331.8 256.3 331.8C208.9 331.8 164.1 324.9 124.5 312.8C112.2 309 100.2 319.7 105.2 331.5C116.9 359.3 135.1 383.1 160 400.7V448C160 466.6 165.3 484 174.5 498.8C73.07 464.7 0 368.9 0 256C0 114.6 114.6 .0003 256 .0003L256 0zM118.8 148.8L154.8 192L118.8 235.2C116.1 237.4 116 240.1 116 242.9C116 251.8 125.6 257.6 133.5 253.3L223.4 205.4C234.1 199.7 234.1 184.3 223.4 178.6L133.5 130.7C125.6 126.4 116 132.2 116 141.1C116 143.9 116.1 146.6 118.8 148.8V148.8zM288.6 178.6C277.9 184.3 277.9 199.7 288.6 205.4L378.5 253.3C386.4 257.6 396 251.8 396 242.9C396 240.1 395 237.4 393.2 235.2L357.2 192L393.2 148.8C395 146.6 396 143.9 396 141.1C396 132.2 386.4 126.4 378.5 130.7L288.6 178.6zM256 512C220.7 512 192 483.3 192 448V402.6C192 387.9 203.9 376 218.6 376H220.6C231.9 376 241.7 383.9 244.2 394.9C247 407.5 264.1 407.5 267.8 394.9C270.3 383.9 280.1 376 291.4 376H293.4C308.1 376 320 387.9 320 402.6V448C320 483.3 291.3 512 256 512V512z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M116 157.1C116 148.2 125.6 142.4 133.5 146.7L223.4 194.6C234.1 200.3 234.1 215.7 223.4 221.4L133.5 269.3C125.6 273.6 116 267.8 116 258.9C116 256.1 116.1 253.4 118.8 251.2L154.8 208L118.8 164.8C116.1 162.6 116 159.9 116 157.1V157.1zM378.5 146.7C386.4 142.4 396 148.2 396 157.1C396 159.9 395 162.6 393.2 164.8L357.2 208L393.2 251.2C395 253.4 396 256.1 396 258.9C396 267.8 386.4 273.6 378.5 269.3L288.6 221.4C277.9 215.7 277.9 200.3 288.6 194.6L378.5 146.7zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 337.7 95.13 408.4 163.7 442.4C161.3 434 160 425.2 160 416V392.7C135.1 375.1 116.9 351.3 105.2 323.5C100.2 311.7 112.2 301 124.5 304.8C164.1 316.9 208.9 323.8 256.3 323.8C303.7 323.8 348.4 316.9 388.1 304.8C400.4 301 412.4 311.7 407.4 323.5C395.6 351.5 376.3 375.5 352 393.1V416C352 425.2 350.7 434 348.3 442.4C416.9 408.4 464 337.7 464 255.1C464 141.1 370.9 47.1 256 47.1L256 48zM320 416V378.6C320 363.9 308.1 352 293.4 352H291.4C280.1 352 270.3 359.9 267.8 370.9C264.1 383.5 247 383.5 244.2 370.9C241.7 359.9 231.9 352 220.6 352H218.6C203.9 352 192 363.9 192 378.6V416C192 451.3 220.7 480 256 480C291.3 480 320 451.3 320 416z',
			),
		),
		'label'             => __( 'Face Grin Tongue Squint', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-grin-tongue-wink'                => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M312 208C312 194.7 322.7 184 336 184C349.3 184 360 194.7 360 208C360 221.3 349.3 232 336 232C322.7 232 312 221.3 312 208zM174.5 498.8C73.07 464.7 0 368.9 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 368.9 438.9 464.7 337.5 498.8C346.7 484 352 466.6 352 448V401.1C376.3 383.5 395.6 359.5 407.4 331.5C412.4 319.7 400.4 309 388.1 312.8C348.4 324.9 303.7 331.8 256.3 331.8C208.9 331.8 164.1 324.9 124.5 312.8C112.2 309 100.2 319.7 105.2 331.5C116.9 359.3 135.1 383.1 159.1 400.7V448C159.1 466.6 165.3 484 174.5 498.8L174.5 498.8zM217.6 236.8C224.7 231.5 226.1 221.5 220.8 214.4C190.4 173.9 129.6 173.9 99.2 214.4C93.9 221.5 95.33 231.5 102.4 236.8C109.5 242.1 119.5 240.7 124.8 233.6C142.4 210.1 177.6 210.1 195.2 233.6C200.5 240.7 210.5 242.1 217.6 236.8zM336 272C371.3 272 400 243.3 400 208C400 172.7 371.3 144 336 144C300.7 144 272 172.7 272 208C272 243.3 300.7 272 336 272zM320 402.6V448C320 483.3 291.3 512 256 512C220.7 512 192 483.3 192 448V402.6C192 387.9 203.9 376 218.6 376H220.6C231.9 376 241.7 383.9 244.2 394.9C247 407.5 264.1 407.5 267.8 394.9C270.3 383.9 280.1 376 291.4 376H293.4C308.1 376 320 387.9 320 402.6V402.6z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M159.6 220C148.1 220 139.7 223.8 134.2 229.7C126.7 237.7 114 238.1 105.9 230.6C97.89 223 97.48 210.4 105 202.3C119.6 186.8 140.3 180 159.6 180C178.1 180 199.7 186.8 214.2 202.3C221.8 210.4 221.4 223 213.3 230.6C205.2 238.1 192.6 237.7 185 229.7C179.6 223.8 170.3 220 159.6 220zM312.4 208C312.4 194.7 323.1 184 336.4 184C349.6 184 360.4 194.7 360.4 208C360.4 221.3 349.6 232 336.4 232C323.1 232 312.4 221.3 312.4 208zM256 208C256 163.8 291.8 128 336 128C380.2 128 416 163.8 416 208C416 252.2 380.2 288 336 288C291.8 288 256 252.2 256 208zM336 256C362.5 256 384 234.5 384 208C384 181.5 362.5 160 336 160C309.5 160 288 181.5 288 208C288 234.5 309.5 256 336 256zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM348.3 442.4C416.9 408.4 464 337.7 464 256C464 141.1 370.9 48 256 48C141.1 48 48 141.1 48 256C48 337.7 95.13 408.4 163.7 442.4C161.3 434 160 425.2 160 416V363.6C151.1 355.6 143.3 346.5 136.9 336.5C126.5 320.4 143.7 303.1 162.3 308.4C191.3 315.1 222.8 318.8 255.9 318.8C289 318.8 320.6 315.1 349.5 308.4C368.2 303.1 385.4 320.4 374.1 336.5C368.6 346.4 360.8 355.5 352 363.5V416C352 425.2 350.7 434 348.3 442.4H348.3zM320 416V378.6C320 363.9 308.1 352 293.4 352H291.4C280.1 352 270.3 359.9 267.8 370.9C264.1 383.5 247 383.5 244.2 370.9C241.7 359.9 231.9 352 220.6 352H218.6C203.9 352 192 363.9 192 378.6V416C192 451.3 220.7 480 256 480C291.3 480 320 451.3 320 416z',
			),
		),
		'label'             => __( 'Face Grin Tongue Wink', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-grin-wide'                       => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256.3 331.8C208.9 331.8 164.1 324.9 124.5 312.8C112.2 309 100.2 319.7 105.2 331.5C130.1 390.6 188.4 432 256.3 432C324.2 432 382.4 390.6 407.4 331.5C412.4 319.7 400.4 309 388.1 312.8C348.4 324.9 303.7 331.8 256.3 331.8H256.3zM176 128C158.3 128 144 156.7 144 192C144 227.3 158.3 256 176 256C193.7 256 208 227.3 208 192C208 156.7 193.7 128 176 128zM336 256C353.7 256 368 227.3 368 192C368 156.7 353.7 128 336 128C318.3 128 304 156.7 304 192C304 227.3 318.3 256 336 256z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M349.5 308.4C368.2 303.1 385.4 320.4 374.1 336.5C350.4 374.6 306.3 399.1 255.9 399.1C205.6 399.1 161.5 374.6 136.9 336.5C126.5 320.4 143.7 303.1 162.3 308.4C191.3 315.1 222.8 318.8 255.9 318.8C289 318.8 320.6 315.1 349.5 308.4zM224 192C224 227.3 209.7 256 192 256C174.3 256 160 227.3 160 192C160 156.7 174.3 128 192 128C209.7 128 224 156.7 224 192zM288 192C288 156.7 302.3 128 320 128C337.7 128 352 156.7 352 192C352 227.3 337.7 256 320 256C302.3 256 288 227.3 288 192zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Grin Wide', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-grin-wink'                       => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256.3 331.8C208.9 331.8 164.1 324.9 124.5 312.8C112.2 309 100.2 319.7 105.2 331.5C130.1 390.6 188.4 432 256.3 432C324.2 432 382.4 390.6 407.4 331.5C412.4 319.7 400.4 309 388.1 312.8C348.4 324.9 303.7 331.8 256.3 331.8H256.3zM393.6 236.8C400.7 231.5 402.1 221.5 396.8 214.4C366.4 173.9 305.6 173.9 275.2 214.4C269.9 221.5 271.3 231.5 278.4 236.8C285.5 242.1 295.5 240.7 300.8 233.6C318.4 210.1 353.6 210.1 371.2 233.6C376.5 240.7 386.5 242.1 393.6 236.8zM176.4 240C194 240 208.4 225.7 208.4 208C208.4 190.3 194 176 176.4 176C158.7 176 144.4 190.3 144.4 208C144.4 225.7 158.7 240 176.4 240z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M349.5 308.4C368.2 303.1 385.4 320.4 374.1 336.5C350.4 374.6 306.3 399.1 255.9 399.1C205.6 399.1 161.5 374.6 136.9 336.5C126.5 320.4 143.7 303.1 162.3 308.4C191.3 315.1 222.8 318.8 255.9 318.8C289 318.8 320.6 315.1 349.5 308.4zM208.4 208C208.4 225.7 194 240 176.4 240C158.7 240 144.4 225.7 144.4 208C144.4 190.3 158.7 176 176.4 176C194 176 208.4 190.3 208.4 208zM281.9 230.6C273.9 223 273.5 210.4 281 202.3C295.6 186.8 316.3 180 335.6 180C354.1 180 375.7 186.8 390.2 202.3C397.8 210.4 397.4 223 389.3 230.6C381.2 238.1 368.6 237.7 361 229.7C355.6 223.8 346.3 220 335.6 220C324.1 220 315.7 223.8 310.2 229.7C302.7 237.7 290 238.1 281.9 230.6zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Grin Wink', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-kiss'                            => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM287.9 300.3C274.7 292.9 257.4 288 240 288C236.4 288 233.2 290.5 232.3 293.1C231.3 297.5 232.9 301.2 236.1 302.1L236.1 302.1L236.3 303.1L236.8 303.4L237.2 303.7C238 304.1 239.2 304.9 240.6 305.8C243.4 307.6 247.2 310.3 250.8 313.4C254.6 316.5 258 319.1 260.5 323.4C262.1 326.1 264 329.8 264 332C264 334.2 262.1 337 260.5 340.6C258 344 254.6 347.5 250.8 350.6C247.2 353.7 243.4 356.4 240.6 358.2C239.2 359.1 238 359.9 237.2 360.3L236.6 360.7L236.3 360.9L236.1 361L236.1 361C233.6 362.4 232 365.1 232 368C232 370.9 233.6 373.6 236.1 374.1L236.1 374.1L236.3 375.1C236.5 375.2 236.8 375.4 237.2 375.7C238 376.1 239.2 376.9 240.6 377.8C243.4 379.6 247.2 382.3 250.8 385.4C254.6 388.5 258 391.9 260.5 395.4C262.1 398.1 264 401.8 264 403.1C264 406.2 262.1 409 260.5 412.6C258 416 254.6 419.5 250.8 422.6C247.2 425.7 243.4 428.4 240.6 430.2C239.2 431.1 238 431.9 237.2 432.3C236.8 432.6 236.5 432.8 236.3 432.9L236.1 432.1L236.1 433C232.9 434.8 231.3 438.5 232.3 442C233.2 445.5 236.4 447.1 240 447.1C257.4 447.1 274.7 443.1 287.9 435.7C294.5 432 300.4 427.5 304.7 422.3C308.9 417.2 312 410.9 312 403.1C312 397.1 308.9 390.8 304.7 385.7C300.4 380.5 294.5 375.1 287.9 372.3C285.2 370.7 282.3 369.3 279.2 367.1C282.3 366.7 285.2 365.3 287.9 363.7C294.5 360 300.4 355.5 304.7 350.3C308.9 345.2 312 338.9 312 331.1C312 325.1 308.9 318.8 304.7 313.7C300.4 308.5 294.5 303.1 287.9 300.3L287.9 300.3zM176.4 176C158.7 176 144.4 190.3 144.4 208C144.4 225.7 158.7 240 176.4 240C194 240 208.4 225.7 208.4 208C208.4 190.3 194 176 176.4 176zM336.4 240C354 240 368.4 225.7 368.4 208C368.4 190.3 354 176 336.4 176C318.7 176 304.4 190.3 304.4 208C304.4 225.7 318.7 240 336.4 240z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M304.7 281.7C308.9 286.8 312 293.1 312 300C312 306.9 308.9 313.2 304.7 318.3C300.4 323.5 294.5 328 287.9 331.7C285.2 333.3 282.3 334.7 279.2 336C282.3 337.3 285.2 338.7 287.9 340.3C294.5 343.1 300.4 348.5 304.7 353.7C308.9 358.8 312 365.1 312 372C312 378.9 308.9 385.2 304.7 390.3C300.4 395.5 294.5 400 287.9 403.7C274.7 411.1 257.4 416 240 416C236.4 416 233.2 413.5 232.3 410C231.3 406.5 232.9 402.8 236.1 401L236.1 401L236.3 400.9C236.5 400.8 236.8 400.6 237.2 400.3C238 399.9 239.2 399.1 240.6 398.2C243.4 396.4 247.2 393.7 250.8 390.6C254.6 387.5 258 384 260.5 380.6C262.1 377 264 374.2 264 372C264 369.8 262.1 366.1 260.5 363.4C258 359.1 254.6 356.5 250.8 353.4C247.2 350.3 243.4 347.6 240.6 345.8C239.2 344.9 238 344.1 237.2 343.7L236.5 343.2L236.3 343.1L236.1 342.1L236.1 342.1C233.6 341.6 232 338.9 232 336C232 333.1 233.6 330.4 236.1 329L236.1 329L236.3 328.9C236.5 328.8 236.8 328.6 237.2 328.3C238 327.9 239.2 327.1 240.6 326.2C243.4 324.4 247.2 321.7 250.8 318.6C254.6 315.5 258 312.1 260.5 308.6C262.1 305 264 302.2 264 300C264 297.8 262.1 294.1 260.5 291.4C258 287.1 254.6 284.5 250.8 281.4C247.2 278.3 243.4 275.6 240.6 273.8C239.2 272.9 238 272.1 237.2 271.7C236.8 271.4 236.5 271.2 236.3 271.1L236.1 270.1L236.1 270.1C232.9 269.2 231.3 265.5 232.3 261.1C233.2 258.5 236.4 256 240 256C257.4 256 274.7 260.9 287.9 268.3C294.5 271.1 300.4 276.5 304.7 281.7V281.7zM208.4 208C208.4 225.7 194 240 176.4 240C158.7 240 144.4 225.7 144.4 208C144.4 190.3 158.7 176 176.4 176C194 176 208.4 190.3 208.4 208zM304.4 208C304.4 190.3 318.7 176 336.4 176C354 176 368.4 190.3 368.4 208C368.4 225.7 354 240 336.4 240C318.7 240 304.4 225.7 304.4 208zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Kiss', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-kiss-beam'                       => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM287.9 300.3C274.7 292.9 257.4 288 240 288C236.4 288 233.2 290.5 232.3 293.1C231.3 297.5 232.9 301.2 236.1 302.1L236.1 302.1L236.3 303.1L236.8 303.4L237.2 303.7C238 304.1 239.2 304.9 240.6 305.8C243.4 307.6 247.2 310.3 250.8 313.4C254.6 316.5 258 319.1 260.5 323.4C262.1 326.1 264 329.8 264 332C264 334.2 262.1 337 260.5 340.6C258 344 254.6 347.5 250.8 350.6C247.2 353.7 243.4 356.4 240.6 358.2C239.2 359.1 238 359.9 237.2 360.3L236.6 360.7L236.3 360.9L236.1 361L236.1 361C233.6 362.4 232 365.1 232 368C232 370.9 233.6 373.6 236.1 374.1L236.1 374.1L236.3 375.1C236.5 375.2 236.8 375.4 237.2 375.7C238 376.1 239.2 376.9 240.6 377.8C243.4 379.6 247.2 382.3 250.8 385.4C254.6 388.5 258 391.9 260.5 395.4C262.1 398.1 264 401.8 264 403.1C264 406.2 262.1 409 260.5 412.6C258 416 254.6 419.5 250.8 422.6C247.2 425.7 243.4 428.4 240.6 430.2C239.2 431.1 238 431.9 237.2 432.3C236.8 432.6 236.5 432.8 236.3 432.9L236.1 432.1L236.1 433C232.9 434.8 231.3 438.5 232.3 442C233.2 445.5 236.4 447.1 240 447.1C257.4 447.1 274.7 443.1 287.9 435.7C294.5 432 300.4 427.5 304.7 422.3C308.9 417.2 312 410.9 312 403.1C312 397.1 308.9 390.8 304.7 385.7C300.4 380.5 294.5 375.1 287.9 372.3C285.2 370.7 282.3 369.3 279.2 367.1C282.3 366.7 285.2 365.3 287.9 363.7C294.5 360 300.4 355.5 304.7 350.3C308.9 345.2 312 338.9 312 331.1C312 325.1 308.9 318.8 304.7 313.7C300.4 308.5 294.5 303.1 287.9 300.3L287.9 300.3zM226.5 231.6C229.8 230.5 232 227.4 232 224C232 206.1 225.3 188.4 215.4 175.2C205.6 162.2 191.5 152 176 152C160.5 152 146.4 162.2 136.6 175.2C126.7 188.4 120 206.1 120 224C120 227.4 122.2 230.5 125.5 231.6C128.7 232.7 132.3 231.6 134.4 228.8L134.4 228.8L134.6 228.5C134.8 228.3 134.1 228 135.3 227.6C135.1 226.8 136.9 225.7 138.1 224.3C140.6 221.4 144.1 217.7 148.3 213.1C157.1 206.2 167.2 200 176 200C184.8 200 194.9 206.2 203.7 213.1C207.9 217.7 211.4 221.4 213.9 224.3C215.1 225.7 216 226.8 216.7 227.6C217 228 217.2 228.3 217.4 228.5L217.6 228.8L217.6 228.8C219.7 231.6 223.3 232.7 226.5 231.6V231.6zM377.6 228.8C379.7 231.6 383.3 232.7 386.5 231.6C389.8 230.5 392 227.4 392 224C392 206.1 385.3 188.4 375.4 175.2C365.6 162.2 351.5 152 336 152C320.5 152 306.4 162.2 296.6 175.2C286.7 188.4 280 206.1 280 224C280 227.4 282.2 230.5 285.5 231.6C288.7 232.7 292.3 231.6 294.4 228.8L294.4 228.8L294.6 228.5C294.8 228.3 294.1 228 295.3 227.6C295.1 226.8 296.9 225.7 298.1 224.3C300.6 221.4 304.1 217.7 308.3 213.1C317.1 206.2 327.2 200 336 200C344.8 200 354.9 206.2 363.7 213.1C367.9 217.7 371.4 221.4 373.9 224.3C375.1 225.7 376 226.8 376.7 227.6C377 228 377.2 228.3 377.4 228.5L377.6 228.8L377.6 228.8z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M304.7 297.7C308.9 302.8 312 309.1 312 316C312 322.9 308.9 329.2 304.7 334.3C300.4 339.5 294.5 344 287.9 347.7C285.2 349.3 282.3 350.7 279.2 352C282.3 353.3 285.2 354.7 287.9 356.3C294.5 359.1 300.4 364.5 304.7 369.7C308.9 374.8 312 381.1 312 388C312 394.9 308.9 401.2 304.7 406.3C300.4 411.5 294.5 416 287.9 419.7C274.7 427.1 257.4 432 240 432C236.4 432 233.2 429.5 232.3 426C231.3 422.5 232.9 418.8 236.1 417L236.1 417L236.3 416.9C236.5 416.8 236.8 416.6 237.2 416.3C238 415.9 239.2 415.1 240.6 414.2C243.4 412.4 247.2 409.7 250.8 406.6C254.6 403.5 258 400 260.5 396.6C262.1 393 264 390.2 264 388C264 385.8 262.1 382.1 260.5 379.4C258 375.1 254.6 372.5 250.8 369.4C247.2 366.3 243.4 363.6 240.6 361.8C239.2 360.9 238 360.1 237.2 359.7C236.8 359.4 236.5 359.2 236.3 359.1L236.1 358.1L236.1 358.1C233.6 357.6 232 354.9 232 352C232 349.1 233.6 346.4 236.1 345L236.1 345L236.3 344.9C236.5 344.8 236.8 344.6 237.2 344.3C238 343.9 239.2 343.1 240.6 342.2C243.4 340.4 247.2 337.7 250.8 334.6C254.6 331.5 258 328.1 260.5 324.6C262.1 321 264 318.2 264 316C264 313.8 262.1 310.1 260.5 307.4C258 303.1 254.6 300.5 250.8 297.4C247.2 294.3 243.4 291.6 240.6 289.8C239.2 288.9 238 288.1 237.2 287.7C236.8 287.4 236.5 287.2 236.3 287.1L236.1 286.1L236.1 286.1C232.9 285.2 231.3 281.5 232.3 277.1C233.2 274.5 236.4 272 240 272C257.4 272 274.7 276.9 287.9 284.3C294.5 287.1 300.4 292.5 304.7 297.7L304.7 297.7zM217.6 228.8L217.6 228.8L217.4 228.5C217.2 228.3 217 228 216.7 227.6C216 226.8 215.1 225.7 213.9 224.3C211.4 221.4 207.9 217.7 203.7 213.1C194.9 206.2 184.8 200 176 200C167.2 200 157.1 206.2 148.3 213.1C144.1 217.7 140.6 221.4 138.1 224.3C136.9 225.7 135.1 226.8 135.3 227.6C134.1 228 134.8 228.3 134.6 228.5L134.4 228.8L134.4 228.8C132.3 231.6 128.7 232.7 125.5 231.6C122.2 230.5 120 227.4 120 224C120 206.1 126.7 188.4 136.6 175.2C146.4 162.2 160.5 152 176 152C191.5 152 205.6 162.2 215.4 175.2C225.3 188.4 232 206.1 232 224C232 227.4 229.8 230.5 226.5 231.6C223.3 232.7 219.7 231.6 217.6 228.8V228.8zM377.6 228.8L377.4 228.5C377.2 228.3 377 228 376.7 227.6C376 226.8 375.1 225.7 373.9 224.3C371.4 221.4 367.9 217.7 363.7 213.1C354.9 206.2 344.8 200 336 200C327.2 200 317.1 206.2 308.3 213.1C304.1 217.7 300.6 221.4 298.1 224.3C296.9 225.7 295.1 226.8 295.3 227.6C294.1 228 294.8 228.3 294.6 228.5L294.4 228.8L294.4 228.8C292.3 231.6 288.7 232.7 285.5 231.6C282.2 230.5 280 227.4 280 224C280 206.1 286.7 188.4 296.6 175.2C306.4 162.2 320.5 152 336 152C351.5 152 365.6 162.2 375.4 175.2C385.3 188.4 392 206.1 392 224C392 227.4 389.8 230.5 386.5 231.6C383.3 232.7 379.7 231.6 377.6 228.8L377.6 228.8zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Kiss Beam', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-kiss-wink-heart'                 => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M461.8 334.6C448.1 300.8 411.5 280.3 374.3 290.7C334.2 301.9 312.4 343.8 322.4 382.8L345.3 472.1C347.3 479.7 350.9 486.4 355.7 491.8C325.1 504.8 291.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 285.3 507.1 313.4 498 339.7C486.9 334.1 474.5 333.1 461.8 334.6L461.8 334.6zM296 332C296 325.1 292.9 318.8 288.7 313.7C284.4 308.5 278.5 303.1 271.9 300.3C258.7 292.9 241.4 288 224 288C220.4 288 217.2 290.5 216.3 293.1C215.3 297.5 216.9 301.2 220.1 302.1L220.1 302.1L220.3 303.1C220.5 303.2 220.8 303.4 221.2 303.7C222 304.1 223.2 304.9 224.6 305.8C227.4 307.6 231.2 310.3 234.8 313.4C238.6 316.5 242 319.1 244.5 323.4C246.1 326.1 248 329.8 248 332C248 334.2 246.1 337 244.5 340.6C242 344 238.6 347.5 234.8 350.6C231.2 353.7 227.4 356.4 224.6 358.2C223.2 359.1 222 359.9 221.2 360.3C220.8 360.6 220.5 360.8 220.3 360.9L220.1 361L220.1 361C217.6 362.4 216 365.1 216 368C216 370.9 217.6 373.6 220.1 374.1L220.1 374.1L220.3 375.1L220.6 375.3L221.2 375.7C222 376.1 223.2 376.9 224.6 377.8C227.4 379.6 231.2 382.3 234.8 385.4C238.6 388.5 242 391.9 244.5 395.4C246.1 398.1 248 401.8 248 404C248 406.2 246.1 409 244.5 412.6C242 416 238.6 419.5 234.8 422.6C231.2 425.7 227.4 428.4 224.6 430.2C223.2 431.1 222 431.9 221.2 432.3C220.8 432.6 220.5 432.8 220.3 432.9L220.1 433L220.1 433C216.9 434.8 215.3 438.5 216.3 442C217.2 445.5 220.4 447.1 224 447.1C241.4 447.1 258.7 443.1 271.9 435.7C278.5 432 284.4 427.5 288.7 422.3C292.9 417.2 296 410.9 296 403.1C296 397.1 292.9 390.8 288.7 385.7C284.4 380.5 278.5 375.1 271.9 372.3C269.2 370.7 266.3 369.3 263.2 367.1C266.3 366.7 269.2 365.3 271.9 363.7C278.5 360 284.4 355.5 288.7 350.3C292.9 345.2 296 338.9 296 331.1V332zM176.4 240C194 240 208.4 225.7 208.4 208C208.4 190.3 194 176 176.4 176C158.7 176 144.4 190.3 144.4 208C144.4 225.7 158.7 240 176.4 240zM393.6 236.8C400.7 231.5 402.1 221.5 396.8 214.4C366.4 173.9 305.6 173.9 275.2 214.4C269.9 221.5 271.3 231.5 278.4 236.8C285.5 242.1 295.5 240.7 300.8 233.6C318.4 210.1 353.6 210.1 371.2 233.6C376.5 240.7 386.5 242.1 393.6 236.8zM439.4 373.3L459.5 367.6C481.7 361.4 504.6 375.2 510.6 398.4C516.5 421.7 503.3 445.6 481.1 451.8L396.1 475.6C387.5 478 378.6 472.9 376.3 464.2L353.4 374.9C347.5 351.6 360.7 327.7 382.9 321.5C405.2 315.3 428 329.1 433.1 352.3L439.4 373.3z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M345.3 472.1C347.3 479.7 350.9 486.4 355.7 491.8C325.1 504.8 291.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 285.3 507.1 313.4 498 339.7C486.9 334.1 474.5 333.1 461.8 334.6C459.7 329.4 457 324.6 453.9 320.1C460.5 299.9 464 278.4 464 256C464 141.1 370.9 48 256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C285.4 464 313.5 457.9 338.9 446.8L345.3 472.1zM288.7 334.3C284.4 339.5 278.5 344 271.9 347.7C269.2 349.3 266.3 350.7 263.2 352C266.3 353.3 269.2 354.7 271.9 356.3C278.5 359.1 284.4 364.5 288.7 369.7C292.9 374.8 296 381.1 296 388C296 394.9 292.9 401.2 288.7 406.3C284.4 411.5 278.5 416 271.9 419.7C258.7 427.1 241.4 432 224 432C220.4 432 217.2 429.5 216.3 426C215.3 422.5 216.9 418.8 220.1 417L220.1 417L220.3 416.9C220.5 416.8 220.8 416.6 221.2 416.3C222 415.9 223.2 415.1 224.6 414.2C227.4 412.4 231.2 409.7 234.8 406.6C238.6 403.5 242 400 244.5 396.6C246.1 393 248 390.2 248 388C248 385.8 246.1 382.1 244.5 379.4C242 375.1 238.6 372.5 234.8 369.4C231.2 366.3 227.4 363.6 224.6 361.8C223.2 360.9 222 360.1 221.2 359.7C220.8 359.4 220.5 359.2 220.3 359.1L220.1 358.1L220.1 358.1C217.6 357.6 216 354.9 216 352C216 349.1 217.6 346.4 220.1 345L220.1 345L220.3 344.9C220.5 344.8 220.8 344.6 221.2 344.3C222 343.9 223.2 343.1 224.6 342.2C227.4 340.4 231.2 337.7 234.8 334.6C238.6 331.5 242 328.1 244.5 324.6C246.1 321 248 318.2 248 316C248 313.8 246.1 310.1 244.5 307.4C242 303.1 238.6 300.5 234.8 297.4C231.2 294.3 227.4 291.6 224.6 289.8C223.2 288.9 222 288.1 221.2 287.7C220.8 287.4 220.5 287.2 220.3 287.1L220.1 286.1L220.1 286.1C216.9 285.2 215.3 281.5 216.3 277.1C217.2 274.5 220.4 272 224 272C241.4 272 258.7 276.9 271.9 284.3C278.5 287.1 284.4 292.5 288.7 297.7C292.9 302.8 296 309.1 296 316C296 322.9 292.9 329.2 288.7 334.3V334.3zM144.4 208C144.4 190.3 158.7 176 176.4 176C194 176 208.4 190.3 208.4 208C208.4 225.7 194 240 176.4 240C158.7 240 144.4 225.7 144.4 208zM335.6 220C324.1 220 315.7 223.8 310.2 229.7C302.7 237.7 290 238.1 281.9 230.6C273.9 223 273.5 210.4 281 202.3C295.6 186.8 316.3 180 335.6 180C354.1 180 375.7 186.8 390.2 202.3C397.8 210.4 397.4 223 389.3 230.6C381.2 238.1 368.6 237.7 361 229.7C355.6 223.8 346.3 220 335.6 220zM439.4 373.3L459.5 367.6C481.7 361.4 504.6 375.2 510.6 398.4C516.5 421.7 503.3 445.6 481.1 451.8L396.1 475.6C387.5 478 378.6 472.9 376.3 464.2L353.4 374.9C347.5 351.6 360.7 327.7 382.9 321.5C405.2 315.3 428 329.1 433.1 352.3L439.4 373.3z',
			),
		),
		'label'             => __( 'Face Kiss Wink Heart', 'astra' ),
		'custom_categories' => array(
			'design',
			'lifestyle-and-hobbies',
		),
	),
	'face-laugh'                           => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 432C332.1 432 396.2 382 415.2 314.1C419.1 300.4 407.8 288 393.6 288H118.4C104.2 288 92.92 300.4 96.76 314.1C115.8 382 179.9 432 256 432V432zM176.4 160C158.7 160 144.4 174.3 144.4 192C144.4 209.7 158.7 224 176.4 224C194 224 208.4 209.7 208.4 192C208.4 174.3 194 160 176.4 160zM336.4 224C354 224 368.4 209.7 368.4 192C368.4 174.3 354 160 336.4 160C318.7 160 304.4 174.3 304.4 192C304.4 209.7 318.7 224 336.4 224z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M130.7 313.9C126.5 300.4 137.8 288 151.1 288H364.5C378.7 288 389.9 300.4 385.8 313.9C368.1 368.4 318.2 408 258.2 408C198.2 408 147.5 368.4 130.7 313.9V313.9zM208.4 192C208.4 209.7 194 224 176.4 224C158.7 224 144.4 209.7 144.4 192C144.4 174.3 158.7 160 176.4 160C194 160 208.4 174.3 208.4 192zM304.4 192C304.4 174.3 318.7 160 336.4 160C354 160 368.4 174.3 368.4 192C368.4 209.7 354 224 336.4 224C318.7 224 304.4 209.7 304.4 192zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Laugh', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-laugh-beam'                      => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 432C332.1 432 396.2 382 415.2 314.1C419.1 300.4 407.8 288 393.6 288H118.4C104.2 288 92.92 300.4 96.76 314.1C115.8 382 179.9 432 256 432V432zM226.5 215.6C229.8 214.5 232 211.4 232 208C232 190.1 225.3 172.4 215.4 159.2C205.6 146.2 191.5 136 176 136C160.5 136 146.4 146.2 136.6 159.2C126.7 172.4 120 190.1 120 208C120 211.4 122.2 214.5 125.5 215.6C128.7 216.7 132.3 215.6 134.4 212.8L134.4 212.8L134.6 212.5C134.8 212.3 134.1 212 135.3 211.6C135.1 210.8 136.9 209.7 138.1 208.3C140.6 205.4 144.1 201.7 148.3 197.1C157.1 190.2 167.2 184 176 184C184.8 184 194.9 190.2 203.7 197.1C207.9 201.7 211.4 205.4 213.9 208.3C215.1 209.7 216 210.8 216.7 211.6C217 212 217.2 212.3 217.4 212.5L217.6 212.8L217.6 212.8C219.7 215.6 223.3 216.7 226.5 215.6V215.6zM377.6 212.8C379.7 215.6 383.3 216.7 386.5 215.6C389.8 214.5 392 211.4 392 208C392 190.1 385.3 172.4 375.4 159.2C365.6 146.2 351.5 136 336 136C320.5 136 306.4 146.2 296.6 159.2C286.7 172.4 280 190.1 280 208C280 211.4 282.2 214.5 285.5 215.6C288.7 216.7 292.3 215.6 294.4 212.8L294.4 212.8L294.6 212.5C294.8 212.3 294.1 212 295.3 211.6C295.1 210.8 296.9 209.7 298.1 208.3C300.6 205.4 304.1 201.7 308.3 197.1C317.1 190.2 327.2 184 336 184C344.8 184 354.9 190.2 363.7 197.1C367.9 201.7 371.4 205.4 373.9 208.3C375.1 209.7 376 210.8 376.7 211.6C377 212 377.2 212.3 377.4 212.5L377.6 212.8L377.6 212.8z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M130.7 313.9C126.5 300.4 137.8 288 151.1 288H364.5C378.7 288 389.9 300.4 385.8 313.9C368.1 368.4 318.2 408 258.2 408C198.2 408 147.5 368.4 130.7 313.9V313.9zM217.6 228.8L217.6 228.8L217.4 228.5C217.2 228.3 217 228 216.7 227.6C216 226.8 215.1 225.7 213.9 224.3C211.4 221.4 207.9 217.7 203.7 213.1C194.9 206.2 184.8 200 176 200C167.2 200 157.1 206.2 148.3 213.1C144.1 217.7 140.6 221.4 138.1 224.3C136.9 225.7 135.1 226.8 135.3 227.6C134.1 228 134.8 228.3 134.6 228.5L134.4 228.8L134.4 228.8C132.3 231.6 128.7 232.7 125.5 231.6C122.2 230.5 120 227.4 120 224C120 206.1 126.7 188.4 136.6 175.2C146.4 162.2 160.5 152 176 152C191.5 152 205.6 162.2 215.4 175.2C225.3 188.4 232 206.1 232 224C232 227.4 229.8 230.5 226.5 231.6C223.3 232.7 219.7 231.6 217.6 228.8V228.8zM377.6 228.8L377.4 228.5C377.2 228.3 377 228 376.7 227.6C376 226.8 375.1 225.7 373.9 224.3C371.4 221.4 367.9 217.7 363.7 213.1C354.9 206.2 344.8 200 336 200C327.2 200 317.1 206.2 308.3 213.1C304.1 217.7 300.6 221.4 298.1 224.3C296.9 225.7 295.1 226.8 295.3 227.6C294.1 228 294.8 228.3 294.6 228.5L294.4 228.8L294.4 228.8C292.3 231.6 288.7 232.7 285.5 231.6C282.2 230.5 280 227.4 280 224C280 206.1 286.7 188.4 296.6 175.2C306.4 162.2 320.5 152 336 152C351.5 152 365.6 162.2 375.4 175.2C385.3 188.4 392 206.1 392 224C392 227.4 389.8 230.5 386.5 231.6C383.3 232.7 379.7 231.6 377.6 228.8L377.6 228.8zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Laugh Beam', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-laugh-squint'                    => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 432C332.1 432 396.2 382 415.2 314.1C419.1 300.4 407.8 288 393.6 288H118.4C104.2 288 92.92 300.4 96.76 314.1C115.8 382 179.9 432 256 432V432zM133.5 114.7C125.6 110.4 116 116.2 116 125.1C116 127.9 116.1 130.6 118.8 132.8L154.8 176L118.8 219.2C116.1 221.4 116 224.1 116 226.9C116 235.8 125.6 241.6 133.5 237.3L223.4 189.4C234.1 183.7 234.1 168.3 223.4 162.6L133.5 114.7zM396 125.1C396 116.2 386.4 110.4 378.5 114.7L288.6 162.6C277.9 168.3 277.9 183.7 288.6 189.4L378.5 237.3C386.4 241.6 396 235.8 396 226.9C396 224.1 395 221.4 393.2 219.2L357.2 176L393.2 132.8C395 130.6 396 127.9 396 125.1V125.1z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M130.7 313.9C126.5 300.4 137.8 288 151.1 288H364.5C378.7 288 389.9 300.4 385.8 313.9C368.1 368.4 318.2 408 258.2 408C198.2 408 147.5 368.4 130.7 313.9V313.9zM223.4 178.6C234.1 184.3 234.1 199.7 223.4 205.4L133.5 253.3C125.6 257.6 116 251.8 116 242.9C116 240.1 116.1 237.4 118.8 235.2L154.8 192L118.8 148.8C116.1 146.6 116 143.9 116 141.1C116 132.2 125.6 126.4 133.5 130.7L223.4 178.6zM393.2 148.8L357.2 192L393.2 235.2C395 237.4 396 240.1 396 242.9C396 251.8 386.4 257.6 378.5 253.3L288.6 205.4C277.9 199.7 277.9 184.3 288.6 178.6L378.5 130.7C386.4 126.4 396 132.2 396 141.1C396 143.9 395 146.6 393.2 148.8V148.8zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Laugh Squint', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-laugh-wink'                      => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 432C332.1 432 396.2 382 415.2 314.1C419.1 300.4 407.8 288 393.6 288H118.4C104.2 288 92.92 300.4 96.76 314.1C115.8 382 179.9 432 256 432V432zM176.4 160C158.7 160 144.4 174.3 144.4 192C144.4 209.7 158.7 224 176.4 224C194 224 208.4 209.7 208.4 192C208.4 174.3 194 160 176.4 160zM300.8 217.6C318.4 194.1 353.6 194.1 371.2 217.6C376.5 224.7 386.5 226.1 393.6 220.8C400.7 215.5 402.1 205.5 396.8 198.4C366.4 157.9 305.6 157.9 275.2 198.4C269.9 205.5 271.3 215.5 278.4 220.8C285.5 226.1 295.5 224.7 300.8 217.6z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M130.7 313.9C126.5 300.4 137.8 288 151.1 288H364.5C378.7 288 389.9 300.4 385.8 313.9C368.1 368.4 318.2 408 258.2 408C198.2 408 147.5 368.4 130.7 313.9V313.9zM208.4 192C208.4 209.7 194 224 176.4 224C158.7 224 144.4 209.7 144.4 192C144.4 174.3 158.7 160 176.4 160C194 160 208.4 174.3 208.4 192zM281.9 214.6C273.9 207 273.5 194.4 281 186.3C295.6 170.8 316.3 164 335.6 164C354.1 164 375.7 170.8 390.2 186.3C397.8 194.4 397.4 207 389.3 214.6C381.2 222.1 368.6 221.7 361 213.7C355.6 207.8 346.3 204 335.6 204C324.1 204 315.7 207.8 310.2 213.7C302.7 221.7 290 222.1 281.9 214.6zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Laugh Wink', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-meh'                             => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM176.4 240C194 240 208.4 225.7 208.4 208C208.4 190.3 194 176 176.4 176C158.7 176 144.4 190.3 144.4 208C144.4 225.7 158.7 240 176.4 240zM336.4 176C318.7 176 304.4 190.3 304.4 208C304.4 225.7 318.7 240 336.4 240C354 240 368.4 225.7 368.4 208C368.4 190.3 354 176 336.4 176zM160 336C151.2 336 144 343.2 144 352C144 360.8 151.2 368 160 368H352C360.8 368 368 360.8 368 352C368 343.2 360.8 336 352 336H160z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M144.4 208C144.4 190.3 158.7 176 176.4 176C194 176 208.4 190.3 208.4 208C208.4 225.7 194 240 176.4 240C158.7 240 144.4 225.7 144.4 208zM368.4 208C368.4 225.7 354 240 336.4 240C318.7 240 304.4 225.7 304.4 208C304.4 190.3 318.7 176 336.4 176C354 176 368.4 190.3 368.4 208zM328 328C341.3 328 352 338.7 352 352C352 365.3 341.3 376 328 376H184C170.7 376 160 365.3 160 352C160 338.7 170.7 328 184 328H328zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464z',
			),
		),
		'label'             => __( 'Face Meh', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
		),
	),
	'face-meh-blank'                       => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM176.4 176C158.7 176 144.4 190.3 144.4 208C144.4 225.7 158.7 240 176.4 240C194 240 208.4 225.7 208.4 208C208.4 190.3 194 176 176.4 176zM336.4 240C354 240 368.4 225.7 368.4 208C368.4 190.3 354 176 336.4 176C318.7 176 304.4 190.3 304.4 208C304.4 225.7 318.7 240 336.4 240z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M208.4 208C208.4 225.7 194 240 176.4 240C158.7 240 144.4 225.7 144.4 208C144.4 190.3 158.7 176 176.4 176C194 176 208.4 190.3 208.4 208zM304.4 208C304.4 190.3 318.7 176 336.4 176C354 176 368.4 190.3 368.4 208C368.4 225.7 354 240 336.4 240C318.7 240 304.4 225.7 304.4 208zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Meh Blank', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-rolling-eyes'                    => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM192 368C183.2 368 176 375.2 176 384C176 392.8 183.2 400 192 400H320C328.8 400 336 392.8 336 384C336 375.2 328.8 368 320 368H192zM186.2 165.6C189.8 170.8 192 177.1 192 184C192 201.7 177.7 216 160 216C142.3 216 128 201.7 128 184C128 177.1 130.2 170.8 133.8 165.6C111.5 175.6 96 197.1 96 224C96 259.3 124.7 288 160 288C195.3 288 224 259.3 224 224C224 197.1 208.5 175.6 186.2 165.6zM352 288C387.3 288 416 259.3 416 224C416 197.1 400.5 175.6 378.2 165.6C381.8 170.8 384 177.1 384 184C384 201.7 369.7 216 352 216C334.3 216 320 201.7 320 184C320 177.1 322.2 170.8 325.8 165.6C303.5 175.6 288 197.1 288 224C288 259.3 316.7 288 352 288z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M168 376C168 362.7 178.7 352 192 352H320C333.3 352 344 362.7 344 376C344 389.3 333.3 400 320 400H192C178.7 400 168 389.3 168 376zM80 224C80 179.8 115.8 144 160 144C204.2 144 240 179.8 240 224C240 268.2 204.2 304 160 304C115.8 304 80 268.2 80 224zM160 272C186.5 272 208 250.5 208 224C208 209.7 201.7 196.8 191.8 188C191.9 189.3 192 190.6 192 192C192 209.7 177.7 224 160 224C142.3 224 128 209.7 128 192C128 190.6 128.1 189.3 128.2 188C118.3 196.8 112 209.7 112 224C112 250.5 133.5 272 160 272V272zM272 224C272 179.8 307.8 144 352 144C396.2 144 432 179.8 432 224C432 268.2 396.2 304 352 304C307.8 304 272 268.2 272 224zM352 272C378.5 272 400 250.5 400 224C400 209.7 393.7 196.8 383.8 188C383.9 189.3 384 190.6 384 192C384 209.7 369.7 224 352 224C334.3 224 320 209.7 320 192C320 190.6 320.1 189.3 320.2 188C310.3 196.8 304 209.7 304 224C304 250.5 325.5 272 352 272zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464z',
			),
		),
		'label'             => __( 'Face Rolling Eyes', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-sad-cry'                         => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M352 493.4C322.4 505.4 289.9 512 256 512C222.1 512 189.6 505.4 160 493.4V288C160 279.2 152.8 272 144 272C135.2 272 128 279.2 128 288V477.8C51.48 433.5 0 350.8 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 350.8 460.5 433.5 384 477.8V288C384 279.2 376.8 272 368 272C359.2 272 352 279.2 352 288V493.4zM217.6 236.8C224.7 231.5 226.1 221.5 220.8 214.4C190.4 173.9 129.6 173.9 99.2 214.4C93.9 221.5 95.33 231.5 102.4 236.8C109.5 242.1 119.5 240.7 124.8 233.6C142.4 210.1 177.6 210.1 195.2 233.6C200.5 240.7 210.5 242.1 217.6 236.8zM316.8 233.6C334.4 210.1 369.6 210.1 387.2 233.6C392.5 240.7 402.5 242.1 409.6 236.8C416.7 231.5 418.1 221.5 412.8 214.4C382.4 173.9 321.6 173.9 291.2 214.4C285.9 221.5 287.3 231.5 294.4 236.8C301.5 242.1 311.5 240.7 316.8 233.6zM208 368C208 394.5 229.5 416 256 416C282.5 416 304 394.5 304 368V336C304 309.5 282.5 288 256 288C229.5 288 208 309.5 208 336V368z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M159.6 220C148.1 220 139.7 223.8 134.2 229.7C126.7 237.7 114 238.1 105.1 230.6C97.89 223 97.48 210.4 105 202.3C119.6 186.8 140.3 180 159.6 180C178.1 180 199.7 186.8 214.2 202.3C221.8 210.4 221.4 223 213.3 230.6C205.2 238.1 192.6 237.7 185 229.7C179.6 223.8 170.3 220 159.6 220zM297.9 230.6C289.9 223 289.5 210.4 297 202.3C311.6 186.8 332.3 180 351.6 180C370.1 180 391.7 186.8 406.2 202.3C413.8 210.4 413.4 223 405.3 230.6C397.2 238.1 384.6 237.7 377 229.7C371.6 223.8 362.3 220 351.6 220C340.1 220 331.7 223.8 326.2 229.7C318.7 237.7 306 238.1 297.9 230.6zM208 320C208 293.5 229.5 272 256 272C282.5 272 304 293.5 304 320V352C304 378.5 282.5 400 256 400C229.5 400 208 378.5 208 352V320zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM400 406.1C439.4 368.2 464 314.1 464 256C464 141.1 370.9 48 256 48C141.1 48 48 141.1 48 256C48 314.1 72.55 368.2 112 406.1V288C112 274.7 122.7 264 136 264C149.3 264 160 274.7 160 288V440.6C188.7 455.5 221.4 464 256 464C290.6 464 323.3 455.5 352 440.6V288C352 274.7 362.7 264 376 264C389.3 264 400 274.7 400 288V406.1z',
			),
		),
		'label'             => __( 'Face Sad Cry', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-sad-tear'                        => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0zM256 352C290.9 352 323.2 367.8 348.3 394.9C354.3 401.4 364.4 401.7 370.9 395.7C377.4 389.7 377.7 379.6 371.7 373.1C341.6 340.5 301 320 256 320C247.2 320 240 327.2 240 336C240 344.8 247.2 352 256 352H256zM208 369C208 349 179.6 308.6 166.4 291.3C163.2 286.9 156.8 286.9 153.6 291.3C140.6 308.6 112 349 112 369C112 395 133.5 416 160 416C186.5 416 208 395 208 369H208zM303.6 208C303.6 225.7 317.1 240 335.6 240C353.3 240 367.6 225.7 367.6 208C367.6 190.3 353.3 176 335.6 176C317.1 176 303.6 190.3 303.6 208zM207.6 208C207.6 190.3 193.3 176 175.6 176C157.1 176 143.6 190.3 143.6 208C143.6 225.7 157.1 240 175.6 240C193.3 240 207.6 225.7 207.6 208z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M169.6 291.3C172.8 286.9 179.2 286.9 182.4 291.3C195.6 308.6 223.1 349 223.1 369C223.1 395 202.5 416 175.1 416C149.5 416 127.1 395 127.1 369C127.1 349 156.6 308.6 169.6 291.3H169.6zM368 346.8C377.9 355.6 378.7 370.8 369.9 380.7C361 390.6 345.9 391.4 335.1 382.6C314.7 363.5 286.7 352 256 352C242.7 352 232 341.3 232 328C232 314.7 242.7 304 256 304C299 304 338.3 320.2 368 346.8L368 346.8zM335.6 176C353.3 176 367.6 190.3 367.6 208C367.6 225.7 353.3 240 335.6 240C317.1 240 303.6 225.7 303.6 208C303.6 190.3 317.1 176 335.6 176zM175.6 240C157.1 240 143.6 225.7 143.6 208C143.6 190.3 157.1 176 175.6 176C193.3 176 207.6 190.3 207.6 208C207.6 225.7 193.3 240 175.6 240zM256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0zM175.9 448C200.5 458.3 227.6 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48C141.1 48 48 141.1 48 256C48 308.7 67.59 356.8 99.88 393.4C110.4 425.4 140.9 447.9 175.9 448V448z',
			),
		),
		'label'             => __( 'Face Sad Tear', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-smile'                           => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM164.1 325.5C158.3 318.8 148.2 318.1 141.5 323.9C134.8 329.7 134.1 339.8 139.9 346.5C162.1 372.1 200.9 400 255.1 400C311.1 400 349.8 372.1 372.1 346.5C377.9 339.8 377.2 329.7 370.5 323.9C363.8 318.1 353.7 318.8 347.9 325.5C329.9 346.2 299.4 368 255.1 368C212.6 368 182 346.2 164.1 325.5H164.1zM176.4 176C158.7 176 144.4 190.3 144.4 208C144.4 225.7 158.7 240 176.4 240C194 240 208.4 225.7 208.4 208C208.4 190.3 194 176 176.4 176zM336.4 240C354 240 368.4 225.7 368.4 208C368.4 190.3 354 176 336.4 176C318.7 176 304.4 190.3 304.4 208C304.4 225.7 318.7 240 336.4 240z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 352C293.2 352 319.2 334.5 334.4 318.1C343.3 308.4 358.5 307.7 368.3 316.7C378 325.7 378.6 340.9 369.6 350.6C347.7 374.5 309.7 400 256 400C202.3 400 164.3 374.5 142.4 350.6C133.4 340.9 133.1 325.7 143.7 316.7C153.5 307.7 168.7 308.4 177.6 318.1C192.8 334.5 218.8 352 256 352zM208.4 208C208.4 225.7 194 240 176.4 240C158.7 240 144.4 225.7 144.4 208C144.4 190.3 158.7 176 176.4 176C194 176 208.4 190.3 208.4 208zM304.4 208C304.4 190.3 318.7 176 336.4 176C354 176 368.4 190.3 368.4 208C368.4 225.7 354 240 336.4 240C318.7 240 304.4 225.7 304.4 208zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Smile', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
		),
	),
	'face-smile-beam'                      => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM164.1 325.5C158.3 318.8 148.2 318.1 141.5 323.9C134.8 329.7 134.1 339.8 139.9 346.5C162.1 372.1 200.9 400 255.1 400C311.1 400 349.8 372.1 372.1 346.5C377.9 339.8 377.2 329.7 370.5 323.9C363.8 318.1 353.7 318.8 347.9 325.5C329.9 346.2 299.4 368 255.1 368C212.6 368 182 346.2 164.1 325.5H164.1zM226.5 231.6C229.8 230.5 232 227.4 232 224C232 206.1 225.3 188.4 215.4 175.2C205.6 162.2 191.5 152 176 152C160.5 152 146.4 162.2 136.6 175.2C126.7 188.4 120 206.1 120 224C120 227.4 122.2 230.5 125.5 231.6C128.7 232.7 132.3 231.6 134.4 228.8L134.4 228.8L134.6 228.5C134.8 228.3 134.1 228 135.3 227.6C135.1 226.8 136.9 225.7 138.1 224.3C140.6 221.4 144.1 217.7 148.3 213.1C157.1 206.2 167.2 200 176 200C184.8 200 194.9 206.2 203.7 213.1C207.9 217.7 211.4 221.4 213.9 224.3C215.1 225.7 216 226.8 216.7 227.6C217 228 217.2 228.3 217.4 228.5L217.6 228.8L217.6 228.8C219.7 231.6 223.3 232.7 226.5 231.6V231.6zM377.6 228.8C379.7 231.6 383.3 232.7 386.5 231.6C389.8 230.5 392 227.4 392 224C392 206.1 385.3 188.4 375.4 175.2C365.6 162.2 351.5 152 336 152C320.5 152 306.4 162.2 296.6 175.2C286.7 188.4 280 206.1 280 224C280 227.4 282.2 230.5 285.5 231.6C288.7 232.7 292.3 231.6 294.4 228.8L294.4 228.8L294.6 228.5C294.8 228.3 294.1 228 295.3 227.6C295.1 226.8 296.9 225.7 298.1 224.3C300.6 221.4 304.1 217.7 308.3 213.1C317.1 206.2 327.2 200 336 200C344.8 200 354.9 206.2 363.7 213.1C367.9 217.7 371.4 221.4 373.9 224.3C375.1 225.7 376 226.8 376.7 227.6C377 228 377.2 228.3 377.4 228.5L377.6 228.8L377.6 228.8z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 352C293.2 352 319.2 334.5 334.4 318.1C343.3 308.4 358.5 307.7 368.3 316.7C378 325.7 378.6 340.9 369.6 350.6C347.7 374.5 309.7 400 256 400C202.3 400 164.3 374.5 142.4 350.6C133.4 340.9 133.1 325.7 143.7 316.7C153.5 307.7 168.7 308.4 177.6 318.1C192.8 334.5 218.8 352 256 352zM217.6 228.8L217.6 228.8L217.4 228.5C217.2 228.3 217 228 216.7 227.6C216 226.8 215.1 225.7 213.9 224.3C211.4 221.4 207.9 217.7 203.7 213.1C194.9 206.2 184.8 200 176 200C167.2 200 157.1 206.2 148.3 213.1C144.1 217.7 140.6 221.4 138.1 224.3C136.9 225.7 135.1 226.8 135.3 227.6C134.1 228 134.8 228.3 134.6 228.5L134.4 228.8L134.4 228.8C132.3 231.6 128.7 232.7 125.5 231.6C122.2 230.5 120 227.4 120 224C120 206.1 126.7 188.4 136.6 175.2C146.4 162.2 160.5 152 176 152C191.5 152 205.6 162.2 215.4 175.2C225.3 188.4 232 206.1 232 224C232 227.4 229.8 230.5 226.5 231.6C223.3 232.7 219.7 231.6 217.6 228.8V228.8zM377.6 228.8L377.4 228.5C377.2 228.3 377 228 376.7 227.6C376 226.8 375.1 225.7 373.9 224.3C371.4 221.4 367.9 217.7 363.7 213.1C354.9 206.2 344.8 200 336 200C327.2 200 317.1 206.2 308.3 213.1C304.1 217.7 300.6 221.4 298.1 224.3C296.9 225.7 295.1 226.8 295.3 227.6C294.1 228 294.8 228.3 294.6 228.5L294.4 228.8L294.4 228.8C292.3 231.6 288.7 232.7 285.5 231.6C282.2 230.5 280 227.4 280 224C280 206.1 286.7 188.4 296.6 175.2C306.4 162.2 320.5 152 336 152C351.5 152 365.6 162.2 375.4 175.2C385.3 188.4 392 206.1 392 224C392 227.4 389.8 230.5 386.5 231.6C383.3 232.7 379.7 231.6 377.6 228.8L377.6 228.8zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Smile Beam', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-smile-wink'                      => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM164.1 325.5C158.3 318.8 148.2 318.1 141.5 323.9C134.8 329.7 134.1 339.8 139.9 346.5C162.1 372.1 200.9 400 255.1 400C311.1 400 349.8 372.1 372.1 346.5C377.9 339.8 377.2 329.7 370.5 323.9C363.8 318.1 353.7 318.8 347.9 325.5C329.9 346.2 299.4 368 255.1 368C212.6 368 182 346.2 164.1 325.5H164.1zM176.4 176C158.7 176 144.4 190.3 144.4 208C144.4 225.7 158.7 240 176.4 240C194 240 208.4 225.7 208.4 208C208.4 190.3 194 176 176.4 176zM300.8 233.6C318.4 210.1 353.6 210.1 371.2 233.6C376.5 240.7 386.5 242.1 393.6 236.8C400.7 231.5 402.1 221.5 396.8 214.4C366.4 173.9 305.6 173.9 275.2 214.4C269.9 221.5 271.3 231.5 278.4 236.8C285.5 242.1 295.5 240.7 300.8 233.6z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 352C293.2 352 319.2 334.5 334.4 318.1C343.3 308.4 358.5 307.7 368.3 316.7C378 325.7 378.6 340.9 369.6 350.6C347.7 374.5 309.7 400 256 400C202.3 400 164.3 374.5 142.4 350.6C133.4 340.9 133.1 325.7 143.7 316.7C153.5 307.7 168.7 308.4 177.6 318.1C192.8 334.5 218.8 352 256 352zM208.4 208C208.4 225.7 194 240 176.4 240C158.7 240 144.4 225.7 144.4 208C144.4 190.3 158.7 176 176.4 176C194 176 208.4 190.3 208.4 208zM281.9 230.6C273.9 223 273.5 210.4 281 202.3C295.6 186.8 316.3 180 335.6 180C354.1 180 375.7 186.8 390.2 202.3C397.8 210.4 397.4 223 389.3 230.6C381.2 238.1 368.6 237.7 361 229.7C355.6 223.8 346.3 220 335.6 220C324.1 220 315.7 223.8 310.2 229.7C302.7 237.7 290 238.1 281.9 230.6zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Smile Wink', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-surprise'                        => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM176.4 240C194 240 208.4 225.7 208.4 208C208.4 190.3 194 176 176.4 176C158.7 176 144.4 190.3 144.4 208C144.4 225.7 158.7 240 176.4 240zM336.4 176C318.7 176 304.4 190.3 304.4 208C304.4 225.7 318.7 240 336.4 240C354 240 368.4 225.7 368.4 208C368.4 190.3 354 176 336.4 176zM256 416C291.3 416 320 387.3 320 352C320 316.7 291.3 288 256 288C220.7 288 192 316.7 192 352C192 387.3 220.7 416 256 416z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M144.4 208C144.4 190.3 158.7 176 176.4 176C194 176 208.4 190.3 208.4 208C208.4 225.7 194 240 176.4 240C158.7 240 144.4 225.7 144.4 208zM368.4 208C368.4 225.7 354 240 336.4 240C318.7 240 304.4 225.7 304.4 208C304.4 190.3 318.7 176 336.4 176C354 176 368.4 190.3 368.4 208zM192 352C192 316.7 220.7 288 256 288C291.3 288 320 316.7 320 352C320 387.3 291.3 416 256 416C220.7 416 192 387.3 192 352zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Surprise', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'face-tired'                           => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM138.3 364.1C132.2 375.8 128 388.4 128 400C128 405.2 130.6 410.2 134.9 413.2C139.2 416.1 144.7 416.8 149.6 414.1L170.2 407.3C197.1 397.2 225.6 392 254.4 392H257.6C286.4 392 314.9 397.2 341.8 407.3L362.4 414.1C367.3 416.8 372.8 416.1 377.1 413.2C381.4 410.2 384 405.2 384 400C384 388.4 379.8 375.8 373.7 364.1C367.4 352.1 358.4 339.8 347.3 328.7C325.3 306.7 293.4 287.1 256 287.1C218.6 287.1 186.7 306.7 164.7 328.7C153.6 339.8 144.6 352.1 138.3 364.1H138.3zM133.5 146.7C125.6 142.4 116 148.2 116 157.1C116 159.9 116.1 162.6 118.8 164.8L154.8 208L118.8 251.2C116.1 253.4 116 256.1 116 258.9C116 267.8 125.6 273.6 133.5 269.3L223.4 221.4C234.1 215.7 234.1 200.3 223.4 194.6L133.5 146.7zM396 157.1C396 148.2 386.4 142.4 378.5 146.7L288.6 194.6C277.9 200.3 277.9 215.7 288.6 221.4L378.5 269.3C386.4 273.6 396 267.8 396 258.9C396 256.1 395 253.4 393.2 251.2L357.2 208L393.2 164.8C395 162.6 396 159.9 396 157.1V157.1z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M176.5 320.3C196.1 302.1 223.8 288 256 288C288.2 288 315.9 302.1 335.5 320.3C354.5 338.1 368 362 368 384C368 389.4 365.3 394.4 360.8 397.4C356.2 400.3 350.5 400.8 345.6 398.7L328.4 391.1C305.6 381.2 280.9 376 256 376C231.1 376 206.4 381.2 183.6 391.1L166.4 398.7C161.5 400.8 155.8 400.3 151.2 397.4C146.7 394.4 144 389.4 144 384C144 362 157.5 338.1 176.5 320.3zM223.4 194.6C234.1 200.3 234.1 215.7 223.4 221.4L133.5 269.3C125.6 273.6 116 267.8 116 258.9C116 256.1 116.1 253.4 118.8 251.2L154.8 208L118.8 164.8C116.1 162.6 116 159.9 116 157.1C116 148.2 125.6 142.4 133.5 146.7L223.4 194.6zM393.2 164.8L357.2 208L393.2 251.2C395 253.4 396 256.1 396 258.9C396 267.8 386.4 273.6 378.5 269.3L288.6 221.4C277.9 215.7 277.9 200.3 288.6 194.6L378.5 146.7C386.4 142.4 396 148.2 396 157.1C396 159.9 395 162.6 393.2 164.8zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z',
			),
		),
		'label'             => __( 'Face Tired', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'facebook'                             => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M504 256C504 119 393 8 256 8S8 119 8 256c0 123.8 90.69 226.4 209.3 245V327.7h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.3 482.4 504 379.8 504 256z',
			),
		),
		'label'             => __( 'Facebook', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'facebook-f'                           => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M279.1 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.4 0 225.4 0c-73.22 0-121.1 44.38-121.1 124.7v70.62H22.89V288h81.39v224h100.2V288z',
			),
		),
		'label'             => __( 'Facebook F', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'facebook-messenger'                   => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256.5 8C116.5 8 8 110.3 8 248.6c0 72.3 29.71 134.8 78.07 177.9 8.35 7.51 6.63 11.86 8.05 58.23A19.92 19.92 0 0 0 122 502.3c52.91-23.3 53.59-25.14 62.56-22.7C337.9 521.8 504 423.7 504 248.6 504 110.3 396.6 8 256.5 8zm149.2 185.1l-73 115.6a37.37 37.37 0 0 1 -53.91 9.93l-58.08-43.47a15 15 0 0 0 -18 0l-78.37 59.44c-10.46 7.93-24.16-4.6-17.11-15.67l73-115.6a37.36 37.36 0 0 1 53.91-9.93l58.06 43.46a15 15 0 0 0 18 0l78.41-59.38c10.44-7.98 24.14 4.54 17.09 15.62z',
			),
		),
		'label'             => __( 'Facebook Messenger', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'facebook-square'                      => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h137.3V327.7h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.27c-30.81 0-40.42 19.12-40.42 38.73V256h68.78l-11 71.69h-57.78V480H400a48 48 0 0 0 48-48V80a48 48 0 0 0 -48-48z',
			),
		),
		'label'             => __( 'Dribbble', 'astra' ),
		'custom_categories' => array(),
	),
	'fan'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M352.6 127.1c-28.12 0-54.13 4.5-77.13 12.88l12.38-123.1c1.125-10.5-8.125-18.88-18.5-17.63C189.6 10.12 127.1 77.62 127.1 159.4c0 28.12 4.5 54.13 12.88 77.13L17.75 224.1c-10.5-1.125-18.88 8.125-17.63 18.5c9.1 79.75 77.5 141.4 159.3 141.4c28.12 0 54.13-4.5 77.13-12.88l-12.38 123.1c-1.125 10.38 8.125 18.88 18.5 17.63c79.75-10 141.4-77.5 141.4-159.3c0-28.12-4.5-54.13-12.88-77.13l123.1 12.38c10.5 1.125 18.88-8.125 17.63-18.5C501.9 189.6 434.4 127.1 352.6 127.1zM255.1 287.1c-17.62 0-31.1-14.38-31.1-32s14.37-32 31.1-32s31.1 14.38 31.1 32S273.6 287.1 255.1 287.1z',
			),
		),
		'label'             => __( 'Fan', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'science-and-technology',
		),
	),
	'fantasy-flight-games'                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 32.86L32.86 256 256 479.1 479.1 256 256 32.86zM88.34 255.8c1.96-2 11.92-12.3 96.49-97.48 41.45-41.75 86.19-43.77 119.8-18.69 24.63 18.4 62.06 58.9 62.15 59 .68 .74 1.07 2.86 .58 3.38-11.27 11.84-22.68 23.54-33.5 34.69-34.21-32.31-40.52-38.24-48.51-43.95-17.77-12.69-41.4-10.13-56.98 5.1-2.17 2.13-1.79 3.43 .12 5.35 2.94 2.95 28.1 28.33 35.09 35.78-11.95 11.6-23.66 22.97-35.69 34.66-12.02-12.54-24.48-25.53-36.54-38.11-21.39 21.09-41.69 41.11-61.85 60.99zm234.8 101.6c-35.49 35.43-78.09 38.14-106.1 20.47-22.08-13.5-39.38-32.08-72.93-66.84 12.05-12.37 23.79-24.42 35.37-36.31 33.02 31.91 37.06 36.01 44.68 42.09 18.48 14.74 42.52 13.67 59.32-1.8 3.68-3.39 3.69-3.64 .14-7.24-10.59-10.73-21.19-21.44-31.77-32.18-1.32-1.34-3.03-2.48-.8-4.69 10.79-10.71 21.48-21.52 32.21-32.29 .26-.26 .65-.38 1.91-1.07 12.37 12.87 24.92 25.92 37.25 38.75 21.01-20.73 41.24-40.68 61.25-60.42 13.68 13.4 27.13 26.58 40.86 40.03-20.17 20.86-81.68 82.71-100.5 101.5zM256 0L0 256l256 256 256-256L256 0zM16 256L256 16l240 240-240 240L16 256z',
			),
		),
		'label'             => __( 'Fantasy Flight-games', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'brands',
			'brands',
			'social',
		),
	),
	'faucet'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M352 256h-38.54C297.7 242.5 277.9 232.9 256 228V180.5L224 177L192 180.5V228C170.1 233 150.3 242.6 134.5 256H16C7.125 256 0 263.1 0 272v96C0 376.9 7.125 384 16 384h92.78C129.4 421.8 173 448 224 448s94.59-26.25 115.2-64H352c17.62 0 32 14.29 32 31.91S398.4 448 416 448h64c17.62 0 32-14.31 32-31.94C512 327.7 440.4 256 352 256zM81.63 159.9L224 144.9l142.4 15C375.9 160.9 384 153.1 384 143.1V112.9c0-10-8.125-17.74-17.62-16.74L256 107.8V80C256 71.12 248.9 64 240 64h-32C199.1 64 192 71.12 192 80v27.75L81.63 96.14C72.13 95.14 64 102.9 64 112.9v30.24C64 153.1 72.13 160.9 81.63 159.9z',
			),
		),
		'label'             => __( 'Faucet', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'faucet-drip'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M416 480c0 17.62 14.38 32 32 32s32-14.38 32-32s-32-64-32-64S416 462.4 416 480zM352 192h-38.54C297.7 178.5 277.9 168.9 256 164V116.5L224 113L192 116.5V164C170.1 169 150.3 178.6 134.5 192H16C7.125 192 0 199.1 0 208v96C0 312.9 7.125 320 16 320h92.78C129.4 357.8 173 384 224 384s94.59-26.25 115.2-64H352c17.62 0 32 14.29 32 31.91S398.4 384 416 384h64c17.62 0 32-14.38 32-32C512 263.6 440.4 192 352 192zM81.63 95.88L224 80.88l142.4 15C375.9 96.88 384 89.12 384 79.12V48.89c0-10-8.125-17.74-17.62-16.74L256 43.75V16C256 7.125 248.9 0 240 0h-32C199.1 0 192 7.125 192 16v27.75L81.63 32.14C72.13 31.14 64 38.89 64 48.89V79.12C64 89.12 72.13 96.88 81.63 95.88z',
			),
		),
		'label'             => __( 'Faucet Drip', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'fax'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M192 64h197.5L416 90.51V160h64V77.25c0-8.484-3.375-16.62-9.375-22.62l-45.25-45.25C419.4 3.375 411.2 0 402.8 0H160C142.3 0 128 14.33 128 32v128h64V64zM64 128H32C14.38 128 0 142.4 0 160v320c0 17.62 14.38 32 32 32h32c17.62 0 32-14.38 32-32V160C96 142.4 81.63 128 64 128zM480 192H128v288c0 17.6 14.4 32 32 32h320c17.6 0 32-14.4 32-32V224C512 206.4 497.6 192 480 192zM288 432c0 8.875-7.125 16-16 16h-32C231.1 448 224 440.9 224 432v-32C224 391.1 231.1 384 240 384h32c8.875 0 16 7.125 16 16V432zM288 304c0 8.875-7.125 16-16 16h-32C231.1 320 224 312.9 224 304v-32C224 263.1 231.1 256 240 256h32C280.9 256 288 263.1 288 272V304zM416 432c0 8.875-7.125 16-16 16h-32c-8.875 0-16-7.125-16-16v-32c0-8.875 7.125-16 16-16h32c8.875 0 16 7.125 16 16V432zM416 304c0 8.875-7.125 16-16 16h-32C359.1 320 352 312.9 352 304v-32C352 263.1 359.1 256 368 256h32C408.9 256 416 263.1 416 272V304z',
			),
		),
		'label'             => __( 'Fax', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
			'science-and-technology',
		),
	),
	'feather'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M483.4 244.2L351.9 287.1h97.74c-9.874 10.62 3.75-3.125-46.24 46.87l-147.6 49.12h98.24c-74.99 73.12-194.6 70.62-246.8 54.1l-66.14 65.99c-9.374 9.374-24.6 9.374-33.98 0s-9.374-24.6 0-33.98l259.5-259.2c6.249-6.25 6.249-16.37 0-22.62c-6.249-6.249-16.37-6.249-22.62 0l-178.4 178.2C58.78 306.1 68.61 216.7 129.1 156.3l85.74-85.68c90.62-90.62 189.8-88.27 252.3-25.78C517.8 95.34 528.9 169.7 483.4 244.2z',
			),
		),
		'label'             => __( 'Feather', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'feather-pointed'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M467.1 241.1L351.1 288h94.34c-7.711 14.85-16.29 29.28-25.87 43.01l-132.5 52.99h85.65c-59.34 52.71-144.1 80.34-264.5 52.82l-68.13 68.13c-9.38 9.38-24.56 9.374-33.94 0c-9.375-9.375-9.375-24.56 0-33.94l253.4-253.4c4.846-6.275 4.643-15.19-1.113-20.95c-6.25-6.25-16.38-6.25-22.62 0l-168.6 168.6C24.56 58 366.9 8.118 478.9 .0846c18.87-1.354 34.41 14.19 33.05 33.05C508.7 78.53 498.5 161.8 467.1 241.1z',
			),
		),
		'label'             => __( 'Feather Pointed', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'fedex'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M586 284.5l53.3-59.9h-62.4l-21.7 24.8-22.5-24.8H414v-16h56.1v-48.1H318.9V236h-.5c-9.6-11-21.5-14.8-35.4-14.8-28.4 0-49.8 19.4-57.3 44.9-18-59.4-97.4-57.6-121.9-14v-24.2H49v-26.2h60v-41.1H0V345h49v-77.5h48.9c-1.5 5.7-2.3 11.8-2.3 18.2 0 73.1 102.6 91.4 130.2 23.7h-42c-14.7 20.9-45.8 8.9-45.8-14.6h85.5c3.7 30.5 27.4 56.9 60.1 56.9 14.1 0 27-6.9 34.9-18.6h.5V345h212.2l22.1-25 22.3 25H640l-54-60.5zm-446.7-16.6c6.1-26.3 41.7-25.6 46.5 0h-46.5zm153.4 48.9c-34.6 0-34-62.8 0-62.8 32.6 0 34.5 62.8 0 62.8zm167.8 19.1h-94.4V169.4h95v30.2H405v33.9h55.5v28.1h-56.1v44.7h56.1v29.6zm-45.9-39.8v-24.4h56.1v-44l50.7 57-50.7 57v-45.6h-56.1zm138.6 10.3l-26.1 29.5H489l45.6-51.2-45.6-51.2h39.7l26.6 29.3 25.6-29.3h38.5l-45.4 51 46 51.4h-40.5l-26.3-29.5z',
			),
		),
		'label'             => __( 'FedEx', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'fedora'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M.0413 255.8C.1219 132.2 100.3 32 224 32C347.7 32 448 132.3 448 256C448 379.7 347.8 479.9 224.1 480H50.93C22.84 480 .0832 457.3 .0416 429.2H0V255.8H.0413zM342.6 192.7C342.6 153 307 124.2 269.4 124.2C234.5 124.2 203.6 150.5 199.3 184.1C199.1 187.9 198.9 189.1 198.9 192.6C198.8 213.7 198.9 235.4 198.1 257C199 283.1 199.1 309.1 198.1 333.6C198.1 360.7 178.7 379.1 153.4 379.1C128.1 379.1 107.6 358.9 107.6 333.6C108.1 305.9 130.2 288.3 156.1 287.5H156.3L182.6 287.3V250L156.3 250.2C109.2 249.8 71.72 286.7 70.36 333.6C70.36 379.2 107.9 416.5 153.4 416.5C196.4 416.5 232.1 382.9 236 340.9L236.2 287.4L268.8 287.1C294.1 287.3 293.8 249.3 268.6 249.8L236.2 250.1C236.2 243.7 236.3 237.3 236.3 230.9C236.4 218.2 236.4 205.5 236.2 192.7C236.3 176.2 252 161.5 269.4 161.5C286.9 161.5 305.3 170.2 305.3 192.7C305.3 195.9 305.2 197.8 305 199C303.1 209.5 310.2 219.4 320.7 220.9C331.3 222.4 340.9 214.8 341.9 204.3C342.5 200.1 342.6 196.4 342.6 192.7H342.6z',
			),
		),
		'label'             => __( 'Fedora', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'ferry'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M352 0C369.7 0 384 14.33 384 32H459.1C479.7 32 490.7 56.29 477.2 71.8L456 96H119.1L98.83 71.8C85.25 56.29 96.27 32 116.9 32H191.1C191.1 14.33 206.3 0 223.1 0L352 0zM95.1 128H480C497.7 128 512 142.3 512 160V283.5C512 296.8 507.8 309.8 500.1 320.7L448.7 392.6C446.8 393.7 444.1 394.9 443.2 396.1C427.7 406.8 409.1 414.2 392.1 416H375.6C358.5 414.2 340.6 406.1 324.8 396.1C302.8 380.6 273.3 380.6 251.2 396.1C236.3 406.3 218.7 414.1 200.5 416H183.9C166.9 414.2 148.3 406.8 132.9 396.1C131.1 394.8 129.2 393.7 127.3 392.6L75.92 320.7C68.17 309.8 64 296.8 64 283.5V160C64 142.3 78.33 128 96 128H95.1zM127.1 288H448V192H127.1V288zM384 448C410.9 448 439.4 437.2 461.4 421.9L461.5 421.9C473.4 413.4 489.5 414.1 500.7 423.6C515 435.5 533.2 444.6 551.3 448.8C568.5 452.8 579.2 470.1 575.2 487.3C571.2 504.5 553.1 515.2 536.7 511.2C512.2 505.4 491.9 494.6 478.5 486.2C449.5 501.7 417 512 384 512C352.1 512 323.4 502.1 303.6 493.1C297.7 490.5 292.5 487.8 288 485.4C283.5 487.8 278.3 490.5 272.4 493.1C252.6 502.1 223.9 512 192 512C158.1 512 126.5 501.7 97.5 486.2C84.12 494.6 63.79 505.4 39.27 511.2C22.06 515.2 4.853 504.5 .8422 487.3C-3.169 470.1 7.532 452.8 24.74 448.8C42.84 444.6 60.96 435.5 75.31 423.6C86.46 414.1 102.6 413.4 114.5 421.9L114.6 421.9C136.7 437.2 165.1 448 192 448C219.5 448 247 437.4 269.5 421.9C280.6 414 295.4 414 306.5 421.9C328.1 437.4 356.5 448 384 448H384z',
			),
		),
		'label'             => __( 'Ferry', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'figma'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M14 95.79C14 42.89 56.89 0 109.8 0H274.2C327.1 0 369.1 42.89 369.1 95.79C369.1 129.3 352.8 158.8 326.7 175.9C352.8 193 369.1 222.5 369.1 256C369.1 308.9 327.1 351.8 274.2 351.8H272.1C247.3 351.8 224.7 342.4 207.7 326.9V415.2C207.7 468.8 163.7 512 110.3 512C57.54 512 14 469.2 14 416.2C14 382.7 31.19 353.2 57.24 336.1C31.19 318.1 14 289.5 14 256C14 222.5 31.2 193 57.24 175.9C31.2 158.8 14 129.3 14 95.79zM176.3 191.6H109.8C74.22 191.6 45.38 220.4 45.38 256C45.38 291.4 73.99 320.2 109.4 320.4C109.5 320.4 109.7 320.4 109.8 320.4H176.3V191.6zM207.7 256C207.7 291.6 236.5 320.4 272.1 320.4H274.2C309.7 320.4 338.6 291.6 338.6 256C338.6 220.4 309.7 191.6 274.2 191.6H272.1C236.5 191.6 207.7 220.4 207.7 256zM109.8 351.8C109.7 351.8 109.5 351.8 109.4 351.8C73.99 352 45.38 380.8 45.38 416.2C45.38 451.7 74.6 480.6 110.3 480.6C146.6 480.6 176.3 451.2 176.3 415.2V351.8H109.8zM109.8 31.38C74.22 31.38 45.38 60.22 45.38 95.79C45.38 131.4 74.22 160.2 109.8 160.2H176.3V31.38H109.8zM207.7 160.2H274.2C309.7 160.2 338.6 131.4 338.6 95.79C338.6 60.22 309.7 31.38 274.2 31.38H207.7V160.2z',
			),
		),
		'label'             => __( 'Figma', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'file'                                 => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M0 64C0 28.65 28.65 0 64 0H224V128C224 145.7 238.3 160 256 160H384V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V64zM256 128V0L384 128H256z',
			),
			'regular' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M0 64C0 28.65 28.65 0 64 0H229.5C246.5 0 262.7 6.743 274.7 18.75L365.3 109.3C377.3 121.3 384 137.5 384 154.5V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V64zM336 448V160H256C238.3 160 224 145.7 224 128V48H64C55.16 48 48 55.16 48 64V448C48 456.8 55.16 464 64 464H320C328.8 464 336 456.8 336 448z',
			),
		),
		'label'             => __( 'File', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
			'design',
			'science-and-technology',
		),
	),
	'file-arrow-down'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M384 128h-128V0L384 128zM256 160H384v304c0 26.51-21.49 48-48 48h-288C21.49 512 0 490.5 0 464v-416C0 21.49 21.49 0 48 0H224l.0039 128C224 145.7 238.3 160 256 160zM255 295L216 334.1V232c0-13.25-10.75-24-24-24S168 218.8 168 232v102.1L128.1 295C124.3 290.3 118.2 288 112 288S99.72 290.3 95.03 295c-9.375 9.375-9.375 24.56 0 33.94l80 80c9.375 9.375 24.56 9.375 33.94 0l80-80c9.375-9.375 9.375-24.56 0-33.94S264.4 285.7 255 295z',
			),
		),
		'label'             => __( 'File Arrow Down', 'astra' ),
		'custom_categories' => array(),
	),
	'file-arrow-up'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M256 0v128h128L256 0zM224 128L224 0H48C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h288c26.51 0 48-21.49 48-48V160h-127.1C238.3 160 224 145.7 224 128zM288.1 344.1C284.3 349.7 278.2 352 272 352s-12.28-2.344-16.97-7.031L216 305.9V408c0 13.25-10.75 24-24 24s-24-10.75-24-24V305.9l-39.03 39.03c-9.375 9.375-24.56 9.375-33.94 0s-9.375-24.56 0-33.94l80-80c9.375-9.375 24.56-9.375 33.94 0l80 80C298.3 320.4 298.3 335.6 288.1 344.1z',
			),
		),
		'label'             => __( 'File Arrow Up', 'astra' ),
		'custom_categories' => array(),
	),
	'file-audio'                           => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M224 128L224 0H48C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h288c26.51 0 48-21.49 48-48V160h-127.1C238.3 160 224 145.7 224 128zM176 404c0 10.75-12.88 15.98-20.5 8.484L120 376H76C69.38 376 64 370.6 64 364v-56C64 301.4 69.38 296 76 296H120l35.5-36.5C163.1 251.9 176 257.3 176 268V404zM224 387.8c-4.391 0-8.75-1.835-11.91-5.367c-5.906-6.594-5.359-16.69 1.219-22.59C220.2 353.7 224 345.2 224 336s-3.797-17.69-10.69-23.88c-6.578-5.906-7.125-16-1.219-22.59c5.922-6.594 16.05-7.094 22.59-1.219C248.2 300.5 256 317.8 256 336s-7.766 35.53-21.31 47.69C231.6 386.4 227.8 387.8 224 387.8zM320 336c0 41.81-20.5 81.11-54.84 105.1c-2.781 1.938-5.988 2.875-9.145 2.875c-5.047 0-10.03-2.375-13.14-6.844c-5.047-7.25-3.281-17.22 3.969-22.28C272.6 396.9 288 367.4 288 336s-15.38-60.84-41.14-78.8c-7.25-5.062-9.027-15.03-3.98-22.28c5.047-7.281 14.99-9.062 22.27-3.969C299.5 254.9 320 294.2 320 336zM256 0v128h128L256 0z',
			),
			'regular' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0L64-.0001c-35.35 0-64 28.65-64 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM171.5 259.5L136 296H92C85.38 296 80 301.4 80 308v56C80 370.7 85.38 376 92 376H136l35.5 36.5C179.1 420 192 414.8 192 404v-136C192 257.3 179.1 251.9 171.5 259.5zM235.1 260.7c-6.25 6.25-6.25 16.38 0 22.62C235.3 283.5 256 305.1 256 336c0 30.94-20.77 52.53-20.91 52.69c-6.25 6.25-6.25 16.38 0 22.62C238.2 414.4 242.3 416 246.4 416s8.188-1.562 11.31-4.688C258.1 410.1 288 380.5 288 336s-29.05-74.06-30.28-75.31C251.5 254.4 241.3 254.4 235.1 260.7z',
			),
		),
		'label'             => __( 'File Audio', 'astra' ),
		'custom_categories' => array(
			'communication',
			'lifestyle-and-hobbies',
		),
	),
	'file-circle-check'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M0 64C0 28.65 28.65 0 64 0H224V128C224 145.7 238.3 160 256 160H384V198.6C310.1 219.5 256 287.4 256 368C256 427.1 285.1 479.3 329.7 511.3C326.6 511.7 323.3 512 320 512H64C28.65 512 0 483.3 0 448V64zM256 128V0L384 128H256zM576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368zM476.7 324.7L416 385.4L387.3 356.7C381.1 350.4 370.9 350.4 364.7 356.7C358.4 362.9 358.4 373.1 364.7 379.3L404.7 419.3C410.9 425.6 421.1 425.6 427.3 419.3L499.3 347.3C505.6 341.1 505.6 330.9 499.3 324.7C493.1 318.4 482.9 318.4 476.7 324.7H476.7z',
			),
		),
		'label'             => __( 'File Circle Check', 'astra' ),
		'custom_categories' => array(),
	),
	'file-circle-exclamation'              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M0 64C0 28.65 28.65 0 64 0H224V128C224 145.7 238.3 160 256 160H384V198.6C310.1 219.5 256 287.4 256 368C256 427.1 285.1 479.3 329.7 511.3C326.6 511.7 323.3 512 320 512H64C28.65 512 0 483.3 0 448V64zM256 128V0L384 128H256zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM432 464C445.3 464 456 453.3 456 440C456 426.7 445.3 416 432 416C418.7 416 408 426.7 408 440C408 453.3 418.7 464 432 464zM415.1 288V368C415.1 376.8 423.2 384 431.1 384C440.8 384 447.1 376.8 447.1 368V288C447.1 279.2 440.8 272 431.1 272C423.2 272 415.1 279.2 415.1 288z',
			),
		),
		'label'             => __( 'File Circle Exclamation', 'astra' ),
		'custom_categories' => array(),
	),
	'file-circle-minus'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M0 64C0 28.65 28.65 0 64 0H224V128C224 145.7 238.3 160 256 160H384V198.6C310.1 219.5 256 287.4 256 368C256 427.1 285.1 479.3 329.7 511.3C326.6 511.7 323.3 512 320 512H64C28.65 512 0 483.3 0 448V64zM256 128V0L384 128H256zM576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368zM496 351.1H368C359.2 351.1 352 359.2 352 367.1C352 376.8 359.2 383.1 368 383.1H496C504.8 383.1 512 376.8 512 367.1C512 359.2 504.8 351.1 496 351.1z',
			),
		),
		'label'             => __( 'File Circle Minus', 'astra' ),
		'custom_categories' => array(),
	),
	'file-circle-plus'                     => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M0 64C0 28.65 28.65 0 64 0H224V128C224 145.7 238.3 160 256 160H384V198.6C310.1 219.5 256 287.4 256 368C256 427.1 285.1 479.3 329.7 511.3C326.6 511.7 323.3 512 320 512H64C28.65 512 0 483.3 0 448V64zM256 128V0L384 128H256zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM448 303.1C448 295.2 440.8 287.1 432 287.1C423.2 287.1 416 295.2 416 303.1V351.1H368C359.2 351.1 352 359.2 352 367.1C352 376.8 359.2 383.1 368 383.1H416V431.1C416 440.8 423.2 447.1 432 447.1C440.8 447.1 448 440.8 448 431.1V383.1H496C504.8 383.1 512 376.8 512 367.1C512 359.2 504.8 351.1 496 351.1H448V303.1z',
			),
		),
		'label'             => __( 'File Circle Plus', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'file-circle-question'                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M0 64C0 28.65 28.65 0 64 0H224V128C224 145.7 238.3 160 256 160H384V198.6C310.1 219.5 256 287.4 256 368C256 427.1 285.1 479.3 329.7 511.3C326.6 511.7 323.3 512 320 512H64C28.65 512 0 483.3 0 448V64zM256 128V0L384 128H256zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM432 464C445.3 464 456 453.3 456 440C456 426.7 445.3 416 432 416C418.7 416 408 426.7 408 440C408 453.3 418.7 464 432 464zM368 328C368 336.8 375.2 344 384 344C392.8 344 400 336.8 400 328V321.6C400 316.3 404.3 312 409.6 312H450.1C457.8 312 464 318.2 464 325.9C464 331.1 461.1 335.8 456.6 338.3L424.6 355.1C419.3 357.9 416 363.3 416 369.2V384C416 392.8 423.2 400 432 400C440.8 400 448 392.8 448 384V378.9L471.5 366.6C486.6 358.6 496 342.1 496 325.9C496 300.6 475.4 280 450.1 280H409.6C386.6 280 368 298.6 368 321.6V328z',
			),
		),
		'label'             => __( 'File Circle Question', 'astra' ),
		'custom_categories' => array(),
	),
	'file-circle-xmark'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M0 64C0 28.65 28.65 0 64 0H224V128C224 145.7 238.3 160 256 160H384V198.6C310.1 219.5 256 287.4 256 368C256 427.1 285.1 479.3 329.7 511.3C326.6 511.7 323.3 512 320 512H64C28.65 512 0 483.3 0 448V64zM256 128V0L384 128H256zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM491.3 331.3C497.6 325.1 497.6 314.9 491.3 308.7C485.1 302.4 474.9 302.4 468.7 308.7L432 345.4L395.3 308.7C389.1 302.4 378.9 302.4 372.7 308.7C366.4 314.9 366.4 325.1 372.7 331.3L409.4 368L372.7 404.7C366.4 410.9 366.4 421.1 372.7 427.3C378.9 433.6 389.1 433.6 395.3 427.3L432 390.6L468.7 427.3C474.9 433.6 485.1 433.6 491.3 427.3C497.6 421.1 497.6 410.9 491.3 404.7L454.6 368L491.3 331.3z',
			),
		),
		'label'             => __( 'File Circle Xmark', 'astra' ),
		'custom_categories' => array(),
	),
	'file-code'                            => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M224 128L224 0H48C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h288c26.51 0 48-21.49 48-48V160h-127.1C238.3 160 224 145.7 224 128zM154.1 353.8c7.812 7.812 7.812 20.5 0 28.31C150.2 386.1 145.1 388 140 388s-10.23-1.938-14.14-5.844l-48-48c-7.812-7.812-7.812-20.5 0-28.31l48-48c7.812-7.812 20.47-7.812 28.28 0s7.812 20.5 0 28.31L120.3 320L154.1 353.8zM306.1 305.8c7.812 7.812 7.812 20.5 0 28.31l-48 48C254.2 386.1 249.1 388 244 388s-10.23-1.938-14.14-5.844c-7.812-7.812-7.812-20.5 0-28.31L263.7 320l-33.86-33.84c-7.812-7.812-7.812-20.5 0-28.31s20.47-7.812 28.28 0L306.1 305.8zM256 0v128h128L256 0z',
			),
			'regular' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M162.1 257.8c-7.812-7.812-20.47-7.812-28.28 0l-48 48c-7.812 7.812-7.812 20.5 0 28.31l48 48C137.8 386.1 142.9 388 148 388s10.23-1.938 14.14-5.844c7.812-7.812 7.812-20.5 0-28.31L128.3 320l33.86-33.84C169.1 278.3 169.1 265.7 162.1 257.8zM365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM221.9 257.8c-7.812 7.812-7.812 20.5 0 28.31L255.7 320l-33.86 33.84c-7.812 7.812-7.812 20.5 0 28.31C225.8 386.1 230.9 388 236 388s10.23-1.938 14.14-5.844l48-48c7.812-7.812 7.812-20.5 0-28.31l-48-48C242.3 250 229.7 250 221.9 257.8z',
			),
		),
		'label'             => __( 'File Code', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'file-contract'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M256 0v128h128L256 0zM224 128L224 0H48C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h288c26.51 0 48-21.49 48-48V160h-127.1C238.3 160 224 145.7 224 128zM64 72C64 67.63 67.63 64 72 64h80C156.4 64 160 67.63 160 72v16C160 92.38 156.4 96 152 96h-80C67.63 96 64 92.38 64 88V72zM64 136C64 131.6 67.63 128 72 128h80C156.4 128 160 131.6 160 136v16C160 156.4 156.4 160 152 160h-80C67.63 160 64 156.4 64 152V136zM304 384c8.875 0 16 7.125 16 16S312.9 416 304 416h-47.25c-16.38 0-31.25-9.125-38.63-23.88c-2.875-5.875-8-6.5-10.12-6.5s-7.25 .625-10 6.125l-7.75 15.38C187.6 412.6 181.1 416 176 416H174.9c-6.5-.5-12-4.75-14-11L144 354.6L133.4 386.5C127.5 404.1 111 416 92.38 416H80C71.13 416 64 408.9 64 400S71.13 384 80 384h12.38c4.875 0 9.125-3.125 10.62-7.625l18.25-54.63C124.5 311.9 133.6 305.3 144 305.3s19.5 6.625 22.75 16.5l13.88 41.63c19.75-16.25 54.13-9.75 66 14.12c2 4 6 6.5 10.12 6.5H304z',
			),
		),
		'label'             => __( 'File Contract', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'file-csv'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M224 0V128C224 145.7 238.3 160 256 160H384V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V64C0 28.65 28.65 0 64 0H224zM80 224C57.91 224 40 241.9 40 264V344C40 366.1 57.91 384 80 384H96C118.1 384 136 366.1 136 344V336C136 327.2 128.8 320 120 320C111.2 320 104 327.2 104 336V344C104 348.4 100.4 352 96 352H80C75.58 352 72 348.4 72 344V264C72 259.6 75.58 256 80 256H96C100.4 256 104 259.6 104 264V272C104 280.8 111.2 288 120 288C128.8 288 136 280.8 136 272V264C136 241.9 118.1 224 96 224H80zM175.4 310.6L200.8 325.1C205.2 327.7 208 332.5 208 337.6C208 345.6 201.6 352 193.6 352H168C159.2 352 152 359.2 152 368C152 376.8 159.2 384 168 384H193.6C219.2 384 240 363.2 240 337.6C240 320.1 231.1 305.6 216.6 297.4L191.2 282.9C186.8 280.3 184 275.5 184 270.4C184 262.4 190.4 256 198.4 256H216C224.8 256 232 248.8 232 240C232 231.2 224.8 224 216 224H198.4C172.8 224 152 244.8 152 270.4C152 287 160.9 302.4 175.4 310.6zM280 240C280 231.2 272.8 224 264 224C255.2 224 248 231.2 248 240V271.6C248 306.3 258.3 340.3 277.6 369.2L282.7 376.9C285.7 381.3 290.6 384 296 384C301.4 384 306.3 381.3 309.3 376.9L314.4 369.2C333.7 340.3 344 306.3 344 271.6V240C344 231.2 336.8 224 328 224C319.2 224 312 231.2 312 240V271.6C312 294.6 306.5 317.2 296 337.5C285.5 317.2 280 294.6 280 271.6V240zM256 0L384 128H256V0z',
			),
		),
		'label'             => __( 'File Csv', 'astra' ),
		'custom_categories' => array(),
	),
	'file-excel'                           => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M224 128L224 0H48C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h288c26.51 0 48-21.49 48-48V160h-127.1C238.3 160 224 145.7 224 128zM272.1 264.4L224 344l48.99 79.61C279.6 434.3 271.9 448 259.4 448h-26.43c-5.557 0-10.71-2.883-13.63-7.617L192 396l-27.31 44.38C161.8 445.1 156.6 448 151.1 448H124.6c-12.52 0-20.19-13.73-13.63-24.39L160 344L111 264.4C104.4 253.7 112.1 240 124.6 240h26.43c5.557 0 10.71 2.883 13.63 7.613L192 292l27.31-44.39C222.2 242.9 227.4 240 232.9 240h26.43C271.9 240 279.6 253.7 272.1 264.4zM256 0v128h128L256 0z',
			),
			'regular' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM229.1 233.3L192 280.9L154.9 233.3C146.8 222.8 131.8 220.9 121.3 229.1C110.8 237.2 108.9 252.3 117.1 262.8L161.6 320l-44.53 57.25c-8.156 10.47-6.25 25.56 4.188 33.69C125.7 414.3 130.8 416 135.1 416c7.156 0 14.25-3.188 18.97-9.25L192 359.1l37.06 47.65C233.8 412.8 240.9 416 248 416c5.125 0 10.31-1.656 14.72-5.062c10.44-8.125 12.34-23.22 4.188-33.69L222.4 320l44.53-57.25c8.156-10.47 6.25-25.56-4.188-33.69C252.2 220.9 237.2 222.8 229.1 233.3z',
			),
		),
		'label'             => __( 'File Excel', 'astra' ),
		'custom_categories' => array(),
	),
	'file-export'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M192 312C192 298.8 202.8 288 216 288H384V160H256c-17.67 0-32-14.33-32-32L224 0H48C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h288c26.51 0 48-21.49 48-48v-128H216C202.8 336 192 325.3 192 312zM256 0v128h128L256 0zM568.1 295l-80-80c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L494.1 288H384v48h110.1l-39.03 39.03C450.3 379.7 448 385.8 448 392s2.344 12.28 7.031 16.97c9.375 9.375 24.56 9.375 33.94 0l80-80C578.3 319.6 578.3 304.4 568.1 295z',
			),
		),
		'label'             => __( 'File Export', 'astra' ),
		'custom_categories' => array(),
	),
	'file-image'                           => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M224 128L224 0H48C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h288c26.51 0 48-21.49 48-48V160h-127.1C238.3 160 224 145.7 224 128zM96 224c17.67 0 32 14.33 32 32S113.7 288 96 288S64 273.7 64 256S78.33 224 96 224zM318.1 439.5C315.3 444.8 309.9 448 304 448h-224c-5.9 0-11.32-3.248-14.11-8.451c-2.783-5.201-2.479-11.52 .7949-16.42l53.33-80C122.1 338.7 127.1 336 133.3 336s10.35 2.674 13.31 7.125L160 363.2l45.35-68.03C208.3 290.7 213.3 288 218.7 288s10.35 2.674 13.31 7.125l85.33 128C320.6 428 320.9 434.3 318.1 439.5zM256 0v128h128L256 0z',
			),
			'regular' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM215.3 292c-4.68 0-9.051 2.34-11.65 6.234L164 357.8l-11.68-17.53C149.7 336.3 145.3 334 140.7 334c-4.682 0-9.053 2.34-11.65 6.234l-46.67 70c-2.865 4.297-3.131 9.82-.6953 14.37C84.09 429.2 88.84 432 93.1 432h196c5.163 0 9.907-2.844 12.34-7.395c2.436-4.551 2.17-10.07-.6953-14.37l-74.67-112C224.4 294.3 220 292 215.3 292zM128 288c17.67 0 32-14.33 32-32S145.7 224 128 224S96 238.3 96 256S110.3 288 128 288z',
			),
		),
		'label'             => __( 'File Image', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
		),
	),
	'file-import'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M384 0v128h128L384 0zM352 128L352 0H176C149.5 0 128 21.49 128 48V288h174.1l-39.03-39.03c-9.375-9.375-9.375-24.56 0-33.94s24.56-9.375 33.94 0l80 80c9.375 9.375 9.375 24.56 0 33.94l-80 80c-9.375 9.375-24.56 9.375-33.94 0C258.3 404.3 256 398.2 256 392s2.344-12.28 7.031-16.97L302.1 336H128v128C128 490.5 149.5 512 176 512h288c26.51 0 48-21.49 48-48V160h-127.1C366.3 160 352 145.7 352 128zM24 288C10.75 288 0 298.7 0 312c0 13.25 10.75 24 24 24H128V288H24z',
			),
		),
		'label'             => __( 'File Import', 'astra' ),
		'custom_categories' => array(),
	),
	'file-invoice'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M256 0v128h128L256 0zM288 256H96v64h192V256zM224 128L224 0H48C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h288c26.51 0 48-21.49 48-48V160h-127.1C238.3 160 224 145.7 224 128zM64 72C64 67.63 67.63 64 72 64h80C156.4 64 160 67.63 160 72v16C160 92.38 156.4 96 152 96h-80C67.63 96 64 92.38 64 88V72zM64 136C64 131.6 67.63 128 72 128h80C156.4 128 160 131.6 160 136v16C160 156.4 156.4 160 152 160h-80C67.63 160 64 156.4 64 152V136zM320 440c0 4.375-3.625 8-8 8h-80C227.6 448 224 444.4 224 440v-16c0-4.375 3.625-8 8-8h80c4.375 0 8 3.625 8 8V440zM320 240v96c0 8.875-7.125 16-16 16h-224C71.13 352 64 344.9 64 336v-96C64 231.1 71.13 224 80 224h224C312.9 224 320 231.1 320 240z',
			),
		),
		'label'             => __( 'File Invoice', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'file-invoice-dollar'                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M384 128h-128V0L384 128zM256 160H384v304c0 26.51-21.49 48-48 48h-288C21.49 512 0 490.5 0 464v-416C0 21.49 21.49 0 48 0H224l.0039 128C224 145.7 238.3 160 256 160zM64 88C64 92.38 67.63 96 72 96h80C156.4 96 160 92.38 160 88v-16C160 67.63 156.4 64 152 64h-80C67.63 64 64 67.63 64 72V88zM72 160h80C156.4 160 160 156.4 160 152v-16C160 131.6 156.4 128 152 128h-80C67.63 128 64 131.6 64 136v16C64 156.4 67.63 160 72 160zM197.5 316.8L191.1 315.2C168.3 308.2 168.8 304.1 169.6 300.5c1.375-7.812 16.59-9.719 30.27-7.625c5.594 .8438 11.73 2.812 17.59 4.844c10.39 3.594 21.83-1.938 25.45-12.34c3.625-10.44-1.891-21.84-12.33-25.47c-7.219-2.484-13.11-4.078-18.56-5.273V248c0-11.03-8.953-20-20-20s-20 8.969-20 20v5.992C149.6 258.8 133.8 272.8 130.2 293.7c-7.406 42.84 33.19 54.75 50.52 59.84l5.812 1.688c29.28 8.375 28.8 11.19 27.92 16.28c-1.375 7.812-16.59 9.75-30.31 7.625c-6.938-1.031-15.81-4.219-23.66-7.031l-4.469-1.625c-10.41-3.594-21.83 1.812-25.52 12.22c-3.672 10.41 1.781 21.84 12.2 25.53l4.266 1.5c7.758 2.789 16.38 5.59 25.06 7.512V424c0 11.03 8.953 20 20 20s20-8.969 20-20v-6.254c22.36-4.793 38.21-18.53 41.83-39.43C261.3 335 219.8 323.1 197.5 316.8z',
			),
		),
		'label'             => __( 'File Invoice Dollar', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'file-lines'                           => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M256 0v128h128L256 0zM224 128L224 0H48C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h288c26.51 0 48-21.49 48-48V160h-127.1C238.3 160 224 145.7 224 128zM272 416h-160C103.2 416 96 408.8 96 400C96 391.2 103.2 384 112 384h160c8.836 0 16 7.162 16 16C288 408.8 280.8 416 272 416zM272 352h-160C103.2 352 96 344.8 96 336C96 327.2 103.2 320 112 320h160c8.836 0 16 7.162 16 16C288 344.8 280.8 352 272 352zM288 272C288 280.8 280.8 288 272 288h-160C103.2 288 96 280.8 96 272C96 263.2 103.2 256 112 256h160C280.8 256 288 263.2 288 272z',
			),
			'regular' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0L64-.0001c-35.35 0-64 28.65-64 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM96 280C96 293.3 106.8 304 120 304h144C277.3 304 288 293.3 288 280S277.3 256 264 256h-144C106.8 256 96 266.8 96 280zM264 352h-144C106.8 352 96 362.8 96 376s10.75 24 24 24h144c13.25 0 24-10.75 24-24S277.3 352 264 352z',
			),
		),
		'label'             => __( 'File Lines', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
			'science-and-technology',
		),
	),
	'file-medical'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M256 0v128h128L256 0zM224 128L224 0H48C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h288c26.51 0 48-21.49 48-48V160h-127.1C238.3 160 224 145.7 224 128zM288 301.7v36.57C288 345.9 281.9 352 274.3 352L224 351.1v50.29C224 409.9 217.9 416 210.3 416H173.7C166.1 416 160 409.9 160 402.3V351.1L109.7 352C102.1 352 96 345.9 96 338.3V301.7C96 294.1 102.1 288 109.7 288H160V237.7C160 230.1 166.1 224 173.7 224h36.57C217.9 224 224 230.1 224 237.7V288h50.29C281.9 288 288 294.1 288 301.7z',
			),
		),
		'label'             => __( 'File Medical', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'file-pdf'                             => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M88 304H80V256H88C101.3 256 112 266.7 112 280C112 293.3 101.3 304 88 304zM192 256H200C208.8 256 216 263.2 216 272V336C216 344.8 208.8 352 200 352H192V256zM224 0V128C224 145.7 238.3 160 256 160H384V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V64C0 28.65 28.65 0 64 0H224zM64 224C55.16 224 48 231.2 48 240V368C48 376.8 55.16 384 64 384C72.84 384 80 376.8 80 368V336H88C118.9 336 144 310.9 144 280C144 249.1 118.9 224 88 224H64zM160 368C160 376.8 167.2 384 176 384H200C226.5 384 248 362.5 248 336V272C248 245.5 226.5 224 200 224H176C167.2 224 160 231.2 160 240V368zM288 224C279.2 224 272 231.2 272 240V368C272 376.8 279.2 384 288 384C296.8 384 304 376.8 304 368V320H336C344.8 320 352 312.8 352 304C352 295.2 344.8 288 336 288H304V256H336C344.8 256 352 248.8 352 240C352 231.2 344.8 224 336 224H288zM256 0L384 128H256V0z',
			),
			'regular' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M320 464C328.8 464 336 456.8 336 448V416H384V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V416H48V448C48 456.8 55.16 464 64 464H320zM256 160C238.3 160 224 145.7 224 128V48H64C55.16 48 48 55.16 48 64V192H0V64C0 28.65 28.65 0 64 0H229.5C246.5 0 262.7 6.743 274.7 18.75L365.3 109.3C377.3 121.3 384 137.5 384 154.5V192H336V160H256zM88 224C118.9 224 144 249.1 144 280C144 310.9 118.9 336 88 336H80V368C80 376.8 72.84 384 64 384C55.16 384 48 376.8 48 368V240C48 231.2 55.16 224 64 224H88zM112 280C112 266.7 101.3 256 88 256H80V304H88C101.3 304 112 293.3 112 280zM160 240C160 231.2 167.2 224 176 224H200C226.5 224 248 245.5 248 272V336C248 362.5 226.5 384 200 384H176C167.2 384 160 376.8 160 368V240zM192 352H200C208.8 352 216 344.8 216 336V272C216 263.2 208.8 256 200 256H192V352zM336 224C344.8 224 352 231.2 352 240C352 248.8 344.8 256 336 256H304V288H336C344.8 288 352 295.2 352 304C352 312.8 344.8 320 336 320H304V368C304 376.8 296.8 384 288 384C279.2 384 272 376.8 272 368V240C272 231.2 279.2 224 288 224H336z',
			),
		),
		'label'             => __( 'File Pdf', 'astra' ),
		'custom_categories' => array(),
	),
	'file-pen'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M0 64C0 28.65 28.65 0 64 0H224V128C224 145.7 238.3 160 256 160H384V299.6L289.3 394.3C281.1 402.5 275.3 412.8 272.5 424.1L257.4 484.2C255.1 493.6 255.7 503.2 258.8 512H64C28.65 512 0 483.3 0 448V64zM256 128V0L384 128H256zM564.1 250.1C579.8 265.7 579.8 291 564.1 306.7L534.7 336.1L463.8 265.1L493.2 235.7C508.8 220.1 534.1 220.1 549.8 235.7L564.1 250.1zM311.9 416.1L441.1 287.8L512.1 358.7L382.9 487.9C378.8 492 373.6 494.9 368 496.3L307.9 511.4C302.4 512.7 296.7 511.1 292.7 507.2C288.7 503.2 287.1 497.4 288.5 491.1L303.5 431.8C304.9 426.2 307.8 421.1 311.9 416.1V416.1z',
			),
		),
		'label'             => __( 'File Pen', 'astra' ),
		'custom_categories' => array(),
	),
	'file-powerpoint'                      => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M256 0v128h128L256 0zM224 128L224 0H48C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h288c26.51 0 48-21.49 48-48V160h-127.1C238.3 160 224 145.7 224 128zM279.6 308.1C284.2 353.5 248.5 392 204 392H160v40C160 440.8 152.8 448 144 448H128c-8.836 0-16-7.164-16-16V256c0-8.836 7.164-16 16-16h71.51C239.3 240 275.6 268.5 279.6 308.1zM160 344h44c15.44 0 28-12.56 28-28S219.4 288 204 288H160V344z',
			),
			'regular' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM200 224H128C119.2 224 112 231.2 112 240v168c0 13.25 10.75 24 24 24S160 421.3 160 408v-32h44c44.21 0 79.73-37.95 75.69-82.98C276.1 253.2 240 224 200 224zM204 328H160V272h44c15.44 0 28 12.56 28 28S219.4 328 204 328z',
			),
		),
		'label'             => __( 'File Powerpoint', 'astra' ),
		'custom_categories' => array(),
	),
	'file-prescription'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M176 240H128v32h48C184.9 272 192 264.9 192 256S184.9 240 176 240zM256 0v128h128L256 0zM224 128L224 0H48C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h288c26.51 0 48-21.49 48-48V160h-127.1C238.3 160 224 145.7 224 128zM292.5 315.5l11.38 11.25c6.25 6.25 6.25 16.38 0 22.62l-29.88 30L304 409.4c6.25 6.25 6.25 16.38 0 22.62l-11.25 11.38c-6.25 6.25-16.5 6.25-22.75 0L240 413.3l-30 30c-6.249 6.25-16.48 6.266-22.73 .0156L176 432c-6.25-6.25-6.25-16.38 0-22.62l29.1-30.12L146.8 320H128l.0078 48.01c0 8.875-7.125 16-16 16L96 384c-8.875 0-16-7.125-16-16v-160C80 199.1 87.13 192 96 192h80c35.38 0 64 28.62 64 64c0 24.25-13.62 45-33.5 55.88L240 345.4l29.88-29.88C276.1 309.3 286.3 309.3 292.5 315.5z',
			),
		),
		'label'             => __( 'File Prescription', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'file-shield'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M0 64C0 28.65 28.65 0 64 0H224V128C224 145.7 238.3 160 256 160H384V207L291.2 244.2C269.9 252.7 256 273.3 256 296.2C256 352.7 274.9 444.2 350.2 504.4C341.2 509.3 330.9 512 320 512H64C28.65 512 0 483.3 0 448V64zM256 128V0L384 128H256zM423.1 225.7C428.8 223.4 435.2 223.4 440.9 225.7L560.9 273.7C570 277.4 576 286.2 576 296C576 359.3 550.1 464.8 441.2 510.2C435.3 512.6 428.7 512.6 422.8 510.2C313.9 464.8 288 359.3 288 296C288 286.2 293.1 277.4 303.1 273.7L423.1 225.7zM432 273.8V461.7C500.2 428.7 523.5 362.7 527.4 311.1L432 273.8z',
			),
		),
		'label'             => __( 'File Shield', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'file-signature'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M292.7 342.3C289.7 345.3 288 349.4 288 353.7V416h62.34c4.264 0 8.35-1.703 11.35-4.727l156.9-158l-67.88-67.88L292.7 342.3zM568.5 167.4L536.6 135.5c-9.875-10-26-10-36 0l-27.25 27.25l67.88 67.88l27.25-27.25C578.5 193.4 578.5 177.3 568.5 167.4zM256 0v128h128L256 0zM256 448c-16.07-.2852-30.62-9.359-37.88-23.88c-2.875-5.875-8-6.5-10.12-6.5s-7.25 .625-10 6.125l-7.749 15.38C187.6 444.6 181.1 448 176 448H174.9c-6.5-.5-12-4.75-14-11L144 386.6L133.4 418.5C127.5 436.1 111 448 92.45 448H80C71.13 448 64 440.9 64 432S71.13 416 80 416h12.4c4.875 0 9.102-3.125 10.6-7.625l18.25-54.63C124.5 343.9 133.6 337.3 144 337.3s19.5 6.625 22.75 16.5l13.88 41.63c19.75-16.25 54.13-9.75 66 14.12C248.5 413.2 252.2 415.6 256 415.9V347c0-8.523 3.402-16.7 9.451-22.71L384 206.5V160H256c-17.67 0-32-14.33-32-32L224 0H48C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h288c26.51 0 48-21.49 48-48V448H256z',
			),
		),
		'label'             => __( 'File Signature', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'file-video'                           => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M256 0v128h128L256 0zM224 128L224 0H48C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h288c26.51 0 48-21.49 48-48V160h-127.1C238.3 160 224 145.7 224 128zM224 384c0 17.67-14.33 32-32 32H96c-17.67 0-32-14.33-32-32V288c0-17.67 14.33-32 32-32h96c17.67 0 32 14.33 32 32V384zM320 284.9v102.3c0 12.57-13.82 20.23-24.48 13.57L256 376v-80l39.52-24.7C306.2 264.6 320 272.3 320 284.9z',
			),
			'regular' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM240 288c0-17.67-14.33-32-32-32h-96c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h96c17.67 0 32-14.33 32-32v-16.52l43.84 30.2C292.3 403.5 304 397.6 304 387.4V284.6c0-10.16-11.64-16.16-20.16-10.32L240 304.5V288z',
			),
		),
		'label'             => __( 'File Video', 'astra' ),
		'custom_categories' => array(
			'communication',
		),
	),
	'file-waveform'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M320 0v128h128L320 0zM288 128L288 0H112C85.49 0 64 21.49 64 48V224H16C7.164 224 0 231.2 0 240v32C0 280.8 7.164 288 16 288h128c6.062 0 11.59 3.438 14.31 8.844L176 332.2l49.69-99.38c5.438-10.81 23.19-10.81 28.62 0L281.9 288H352c8.844 0 16 7.156 16 16S360.8 320 352 320h-80c-6.062 0-11.59-3.438-14.31-8.844L240 275.8l-49.69 99.38C187.6 380.6 182.1 384 176 384s-11.59-3.438-14.31-8.844L134.1 320H64v144C64 490.5 85.49 512 112 512h288c26.51 0 48-21.49 48-48V160h-127.1C302.3 160 288 145.7 288 128z',
			),
		),
		'label'             => __( 'File Waveform', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'file-word'                            => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M224 128L224 0H48C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h288c26.51 0 48-21.49 48-48V160h-127.1C238.3 160 224 145.7 224 128zM281.5 240h23.37c7.717 0 13.43 7.18 11.69 14.7l-42.46 184C272.9 444.1 268 448 262.5 448h-29.26c-5.426 0-10.18-3.641-11.59-8.883L192 329.1l-29.61 109.1C160.1 444.4 156.2 448 150.8 448H121.5c-5.588 0-10.44-3.859-11.69-9.305l-42.46-184C65.66 247.2 71.37 240 79.08 240h23.37c5.588 0 10.44 3.859 11.69 9.301L137.8 352L165.6 248.9C167 243.6 171.8 240 177.2 240h29.61c5.426 0 10.18 3.641 11.59 8.883L246.2 352l23.7-102.7C271.1 243.9 275.1 240 281.5 240zM256 0v128h128L256 0z',
			),
			'regular' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM214.6 248C211.3 238.4 202.2 232 192 232s-19.25 6.406-22.62 16L144.7 318.1l-25.89-77.66C114.6 227.8 101 221.2 88.41 225.2C75.83 229.4 69.05 243 73.23 255.6l48 144C124.5 409.3 133.5 415.9 143.8 416c10.17 0 19.45-6.406 22.83-16L192 328.1L217.4 400C220.8 409.6 229.8 416 240 416c10.27-.0938 19.53-6.688 22.77-16.41l48-144c4.188-12.59-2.594-26.16-15.17-30.38c-12.61-4.125-26.2 2.594-30.36 15.19l-25.89 77.66L214.6 248z',
			),
		),
		'label'             => __( 'File Word', 'astra' ),
		'custom_categories' => array(),
	),
	'file-zipper'                          => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M256 0v128h128L256 0zM224 128L224 0H48C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h288c26.51 0 48-21.49 48-48V160h-127.1C238.3 160 224 145.7 224 128zM96 32h64v32H96V32zM96 96h64v32H96V96zM96 160h64v32H96V160zM128.3 415.1c-40.56 0-70.76-36.45-62.83-75.45L96 224h64l30.94 116.9C198.7 379.7 168.5 415.1 128.3 415.1zM144 336h-32C103.2 336 96 343.2 96 352s7.164 16 16 16h32C152.8 368 160 360.8 160 352S152.8 336 144 336z',
			),
			'regular' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0L64-.0001c-35.35 0-64 28.65-64 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h48V64h64V48.13h48.01L224 128c0 17.67 14.33 32 32 32h79.1V448zM176 96h-64v32h64V96zM176 160h-64v32h64V160zM176 224h-64l-30.56 116.5C73.51 379.5 103.7 416 144.3 416c40.26 0 70.45-36.3 62.68-75.15L176 224zM160 368H128c-8.836 0-16-7.164-16-16s7.164-16 16-16h32c8.836 0 16 7.164 16 16S168.8 368 160 368z',
			),
		),
		'label'             => __( 'File Zipper', 'astra' ),
		'custom_categories' => array(),
	),
	'fill'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M168 90.74L221.1 37.66C249.2 9.539 294.8 9.539 322.9 37.66L474.3 189.1C502.5 217.2 502.5 262.8 474.3 290.9L283.9 481.4C246.4 518.9 185.6 518.9 148.1 481.4L30.63 363.9C-6.863 326.4-6.863 265.6 30.63 228.1L122.7 135.1L41.37 54.63C28.88 42.13 28.88 21.87 41.37 9.372C53.87-3.124 74.13-3.124 86.63 9.372L168 90.74zM75.88 273.4C71.69 277.6 68.9 282.6 67.52 287.1H386.7L429.1 245.7C432.2 242.5 432.2 237.5 429.1 234.3L277.7 82.91C274.5 79.79 269.5 79.79 266.3 82.91L213.3 136L262.6 185.4C275.1 197.9 275.1 218.1 262.6 230.6C250.1 243.1 229.9 243.1 217.4 230.6L168 181.3L75.88 273.4z',
			),
		),
		'label'             => __( 'Fill', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'fill-drip'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M41.37 9.372C53.87-3.124 74.13-3.124 86.63 9.372L168 90.74L221.1 37.66C249.2 9.539 294.8 9.539 322.9 37.66L474.3 189.1C502.5 217.2 502.5 262.8 474.3 290.9L283.9 481.4C246.4 518.9 185.6 518.9 148.1 481.4L30.63 363.9C-6.863 326.4-6.863 265.6 30.63 228.1L122.7 135.1L41.37 54.63C28.88 42.13 28.88 21.87 41.37 9.372V9.372zM217.4 230.6L168 181.3L75.88 273.4C71.69 277.6 68.9 282.6 67.52 288H386.7L429.1 245.7C432.2 242.5 432.2 237.5 429.1 234.3L277.7 82.91C274.5 79.79 269.5 79.79 266.3 82.91L213.3 136L262.6 185.4C275.1 197.9 275.1 218.1 262.6 230.6C250.1 243.1 229.9 243.1 217.4 230.6L217.4 230.6zM448 448C448 422.8 480.6 368.4 499.2 339.3C505.3 329.9 518.7 329.9 524.8 339.3C543.4 368.4 576 422.8 576 448C576 483.3 547.3 512 512 512C476.7 512 448 483.3 448 448H448z',
			),
		),
		'label'             => __( 'Fill Drip', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'film'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M463.1 32h-416C21.49 32-.0001 53.49-.0001 80v352c0 26.51 21.49 48 47.1 48h416c26.51 0 48-21.49 48-48v-352C511.1 53.49 490.5 32 463.1 32zM111.1 408c0 4.418-3.582 8-8 8H55.1c-4.418 0-8-3.582-8-8v-48c0-4.418 3.582-8 8-8h47.1c4.418 0 8 3.582 8 8L111.1 408zM111.1 280c0 4.418-3.582 8-8 8H55.1c-4.418 0-8-3.582-8-8v-48c0-4.418 3.582-8 8-8h47.1c4.418 0 8 3.582 8 8V280zM111.1 152c0 4.418-3.582 8-8 8H55.1c-4.418 0-8-3.582-8-8v-48c0-4.418 3.582-8 8-8h47.1c4.418 0 8 3.582 8 8L111.1 152zM351.1 400c0 8.836-7.164 16-16 16H175.1c-8.836 0-16-7.164-16-16v-96c0-8.838 7.164-16 16-16h160c8.836 0 16 7.162 16 16V400zM351.1 208c0 8.836-7.164 16-16 16H175.1c-8.836 0-16-7.164-16-16v-96c0-8.838 7.164-16 16-16h160c8.836 0 16 7.162 16 16V208zM463.1 408c0 4.418-3.582 8-8 8h-47.1c-4.418 0-7.1-3.582-7.1-8l0-48c0-4.418 3.582-8 8-8h47.1c4.418 0 8 3.582 8 8V408zM463.1 280c0 4.418-3.582 8-8 8h-47.1c-4.418 0-8-3.582-8-8v-48c0-4.418 3.582-8 8-8h47.1c4.418 0 8 3.582 8 8V280zM463.1 152c0 4.418-3.582 8-8 8h-47.1c-4.418 0-8-3.582-8-8l0-48c0-4.418 3.582-8 7.1-8h47.1c4.418 0 8 3.582 8 8V152z',
			),
		),
		'label'             => __( 'Film', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
		),
	),
	'filter'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M3.853 54.87C10.47 40.9 24.54 32 40 32H472C487.5 32 501.5 40.9 508.1 54.87C514.8 68.84 512.7 85.37 502.1 97.33L320 320.9V448C320 460.1 313.2 471.2 302.3 476.6C291.5 482 278.5 480.9 268.8 473.6L204.8 425.6C196.7 419.6 192 410.1 192 400V320.9L9.042 97.33C-.745 85.37-2.765 68.84 3.854 54.87L3.853 54.87z',
			),
		),
		'label'             => __( 'Filter', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'filter-circle-dollar'                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M3.853 22.87C10.47 8.904 24.54 0 40 0H472C487.5 0 501.5 8.904 508.1 22.87C514.8 36.84 512.7 53.37 502.1 65.33L396.4 195.6C316.2 212.1 255.1 283 255.1 368C255.1 395.4 262.3 421.4 273.5 444.5C271.8 443.7 270.3 442.7 268.8 441.6L204.8 393.6C196.7 387.6 192 378.1 192 368V288.9L9.042 65.33C-.745 53.37-2.765 36.84 3.854 22.87H3.853zM576 368C576 447.5 511.5 512 432 512C352.5 512 287.1 447.5 287.1 368C287.1 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368zM413 331.1C418.1 329.3 425.6 327.9 431.8 328C439.1 328.1 448.9 329.8 458.1 332.1C466.7 334.2 475.4 328.1 477.5 320.4C479.7 311.8 474.4 303.2 465.9 301C460.3 299.6 454.3 298.3 448 297.4V288C448 279.2 440.8 272 432 272C423.2 272 416 279.2 416 288V297.5C409.9 298.7 403.7 300.7 397.1 303.8C386.1 310.1 374.9 322.2 376.1 341C377.1 357 387.8 366.4 397.7 371.7C406.6 376.4 417.5 379.5 426.3 381.1L428.1 382.5C438.3 385.4 445.1 387.7 451.2 390.8C455.8 393.5 455.1 395.1 455.1 396.5C456.1 398.9 455.5 400.2 454.1 401C454.3 401.1 453.2 403.2 450.1 404.4C446.3 406.9 439.2 408.2 432.5 407.1C422.1 407.7 414 404.8 402.6 401.2C400.7 400.6 398.8 400 396.8 399.4C388.3 396.8 379.3 401.5 376.7 409.9C374.1 418.3 378.8 427.3 387.2 429.9C388.9 430.4 390.5 430.1 392.3 431.5C399.3 433.8 407.4 436.4 416 438.1V449.5C416 458.4 423.2 465.5 432 465.5C440.8 465.5 448 458.4 448 449.5V438.7C454.2 437.6 460.5 435.6 466.3 432.5C478.3 425.9 488.5 413.8 487.1 395.5C487.5 379.4 477.7 369.3 467.5 363.3C458.1 357.7 446.2 354.4 436.9 351.7L436.8 351.7C426.3 348.7 418.5 346.5 412.9 343.5C408.1 340.9 408.1 339.5 408.1 339.1L408.1 338.1C407.9 337 408.4 336.1 408.8 335.4C409.4 334.5 410.6 333.3 413 331.1L413 331.1z',
			),
		),
		'label'             => __( 'Filter Circle Dollar', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'filter-circle-xmark'                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M3.853 22.87C10.47 8.904 24.54 0 40 0H472C487.5 0 501.5 8.904 508.1 22.87C514.8 36.84 512.7 53.37 502.1 65.33L396.4 195.6C316.2 212.1 255.1 283 255.1 368C255.1 395.4 262.3 421.4 273.5 444.5C271.8 443.7 270.3 442.7 268.8 441.6L204.8 393.6C196.7 387.6 192 378.1 192 368V288.9L9.042 65.33C-.745 53.37-2.765 36.84 3.854 22.87H3.853zM287.1 368C287.1 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 287.1 447.5 287.1 368zM491.3 331.3C497.6 325.1 497.6 314.9 491.3 308.7C485.1 302.4 474.9 302.4 468.7 308.7L432 345.4L395.3 308.7C389.1 302.4 378.9 302.4 372.7 308.7C366.4 314.9 366.4 325.1 372.7 331.3L409.4 368L372.7 404.7C366.4 410.9 366.4 421.1 372.7 427.3C378.9 433.6 389.1 433.6 395.3 427.3L432 390.6L468.7 427.3C474.9 433.6 485.1 433.6 491.3 427.3C497.6 421.1 497.6 410.9 491.3 404.7L454.6 368L491.3 331.3z',
			),
		),
		'label'             => __( 'Filter Circle Xmark', 'astra' ),
		'custom_categories' => array(),
	),
	'fingerprint'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256.1 246c-13.25 0-23.1 10.75-23.1 23.1c1.125 72.25-8.124 141.9-27.75 211.5C201.7 491.3 206.6 512 227.5 512c10.5 0 20.12-6.875 23.12-17.5c13.5-47.87 30.1-125.4 29.5-224.5C280.1 256.8 269.4 246 256.1 246zM255.2 164.3C193.1 164.1 151.2 211.3 152.1 265.4c.75 47.87-3.75 95.87-13.37 142.5c-2.75 12.1 5.624 25.62 18.62 28.37c12.1 2.625 25.62-5.625 28.37-18.62c10.37-50.12 15.12-101.6 14.37-152.1C199.7 238.6 219.1 212.1 254.5 212.3c31.37 .5 57.24 25.37 57.62 55.5c.8749 47.1-2.75 96.25-10.62 143.5c-2.125 12.1 6.749 25.37 19.87 27.62c19.87 3.25 26.75-15.12 27.5-19.87c8.249-49.1 12.12-101.1 11.25-151.1C359.2 211.1 312.2 165.1 255.2 164.3zM144.6 144.5C134.2 136.1 119.2 137.6 110.7 147.9C85.25 179.4 71.38 219.3 72 259.9c.6249 37.62-2.375 75.37-8.999 112.1c-2.375 12.1 6.249 25.5 19.25 27.87c20.12 3.5 27.12-14.87 27.1-19.37c7.124-39.87 10.5-80.62 9.749-121.4C119.6 229.3 129.2 201.3 147.1 178.3C156.4 167.9 154.9 152.9 144.6 144.5zM253.1 82.14C238.6 81.77 223.1 83.52 208.2 87.14c-12.87 2.1-20.87 15.1-17.87 28.87c3.125 12.87 15.1 20.75 28.1 17.75C230.4 131.3 241.7 130 253.4 130.1c75.37 1.125 137.6 61.5 138.9 134.6c.5 37.87-1.375 75.1-5.624 113.6c-1.5 13.12 7.999 24.1 21.12 26.5c16.75 1.1 25.5-11.87 26.5-21.12c4.625-39.75 6.624-79.75 5.999-119.7C438.6 165.3 355.1 83.64 253.1 82.14zM506.1 203.6c-2.875-12.1-15.51-21.25-28.63-18.38c-12.1 2.875-21.12 15.75-18.25 28.62c4.75 21.5 4.875 37.5 4.75 61.62c-.1249 13.25 10.5 24.12 23.75 24.25c13.12 0 24.12-10.62 24.25-23.87C512.1 253.8 512.3 231.8 506.1 203.6zM465.1 112.9c-48.75-69.37-128.4-111.7-213.3-112.9c-69.74-.875-134.2 24.84-182.2 72.96c-46.37 46.37-71.34 108-70.34 173.6l-.125 21.5C-.3651 281.4 10.01 292.4 23.26 292.8C23.51 292.9 23.76 292.9 24.01 292.9c12.1 0 23.62-10.37 23.1-23.37l.125-23.62C47.38 193.4 67.25 144 104.4 106.9c38.87-38.75 91.37-59.62 147.7-58.87c69.37 .1 134.7 35.62 174.6 92.37c7.624 10.87 22.5 13.5 33.37 5.875C470.1 138.6 473.6 123.8 465.1 112.9z',
			),
		),
		'label'             => __( 'Fingerprint', 'astra' ),
		'custom_categories' => array(
			'design',
			'science-and-technology',
		),
	),
	'fire'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M323.5 51.25C302.8 70.5 284 90.75 267.4 111.1C240.1 73.62 206.2 35.5 168 0C69.75 91.12 0 210 0 281.6C0 408.9 100.2 512 224 512s224-103.1 224-230.4C448 228.4 396 118.5 323.5 51.25zM304.1 391.9C282.4 407 255.8 416 226.9 416c-72.13 0-130.9-47.73-130.9-125.2c0-38.63 24.24-72.64 72.74-130.8c7 8 98.88 125.4 98.88 125.4l58.63-66.88c4.125 6.75 7.867 13.52 11.24 19.9C364.9 290.6 353.4 357.4 304.1 391.9z',
			),
		),
		'label'             => __( 'Fire', 'astra' ),
		'custom_categories' => array(
			'environment',
			'lifestyle-and-hobbies',
			'science-and-technology',
			'travel',
		),
	),
	'fire-burner'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M349 61.49C356.9 51.61 365.8 40.76 375.5 31.99C381.1 26.87 389.9 26.89 395.5 32.03C420.2 54.71 441.1 84.69 455.8 113.2C470.4 141.2 480 169.9 480 190.1C480 277.9 408.7 352 320 352C230.3 352 160 277.8 160 190.1C160 163.7 172.7 131.5 192.4 99.52C212.4 67.16 240.5 33.43 273.8 3.734C279.4-1.26 287.1-1.242 293.5 3.773C313.3 21.55 331.8 40.74 349 61.49V61.49zM390 176.1C388 172.1 386 168.1 383 164.1L347 206.1C347 206.1 289 132.1 285 127.1C255 164.1 240 185.1 240 209.1C240 258.1 276 287.1 320.1 287.1C339 287.1 355 282.1 370 272.1C400 251.1 408 209.1 390 176.1zM32 287.1C32 270.3 46.33 255.1 64 255.1H96C113.7 255.1 128 270.3 128 287.1C128 305.7 113.7 319.1 96 319.1V384H544V319.1C526.3 319.1 512 305.7 512 287.1C512 270.3 526.3 255.1 544 255.1H576C593.7 255.1 608 270.3 608 287.1V384C625.7 384 640 398.3 640 416V480C640 497.7 625.7 512 608 512H32C14.33 512 0 497.7 0 480V416C0 398.3 14.33 384 32 384V287.1zM320 480C337.7 480 352 465.7 352 448C352 430.3 337.7 416 320 416C302.3 416 288 430.3 288 448C288 465.7 302.3 480 320 480zM448 416C430.3 416 416 430.3 416 448C416 465.7 430.3 480 448 480C465.7 480 480 465.7 480 448C480 430.3 465.7 416 448 416zM192 480C209.7 480 224 465.7 224 448C224 430.3 209.7 416 192 416C174.3 416 160 430.3 160 448C160 465.7 174.3 480 192 480z',
			),
		),
		'label'             => __( 'Fire Burner', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'fire-extinguisher'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M64 480c0 17.67 14.33 32 31.1 32H256c17.67 0 31.1-14.33 31.1-32l-.0001-32H64L64 480zM503.4 5.56c-5.453-4.531-12.61-6.406-19.67-5.188l-175.1 32c-11.41 2.094-19.7 12.03-19.7 23.63L224 56L224 32c0-17.67-14.33-32-31.1-32H160C142.3 0 128 14.33 128 32l.0002 26.81C69.59 69.32 20.5 110.6 1.235 168.4C-2.952 181 3.845 194.6 16.41 198.8C18.94 199.6 21.48 200 24 200c10.05 0 19.42-6.344 22.77-16.41C59.45 145.5 90.47 117.8 128 108L128 139.2C90.27 157.2 64 195.4 64 240L64 416h223.1l.0001-176c0-44.6-26.27-82.79-63.1-100.8L224 104l63.1-.002c0 11.59 8.297 21.53 19.7 23.62l175.1 31.1c1.438 .25 2.875 .375 4.297 .375c5.578 0 11.03-1.938 15.37-5.562c5.469-4.562 8.625-11.31 8.625-18.44V23.1C511.1 16.87 508.8 10.12 503.4 5.56zM176 96C167.2 96 160 88.84 160 80S167.2 64 176 64s15.1 7.164 15.1 16S184.8 96 176 96z',
			),
		),
		'label'             => __( 'Fire Extinguisher', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
			'travel',
		),
	),
	'fire-flame-curved'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M384 319.1C384 425.9 297.9 512 192 512s-192-86.13-192-192c0-58.67 27.82-106.8 54.57-134.1C69.54 169.3 96 179.8 96 201.5v85.5c0 35.17 27.97 64.5 63.16 64.94C194.9 352.5 224 323.6 224 288c0-88-175.1-96.12-52.15-277.2c13.5-19.72 44.15-10.77 44.15 13.03C215.1 127 384 149.7 384 319.1z',
			),
		),
		'label'             => __( 'Fire Flame Curved', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'science-and-technology',
			'travel',
		),
	),
	'fire-flame-simple'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M203.1 4.365c-6.177-5.82-16.06-5.819-22.23-.0007C74.52 104.5 0 234.1 0 312C0 437.9 79 512 192 512s192-74.05 192-200C384 233.9 309 104.2 203.1 4.365zM192 432c-56.5 0-96-37.76-96-91.74c0-12.47 4.207-55.32 83.87-143c6.314-6.953 17.95-6.953 24.26 0C283.8 284.9 288 327.8 288 340.3C288 394.2 248.5 432 192 432z',
			),
		),
		'label'             => __( 'Fire Flame Simple', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'science-and-technology',
		),
	),
	'firefox'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M503.5 241.5c-.12-1.56-.24-3.12-.24-4.68v-.12l-.36-4.68v-.12a245.9 245.9 0 0 0 -7.32-41.15c0-.12 0-.12-.12-.24l-1.08-4c-.12-.24-.12-.48-.24-.6-.36-1.2-.72-2.52-1.08-3.72-.12-.24-.12-.6-.24-.84-.36-1.2-.72-2.4-1.08-3.48-.12-.36-.24-.6-.36-1-.36-1.2-.72-2.28-1.2-3.48l-.36-1.08c-.36-1.08-.84-2.28-1.2-3.36a8.27 8.27 0 0 0 -.36-1c-.48-1.08-.84-2.28-1.32-3.36-.12-.24-.24-.6-.36-.84-.48-1.2-1-2.28-1.44-3.48 0-.12-.12-.24-.12-.36-1.56-3.84-3.24-7.68-5-11.4l-.36-.72c-.48-1-.84-1.8-1.32-2.64-.24-.48-.48-1.08-.72-1.56-.36-.84-.84-1.56-1.2-2.4-.36-.6-.6-1.2-1-1.8s-.84-1.44-1.2-2.28c-.36-.6-.72-1.32-1.08-1.92s-.84-1.44-1.2-2.16a18.07 18.07 0 0 0 -1.2-2c-.36-.72-.84-1.32-1.2-2s-.84-1.32-1.2-2-.84-1.32-1.2-1.92-.84-1.44-1.32-2.16a15.63 15.63 0 0 0 -1.2-1.8L463.2 119a15.63 15.63 0 0 0 -1.2-1.8c-.48-.72-1.08-1.56-1.56-2.28-.36-.48-.72-1.08-1.08-1.56l-1.8-2.52c-.36-.48-.6-.84-1-1.32-1-1.32-1.8-2.52-2.76-3.72a248.8 248.8 0 0 0 -23.51-26.64A186.8 186.8 0 0 0 412 62.46c-4-3.48-8.16-6.72-12.48-9.84a162.5 162.5 0 0 0 -24.6-15.12c-2.4-1.32-4.8-2.52-7.2-3.72a254 254 0 0 0 -55.43-19.56c-1.92-.36-3.84-.84-5.64-1.2h-.12c-1-.12-1.8-.36-2.76-.48a236.4 236.4 0 0 0 -38-4H255.1a234.6 234.6 0 0 0 -45.48 5c-33.59 7.08-63.23 21.24-82.91 39-1.08 1-1.92 1.68-2.4 2.16l-.48 .48H124l-.12 .12 .12-.12a.12 .12 0 0 0 .12-.12l-.12 .12a.42 .42 0 0 1 .24-.12c14.64-8.76 34.92-16 49.44-19.56l5.88-1.44c.36-.12 .84-.12 1.2-.24 1.68-.36 3.36-.72 5.16-1.08 .24 0 .6-.12 .84-.12C250.9 20.94 319.3 40.14 367 85.61a171.5 171.5 0 0 1 26.88 32.76c30.36 49.2 27.48 111.1 3.84 147.6-34.44 53-111.3 71.27-159 24.84a84.19 84.19 0 0 1 -25.56-59 74.05 74.05 0 0 1 6.24-31c1.68-3.84 13.08-25.67 18.24-24.59-13.08-2.76-37.55 2.64-54.71 28.19-15.36 22.92-14.52 58.2-5 83.28a132.9 132.9 0 0 1 -12.12-39.24c-12.24-82.55 43.31-153 94.31-170.5-27.48-24-96.47-22.31-147.7 15.36-29.88 22-51.23 53.16-62.51 90.36 1.68-20.88 9.6-52.08 25.8-83.88-17.16 8.88-39 37-49.8 62.88-15.6 37.43-21 82.19-16.08 124.8 .36 3.24 .72 6.36 1.08 9.6 19.92 117.1 122 206.4 244.8 206.4C392.8 503.4 504 392.2 504 255 503.9 250.5 503.8 245.9 503.5 241.5z',
			),
		),
		'label'             => __( 'Firefox', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'firefox-browser'                      => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M130.2 127.5C130.4 127.6 130.3 127.6 130.2 127.5V127.5zM481.6 172.9C471 147.4 449.6 119.9 432.7 111.2C446.4 138.1 454.4 165 457.4 185.2C457.4 185.3 457.4 185.4 457.5 185.6C429.9 116.8 383.1 89.11 344.9 28.75C329.9 5.058 333.1 3.518 331.8 4.088L331.7 4.158C284.1 30.11 256.4 82.53 249.1 126.9C232.5 127.8 216.2 131.9 201.2 139C199.8 139.6 198.7 140.7 198.1 142C197.4 143.4 197.2 144.9 197.5 146.3C197.7 147.2 198.1 147.1 198.6 148.6C199.1 149.3 199.8 149.9 200.5 150.3C201.3 150.7 202.1 150.1 202.1 151.1C203.8 151.1 204.7 151 205.5 150.8L206 150.6C221.5 143.3 238.4 139.4 255.5 139.2C318.4 138.7 352.7 183.3 363.2 201.5C350.2 192.4 326.8 183.3 304.3 187.2C392.1 231.1 368.5 381.8 246.1 376.4C187.5 373.8 149.9 325.5 146.4 285.6C146.4 285.6 157.7 243.7 227 243.7C234.5 243.7 255.1 222.8 256.4 216.7C256.3 214.7 213.8 197.8 197.3 181.5C188.4 172.8 184.2 168.6 180.5 165.5C178.5 163.8 176.4 162.2 174.2 160.7C168.6 141.2 168.4 120.6 173.5 101.1C148.4 112.5 128.1 130.5 114.8 146.4H114.7C105 134.2 105.7 93.78 106.3 85.35C106.1 84.82 99.02 89.02 98.1 89.66C89.53 95.71 81.55 102.6 74.26 110.1C57.97 126.7 30.13 160.2 18.76 211.3C14.22 231.7 12 255.7 12 263.6C12 398.3 121.2 507.5 255.9 507.5C376.6 507.5 478.9 420.3 496.4 304.9C507.9 228.2 481.6 173.8 481.6 172.9z',
			),
		),
		'label'             => __( 'Firefox Browser', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'first-order'                          => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M12.9 229.2c.1-.1 .2-.3 .3-.4 0 .1 0 .3-.1 .4h-.2zM224 96.6c-7.1 0-14.6 .6-21.4 1.7l3.7 67.4-22-64c-14.3 3.7-27.7 9.4-40 16.6l29.4 61.4-45.1-50.9c-11.4 8.9-21.7 19.1-30.6 30.9l50.6 45.4-61.1-29.7c-7.1 12.3-12.9 25.7-16.6 40l64.3 22.6-68-4c-.9 7.1-1.4 14.6-1.4 22s.6 14.6 1.4 21.7l67.7-4-64 22.6c3.7 14.3 9.4 27.7 16.6 40.3l61.1-29.7L97.7 352c8.9 11.7 19.1 22.3 30.9 30.9l44.9-50.9-29.5 61.4c12.3 7.4 25.7 13.1 40 16.9l22.3-64.6-4 68c7.1 1.1 14.6 1.7 21.7 1.7 7.4 0 14.6-.6 21.7-1.7l-4-68.6 22.6 65.1c14.3-4 27.7-9.4 40-16.9L274.9 332l44.9 50.9c11.7-8.9 22-19.1 30.6-30.9l-50.6-45.1 61.1 29.4c7.1-12.3 12.9-25.7 16.6-40.3l-64-22.3 67.4 4c1.1-7.1 1.4-14.3 1.4-21.7s-.3-14.9-1.4-22l-67.7 4 64-22.3c-3.7-14.3-9.1-28-16.6-40.3l-60.9 29.7 50.6-45.4c-8.9-11.7-19.1-22-30.6-30.9l-45.1 50.9 29.4-61.1c-12.3-7.4-25.7-13.1-40-16.9L241.7 166l4-67.7c-7.1-1.2-14.3-1.7-21.7-1.7zM443.4 128v256L224 512 4.6 384V128L224 0l219.4 128zm-17.1 10.3L224 20.9 21.7 138.3v235.1L224 491.1l202.3-117.7V138.3zM224 37.1l187.7 109.4v218.9L224 474.9 36.3 365.4V146.6L224 37.1zm0 50.9c-92.3 0-166.9 75.1-166.9 168 0 92.6 74.6 167.7 166.9 167.7 92 0 166.9-75.1 166.9-167.7 0-92.9-74.9-168-166.9-168z',
			),
		),
		'label'             => __( 'First Order', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'first-order-alt'                      => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S384.1 8 248 8zm0 488.2C115.3 496.2 7.79 388.7 7.79 256S115.3 15.79 248 15.79 488.2 123.3 488.2 256 380.7 496.2 248 496.2zm0-459.9C126.7 36.29 28.29 134.7 28.29 256S126.7 475.7 248 475.7 467.7 377.3 467.7 256 369.3 36.29 248 36.29zm0 431.2c-116.8 0-211.5-94.69-211.5-211.5S131.2 44.49 248 44.49 459.5 139.2 459.5 256 364.8 467.5 248 467.5zm186.2-162.1a191.6 191.6 0 0 1 -20.13 48.69l-74.13-35.88 61.48 54.82a193.5 193.5 0 0 1 -37.2 37.29l-54.8-61.57 35.88 74.27a190.9 190.9 0 0 1 -48.63 20.23l-27.29-78.47 4.79 82.93c-8.61 1.18-17.4 1.8-26.33 1.8s-17.72-.62-26.33-1.8l4.76-82.46-27.15 78.03a191.4 191.4 0 0 1 -48.65-20.2l35.93-74.34-54.87 61.64a193.9 193.9 0 0 1 -37.22-37.28l61.59-54.9-74.26 35.93a191.6 191.6 0 0 1 -20.14-48.69l77.84-27.11-82.23 4.76c-1.16-8.57-1.78-17.32-1.78-26.21 0-9 .63-17.84 1.82-26.51l82.38 4.77-77.94-27.16a191.7 191.7 0 0 1 20.23-48.67l74.22 35.92-61.52-54.86a193.9 193.9 0 0 1 37.28-37.22l54.76 61.53-35.83-74.17a191.5 191.5 0 0 1 48.65-20.13l26.87 77.25-4.71-81.61c8.61-1.18 17.39-1.8 26.32-1.8s17.71 .62 26.32 1.8l-4.74 82.16 27.05-77.76c17.27 4.5 33.6 11.35 48.63 20.17l-35.82 74.12 54.72-61.47a193.1 193.1 0 0 1 37.24 37.23l-61.45 54.77 74.12-35.86a191.5 191.5 0 0 1 20.2 48.65l-77.81 27.1 82.24-4.75c1.19 8.66 1.82 17.5 1.82 26.49 0 8.88-.61 17.63-1.78 26.19l-82.12-4.75 77.72 27.09z',
			),
		),
		'label'             => __( 'Alternate First Order', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'firstdraft'                           => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M384 192h-64v128H192v128H0v-25.6h166.4v-128h128v-128H384V192zm-25.6 38.4v128h-128v128H64V512h192V384h128V230.4h-25.6zm25.6 192h-89.6V512H320v-64h64v-25.6zM0 0v384h128V256h128V128h128V0H0z',
			),
		),
		'label'             => __( 'firstdraft', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'fish'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M180.5 141.5C219.7 108.5 272.6 80 336 80C399.4 80 452.3 108.5 491.5 141.5C530.5 174.5 558.3 213.1 572.4 241.3C577.2 250.5 577.2 261.5 572.4 270.7C558.3 298 530.5 337.5 491.5 370.5C452.3 403.5 399.4 432 336 432C272.6 432 219.7 403.5 180.5 370.5C164.3 356.7 150 341.9 137.8 327.3L48.12 379.6C35.61 386.9 19.76 384.9 9.474 374.7C-.8133 364.5-2.97 348.7 4.216 336.1L50 256L4.216 175.9C-2.97 163.3-.8133 147.5 9.474 137.3C19.76 127.1 35.61 125.1 48.12 132.4L137.8 184.7C150 170.1 164.3 155.3 180.5 141.5L180.5 141.5zM416 224C398.3 224 384 238.3 384 256C384 273.7 398.3 288 416 288C433.7 288 448 273.7 448 256C448 238.3 433.7 224 416 224z',
			),
		),
		'label'             => __( 'Fish', 'astra' ),
		'custom_categories' => array(
			'environment',
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'fish-fins'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M352.8 96.61C407.7 100.6 454.3 123.6 490 150.4C529.2 179.8 557.3 215.1 571.7 239.9C577.4 249.9 577.4 262.1 571.7 272.1C557.3 296.9 529.2 332.2 490 361.6C454.3 388.4 407.7 411.4 352.8 415.4L275.2 473.6C264.6 481.6 250.2 482.1 238.9 475.1C227.7 468 222 454.7 224.6 441.7L234.3 393.1C214.1 384.1 197.5 373.2 181.1 361.6C166.6 350.1 152.1 337.7 141.2 325.3L48.12 379.6C35.61 386.9 19.76 384.9 9.475 374.7C-.8124 364.5-2.969 348.7 4.217 336.1L50 256L4.217 175.9C-2.969 163.3-.8124 147.5 9.475 137.3C19.76 127.1 35.61 125.1 48.12 132.4L141.2 186.7C152.1 174.3 166.6 161.9 181.1 150.4C197.5 138.8 214.1 127.9 234.3 118.9L224.6 70.28C222 57.27 227.7 44 238.9 36.93C250.2 29.85 264.6 30.44 275.2 38.4L352.8 96.61zM416 224C398.3 224 384 238.3 384 256C384 273.7 398.3 288 416 288C433.7 288 448 273.7 448 256C448 238.3 433.7 224 416 224z',
			),
		),
		'label'             => __( 'Fish Fins', 'astra' ),
		'custom_categories' => array(
			'environment',
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'flag'                                 => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M64 496C64 504.8 56.75 512 48 512h-32C7.25 512 0 504.8 0 496V32c0-17.75 14.25-32 32-32s32 14.25 32 32V496zM476.3 0c-6.365 0-13.01 1.35-19.34 4.233c-45.69 20.86-79.56 27.94-107.8 27.94c-59.96 0-94.81-31.86-163.9-31.87C160.9 .3055 131.6 4.867 96 15.75v350.5c32-9.984 59.87-14.1 84.85-14.1c73.63 0 124.9 31.78 198.6 31.78c31.91 0 68.02-5.971 111.1-23.09C504.1 355.9 512 344.4 512 332.1V30.73C512 11.1 495.3 0 476.3 0z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M476.3 0c-6.365 0-13.01 1.35-19.34 4.233c-45.69 20.86-79.56 27.94-107.8 27.94c-59.96 0-94.81-31.86-163.9-31.87c-34.63 0-77.87 8.003-137.2 32.05V24C48 10.75 37.25 0 24 0S0 10.75 0 24v464C0 501.3 10.75 512 24 512s24-10.75 24-24v-104c53.59-23.86 96.02-31.81 132.8-31.81c73.63 0 124.9 31.78 198.6 31.78c31.91 0 68.02-5.971 111.1-23.09C504.1 355.9 512 344.4 512 332.1V30.73C512 11.1 495.3 0 476.3 0zM464 319.8c-30.31 10.82-58.08 16.1-84.6 16.1c-30.8 0-58.31-7-87.44-14.41c-32.01-8.141-68.29-17.37-111.1-17.37c-42.35 0-85.99 9.09-132.8 27.73V84.14l18.03-7.301c47.39-19.2 86.38-28.54 119.2-28.54c28.24 .0039 49.12 6.711 73.31 14.48c25.38 8.148 54.13 17.39 90.58 17.39c35.43 0 72.24-8.496 114.9-26.61V319.8z',
			),
		),
		'label'             => __( 'Flag', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'flag-checkered'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M509.5 .0234c-6.145 0-12.53 1.344-18.64 4.227c-44.11 20.86-76.81 27.94-104.1 27.94c-57.89 0-91.53-31.86-158.2-31.87C195 .3203 153.3 8.324 96 32.38V32c0-17.75-14.25-32-32-32S32 14.25 32 32L31.96 496c0 8.75 7.25 16 16 16H80C88.75 512 96 504.8 96 496V384c51.74-23.86 92.71-31.82 128.3-31.82c71.09 0 120.6 31.78 191.7 31.78c30.81 0 65.67-5.969 108.1-23.09C536.3 355.9 544 344.4 544 332.1V30.74C544 12.01 527.8 .0234 509.5 .0234zM480 141.8c-31.99 14.04-57.81 20.59-80 22.49v80.21c25.44-1.477 51.59-6.953 80-17.34V308.9c-22.83 7.441-43.93 11.08-64.03 11.08c-5.447 0-10.71-.4258-15.97-.8906V244.5c-4.436 .2578-8.893 .6523-13.29 .6523c-25.82 0-47.35-4.547-66.71-10.08v66.91c-23.81-6.055-50.17-11.41-80-12.98V213.1C236.2 213.7 232.5 213.3 228.5 213.3C208.8 213.3 185.1 217.7 160 225.1v69.1C139.2 299.4 117.9 305.8 96 314.4V250.7l24.77-10.39C134.8 234.5 147.6 229.9 160 225.1V143.4C140.9 148.5 120.1 155.2 96 165.3V101.8l24.77-10.39C134.8 85.52 147.6 80.97 160 77.02v66.41c26.39-6.953 49.09-10.17 68.48-10.16c4.072 0 7.676 .4453 11.52 .668V65.03C258.6 66.6 274.4 71.55 293.2 77.83C301.7 80.63 310.7 83.45 320 86.12v66.07c20.79 6.84 41.45 12.96 66.71 12.96c4.207 0 8.781-.4766 13.29-.8594V95.54c25.44-1.477 51.59-6.953 80-17.34V141.8zM240 133.9v80.04c18.61 1.57 34.37 6.523 53.23 12.8C301.7 229.6 310.7 232.4 320 235.1V152.2C296.1 144.3 271.6 135.8 240 133.9z',
			),
		),
		'label'             => __( 'Flag Checkered', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'flag-usa'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M544 61.63V30.74c0-25-28.81-37.99-53.17-26.49C306.3 91.5 321.5-62.25 96 32.38V32c0-17.75-14.25-32-32-32S32 14.25 32 32L31.96 496c0 8.75 7.25 16 15.1 16H80C88.75 512 96 504.8 96 496V384c200-92.25 238.8 53.25 428.1-23.12C536.3 355.9 544 344.4 544 332.1V296.1c-46.98 17.25-86.42 24.12-120.8 24.12c-40.25-.125-74.17-8.5-107.7-16.62C254 288.5 195.3 274.8 96 314.8v-34.5c102-37.63 166.5-22.75 228.4-7.625C385.1 287.8 444.7 301.4 544 261.5V200c-46.98 17.25-86.42 24.12-120.8 24.12c-40.25 0-74.17-8.375-107.7-16.5C254 192.5 195.3 178.8 96 218.8v-34.5c102-37.5 166.5-22.62 228.4-7.5C385.1 191.8 444.7 205.4 544 165.6V96.75c-57.75 23.5-100.4 31.38-135.8 31.38c-62.96 0-118.9-27.09-120.2-27.38V67.5C331.9 78.94 390.1 128.3 544 61.63zM160 136c-8.75 0-16-7.125-16-16s7.25-16 16-16s16 7.125 16 16S168.8 136 160 136zM160 72c-8.75 0-16-7-16-16c0-8.75 7.25-16 16-16s16 7.125 16 16S168.8 72 160 72zM224 128C215.3 128 208 120.9 208 112S215.3 96 224 96s16 7 16 16C240 120.8 232.8 128 224 128zM224 64.25c-8.75 0-16-7-16-16c0-8.75 7.25-16 16-16s16 7.125 16 16S232.8 64.25 224 64.25z',
			),
		),
		'label'             => __( 'Flag Usa', 'astra' ),
		'custom_categories' => array(),
	),
	'flask'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M437.2 403.5L319.1 215L319.1 64h7.1c13.25 0 23.1-10.75 23.1-24l-.0002-16c0-13.25-10.75-24-23.1-24H120C106.8 0 96.01 10.75 96.01 24l-.0002 16c0 13.25 10.75 24 23.1 24h7.1L128 215l-117.2 188.5C-18.48 450.6 15.27 512 70.89 512h306.2C432.7 512 466.5 450.5 437.2 403.5zM137.1 320l48.15-77.63C189.8 237.3 191.9 230.8 191.9 224l.0651-160h63.99l-.06 160c0 6.875 2.25 13.25 5.875 18.38L309.9 320H137.1z',
			),
		),
		'label'             => __( 'Flask', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'science-and-technology',
			'travel',
		),
	),
	'flask-vial'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M160 442.5C149.1 446.1 139.2 448 128 448C74.98 448 32 405 32 352V64C14.33 64 0 49.67 0 32C0 14.33 14.33 0 32 0H224C241.7 0 256 14.33 256 32C256 49.67 241.7 64 224 64V309.9L175 389.4C165.2 405.4 160 423.8 160 442.5zM96 160H160V64H96V160zM512 0C529.7 0 544 14.33 544 32C544 49.67 529.7 64 512 64V214.9L629.7 406.2C636.4 417.2 640 429.7 640 442.6C640 480.9 608.9 512 570.6 512H261.4C223.1 512 191.1 480.9 191.1 442.6C191.1 429.7 195.6 417.2 202.3 406.2L319.1 214.9V64C302.3 64 287.1 49.67 287.1 32C287.1 14.33 302.3 0 319.1 0L512 0zM384 64V224C384 229.9 382.4 235.7 379.3 240.8L330.5 320H501.5L452.7 240.8C449.6 235.7 448 229.9 448 224V64H384z',
			),
		),
		'label'             => __( 'Flask Vial', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'flickr'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM144.5 319c-35.1 0-63.5-28.4-63.5-63.5s28.4-63.5 63.5-63.5 63.5 28.4 63.5 63.5-28.4 63.5-63.5 63.5zm159 0c-35.1 0-63.5-28.4-63.5-63.5s28.4-63.5 63.5-63.5 63.5 28.4 63.5 63.5-28.4 63.5-63.5 63.5z',
			),
		),
		'label'             => __( 'Flickr', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'flipboard'                            => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M0 32v448h448V32H0zm358.4 179.2h-89.6v89.6h-89.6v89.6H89.6V121.6h268.8v89.6z',
			),
		),
		'label'             => __( 'Flipboard', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'floppy-disk'                          => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M433.1 129.1l-83.9-83.9C342.3 38.32 327.1 32 316.1 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V163.9C448 152.9 441.7 137.7 433.1 129.1zM224 416c-35.34 0-64-28.66-64-64s28.66-64 64-64s64 28.66 64 64S259.3 416 224 416zM320 208C320 216.8 312.8 224 304 224h-224C71.16 224 64 216.8 64 208v-96C64 103.2 71.16 96 80 96h224C312.8 96 320 103.2 320 112V208z',
			),
			'regular' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M224 256c-35.2 0-64 28.8-64 64c0 35.2 28.8 64 64 64c35.2 0 64-28.8 64-64C288 284.8 259.2 256 224 256zM433.1 129.1l-83.9-83.9C341.1 37.06 328.8 32 316.1 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V163.9C448 151.2 442.9 138.9 433.1 129.1zM128 80h144V160H128V80zM400 416c0 8.836-7.164 16-16 16H64c-8.836 0-16-7.164-16-16V96c0-8.838 7.164-16 16-16h16v104c0 13.25 10.75 24 24 24h192C309.3 208 320 197.3 320 184V83.88l78.25 78.25C399.4 163.2 400 164.8 400 166.3V416z',
			),
		),
		'label'             => __( 'Floppy Disk', 'astra' ),
		'custom_categories' => array(
			'business',
			'design',
			'science-and-technology',
		),
	),
	'florin-sign'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M352 32C369.7 32 384 46.33 384 64C384 81.67 369.7 96 352 96H314.7C301.7 96 290.1 103.8 285.1 115.7L240 224H320C337.7 224 352 238.3 352 256C352 273.7 337.7 288 320 288H213.3L157.9 420.9C143 456.7 108.1 480 69.33 480H32C14.33 480 0 465.7 0 448C0 430.3 14.33 416 32 416H69.33C82.25 416 93.9 408.2 98.87 396.3L144 288H64C46.33 288 32 273.7 32 256C32 238.3 46.33 224 64 224H170.7L226.1 91.08C240.1 55.3 275.9 32 314.7 32H352z',
			),
		),
		'label'             => __( 'Florin Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'fly'                                  => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M197.8 427.8c12.9 11.7 33.7 33.3 33.2 50.7 0 .8-.1 1.6-.1 2.5-1.8 19.8-18.8 31.1-39.1 31-25-.1-39.9-16.8-38.7-35.8 1-16.2 20.5-36.7 32.4-47.6 2.3-2.1 2.7-2.7 5.6-3.6 3.4 0 3.9 .3 6.7 2.8zM331.9 67.3c-16.3-25.7-38.6-40.6-63.3-52.1C243.1 4.5 214-.2 192 0c-44.1 0-71.2 13.2-81.1 17.3C57.3 45.2 26.5 87.2 28 158.6c7.1 82.2 97 176 155.8 233.8 1.7 1.6 4.5 4.5 6.2 5.1l3.3 .1c2.1-.7 1.8-.5 3.5-2.1 52.3-49.2 140.7-145.8 155.9-215.7 7-39.2 3.1-72.5-20.8-112.5zM186.8 351.9c-28-51.1-65.2-130.7-69.3-189-3.4-47.5 11.4-131.2 69.3-136.7v325.7zM328.7 180c-16.4 56.8-77.3 128-118.9 170.3C237.6 298.4 275 217 277 158.4c1.6-45.9-9.8-105.8-48-131.4 88.8 18.3 115.5 98.1 99.7 153z',
			),
		),
		'label'             => __( 'Fly', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'folder'                               => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 144v288c0 26.5-21.5 48-48 48h-416C21.5 480 0 458.5 0 432v-352C0 53.5 21.5 32 48 32h160l64 64h192C490.5 96 512 117.5 512 144z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M447.1 96h-172.1L226.7 50.75C214.7 38.74 198.5 32 181.5 32H63.1c-35.35 0-64 28.66-64 64v320c0 35.34 28.65 64 64 64h384c35.35 0 64-28.66 64-64V160C511.1 124.7 483.3 96 447.1 96zM463.1 416c0 8.824-7.178 16-16 16h-384c-8.822 0-16-7.176-16-16V96c0-8.824 7.178-16 16-16h117.5c4.273 0 8.293 1.664 11.31 4.688L255.1 144h192c8.822 0 16 7.176 16 16V416z',
			),
		),
		'label'             => __( 'Folder', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
			'design',
			'science-and-technology',
		),
	),
	'folder-closed'                        => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M464 96h-192l-64-64h-160C21.5 32 0 53.5 0 80V160h512V144C512 117.5 490.5 96 464 96zM0 432C0 458.5 21.5 480 48 480h416c26.5 0 48-21.5 48-48V192H0V432z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M448 96h-172.1L226.7 50.75C214.7 38.74 198.5 32 181.5 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h384c35.35 0 64-28.66 64-64V160C512 124.7 483.3 96 448 96zM64 80h117.5c4.273 0 8.293 1.664 11.31 4.688L256 144h192c8.822 0 16 7.176 16 16v32h-416V96C48 87.18 55.18 80 64 80zM448 432H64c-8.822 0-16-7.176-16-16V240h416V416C464 424.8 456.8 432 448 432z',
			),
		),
		'label'             => __( 'Folder Closed', 'astra' ),
		'custom_categories' => array(),
	),
	'folder-minus'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M464 96h-192l-64-64h-160C21.5 32 0 53.5 0 80v352C0 458.5 21.5 480 48 480h416c26.5 0 48-21.5 48-48v-288C512 117.5 490.5 96 464 96zM336 311.1H175.1C162.7 311.1 152 301.3 152 288c0-13.26 10.74-23.1 23.1-23.1h160C349.3 264 360 274.7 360 288S349.3 311.1 336 311.1z',
			),
		),
		'label'             => __( 'Folder Minus', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'folder-open'                          => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M147.8 192H480V144C480 117.5 458.5 96 432 96h-160l-64-64h-160C21.49 32 0 53.49 0 80v328.4l90.54-181.1C101.4 205.6 123.4 192 147.8 192zM543.1 224H147.8C135.7 224 124.6 230.8 119.2 241.7L0 480h447.1c12.12 0 23.2-6.852 28.62-17.69l96-192C583.2 249 567.7 224 543.1 224z',
			),
			'regular' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M572.6 270.3l-96 192C471.2 473.2 460.1 480 447.1 480H64c-35.35 0-64-28.66-64-64V96c0-35.34 28.65-64 64-64h117.5c16.97 0 33.25 6.742 45.26 18.75L275.9 96H416c35.35 0 64 28.66 64 64v32h-48V160c0-8.824-7.178-16-16-16H256L192.8 84.69C189.8 81.66 185.8 80 181.5 80H64C55.18 80 48 87.18 48 96v288l71.16-142.3C124.6 230.8 135.7 224 147.8 224h396.2C567.7 224 583.2 249 572.6 270.3z',
			),
		),
		'label'             => __( 'Folder Open', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
			'science-and-technology',
		),
	),
	'folder-plus'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M464 96h-192l-64-64h-160C21.5 32 0 53.5 0 80v352C0 458.5 21.5 480 48 480h416c26.5 0 48-21.5 48-48v-288C512 117.5 490.5 96 464 96zM336 311.1h-56v56C279.1 381.3 269.3 392 256 392c-13.27 0-23.1-10.74-23.1-23.1V311.1H175.1C162.7 311.1 152 301.3 152 288c0-13.26 10.74-23.1 23.1-23.1h56V207.1C232 194.7 242.7 184 256 184s23.1 10.74 23.1 23.1V264h56C349.3 264 360 274.7 360 288S349.3 311.1 336 311.1z',
			),
		),
		'label'             => __( 'Folder Plus', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'folder-tree'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M544 32h-112l-32-32H320c-17.62 0-32 14.38-32 32v160c0 17.62 14.38 32 32 32h224c17.62 0 32-14.38 32-32V64C576 46.38 561.6 32 544 32zM544 320h-112l-32-32H320c-17.62 0-32 14.38-32 32v160c0 17.62 14.38 32 32 32h224c17.62 0 32-14.38 32-32v-128C576 334.4 561.6 320 544 320zM64 16C64 7.125 56.88 0 48 0h-32C7.125 0 0 7.125 0 16V416c0 17.62 14.38 32 32 32h224v-64H64V160h192V96H64V16z',
			),
		),
		'label'             => __( 'Folder Tree', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'font'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M416 416h-25.81L253.1 52.76c-4.688-12.47-16.57-20.76-29.91-20.76s-25.34 8.289-30.02 20.76L57.81 416H32c-17.67 0-32 14.31-32 32s14.33 32 32 32h96c17.67 0 32-14.31 32-32s-14.33-32-32-32H126.2l17.1-48h159.6l17.1 48H320c-17.67 0-32 14.31-32 32s14.33 32 32 32h96c17.67 0 32-14.31 32-32S433.7 416 416 416zM168.2 304L224 155.1l55.82 148.9H168.2z',
			),
		),
		'label'             => __( 'Font', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'font-awesome'                         => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M448 48V384c-63.09 22.54-82.34 32-119.5 32c-62.82 0-86.6-32-149.3-32C158.6 384 142.6 387.6 128 392.2v-64C142.6 323.6 158.6 320 179.2 320c62.73 0 86.51 32 149.3 32C348.9 352 364.1 349 384 342.7v-208C364.1 141 348.9 144 328.5 144c-62.82 0-86.6-32-149.3-32C128.4 112 104.3 132.6 64 140.7v307.3C64 465.7 49.67 480 32 480S0 465.7 0 448V63.1C0 46.33 14.33 32 31.1 32S64 46.33 64 63.1V76.66C104.3 68.63 128.4 48 179.2 48c62.73 0 86.51 32 149.3 32C365.7 80 384.9 70.54 448 48z',
			),
			'regular' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M448 48V384c-63.09 22.54-82.34 32-119.5 32c-62.82 0-86.6-32-149.3-32c-21.69 0-38.48 3.791-53.74 8.766C110.1 397.5 96 386.1 96 371.7v-.7461c0-9.275 5.734-17.6 14.42-20.86C129.1 342.8 150.2 336 179.2 336c62.73 0 86.51 32 149.3 32c25.5 0 42.85-4.604 71.47-14.7v-240C379.2 120.6 357.7 128 328.5 128c-.0039 0 .0039 0 0 0c-62.81 0-86.61-32-149.3-32C122.1 96 98.8 122.1 48 126.1V456C48 469.3 37.25 480 24 480S0 469.3 0 456V56C0 42.74 10.75 32 24 32S48 42.74 48 56v22.99C98.8 74.14 122.1 48 179.2 48c62.77 0 86.45 32 149.3 32C366.1 80 386.8 69.85 448 48z',
			),
			'brands'  => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M448 48V384C385 407 366 416 329 416C266 416 242 384 179 384C159 384 143 388 128 392V328C143 324 159 320 179 320C242 320 266 352 329 352C349 352 364 349 384 343V135C364 141 349 144 329 144C266 144 242 112 179 112C128 112 104 133 64 141V448C64 466 50 480 32 480S0 466 0 448V64C0 46 14 32 32 32S64 46 64 64V77C104 69 128 48 179 48C242 48 266 80 329 80C366 80 385 71 448 48z',
			),
		),
		'label'             => __( 'Font Awesome', 'astra' ),
		'custom_categories' => array(
			'design',
			'science-and-technology',
			'brands',
			'brands',
			'social',
		),
	),
	'fonticons'                            => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M0 32v448h448V32zm187 140.9c-18.4 0-19 9.9-19 27.4v23.3c0 2.4-3.5 4.4-.6 4.4h67.4l-11.1 37.3H168v112.9c0 5.8-2 6.7 3.2 7.3l43.5 4.1v25.1H84V389l21.3-2c5.2-.6 6.7-2.3 6.7-7.9V267.7c0-2.3-2.9-2.3-5.8-2.3H84V228h28v-21c0-49.6 26.5-70 77.3-70 34.1 0 64.7 8.2 64.7 52.8l-50.7 6.1c.3-18.7-4.4-23-16.3-23zm74.3 241.8v-25.1l20.4-2.6c5.2-.6 7.6-1.7 7.6-7.3V271.8c0-4.1-2.9-6.7-6.7-7.9l-24.2-6.4 6.7-29.5h80.2v151.7c0 5.8-2.6 6.4 2.9 7.3l15.7 2.6v25.1zm80.8-255.5l9 33.2-7.3 7.3-31.2-16.6-31.2 16.6-7.3-7.3 9-33.2-21.8-24.2 3.5-9.6h27.7l15.5-28h9.3l15.5 28h27.7l3.5 9.6z',
			),
		),
		'label'             => __( 'Fonticons', 'astra' ),
		'custom_categories' => array(),
	),
	'fonticons-fi'                         => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M114.4 224h92.4l-15.2 51.2h-76.4V433c0 8-2.8 9.2 4.4 10l59.6 5.6V483H0v-35.2l29.2-2.8c7.2-.8 9.2-3.2 9.2-10.8V278.4c0-3.2-4-3.2-8-3.2H0V224h38.4v-28.8c0-68 36.4-96 106-96 46.8 0 88.8 11.2 88.8 72.4l-69.6 8.4c.4-25.6-6-31.6-22.4-31.6-25.2 0-26 13.6-26 37.6v32c0 3.2-4.8 6-.8 6zM384 483H243.2v-34.4l28-3.6c7.2-.8 10.4-2.4 10.4-10V287c0-5.6-4-9.2-9.2-10.8l-33.2-8.8 9.2-40.4h110v208c0 8-3.6 8.8 4 10l21.6 3.6V483zm-30-347.2l12.4 45.6-10 10-42.8-22.8-42.8 22.8-10-10 12.4-45.6-30-36.4 4.8-10h38L307.2 51H320l21.2 38.4h38l4.8 13.2-30 33.2z',
			),
		),
		'label'             => __( 'Fonticons Fi', 'astra' ),
		'custom_categories' => array(),
	),
	'football'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M16.17 337.5c0 44.98 7.565 83.54 13.98 107.9C35.22 464.3 50.46 496 174.9 496c9.566 0 19.59-.4707 29.84-1.271L17.33 307.3C16.53 317.6 16.17 327.7 16.17 337.5zM495.8 174.5c0-44.98-7.565-83.53-13.98-107.9c-4.688-17.54-18.34-31.23-36.04-35.95C435.5 27.91 392.9 16 337 16c-9.564 0-19.59 .4707-29.84 1.271l187.5 187.5C495.5 194.4 495.8 184.3 495.8 174.5zM26.77 248.8l236.3 236.3c142-36.1 203.9-150.4 222.2-221.1L248.9 26.87C106.9 62.96 45.07 177.2 26.77 248.8zM256 335.1c0 9.141-7.474 16-16 16c-4.094 0-8.188-1.564-11.31-4.689L164.7 283.3C161.6 280.2 160 276.1 160 271.1c0-8.529 6.865-16 16-16c4.095 0 8.189 1.562 11.31 4.688l64.01 64C254.4 327.8 256 331.9 256 335.1zM304 287.1c0 9.141-7.474 16-16 16c-4.094 0-8.188-1.564-11.31-4.689L212.7 235.3C209.6 232.2 208 228.1 208 223.1c0-9.141 7.473-16 16-16c4.094 0 8.188 1.562 11.31 4.688l64.01 64.01C302.5 279.8 304 283.9 304 287.1zM256 175.1c0-9.141 7.473-16 16-16c4.094 0 8.188 1.562 11.31 4.688l64.01 64.01c3.125 3.125 4.688 7.219 4.688 11.31c0 9.133-7.468 16-16 16c-4.094 0-8.189-1.562-11.31-4.688l-64.01-64.01C257.6 184.2 256 180.1 256 175.1z',
			),
		),
		'label'             => __( 'Football', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'fort-awesome'                         => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M489.2 287.9h-27.4c-2.6 0-4.6 2-4.6 4.6v32h-36.6V146.2c0-2.6-2-4.6-4.6-4.6h-27.4c-2.6 0-4.6 2-4.6 4.6v32h-36.6v-32c0-2.6-2-4.6-4.6-4.6h-27.4c-2.6 0-4.6 2-4.6 4.6v32h-36.6v-32c0-6-8-4.6-11.7-4.6v-38c8.3-2 17.1-3.4 25.7-3.4 10.9 0 20.9 4.3 31.4 4.3 4.6 0 27.7-1.1 27.7-8v-60c0-2.6-2-4.6-4.6-4.6-5.1 0-15.1 4.3-24 4.3-9.7 0-20.9-4.3-32.6-4.3-8 0-16 1.1-23.7 2.9v-4.9c5.4-2.6 9.1-8.3 9.1-14.3 0-20.7-31.4-20.8-31.4 0 0 6 3.7 11.7 9.1 14.3v111.7c-3.7 0-11.7-1.4-11.7 4.6v32h-36.6v-32c0-2.6-2-4.6-4.6-4.6h-27.4c-2.6 0-4.6 2-4.6 4.6v32H128v-32c0-2.6-2-4.6-4.6-4.6H96c-2.6 0-4.6 2-4.6 4.6v178.3H54.8v-32c0-2.6-2-4.6-4.6-4.6H22.8c-2.6 0-4.6 2-4.6 4.6V512h182.9v-96c0-72.6 109.7-72.6 109.7 0v96h182.9V292.5c.1-2.6-1.9-4.6-4.5-4.6zm-288.1-4.5c0 2.6-2 4.6-4.6 4.6h-27.4c-2.6 0-4.6-2-4.6-4.6v-64c0-2.6 2-4.6 4.6-4.6h27.4c2.6 0 4.6 2 4.6 4.6v64zm146.4 0c0 2.6-2 4.6-4.6 4.6h-27.4c-2.6 0-4.6-2-4.6-4.6v-64c0-2.6 2-4.6 4.6-4.6h27.4c2.6 0 4.6 2 4.6 4.6v64z',
			),
		),
		'label'             => __( 'Fort Awesome', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'fort-awesome-alt'                     => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M208 237.4h-22.2c-2.1 0-3.7 1.6-3.7 3.7v51.7c0 2.1 1.6 3.7 3.7 3.7H208c2.1 0 3.7-1.6 3.7-3.7v-51.7c0-2.1-1.6-3.7-3.7-3.7zm118.2 0H304c-2.1 0-3.7 1.6-3.7 3.7v51.7c0 2.1 1.6 3.7 3.7 3.7h22.2c2.1 0 3.7-1.6 3.7-3.7v-51.7c-.1-2.1-1.7-3.7-3.7-3.7zm132-125.1c-2.3-3.2-4.6-6.4-7.1-9.5-9.8-12.5-20.8-24-32.8-34.4-4.5-3.9-9.1-7.6-13.9-11.2-1.6-1.2-3.2-2.3-4.8-3.5C372 34.1 340.3 20 306 13c-16.2-3.3-32.9-5-50-5s-33.9 1.7-50 5c-34.3 7.1-66 21.2-93.3 40.8-1.6 1.1-3.2 2.3-4.8 3.5-4.8 3.6-9.4 7.3-13.9 11.2-3 2.6-5.9 5.3-8.8 8s-5.7 5.5-8.4 8.4c-5.5 5.7-10.7 11.8-15.6 18-2.4 3.1-4.8 6.3-7.1 9.5C25.2 153 8.3 202.5 8.3 256c0 2 .1 4 .1 6 .1 .7 .1 1.3 .1 2 .1 1.3 .1 2.7 .2 4 0 .8 .1 1.5 .1 2.3 0 1.3 .1 2.5 .2 3.7 .1 .8 .1 1.6 .2 2.4 .1 1.1 .2 2.3 .3 3.5 0 .8 .1 1.6 .2 2.4 .1 1.2 .3 2.4 .4 3.6 .1 .8 .2 1.5 .3 2.3 .1 1.3 .3 2.6 .5 3.9 .1 .6 .2 1.3 .3 1.9l.9 5.7c.1 .6 .2 1.1 .3 1.7 .3 1.3 .5 2.7 .8 4 .2 .8 .3 1.6 .5 2.4 .2 1 .5 2.1 .7 3.2 .2 .9 .4 1.7 .6 2.6 .2 1 .4 2 .7 3 .2 .9 .5 1.8 .7 2.7 .3 1 .5 1.9 .8 2.9 .3 .9 .5 1.8 .8 2.7 .2 .9 .5 1.9 .8 2.8s.5 1.8 .8 2.7c.3 1 .6 1.9 .9 2.8 .6 1.6 1.1 3.3 1.7 4.9 .4 1 .7 1.9 1 2.8 .3 1 .7 2 1.1 3 .3 .8 .6 1.5 .9 2.3l1.2 3c.3 .7 .6 1.5 .9 2.2 .4 1 .9 2 1.3 3l.9 2.1c.5 1 .9 2 1.4 3 .3 .7 .6 1.3 .9 2 .5 1 1 2.1 1.5 3.1 .2 .6 .5 1.1 .8 1.7 .6 1.1 1.1 2.2 1.7 3.3 .1 .2 .2 .3 .3 .5 2.2 4.1 4.4 8.2 6.8 12.2 .2 .4 .5 .8 .7 1.2 .7 1.1 1.3 2.2 2 3.3 .3 .5 .6 .9 .9 1.4 .6 1.1 1.3 2.1 2 3.2 .3 .5 .6 .9 .9 1.4 .7 1.1 1.4 2.1 2.1 3.2 .2 .4 .5 .8 .8 1.2 .7 1.1 1.5 2.2 2.3 3.3 .2 .2 .3 .5 .5 .7 37.5 51.7 94.4 88.5 160 99.4 .9 .1 1.7 .3 2.6 .4 1 .2 2.1 .4 3.1 .5s1.9 .3 2.8 .4c1 .2 2 .3 3 .4 .9 .1 1.9 .2 2.9 .3s1.9 .2 2.9 .3 2.1 .2 3.1 .3c.9 .1 1.8 .1 2.7 .2 1.1 .1 2.3 .1 3.4 .2 .8 0 1.7 .1 2.5 .1 1.3 0 2.6 .1 3.9 .1 .7 .1 1.4 .1 2.1 .1 2 .1 4 .1 6 .1s4-.1 6-.1c.7 0 1.4-.1 2.1-.1 1.3 0 2.6 0 3.9-.1 .8 0 1.7-.1 2.5-.1 1.1-.1 2.3-.1 3.4-.2 .9 0 1.8-.1 2.7-.2 1-.1 2.1-.2 3.1-.3s1.9-.2 2.9-.3c.9-.1 1.9-.2 2.9-.3s2-.3 3-.4 1.9-.3 2.8-.4c1-.2 2.1-.3 3.1-.5 .9-.1 1.7-.3 2.6-.4 65.6-11 122.5-47.7 160.1-102.4 .2-.2 .3-.5 .5-.7 .8-1.1 1.5-2.2 2.3-3.3 .2-.4 .5-.8 .8-1.2 .7-1.1 1.4-2.1 2.1-3.2 .3-.5 .6-.9 .9-1.4 .6-1.1 1.3-2.1 2-3.2 .3-.5 .6-.9 .9-1.4 .7-1.1 1.3-2.2 2-3.3 .2-.4 .5-.8 .7-1.2 2.4-4 4.6-8.1 6.8-12.2 .1-.2 .2-.3 .3-.5 .6-1.1 1.1-2.2 1.7-3.3 .2-.6 .5-1.1 .8-1.7 .5-1 1-2.1 1.5-3.1 .3-.7 .6-1.3 .9-2 .5-1 1-2 1.4-3l.9-2.1c.5-1 .9-2 1.3-3 .3-.7 .6-1.5 .9-2.2l1.2-3c.3-.8 .6-1.5 .9-2.3 .4-1 .7-2 1.1-3s.7-1.9 1-2.8c.6-1.6 1.2-3.3 1.7-4.9 .3-1 .6-1.9 .9-2.8s.5-1.8 .8-2.7c.2-.9 .5-1.9 .8-2.8s.6-1.8 .8-2.7c.3-1 .5-1.9 .8-2.9 .2-.9 .5-1.8 .7-2.7 .2-1 .5-2 .7-3 .2-.9 .4-1.7 .6-2.6 .2-1 .5-2.1 .7-3.2 .2-.8 .3-1.6 .5-2.4 .3-1.3 .6-2.7 .8-4 .1-.6 .2-1.1 .3-1.7l.9-5.7c.1-.6 .2-1.3 .3-1.9 .1-1.3 .3-2.6 .5-3.9 .1-.8 .2-1.5 .3-2.3 .1-1.2 .3-2.4 .4-3.6 0-.8 .1-1.6 .2-2.4 .1-1.1 .2-2.3 .3-3.5 .1-.8 .1-1.6 .2-2.4 .1 1.7 .1 .5 .2-.7 0-.8 .1-1.5 .1-2.3 .1-1.3 .2-2.7 .2-4 .1-.7 .1-1.3 .1-2 .1-2 .1-4 .1-6 0-53.5-16.9-103-45.8-143.7zM448 371.5c-9.4 15.5-20.6 29.9-33.6 42.9-20.6 20.6-44.5 36.7-71.2 48-13.9 5.8-28.2 10.3-42.9 13.2v-75.8c0-58.6-88.6-58.6-88.6 0v75.8c-14.7-2.9-29-7.3-42.9-13.2-26.7-11.3-50.6-27.4-71.2-48-13-13-24.2-27.4-33.6-42.9v-71.3c0-2.1 1.6-3.7 3.7-3.7h22.1c2.1 0 3.7 1.6 3.7 3.7V326h29.6V182c0-2.1 1.6-3.7 3.7-3.7h22.1c2.1 0 3.7 1.6 3.7 3.7v25.9h29.5V182c0-2.1 1.6-3.7 3.7-3.7H208c2.1 0 3.7 1.6 3.7 3.7v25.9h29.5V182c0-4.8 6.5-3.7 9.5-3.7V88.1c-4.4-2-7.4-6.7-7.4-11.5 0-16.8 25.4-16.8 25.4 0 0 4.8-3 9.4-7.4 11.5V92c6.3-1.4 12.7-2.3 19.2-2.3 9.4 0 18.4 3.5 26.3 3.5 7.2 0 15.2-3.5 19.4-3.5 2.1 0 3.7 1.6 3.7 3.7v48.4c0 5.6-18.7 6.5-22.4 6.5-8.6 0-16.6-3.5-25.4-3.5-7 0-14.1 1.2-20.8 2.8v30.7c3 0 9.5-1.1 9.5 3.7v25.9h29.5V182c0-2.1 1.6-3.7 3.7-3.7h22.2c2.1 0 3.7 1.6 3.7 3.7v25.9h29.5V182c0-2.1 1.6-3.7 3.7-3.7h22.1c2.1 0 3.7 1.6 3.7 3.7v144h29.5v-25.8c0-2.1 1.6-3.7 3.7-3.7h22.2c2.1 0 3.7 1.6 3.7 3.7z',
			),
		),
		'label'             => __( 'Alternate Fort Awesome', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'forumbee'                             => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M5.8 309.7C2 292.7 0 275.5 0 258.3 0 135 99.8 35 223.1 35c16.6 0 33.3 2 49.3 5.5C149 87.5 51.9 186 5.8 309.7zm392.9-189.2C385 103 369 87.8 350.9 75.2c-149.6 44.3-266.3 162.1-309.7 312 12.5 18.1 28 35.6 45.2 49 43.1-151.3 161.2-271.7 312.3-315.7zm15.8 252.7c15.2-25.1 25.4-53.7 29.5-82.8-79.4 42.9-145 110.6-187.6 190.3 30-4.4 58.9-15.3 84.6-31.3 35 13.1 70.9 24.3 107 33.6-9.3-36.5-20.4-74.5-33.5-109.8zm29.7-145.5c-2.6-19.5-7.9-38.7-15.8-56.8C290.5 216.7 182 327.5 137.1 466c18.1 7.6 37 12.5 56.6 15.2C240 367.1 330.5 274.4 444.2 227.7z',
			),
		),
		'label'             => __( 'Forumbee', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'forward'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M52.51 440.6l171.5-142.9V214.3L52.51 71.41C31.88 54.28 0 68.66 0 96.03v319.9C0 443.3 31.88 457.7 52.51 440.6zM308.5 440.6l192-159.1c15.25-12.87 15.25-36.37 0-49.24l-192-159.1c-20.63-17.12-52.51-2.749-52.51 24.62v319.9C256 443.3 287.9 457.7 308.5 440.6z',
			),
		),
		'label'             => __( 'Forward', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
		),
	),
	'forward-fast'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 96.03v319.9c0 17.67-14.33 31.1-31.1 31.1C462.3 447.1 448 433.6 448 415.1V284.1l-171.5 156.5C255.9 457.7 224 443.3 224 415.1V284.1l-171.5 156.5C31.88 457.7 0 443.3 0 415.1V96.03c0-27.37 31.88-41.74 52.5-24.62L224 226.8V96.03c0-27.37 31.88-41.74 52.5-24.62L448 226.8V96.03c0-17.67 14.33-31.1 31.1-31.1C497.7 64.03 512 78.36 512 96.03z',
			),
		),
		'label'             => __( 'Forward Fast', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
		),
	),
	'forward-step'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M287.1 447.1c17.67 0 31.1-14.33 31.1-32V96.03c0-17.67-14.33-32-32-32c-17.67 0-31.1 14.33-31.1 31.1v319.9C255.1 433.6 270.3 447.1 287.1 447.1zM52.51 440.6l192-159.1c7.625-6.436 11.43-15.53 11.43-24.62c0-9.094-3.809-18.18-11.43-24.62l-192-159.1C31.88 54.28 0 68.66 0 96.03v319.9C0 443.3 31.88 457.7 52.51 440.6z',
			),
		),
		'label'             => __( 'Forward Step', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
		),
	),
	'foursquare'                           => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 368,
				'height' => 512,
				'path'   => 'M323.1 3H49.9C12.4 3 0 31.3 0 49.1v433.8c0 20.3 12.1 27.7 18.2 30.1 6.2 2.5 22.8 4.6 32.9-7.1C180 356.5 182.2 354 182.2 354c3.1-3.4 3.4-3.1 6.8-3.1h83.4c35.1 0 40.6-25.2 44.3-39.7l48.6-243C373.8 25.8 363.1 3 323.1 3zm-16.3 73.8l-11.4 59.7c-1.2 6.5-9.5 13.2-16.9 13.2H172.1c-12 0-20.6 8.3-20.6 20.3v13c0 12 8.6 20.6 20.6 20.6h90.4c8.3 0 16.6 9.2 14.8 18.2-1.8 8.9-10.5 53.8-11.4 58.8-.9 4.9-6.8 13.5-16.9 13.5h-73.5c-13.5 0-17.2 1.8-26.5 12.6 0 0-8.9 11.4-89.5 108.3-.9 .9-1.8 .6-1.8-.3V75.9c0-7.7 6.8-16.6 16.6-16.6h219c8.2 0 15.6 7.7 13.5 17.5z',
			),
		),
		'label'             => __( 'Foursquare', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'franc-sign'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M288 32C305.7 32 320 46.33 320 64C320 81.67 305.7 96 288 96H112V192H256C273.7 192 288 206.3 288 224C288 241.7 273.7 256 256 256H112V320H192C209.7 320 224 334.3 224 352C224 369.7 209.7 384 192 384H112V448C112 465.7 97.67 480 80 480C62.33 480 48 465.7 48 448V384H32C14.33 384 0 369.7 0 352C0 334.3 14.33 320 32 320H48V64C48 46.33 62.33 32 80 32H288z',
			),
		),
		'label'             => __( 'Franc Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'free-code-camp'                       => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M97.22 96.21c10.36-10.65 16-17.12 16-21.9 0-2.76-1.92-5.51-3.83-7.42A14.81 14.81 0 0 0 101 64.05c-8.48 0-20.92 8.79-35.84 25.69C23.68 137 2.51 182.8 3.37 250.3s17.47 117 54.06 161.9C76.22 435.9 90.62 448 100.9 448a13.55 13.55 0 0 0 8.37-3.84c1.91-2.76 3.81-5.63 3.81-8.38 0-5.63-3.86-12.2-13.2-20.55-44.45-42.33-67.32-97-67.48-165C32.25 188.8 54 137.8 97.22 96.21zM239.5 420.1c.58 .37 .91 .55 .91 .55zm93.79 .55 .17-.13C333.2 420.6 333.2 420.7 333.3 420.6zm3.13-158.2c-16.24-4.15 50.41-82.89-68.05-177.2 0 0 15.54 49.38-62.83 159.6-74.27 104.3 23.46 168.7 34 175.2-6.73-4.35-47.4-35.7 9.55-128.6 11-18.3 25.53-34.87 43.5-72.16 0 0 15.91 22.45 7.6 71.13C287.7 364 354 342.9 355 343.9c22.75 26.78-17.72 73.51-21.58 76.55 5.49-3.65 117.7-78 33-188.1C360.4 238.4 352.6 266.6 336.4 262.4zM510.9 89.69C496 72.79 483.5 64 475 64a14.81 14.81 0 0 0 -8.39 2.84c-1.91 1.91-3.83 4.66-3.83 7.42 0 4.78 5.6 11.26 16 21.9 43.23 41.61 65 92.59 64.82 154.1-.16 68-23 122.6-67.48 165-9.34 8.35-13.18 14.92-13.2 20.55 0 2.75 1.9 5.62 3.81 8.38A13.61 13.61 0 0 0 475.1 448c10.28 0 24.68-12.13 43.47-35.79 36.59-44.85 53.14-94.38 54.06-161.9S552.3 137 510.9 89.69z',
			),
		),
		'label'             => __( 'freeCodeCamp', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'freebsd'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M303.7 96.2c11.1-11.1 115.5-77 139.2-53.2 23.7 23.7-42.1 128.1-53.2 139.2-11.1 11.1-39.4 .9-63.1-22.9-23.8-23.7-34.1-52-22.9-63.1zM109.9 68.1C73.6 47.5 22 24.6 5.6 41.1c-16.6 16.6 7.1 69.4 27.9 105.7 18.5-32.2 44.8-59.3 76.4-78.7zM406.7 174c3.3 11.3 2.7 20.7-2.7 26.1-20.3 20.3-87.5-27-109.3-70.1-18-32.3-11.1-53.4 14.9-48.7 5.7-3.6 12.3-7.6 19.6-11.6-29.8-15.5-63.6-24.3-99.5-24.3-119.1 0-215.6 96.5-215.6 215.6 0 119 96.5 215.6 215.6 215.6S445.3 380.1 445.3 261c0-38.4-10.1-74.5-27.7-105.8-3.9 7-7.6 13.3-10.9 18.8z',
			),
		),
		'label'             => __( 'FreeBSD', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'frog'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M528 416h-32.07l-90.32-96.34l140.6-79.03c18.38-10.25 29.75-29.62 29.75-50.62c0-21.5-11.75-41-30.5-51.25c-40.5-22.25-99.07-41.43-99.07-41.43C439.6 60.19 407.3 32 368 32s-71.77 28.25-78.52 65.5C126.7 113-.4999 250.1 .0001 417C.1251 451.9 29.13 480 64 480h304c8.875 0 16-7.125 16-16c0-26.51-21.49-48-47.1-48H284.3l23.93-32.38c24.25-36.13 10.38-88.25-33.63-106.5C250.8 267.1 223 272.4 202.4 288L169.6 312.5c-7.125 5.375-17.12 4-22.38-3.125c-5.375-7.125-4-17.12 3.125-22.38l34.75-26.12c36.87-27.62 88.37-27.62 125.1 0c10.88 8.125 45.88 39 40.88 93.13L469.6 480h90.38c8.875 0 16-7.125 16-16C576 437.5 554.5 416 528 416zM344 112c0-13.25 10.75-24 24-24s24 10.75 24 24s-10.75 24-24 24S344 125.3 344 112z',
			),
		),
		'label'             => __( 'Frog', 'astra' ),
		'custom_categories' => array(
			'environment',
			'lifestyle-and-hobbies',
			'science-and-technology',
		),
	),
	'fulcrum'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M95.75 164.1l-35.38 43.55L25 164.1l35.38-43.55zM144.2 0l-20.54 198.2L72.72 256l51 57.82L144.2 512V300.9L103.2 256l41.08-44.89zm79.67 164.1l35.38 43.55 35.38-43.55-35.38-43.55zm-48.48 47L216.5 256l-41.08 44.89V512L196 313.8 247 256l-51-57.82L175.4 0z',
			),
		),
		'label'             => __( 'Fulcrum', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'futbol'                               => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M177.1 228.6L207.9 320h96.5l29.62-91.38L256 172.1L177.1 228.6zM255.1 0C114.6 0 .0001 114.6 .0001 256S114.6 512 256 512s255.1-114.6 255.1-255.1S397.4 0 255.1 0zM416.6 360.9l-85.4-1.297l-25.15 81.59C290.1 445.5 273.4 448 256 448s-34.09-2.523-50.09-6.859L180.8 359.6l-85.4 1.297c-18.12-27.66-29.15-60.27-30.88-95.31L134.3 216.4L106.6 135.6c21.16-26.21 49.09-46.61 81.06-58.84L256 128l68.29-51.22c31.98 12.23 59.9 32.64 81.06 58.84L377.7 216.4l69.78 49.1C445.8 300.6 434.8 333.2 416.6 360.9z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M177.1 228.6L207.9 320h96.5l29.62-91.38L256 172.1L177.1 228.6zM255.1 0C114.6 0 .0001 114.6 .0001 256S114.6 512 256 512s255.1-114.6 255.1-255.1S397.4 0 255.1 0zM435.2 361.1l-103.9-1.578l-30.67 99.52C286.2 462.2 271.3 464 256 464s-30.19-1.773-44.56-4.93L180.8 359.6L76.83 361.1c-14.93-25.35-24.79-54.01-27.8-84.72L134.3 216.4L100.7 118.1c19.85-22.34 44.32-40.45 72.04-52.62L256 128l83.29-62.47c27.72 12.17 52.19 30.27 72.04 52.62L377.7 216.4l85.23 59.97C459.1 307.1 450.1 335.8 435.2 361.1z',
			),
		),
		'label'             => __( 'Futbol', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'g'                                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M448 256c0 143.4-118.6 222.3-225 222.3c-132.3 0-222.1-106.2-222.1-222.4c0-124.4 100.9-223.9 223.1-223.9c84.84 0 167.8 55.28 167.8 88.2c0 18.28-14.95 32-32 32c-31.04 0-46.79-56.16-135.8-56.16c-87.66 0-159.1 70.66-159.1 159.8c0 34.81 27.19 158.8 159.1 158.8c79.45 0 144.6-55.1 158.1-126.7h-134.1c-17.67 0-32-14.33-32-32s14.33-31.1 32-31.1H416C433.7 224 448 238.3 448 256z',
			),
		),
		'label'             => __( 'G', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'galactic-republic'                    => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M248 504C111.3 504 0 392.8 0 256S111.3 8 248 8s248 111.3 248 248-111.3 248-248 248zm0-479.5C120.4 24.53 16.53 128.4 16.53 256S120.4 487.5 248 487.5 479.5 383.6 479.5 256 375.6 24.53 248 24.53zm27.62 21.81v24.62a185.9 185.9 0 0 1 83.57 34.54l17.39-17.36c-28.75-22.06-63.3-36.89-100.1-41.8zm-55.37 .07c-37.64 4.94-72.16 19.8-100.9 41.85l17.28 17.36h.08c24.07-17.84 52.55-30.06 83.52-34.67V46.41zm12.25 50.17v82.87c-10.04 2.03-19.42 5.94-27.67 11.42l-58.62-58.59-21.93 21.93 58.67 58.67c-5.47 8.23-9.45 17.59-11.47 27.62h-82.9v31h82.9c2.02 10.02 6.01 19.31 11.47 27.54l-58.67 58.69 21.93 21.93 58.62-58.62a77.87 77.87 0 0 0 27.67 11.47v82.9h31v-82.9c10.05-2.03 19.37-6.06 27.62-11.55l58.67 58.69 21.93-21.93-58.67-58.69c5.46-8.23 9.47-17.52 11.5-27.54h82.87v-31h-82.87c-2.02-10.02-6.03-19.38-11.5-27.62l58.67-58.67-21.93-21.93-58.67 58.67c-8.25-5.49-17.57-9.47-27.62-11.5V96.58h-31zm183.2 30.72l-17.36 17.36a186.3 186.3 0 0 1 34.67 83.67h24.62c-4.95-37.69-19.83-72.29-41.93-101zm-335.5 .13c-22.06 28.72-36.91 63.26-41.85 100.9h24.65c4.6-30.96 16.76-59.45 34.59-83.52l-17.39-17.39zM38.34 283.7c4.92 37.64 19.75 72.18 41.8 100.9l17.36-17.39c-17.81-24.07-29.92-52.57-34.51-83.52H38.34zm394.7 0c-4.61 30.99-16.8 59.5-34.67 83.6l17.36 17.36c22.08-28.74 36.98-63.29 41.93-100.1h-24.62zM136.7 406.4l-17.36 17.36c28.73 22.09 63.3 36.98 100.1 41.93v-24.64c-30.99-4.63-59.53-16.79-83.6-34.65zm222.5 .05c-24.09 17.84-52.58 30.08-83.57 34.67v24.57c37.67-4.92 72.21-19.79 100.1-41.85l-17.31-17.39h-.08z',
			),
		),
		'label'             => __( 'Galactic Republic', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
			'brands',
			'brands',
			'social',
		),
	),
	'galactic-senate'                      => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M249.9 33.48v26.07C236.3 80.17 226 168.1 225.4 274.9c11.74-15.62 19.13-33.33 19.13-48.24v-16.88c-.03-5.32 .75-10.53 2.19-15.65 .65-2.14 1.39-4.08 2.62-5.82 1.23-1.75 3.43-3.79 6.68-3.79 3.24 0 5.45 2.05 6.68 3.79 1.23 1.75 1.97 3.68 2.62 5.82 1.44 5.12 2.22 10.33 2.19 15.65v16.88c0 14.91 7.39 32.62 19.13 48.24-.63-106.8-10.91-194.7-24.49-215.4V33.48h-12.28zm-26.34 147.8c-9.52 2.15-18.7 5.19-27.46 9.08 8.9 16.12 9.76 32.64 1.71 37.29-8 4.62-21.85-4.23-31.36-19.82-11.58 8.79-21.88 19.32-30.56 31.09 14.73 9.62 22.89 22.92 18.32 30.66-4.54 7.7-20.03 7.14-35.47-.96-5.78 13.25-9.75 27.51-11.65 42.42 9.68 .18 18.67 2.38 26.18 6.04 17.78-.3 32.77-1.96 40.49-4.22 5.55-26.35 23.02-48.23 46.32-59.51 .73-25.55 1.88-49.67 3.48-72.07zm64.96 0c1.59 22.4 2.75 46.52 3.47 72.07 23.29 11.28 40.77 33.16 46.32 59.51 7.72 2.26 22.71 3.92 40.49 4.22 7.51-3.66 16.5-5.85 26.18-6.04-1.9-14.91-5.86-29.17-11.65-42.42-15.44 8.1-30.93 8.66-35.47 .96-4.57-7.74 3.6-21.05 18.32-30.66-8.68-11.77-18.98-22.3-30.56-31.09-9.51 15.59-23.36 24.44-31.36 19.82-8.05-4.65-7.19-21.16 1.71-37.29a147.5 147.5 0 0 0 -27.45-9.08zm-32.48 8.6c-3.23 0-5.86 8.81-6.09 19.93h-.05v16.88c0 41.42-49.01 95.04-93.49 95.04-52 0-122.8-1.45-156.4 29.17v2.51c9.42 17.12 20.58 33.17 33.18 47.97C45.7 380.3 84.77 360.4 141.2 360c45.68 1.02 79.03 20.33 90.76 40.87 .01 .01-.01 .04 0 .05 7.67 2.14 15.85 3.23 24.04 3.21 8.19 .02 16.37-1.07 24.04-3.21 .01-.01-.01-.04 0-.05 11.74-20.54 45.08-39.85 90.76-40.87 56.43 .39 95.49 20.26 108 41.35 12.6-14.8 23.76-30.86 33.18-47.97v-2.51c-33.61-30.62-104.4-29.17-156.4-29.17-44.48 0-93.49-53.62-93.49-95.04v-16.88h-.05c-.23-11.12-2.86-19.93-6.09-19.93zm0 96.59c22.42 0 40.6 18.18 40.6 40.6s-18.18 40.65-40.6 40.65-40.6-18.23-40.6-40.65c0-22.42 18.18-40.6 40.6-40.6zm0 7.64c-18.19 0-32.96 14.77-32.96 32.96S237.8 360 256 360s32.96-14.77 32.96-32.96-14.77-32.96-32.96-32.96zm0 6.14c14.81 0 26.82 12.01 26.82 26.82s-12.01 26.82-26.82 26.82-26.82-12.01-26.82-26.82 12.01-26.82 26.82-26.82zm-114.8 66.67c-10.19 .07-21.6 .36-30.5 1.66 .43 4.42 1.51 18.63 7.11 29.76 9.11-2.56 18.36-3.9 27.62-3.9 41.28 .94 71.48 34.35 78.26 74.47l.11 4.7c10.4 1.91 21.19 2.94 32.21 2.94 11.03 0 21.81-1.02 32.21-2.94l.11-4.7c6.78-40.12 36.98-73.53 78.26-74.47 9.26 0 18.51 1.34 27.62 3.9 5.6-11.13 6.68-25.34 7.11-29.76-8.9-1.3-20.32-1.58-30.5-1.66-18.76 .42-35.19 4.17-48.61 9.67-12.54 16.03-29.16 30.03-49.58 33.07-.09 .02-.17 .04-.27 .05-.05 .01-.11 .04-.16 .05-5.24 1.07-10.63 1.6-16.19 1.6-5.55 0-10.95-.53-16.19-1.6-.05-.01-.11-.04-.16-.05-.1-.02-.17-.04-.27-.05-20.42-3.03-37.03-17.04-49.58-33.07-13.42-5.49-29.86-9.25-48.61-9.67z',
			),
		),
		'label'             => __( 'Galactic Senate', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
			'brands',
			'brands',
			'social',
		),
	),
	'gamepad'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M448 64H192C85.96 64 0 149.1 0 256s85.96 192 192 192h256c106 0 192-85.96 192-192S554 64 448 64zM247.1 280h-32v32c0 13.2-10.78 24-23.98 24c-13.2 0-24.02-10.8-24.02-24v-32L136 279.1C122.8 279.1 111.1 269.2 111.1 256c0-13.2 10.85-24.01 24.05-24.01L167.1 232v-32c0-13.2 10.82-24 24.02-24c13.2 0 23.98 10.8 23.98 24v32h32c13.2 0 24.02 10.8 24.02 24C271.1 269.2 261.2 280 247.1 280zM431.1 344c-22.12 0-39.1-17.87-39.1-39.1s17.87-40 39.1-40s39.1 17.88 39.1 40S454.1 344 431.1 344zM495.1 248c-22.12 0-39.1-17.87-39.1-39.1s17.87-40 39.1-40c22.12 0 39.1 17.88 39.1 40S518.1 248 495.1 248z',
			),
		),
		'label'             => __( 'Gamepad', 'astra' ),
		'custom_categories' => array(
			'education',
			'lifestyle-and-hobbies',
			'science-and-technology',
			'travel',
		),
	),
	'gas-pump'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M32 64C32 28.65 60.65 0 96 0H256C291.3 0 320 28.65 320 64V256H328C376.6 256 416 295.4 416 344V376C416 389.3 426.7 400 440 400C453.3 400 464 389.3 464 376V221.1C436.4 214.9 416 189.8 416 160V96L384 64C375.2 55.16 375.2 40.84 384 32C392.8 23.16 407.2 23.16 416 32L493.3 109.3C505.3 121.3 512 137.5 512 154.5V376C512 415.8 479.8 448 440 448C400.2 448 368 415.8 368 376V344C368 321.9 350.1 303.1 328 303.1H320V448C337.7 448 352 462.3 352 480C352 497.7 337.7 512 320 512H32C14.33 512 0 497.7 0 480C0 462.3 14.33 448 32 448V64zM96 176C96 184.8 103.2 192 112 192H240C248.8 192 256 184.8 256 176V80C256 71.16 248.8 64 240 64H112C103.2 64 96 71.16 96 80V176z',
			),
		),
		'label'             => __( 'Gas Pump', 'astra' ),
		'custom_categories' => array(
			'business',
			'science-and-technology',
			'travel',
		),
	),
	'gauge'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM280 292.7V88C280 74.75 269.3 64 256 64C242.7 64 232 74.75 232 88V292.7C208.5 302.1 192 325.1 192 352C192 387.3 220.7 416 256 416C291.3 416 320 387.3 320 352C320 325.1 303.5 302.1 280 292.7zM144 176C161.7 176 176 161.7 176 144C176 126.3 161.7 112 144 112C126.3 112 112 126.3 112 144C112 161.7 126.3 176 144 176zM96 224C78.33 224 64 238.3 64 256C64 273.7 78.33 288 96 288C113.7 288 128 273.7 128 256C128 238.3 113.7 224 96 224zM416 288C433.7 288 448 273.7 448 256C448 238.3 433.7 224 416 224C398.3 224 384 238.3 384 256C384 273.7 398.3 288 416 288zM368 112C350.3 112 336 126.3 336 144C336 161.7 350.3 176 368 176C385.7 176 400 161.7 400 144C400 126.3 385.7 112 368 112z',
			),
		),
		'label'             => __( 'Gauge', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'gauge-high'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 64C238.3 64 224 78.33 224 96C224 113.7 238.3 128 256 128C273.7 128 288 113.7 288 96C288 78.33 273.7 64 256 64zM256 416C291.3 416 320 387.3 320 352C320 334.6 313.1 318.9 301.9 307.4L365.1 161.7C371.3 149.5 365.8 135.4 353.7 130C341.5 124.7 327.4 130.2 322 142.3L257.9 288C257.3 288 256.6 287.1 256 287.1C220.7 287.1 192 316.7 192 352C192 387.3 220.7 416 256 416V416zM144 112C126.3 112 112 126.3 112 144C112 161.7 126.3 176 144 176C161.7 176 176 161.7 176 144C176 126.3 161.7 112 144 112zM96 288C113.7 288 128 273.7 128 256C128 238.3 113.7 224 96 224C78.33 224 64 238.3 64 256C64 273.7 78.33 288 96 288zM416 224C398.3 224 384 238.3 384 256C384 273.7 398.3 288 416 288C433.7 288 448 273.7 448 256C448 238.3 433.7 224 416 224z',
			),
		),
		'label'             => __( 'Gauge High', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'gauge-simple'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM280 292.7V88C280 74.75 269.3 64 256 64C242.7 64 232 74.75 232 88V292.7C208.5 302.1 192 325.1 192 352C192 387.3 220.7 416 256 416C291.3 416 320 387.3 320 352C320 325.1 303.5 302.1 280 292.7z',
			),
		),
		'label'             => __( 'Gauge Simple', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'gauge-simple-high'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM304.7 310.4L381.3 163.1C387.4 151.3 382.8 136.8 371.1 130.7C359.3 124.6 344.8 129.2 338.7 140.9L262.1 288.3C260.1 288.1 258.1 287.1 255.1 287.1C220.7 287.1 191.1 316.7 191.1 352C191.1 387.3 220.7 416 255.1 416C291.3 416 320 387.3 320 352C320 336.1 314.2 321.6 304.7 310.4L304.7 310.4z',
			),
		),
		'label'             => __( 'Gauge Simple High', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'gavel'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 216.3c0-6.125-2.344-12.25-7.031-16.93L482.3 176.8c-4.688-4.686-10.84-7.028-16.1-7.028s-12.31 2.343-16.1 7.028l-5.625 5.625L329.6 69.28l5.625-5.625c4.687-4.688 7.03-10.84 7.03-16.1s-2.343-12.31-7.03-16.1l-22.62-22.62C307.9 2.344 301.8 0 295.7 0s-12.15 2.344-16.84 7.031L154.2 131.5C149.6 136.2 147.2 142.3 147.2 148.5s2.344 12.25 7.031 16.94l22.62 22.62c4.688 4.688 10.84 7.031 16.1 7.031c6.156 0 12.31-2.344 16.1-7.031l5.625-5.625l113.1 113.1l-5.625 5.621c-4.688 4.688-7.031 10.84-7.031 16.1s2.344 12.31 7.031 16.1l22.62 22.62c4.688 4.688 10.81 7.031 16.94 7.031s12.25-2.344 16.94-7.031l124.5-124.6C509.7 228.5 512 222.5 512 216.3zM227.8 238.1L169.4 297.4C163.1 291.1 154.9 288 146.7 288S130.4 291.1 124.1 297.4l-114.7 114.7c-6.25 6.248-9.375 14.43-9.375 22.62s3.125 16.37 9.375 22.62l45.25 45.25C60.87 508.9 69.06 512 77.25 512s16.37-3.125 22.62-9.375l114.7-114.7c6.25-6.25 9.376-14.44 9.376-22.62c0-8.185-3.125-16.37-9.374-22.62l58.43-58.43L227.8 238.1z',
			),
		),
		'label'             => __( 'Gavel', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'gear'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M495.9 166.6C499.2 175.2 496.4 184.9 489.6 191.2L446.3 230.6C447.4 238.9 448 247.4 448 256C448 264.6 447.4 273.1 446.3 281.4L489.6 320.8C496.4 327.1 499.2 336.8 495.9 345.4C491.5 357.3 486.2 368.8 480.2 379.7L475.5 387.8C468.9 398.8 461.5 409.2 453.4 419.1C447.4 426.2 437.7 428.7 428.9 425.9L373.2 408.1C359.8 418.4 344.1 427 329.2 433.6L316.7 490.7C314.7 499.7 307.7 506.1 298.5 508.5C284.7 510.8 270.5 512 255.1 512C241.5 512 227.3 510.8 213.5 508.5C204.3 506.1 197.3 499.7 195.3 490.7L182.8 433.6C167 427 152.2 418.4 138.8 408.1L83.14 425.9C74.3 428.7 64.55 426.2 58.63 419.1C50.52 409.2 43.12 398.8 36.52 387.8L31.84 379.7C25.77 368.8 20.49 357.3 16.06 345.4C12.82 336.8 15.55 327.1 22.41 320.8L65.67 281.4C64.57 273.1 64 264.6 64 256C64 247.4 64.57 238.9 65.67 230.6L22.41 191.2C15.55 184.9 12.82 175.3 16.06 166.6C20.49 154.7 25.78 143.2 31.84 132.3L36.51 124.2C43.12 113.2 50.52 102.8 58.63 92.95C64.55 85.8 74.3 83.32 83.14 86.14L138.8 103.9C152.2 93.56 167 84.96 182.8 78.43L195.3 21.33C197.3 12.25 204.3 5.04 213.5 3.51C227.3 1.201 241.5 0 256 0C270.5 0 284.7 1.201 298.5 3.51C307.7 5.04 314.7 12.25 316.7 21.33L329.2 78.43C344.1 84.96 359.8 93.56 373.2 103.9L428.9 86.14C437.7 83.32 447.4 85.8 453.4 92.95C461.5 102.8 468.9 113.2 475.5 124.2L480.2 132.3C486.2 143.2 491.5 154.7 495.9 166.6V166.6zM256 336C300.2 336 336 300.2 336 255.1C336 211.8 300.2 175.1 256 175.1C211.8 175.1 176 211.8 176 255.1C176 300.2 211.8 336 256 336z',
			),
		),
		'label'             => __( 'Gear', 'astra' ),
		'custom_categories' => array(),
	),
	'gears'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M286.3 155.1C287.4 161.9 288 168.9 288 175.1C288 183.1 287.4 190.1 286.3 196.9L308.5 216.7C315.5 223 318.4 232.1 314.7 241.7C312.4 246.1 309.9 252.2 307.1 257.2L304 262.6C300.1 267.6 297.7 272.4 294.2 277.1C288.5 284.7 278.5 287.2 269.5 284.2L241.2 274.9C230.5 283.8 218.3 290.9 205 295.9L198.1 324.9C197 334.2 189.8 341.6 180.4 342.8C173.7 343.6 166.9 344 160 344C153.1 344 146.3 343.6 139.6 342.8C130.2 341.6 122.1 334.2 121 324.9L114.1 295.9C101.7 290.9 89.5 283.8 78.75 274.9L50.53 284.2C41.54 287.2 31.52 284.7 25.82 277.1C22.28 272.4 18.98 267.5 15.94 262.5L12.92 257.2C10.13 252.2 7.592 247 5.324 241.7C1.62 232.1 4.458 223 11.52 216.7L33.7 196.9C32.58 190.1 31.1 183.1 31.1 175.1C31.1 168.9 32.58 161.9 33.7 155.1L11.52 135.3C4.458 128.1 1.62 119 5.324 110.3C7.592 104.1 10.13 99.79 12.91 94.76L15.95 89.51C18.98 84.46 22.28 79.58 25.82 74.89C31.52 67.34 41.54 64.83 50.53 67.79L78.75 77.09C89.5 68.25 101.7 61.13 114.1 56.15L121 27.08C122.1 17.8 130.2 10.37 139.6 9.231C146.3 8.418 153.1 8 160 8C166.9 8 173.7 8.418 180.4 9.23C189.8 10.37 197 17.8 198.1 27.08L205 56.15C218.3 61.13 230.5 68.25 241.2 77.09L269.5 67.79C278.5 64.83 288.5 67.34 294.2 74.89C297.7 79.56 300.1 84.42 304 89.44L307.1 94.83C309.9 99.84 312.4 105 314.7 110.3C318.4 119 315.5 128.1 308.5 135.3L286.3 155.1zM160 127.1C133.5 127.1 112 149.5 112 175.1C112 202.5 133.5 223.1 160 223.1C186.5 223.1 208 202.5 208 175.1C208 149.5 186.5 127.1 160 127.1zM484.9 478.3C478.1 479.4 471.1 480 464 480C456.9 480 449.9 479.4 443.1 478.3L423.3 500.5C416.1 507.5 407 510.4 398.3 506.7C393 504.4 387.8 501.9 382.8 499.1L377.4 496C372.4 492.1 367.6 489.7 362.9 486.2C355.3 480.5 352.8 470.5 355.8 461.5L365.1 433.2C356.2 422.5 349.1 410.3 344.1 397L315.1 390.1C305.8 389 298.4 381.8 297.2 372.4C296.4 365.7 296 358.9 296 352C296 345.1 296.4 338.3 297.2 331.6C298.4 322.2 305.8 314.1 315.1 313L344.1 306.1C349.1 293.7 356.2 281.5 365.1 270.8L355.8 242.5C352.8 233.5 355.3 223.5 362.9 217.8C367.6 214.3 372.5 210.1 377.5 207.9L382.8 204.9C387.8 202.1 392.1 199.6 398.3 197.3C407 193.6 416.1 196.5 423.3 203.5L443.1 225.7C449.9 224.6 456.9 224 464 224C471.1 224 478.1 224.6 484.9 225.7L504.7 203.5C511 196.5 520.1 193.6 529.7 197.3C535 199.6 540.2 202.1 545.2 204.9L550.5 207.9C555.5 210.1 560.4 214.3 565.1 217.8C572.7 223.5 575.2 233.5 572.2 242.5L562.9 270.8C571.8 281.5 578.9 293.7 583.9 306.1L612.9 313C622.2 314.1 629.6 322.2 630.8 331.6C631.6 338.3 632 345.1 632 352C632 358.9 631.6 365.7 630.8 372.4C629.6 381.8 622.2 389 612.9 390.1L583.9 397C578.9 410.3 571.8 422.5 562.9 433.2L572.2 461.5C575.2 470.5 572.7 480.5 565.1 486.2C560.4 489.7 555.6 492.1 550.6 496L545.2 499.1C540.2 501.9 534.1 504.4 529.7 506.7C520.1 510.4 511 507.5 504.7 500.5L484.9 478.3zM512 352C512 325.5 490.5 304 464 304C437.5 304 416 325.5 416 352C416 378.5 437.5 400 464 400C490.5 400 512 378.5 512 352z',
			),
		),
		'label'             => __( 'Gears', 'astra' ),
		'custom_categories' => array(
			'business',
			'science-and-technology',
		),
	),
	'gem'                                  => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M378.7 32H133.3L256 182.7L378.7 32zM512 192l-107.4-141.3L289.6 192H512zM107.4 50.67L0 192h222.4L107.4 50.67zM244.3 474.9C247.3 478.2 251.6 480 256 480s8.653-1.828 11.67-5.062L510.6 224H1.365L244.3 474.9z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M507.9 196.4l-104-153.8C399.4 35.95 391.1 32 384 32H127.1C120 32 112.6 35.95 108.1 42.56l-103.1 153.8c-6.312 9.297-5.281 21.72 2.406 29.89l231.1 246.2C243.1 477.3 249.4 480 256 480s12.94-2.734 17.47-7.547l232-246.2C513.2 218.1 514.2 205.7 507.9 196.4zM382.5 96.59L446.1 192h-140.1L382.5 96.59zM256 178.9L177.6 80h156.7L256 178.9zM129.5 96.59L205.1 192H65.04L129.5 96.59zM256 421L85.42 240h341.2L256 421z',
			),
		),
		'label'             => __( 'Gem', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'genderless'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M192 80C94.83 80 16 158.8 16 256c0 97.17 78.83 176 176 176s176-78.83 176-176C368 158.8 289.2 80 192 80zM192 352c-52.95 0-96-43.05-96-96c0-52.95 43.05-96 96-96s96 43.05 96 96C288 308.9 244.1 352 192 352z',
			),
		),
		'label'             => __( 'Genderless', 'astra' ),
		'custom_categories' => array(),
	),
	'get-pocket'                           => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M407.6 64h-367C18.5 64 0 82.5 0 104.6v135.2C0 364.5 99.7 464 224.2 464c124 0 223.8-99.5 223.8-224.2V104.6c0-22.4-17.7-40.6-40.4-40.6zm-162 268.5c-12.4 11.8-31.4 11.1-42.4 0C89.5 223.6 88.3 227.4 88.3 209.3c0-16.9 13.8-30.7 30.7-30.7 17 0 16.1 3.8 105.2 89.3 90.6-86.9 88.6-89.3 105.5-89.3 16.9 0 30.7 13.8 30.7 30.7 0 17.8-2.9 15.7-114.8 123.2z',
			),
		),
		'label'             => __( 'Get Pocket', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'gg'                                   => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M179.2 230.4l102.4 102.4-102.4 102.4L0 256 179.2 76.8l44.8 44.8-25.6 25.6-19.2-19.2-128 128 128 128 51.5-51.5-77.1-76.5 25.6-25.6zM332.8 76.8L230.4 179.2l102.4 102.4 25.6-25.6-77.1-76.5 51.5-51.5 128 128-128 128-19.2-19.2-25.6 25.6 44.8 44.8L512 256 332.8 76.8z',
			),
		),
		'label'             => __( 'GG Currency', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'gg-circle'                            => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M257 8C120 8 9 119 9 256s111 248 248 248 248-111 248-248S394 8 257 8zm-49.5 374.8L81.8 257.1l125.7-125.7 35.2 35.4-24.2 24.2-11.1-11.1-77.2 77.2 77.2 77.2 26.6-26.6-53.1-52.9 24.4-24.4 77.2 77.2-75 75.2zm99-2.2l-35.2-35.2 24.1-24.4 11.1 11.1 77.2-77.2-77.2-77.2-26.5 26.5 53.1 52.9-24.4 24.4-77.2-77.2 75-75L432.2 255 306.5 380.6z',
			),
		),
		'label'             => __( 'GG Currency Circle', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'ghost'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M186.1 .1032c-105.1 3.126-186.1 94.75-186.1 199.9v264c0 14.25 17.3 21.38 27.3 11.25l24.95-18.5c6.625-5.001 16-4.001 21.5 2.25l43 48.31c6.25 6.251 16.37 6.251 22.62 0l40.62-45.81c6.375-7.251 17.62-7.251 24 0l40.63 45.81c6.25 6.251 16.38 6.251 22.62 0l43-48.31c5.5-6.251 14.88-7.251 21.5-2.25l24.95 18.5c10 10.13 27.3 3.002 27.3-11.25V192C384 83.98 294.9-3.147 186.1 .1032zM128 224c-17.62 0-31.1-14.38-31.1-32.01s14.38-32.01 31.1-32.01s32 14.38 32 32.01S145.6 224 128 224zM256 224c-17.62 0-32-14.38-32-32.01s14.38-32.01 32-32.01c17.62 0 32 14.38 32 32.01S273.6 224 256 224z',
			),
		),
		'label'             => __( 'Ghost', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'gift'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M152 0H154.2C186.1 0 215.7 16.91 231.9 44.45L256 85.46L280.1 44.45C296.3 16.91 325.9 0 357.8 0H360C408.6 0 448 39.4 448 88C448 102.4 444.5 115.1 438.4 128H480C497.7 128 512 142.3 512 160V224C512 241.7 497.7 256 480 256H32C14.33 256 0 241.7 0 224V160C0 142.3 14.33 128 32 128H73.6C67.46 115.1 64 102.4 64 88C64 39.4 103.4 0 152 0zM190.5 68.78C182.9 55.91 169.1 48 154.2 48H152C129.9 48 112 65.91 112 88C112 110.1 129.9 128 152 128H225.3L190.5 68.78zM360 48H357.8C342.9 48 329.1 55.91 321.5 68.78L286.7 128H360C382.1 128 400 110.1 400 88C400 65.91 382.1 48 360 48V48zM32 288H224V512H80C53.49 512 32 490.5 32 464V288zM288 512V288H480V464C480 490.5 458.5 512 432 512H288z',
			),
		),
		'label'             => __( 'Gift', 'astra' ),
		'custom_categories' => array(
			'business',
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'gifts'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M192.5 55.09L217.9 36.59C228.6 28.79 243.6 31.16 251.4 41.88C259.2 52.6 256.8 67.61 246.1 75.41L217.8 95.1H240C256.9 95.1 271.7 104.7 280.3 117.9C257.3 135.7 241.9 162.1 240.2 193.1C212.5 201 192 226.1 192 256V480C192 491.7 195.1 502.6 200.6 512H48C21.49 512 0 490.5 0 464V144C0 117.5 21.49 96 48 96H70.2L41.88 75.41C31.16 67.61 28.79 52.6 36.59 41.88C44.39 31.16 59.4 28.79 70.12 36.59L97.55 56.54L89.23 31.59C85.04 19.01 91.84 5.423 104.4 1.232C116.1-2.96 130.6 3.836 134.8 16.41L144.7 46.17L155.4 15.99C159.8 3.493 173.5-3.048 186 1.377C198.5 5.802 205 19.52 200.6 32.01L192.5 55.09zM344.2 127.1C366.6 127.1 387.8 138.4 401.5 156.2L432 195.8L462.5 156.2C476.2 138.4 497.4 127.1 519.8 127.1C559.5 127.1 592 160.1 592 199.1C592 208.4 590.6 216.5 587.9 223.1H592C618.5 223.1 640 245.5 640 271.1V352H448V255.1H416V352H224V271.1C224 245.5 245.5 223.1 272 223.1H276.1C273.4 216.5 272 208.4 272 199.1C272 160.1 304.5 127.1 344.2 127.1H344.2zM363.5 185.5C358.9 179.5 351.7 175.1 344.2 175.1C330.8 175.1 320 186.9 320 199.1C320 213.3 330.7 223.1 344 223.1H393.1L363.5 185.5zM519.8 175.1C512.3 175.1 505.1 179.5 500.5 185.5L470.9 223.1H520C533.3 223.1 544 213.3 544 199.1C544 186.9 533.2 175.1 519.8 175.1H519.8zM224 464V384H416V512H272C245.5 512 224 490.5 224 464zM448 512V384H640V464C640 490.5 618.5 512 592 512H448z',
			),
		),
		'label'             => __( 'Gifts', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'git'                                  => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M216.3 158.4H137C97 147.9 6.51 150.6 6.51 233.2c0 30.09 15 51.23 35 61-25.1 23-37 33.85-37 49.21 0 11 4.47 21.14 17.89 26.81C8.13 383.6 0 393.4 0 411.6c0 32.11 28.05 50.82 101.6 50.82 70.75 0 111.8-26.42 111.8-73.18 0-58.66-45.16-56.5-151.6-63l13.43-21.55c27.27 7.58 118.7 10 118.7-67.89 0-18.7-7.73-31.71-15-41.07l37.41-2.84zm-63.42 241.9c0 32.06-104.9 32.1-104.9 2.43 0-8.14 5.27-15 10.57-21.54 77.71 5.3 94.32 3.37 94.32 19.11zm-50.81-134.6c-52.8 0-50.46-71.16 1.2-71.16 49.54 0 50.82 71.16-1.2 71.16zm133.3 100.5v-32.1c26.75-3.66 27.24-2 27.24-11V203.6c0-8.5-2.05-7.38-27.24-16.26l4.47-32.92H324v168.7c0 6.51 .4 7.32 6.51 8.14l20.73 2.84v32.1zm52.45-244.3c-23.17 0-36.59-13.43-36.59-36.61s13.42-35.77 36.59-35.77c23.58 0 37 12.62 37 35.77s-13.42 36.61-37 36.61zM512 350.5c-17.49 8.53-43.1 16.26-66.28 16.26-48.38 0-66.67-19.5-66.67-65.46V194.8c0-5.42 1.05-4.06-31.71-4.06V154.5c35.78-4.07 50-22 54.47-66.27h38.63c0 65.83-1.34 61.81 3.26 61.81H501v40.65h-60.56v97.15c0 6.92-4.92 51.41 60.57 26.84z',
			),
		),
		'label'             => __( 'Git', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'git-alt'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M439.5 236.1L244 40.45a28.87 28.87 0 0 0 -40.81 0l-40.66 40.63 51.52 51.52c27.06-9.14 52.68 16.77 43.39 43.68l49.66 49.66c34.23-11.8 61.18 31 35.47 56.69-26.49 26.49-70.21-2.87-56-37.34L240.2 199v121.8c25.3 12.54 22.26 41.85 9.08 55a34.34 34.34 0 0 1 -48.55 0c-17.57-17.6-11.07-46.91 11.25-56v-123c-20.8-8.51-24.6-30.74-18.64-45L142.6 101 8.45 235.1a28.86 28.86 0 0 0 0 40.81l195.6 195.6a28.86 28.86 0 0 0 40.8 0l194.7-194.7a28.86 28.86 0 0 0 0-40.81z',
			),
		),
		'label'             => __( 'Git Alt', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'git-square'                           => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M100.6 334.2c48.57 3.31 58.95 2.11 58.95 11.94 0 20-65.55 20.06-65.55 1.52 .01-5.09 3.29-9.4 6.6-13.46zm27.95-116.6c-32.29 0-33.75 44.47-.75 44.47 32.51 0 31.71-44.47 .75-44.47zM448 80v352a48 48 0 0 1 -48 48H48a48 48 0 0 1 -48-48V80a48 48 0 0 1 48-48h352a48 48 0 0 1 48 48zm-227 69.31c0 14.49 8.38 22.88 22.86 22.88 14.74 0 23.13-8.39 23.13-22.88S258.6 127 243.9 127c-14.48 0-22.88 7.84-22.88 22.31zM199.2 195h-49.55c-25-6.55-81.56-4.85-81.56 46.75 0 18.8 9.4 32 21.85 38.11C74.23 294.2 66.8 301 66.8 310.6c0 6.87 2.79 13.22 11.18 16.76-8.9 8.4-14 14.48-14 25.92C64 373.4 81.53 385 127.5 385c44.22 0 69.87-16.51 69.87-45.73 0-36.67-28.23-35.32-94.77-39.38l8.38-13.43c17 4.74 74.19 6.23 74.19-42.43 0-11.69-4.83-19.82-9.4-25.67l23.38-1.78zm84.34 109.8l-13-1.78c-3.82-.51-4.07-1-4.07-5.09V192.5h-52.6l-2.79 20.57c15.75 5.55 17 4.86 17 10.17V298c0 5.62-.31 4.58-17 6.87v20.06h72.42zM384 315l-6.87-22.37c-40.93 15.37-37.85-12.41-37.85-16.73v-60.72h37.85v-25.41h-35.82c-2.87 0-2 2.52-2-38.63h-24.18c-2.79 27.7-11.68 38.88-34 41.42v22.62c20.47 0 19.82-.85 19.82 2.54v66.57c0 28.72 11.43 40.91 41.67 40.91 14.45 0 30.45-4.83 41.38-10.2z',
			),
		),
		'label'             => __( 'Dribbble', 'astra' ),
		'custom_categories' => array(),
	),
	'github'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3 .3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5 .3-6.2 2.3zm44.2-1.7c-2.9 .7-4.9 2.6-4.6 4.9 .3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3 .7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3 .3 2.9 2.3 3.9 1.6 1 3.6 .7 4.3-.7 .7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3 .7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3 .7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z',
			),
		),
		'label'             => __( 'GitHub', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'brands',
			'social',
			'social',
		),
	),
	'github-alt'                           => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 480,
				'height' => 512,
				'path'   => 'M186.1 328.7c0 20.9-10.9 55.1-36.7 55.1s-36.7-34.2-36.7-55.1 10.9-55.1 36.7-55.1 36.7 34.2 36.7 55.1zM480 278.2c0 31.9-3.2 65.7-17.5 95-37.9 76.6-142.1 74.8-216.7 74.8-75.8 0-186.2 2.7-225.6-74.8-14.6-29-20.2-63.1-20.2-95 0-41.9 13.9-81.5 41.5-113.6-5.2-15.8-7.7-32.4-7.7-48.8 0-21.5 4.9-32.3 14.6-51.8 45.3 0 74.3 9 108.8 36 29-6.9 58.8-10 88.7-10 27 0 54.2 2.9 80.4 9.2 34-26.7 63-35.2 107.8-35.2 9.8 19.5 14.6 30.3 14.6 51.8 0 16.4-2.6 32.7-7.7 48.2 27.5 32.4 39 72.3 39 114.2zm-64.3 50.5c0-43.9-26.7-82.6-73.5-82.6-18.9 0-37 3.4-56 6-14.9 2.3-29.8 3.2-45.1 3.2-15.2 0-30.1-.9-45.1-3.2-18.7-2.6-37-6-56-6-46.8 0-73.5 38.7-73.5 82.6 0 87.8 80.4 101.3 150.4 101.3h48.2c70.3 0 150.6-13.4 150.6-101.3zm-82.6-55.1c-25.8 0-36.7 34.2-36.7 55.1s10.9 55.1 36.7 55.1 36.7-34.2 36.7-55.1-10.9-55.1-36.7-55.1z',
			),
		),
		'label'             => __( 'Alternate GitHub', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'brands',
			'social',
			'social',
		),
	),
	'github-square'                        => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM277.3 415.7c-8.4 1.5-11.5-3.7-11.5-8 0-5.4 .2-33 .2-55.3 0-15.6-5.2-25.5-11.3-30.7 37-4.1 76-9.2 76-73.1 0-18.2-6.5-27.3-17.1-39 1.7-4.3 7.4-22-1.7-45-13.9-4.3-45.7 17.9-45.7 17.9-13.2-3.7-27.5-5.6-41.6-5.6-14.1 0-28.4 1.9-41.6 5.6 0 0-31.8-22.2-45.7-17.9-9.1 22.9-3.5 40.6-1.7 45-10.6 11.7-15.6 20.8-15.6 39 0 63.6 37.3 69 74.3 73.1-4.8 4.3-9.1 11.7-10.6 22.3-9.5 4.3-33.8 11.7-48.3-13.9-9.1-15.8-25.5-17.1-25.5-17.1-16.2-.2-1.1 10.2-1.1 10.2 10.8 5 18.4 24.2 18.4 24.2 9.7 29.7 56.1 19.7 56.1 19.7 0 13.9 .2 36.5 .2 40.6 0 4.3-3 9.5-11.5 8-66-22.1-112.2-84.9-112.2-158.3 0-91.8 70.2-161.5 162-161.5S388 165.6 388 257.4c.1 73.4-44.7 136.3-110.7 158.3zm-98.1-61.1c-1.9 .4-3.7-.4-3.9-1.7-.2-1.5 1.1-2.8 3-3.2 1.9-.2 3.7 .6 3.9 1.9 .3 1.3-1 2.6-3 3zm-9.5-.9c0 1.3-1.5 2.4-3.5 2.4-2.2 .2-3.7-.9-3.7-2.4 0-1.3 1.5-2.4 3.5-2.4 1.9-.2 3.7 .9 3.7 2.4zm-13.7-1.1c-.4 1.3-2.4 1.9-4.1 1.3-1.9-.4-3.2-1.9-2.8-3.2 .4-1.3 2.4-1.9 4.1-1.5 2 .6 3.3 2.1 2.8 3.4zm-12.3-5.4c-.9 1.1-2.8 .9-4.3-.6-1.5-1.3-1.9-3.2-.9-4.1 .9-1.1 2.8-.9 4.3 .6 1.3 1.3 1.8 3.3 .9 4.1zm-9.1-9.1c-.9 .6-2.6 0-3.7-1.5s-1.1-3.2 0-3.9c1.1-.9 2.8-.2 3.7 1.3 1.1 1.5 1.1 3.3 0 4.1zm-6.5-9.7c-.9 .9-2.4 .4-3.5-.6-1.1-1.3-1.3-2.8-.4-3.5 .9-.9 2.4-.4 3.5 .6 1.1 1.3 1.3 2.8 .4 3.5zm-6.7-7.4c-.4 .9-1.7 1.1-2.8 .4-1.3-.6-1.9-1.7-1.5-2.6 .4-.6 1.5-.9 2.8-.4 1.3 .7 1.9 1.8 1.5 2.6z',
			),
		),
		'label'             => __( 'Dribbble', 'astra' ),
		'custom_categories' => array(),
	),
	'gitkraken'                            => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 592,
				'height' => 512,
				'path'   => 'M565.7 118.1c-2.3-6.1-9.3-9.2-15.3-6.6-5.7 2.4-8.5 8.9-6.3 14.6 10.9 29 16.9 60.5 16.9 93.3 0 134.6-100.3 245.7-230.2 262.7V358.4c7.9-1.5 15.5-3.6 23-6.2v104c106.7-25.9 185.9-122.1 185.9-236.8 0-91.8-50.8-171.8-125.8-213.3-5.7-3.2-13-.9-15.9 5-2.7 5.5-.6 12.2 4.7 15.1 67.9 37.6 113.9 110 113.9 193.2 0 93.3-57.9 173.1-139.8 205.4v-92.2c14.2-4.5 24.9-17.7 24.9-33.5 0-13.1-6.8-24.4-17.3-30.5 8.3-79.5 44.5-58.6 44.5-83.9V170c0-38-87.9-161.8-129-164.7-2.5-.2-5-.2-7.6 0C251.1 8.3 163.2 132 163.2 170v14.8c0 25.3 36.3 4.3 44.5 83.9-10.6 6.1-17.3 17.4-17.3 30.5 0 15.8 10.6 29 24.8 33.5v92.2c-81.9-32.2-139.8-112-139.8-205.4 0-83.1 46-155.5 113.9-193.2 5.4-3 7.4-9.6 4.7-15.1-2.9-5.9-10.1-8.2-15.9-5-75 41.5-125.8 121.5-125.8 213.3 0 114.7 79.2 210.8 185.9 236.8v-104c7.6 2.5 15.1 4.6 23 6.2v123.7C131.4 465.2 31 354.1 31 219.5c0-32.8 6-64.3 16.9-93.3 2.2-5.8-.6-12.2-6.3-14.6-6-2.6-13 .4-15.3 6.6C14.5 149.7 8 183.8 8 219.5c0 155.1 122.6 281.6 276.3 287.8V361.4c6.8 .4 15 .5 23.4 0v145.8C461.4 501.1 584 374.6 584 219.5c0-35.7-6.5-69.8-18.3-101.4zM365.9 275.5c13 0 23.7 10.5 23.7 23.7 0 13.1-10.6 23.7-23.7 23.7-13 0-23.7-10.5-23.7-23.7 0-13.1 10.6-23.7 23.7-23.7zm-139.8 47.3c-13.2 0-23.7-10.7-23.7-23.7s10.5-23.7 23.7-23.7c13.1 0 23.7 10.6 23.7 23.7 0 13-10.5 23.7-23.7 23.7z',
			),
		),
		'label'             => __( 'GitKraken', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'gitlab'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M510.5 284.5l-27.26-83.96c.012 .038 .016 .077 .028 .115-.013-.044-.021-.088-.033-.132v-.01L429.1 33.87a21.33 21.33 0 0 0 -20.44-14.6A21.04 21.04 0 0 0 388.5 34L337.1 192.2H175L123.5 33.99A21.03 21.03 0 0 0 103.3 19.27h-.113A21.47 21.47 0 0 0 82.86 34L28.89 200.5l-.008 .021v0c-.013 .042-.019 .084-.033 .127 .012-.038 .017-.077 .029-.115L1.514 284.5a30.6 30.6 0 0 0 11.12 34.28L248.9 490.4c.035 .026 .074 .041 .109 .067 .1 .072 .2 .146 .3 .214-.1-.065-.187-.136-.282-.2l0 0c.015 .012 .033 .02 .05 .031s.027 .015 .041 .024l.006 0a11.99 11.99 0 0 0 1.137 .7c.054 .03 .1 .068 .157 .1l0 0c.033 .016 .064 .038 .1 .054s.053 .02 .077 .032 .038 .015 .056 .023c.044 .021 .092 .034 .136 .057 .205 .1 .421 .178 .633 .264 .2 .082 .389 .177 .592 .248l.025 .011c.034 .012 .064 .028 .1 .04s.083 .032 .125 .046l.05 .012c.053 .016 .11 .024 .163 .039 .019 .006 .042 .009 .063 .015 .284 .086 .579 .148 .872 .213 .115 .026 .225 .062 .341 .083 .017 0 .032 .009 .05 .012 .038 .008 .073 .021 .112 .027 .062 .011 .122 .031 .186 .04 .049 .007 .1 0 .151 .012h.033a11.92 11.92 0 0 0 1.7 .136h.019a11.97 11.97 0 0 0 1.7-.136h.033c.05-.008 .1 0 .153-.012s.124-.029 .187-.04c.038-.006 .073-.019 .11-.027 .017 0 .032-.009 .049-.012 .118-.023 .231-.059 .349-.084 .288-.064 .578-.126 .861-.21 .019-.006 .039-.008 .059-.014 .055-.017 .113-.024 .169-.041 .016-.006 .035-.007 .051-.012 .044-.013 .086-.032 .129-.047s.063-.028 .1-.041l.026-.01c.214-.076 .417-.175 .627-.261s.394-.154 .584-.245c.047-.023 .1-.036 .142-.059 .018-.009 .04-.015 .058-.024s.053-.02 .078-.033 .068-.04 .1-.056l0 0c.056-.028 .106-.069 .161-.1a12.34 12.34 0 0 0 1.132-.695c.029-.02 .062-.035 .092-.056 .008-.006 .017-.009 .024-.015 .035-.026 .076-.043 .11-.068l236.3-171.7A30.6 30.6 0 0 0 510.5 284.5zM408.8 49.48l46.34 142.7H362.5zm-305.6 0 46.43 142.7H56.95zM26.82 299.3a6.526 6.526 0 0 1 -2.361-7.308l20.34-62.42L193.8 420.6zm38.24-82.97h92.41L223.4 419.2zm183.4 273.8c-.047-.038-.092-.079-.138-.118-.009-.008-.018-.018-.028-.026-.091-.075-.18-.152-.268-.231-.172-.15-.341-.3-.5-.462 .014 .012 .029 .022 .043 .035l.055 .046a12.19 12.19 0 0 0 1.091 .929l.012 .011c.018 .013 .033 .03 .051 .045C248.7 490.3 248.6 490.2 248.5 490.1zm7.514-48.48L217.2 322.2 182.8 216.3H329.3zm7.935 48.11c-.091 .079-.178 .157-.27 .233l-.032 .028c-.047 .038-.091 .079-.136 .117-.1 .08-.209 .152-.313 .229 .018-.013 .033-.032 .053-.044l.009-.009a11.69 11.69 0 0 0 1.086-.926c.014-.013 .03-.024 .044-.036s.038-.03 .054-.047C264.3 489.4 264.1 489.6 263.9 489.7zm90.7-273.5h92.4l-18.91 24.23-139.5 178.7zm130.6 82.97L318.2 420.6 467.3 229.5l20.26 62.39A6.528 6.528 0 0 1 485.2 299.2z',
			),
		),
		'label'             => __( 'GitLab', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'brands',
			'social',
			'social',
		),
	),
	'gitter'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M66.4 322.5H16V0h50.4v322.5zM166.9 76.1h-50.4V512h50.4V76.1zm100.6 0h-50.4V512h50.4V76.1zM368 76h-50.4v247H368V76z',
			),
		),
		'label'             => __( 'Gitter', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'glass-water'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M352 0C360.9 0 369.4 3.692 375.4 10.19C381.5 16.69 384.6 25.42 383.9 34.28L355.1 437.7C352.1 479.6 317.3 512 275.3 512H108.7C66.72 512 31.89 479.6 28.9 437.7L.0813 34.28C-.5517 25.42 2.527 16.69 8.58 10.19C14.63 3.692 23.12 0 32 0L352 0zM97.19 168.6C116.6 178.3 139.4 178.3 158.8 168.6C179.7 158.1 204.3 158.1 225.2 168.6C244.6 178.3 267.4 178.3 286.8 168.6L311 156.5L317.6 64H66.37L72.97 156.5L97.19 168.6z',
			),
		),
		'label'             => __( 'Glass Water', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'glass-water-droplet'                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M256 196C256 229.1 227.3 256 192 256C156.7 256 128 229.1 128 196C128 171.1 161.7 125.9 180.2 102.5C186.3 94.77 197.7 94.77 203.8 102.5C222.3 125.9 256 171.1 256 196V196zM352 0C360.9 0 369.4 3.692 375.4 10.19C381.5 16.69 384.6 25.42 383.9 34.28L355.1 437.7C352.1 479.6 317.3 512 275.3 512H108.7C66.72 512 31.89 479.6 28.9 437.7L.0813 34.28C-.5517 25.42 2.527 16.69 8.58 10.19C14.63 3.692 23.12 0 32 0L352 0zM96 304C116.1 314.1 139.9 314.1 160 304C180.1 293.9 203.9 293.9 224 304C244.1 314.1 267.9 314.1 288 304L300.1 297.5L317.6 64H66.37L83.05 297.5L96 304z',
			),
		),
		'label'             => __( 'Glass Water Droplet', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'glasses'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M574.1 280.4l-45.38-181.8c-5.875-23.63-21.62-44-43-55.75c-21.5-11.75-46.1-14.13-70.25-6.375l-15.25 5.125c-8.375 2.75-12.87 11.88-10 20.25l5 15.13c2.75 8.375 11.88 12.88 20.25 10.13l13.12-4.375c10.88-3.625 23-3.625 33.25 1.75c10.25 5.375 17.5 14.5 20.38 25.75l38.38 153.9c-22.12-6.875-49.75-12.5-81.13-12.5c-34.88 0-73.1 7-114.9 26.75H251.4C210.5 258.6 171.4 251.6 136.5 251.6c-31.38 0-59 5.625-81.12 12.5l38.38-153.9c2.875-11.25 10.12-20.38 20.5-25.75C124.4 79.12 136.5 79.12 147.4 82.74l13.12 4.375c8.375 2.75 17.5-1.75 20.25-10.13l5-15.13C188.6 53.49 184.1 44.37 175.6 41.62l-15.25-5.125c-23.13-7.75-48.75-5.375-70.13 6.375c-21.37 11.75-37.12 32.13-43 55.75L1.875 280.4C.6251 285.4 .0001 290.6 .0001 295.9v70.25C.0001 428.1 51.63 480 115.3 480h37.13c60.25 0 110.4-46 114.9-105.4l2.875-38.63h35.75l2.875 38.63C313.3 433.1 363.4 480 423.6 480h37.13c63.62 0 115.2-51 115.2-113.9V295.9C576 290.6 575.4 285.5 574.1 280.4zM203.4 369.7c-2 26-24.38 46.25-51 46.25H115.2C87 415.1 64 393.6 64 366.1v-37.5c18.12-6.5 43.38-13 72.62-13c23.88 0 47.25 4.375 69.88 13L203.4 369.7zM512 366.1c0 27.5-23 49.88-51.25 49.88h-37.13c-26.62 0-49-20.25-51-46.25l-3.125-41.13c22.62-8.625 46.13-13 70-13c29 0 54.38 6.5 72.5 13V366.1z',
			),
		),
		'label'             => __( 'Glasses', 'astra' ),
		'custom_categories' => array(
			'business',
			'lifestyle-and-hobbies',
		),
	),
	'glide'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M252.8 148.6c0 8.8-1.6 17.7-3.4 26.4-5.8 27.8-11.6 55.8-17.3 83.6-1.4 6.3-8.3 4.9-13.7 4.9-23.8 0-30.5-26-30.5-45.5 0-29.3 11.2-68.1 38.5-83.1 4.3-2.5 9.2-4.2 14.1-4.2 11.4 0 12.3 8.3 12.3 17.9zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-64 187c0-5.1-20.8-37.7-25.5-39.5-2.2-.9-7.2-2.3-9.6-2.3-23.1 0-38.7 10.5-58.2 21.5l-.5-.5c4.3-29.4 14.6-57.2 14.6-87.4 0-44.6-23.8-62.7-67.5-62.7-71.7 0-108 70.8-108 123.5 0 54.7 32 85 86.3 85 7.5 0 6.9-.6 6.9 2.3-10.5 80.3-56.5 82.9-56.5 58.9 0-24.4 28-36.5 28.3-38-.2-7.6-29.3-17.2-36.7-17.2-21.1 0-32.7 33-32.7 50.6 0 32.3 20.4 54.7 53.3 54.7 48.2 0 83.4-49.7 94.3-91.7 9.4-37.7 7-39.4 12.3-42.1 20-10.1 35.8-16.8 58.4-16.8 11.1 0 19 2.3 36.7 5.2 1.8 .1 4.1-1.7 4.1-3.5z',
			),
		),
		'label'             => __( 'Glide', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'glide-g'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M407.1 211.2c-3.5-1.4-11.6-3.8-15.4-3.8-37.1 0-62.2 16.8-93.5 34.5l-.9-.9c7-47.3 23.5-91.9 23.5-140.4C320.8 29.1 282.6 0 212.4 0 97.3 0 39 113.7 39 198.4 39 286.3 90.3 335 177.6 335c12 0 11-1 11 3.8-16.9 128.9-90.8 133.1-90.8 94.6 0-39.2 45-58.6 45.5-61-.3-12.2-47-27.6-58.9-27.6-33.9 .1-52.4 51.2-52.4 79.3C32 476 64.8 512 117.5 512c77.4 0 134-77.8 151.4-145.4 15.1-60.5 11.2-63.3 19.7-67.6 32.2-16.2 57.5-27 93.8-27 17.8 0 30.5 3.7 58.9 8.4 2.9 0 6.7-2.9 6.7-5.8 0-8-33.4-60.5-40.9-63.4zm-175.3-84.4c-9.3 44.7-18.6 89.6-27.8 134.3-2.3 10.2-13.3 7.8-22 7.8-38.3 0-49-41.8-49-73.1 0-47 18-109.3 61.8-133.4 7-4.1 14.8-6.7 22.6-6.7 18.6 0 20 13.3 20 28.7-.1 14.3-2.7 28.5-5.6 42.4z',
			),
		),
		'label'             => __( 'Glide G', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'globe'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M352 256C352 278.2 350.8 299.6 348.7 320H163.3C161.2 299.6 159.1 278.2 159.1 256C159.1 233.8 161.2 212.4 163.3 192H348.7C350.8 212.4 352 233.8 352 256zM503.9 192C509.2 212.5 512 233.9 512 256C512 278.1 509.2 299.5 503.9 320H380.8C382.9 299.4 384 277.1 384 256C384 234 382.9 212.6 380.8 192H503.9zM493.4 160H376.7C366.7 96.14 346.9 42.62 321.4 8.442C399.8 29.09 463.4 85.94 493.4 160zM344.3 160H167.7C173.8 123.6 183.2 91.38 194.7 65.35C205.2 41.74 216.9 24.61 228.2 13.81C239.4 3.178 248.7 0 256 0C263.3 0 272.6 3.178 283.8 13.81C295.1 24.61 306.8 41.74 317.3 65.35C328.8 91.38 338.2 123.6 344.3 160H344.3zM18.61 160C48.59 85.94 112.2 29.09 190.6 8.442C165.1 42.62 145.3 96.14 135.3 160H18.61zM131.2 192C129.1 212.6 127.1 234 127.1 256C127.1 277.1 129.1 299.4 131.2 320H8.065C2.8 299.5 0 278.1 0 256C0 233.9 2.8 212.5 8.065 192H131.2zM194.7 446.6C183.2 420.6 173.8 388.4 167.7 352H344.3C338.2 388.4 328.8 420.6 317.3 446.6C306.8 470.3 295.1 487.4 283.8 498.2C272.6 508.8 263.3 512 255.1 512C248.7 512 239.4 508.8 228.2 498.2C216.9 487.4 205.2 470.3 194.7 446.6H194.7zM190.6 503.6C112.2 482.9 48.59 426.1 18.61 352H135.3C145.3 415.9 165.1 469.4 190.6 503.6V503.6zM321.4 503.6C346.9 469.4 366.7 415.9 376.7 352H493.4C463.4 426.1 399.8 482.9 321.4 503.6V503.6z',
			),
		),
		'label'             => __( 'Globe', 'astra' ),
		'custom_categories' => array(
			'business',
			'science-and-technology',
			'travel',
		),
	),
	'gofore'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 400,
				'height' => 512,
				'path'   => 'M324 319.8h-13.2v34.7c-24.5 23.1-56.3 35.8-89.9 35.8-73.2 0-132.4-60.2-132.4-134.4 0-74.1 59.2-134.4 132.4-134.4 35.3 0 68.6 14 93.6 39.4l62.3-63.3C335 55.3 279.7 32 220.7 32 98 32 0 132.6 0 256c0 122.5 97 224 220.7 224 63.2 0 124.5-26.2 171-82.5-2-27.6-13.4-77.7-67.7-77.7zm-12.1-112.5H205.6v89H324c33.5 0 60.5 15.1 76 41.8v-30.6c0-65.2-40.4-100.2-88.1-100.2z',
			),
		),
		'label'             => __( 'Gofore', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'golang'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M400.1 194.8C389.2 197.6 380.2 199.1 371 202.4C363.7 204.3 356.3 206.3 347.8 208.5L347.2 208.6C343 209.8 342.6 209.9 338.7 205.4C334 200.1 330.6 196.7 324.1 193.5C304.4 183.9 285.4 186.7 267.7 198.2C246.5 211.9 235.6 232.2 235.9 257.4C236.2 282.4 253.3 302.9 277.1 306.3C299.1 309.1 316.9 301.7 330.9 285.8C333 283.2 334.9 280.5 337 277.5V277.5L337 277.5C337.8 276.5 338.5 275.4 339.3 274.2H279.2C272.7 274.2 271.1 270.2 273.3 264.9C277.3 255.2 284.8 239 289.2 230.9C290.1 229.1 292.3 225.1 296.1 225.1H397.2C401.7 211.7 409 198.2 418.8 185.4C441.5 155.5 468.1 139.9 506 133.4C537.8 127.8 567.7 130.9 594.9 149.3C619.5 166.1 634.7 188.9 638.8 218.8C644.1 260.9 631.9 295.1 602.1 324.4C582.4 345.3 557.2 358.4 528.2 364.3C522.6 365.3 517.1 365.8 511.7 366.3C508.8 366.5 506 366.8 503.2 367.1C474.9 366.5 449 358.4 427.2 339.7C411.9 326.4 401.3 310.1 396.1 291.2C392.4 298.5 388.1 305.6 382.1 312.3C360.5 341.9 331.2 360.3 294.2 365.2C263.6 369.3 235.3 363.4 210.3 344.7C187.3 327.2 174.2 304.2 170.8 275.5C166.7 241.5 176.7 210.1 197.2 184.2C219.4 155.2 248.7 136.8 284.5 130.3C313.8 124.1 341.8 128.4 367.1 145.6C383.6 156.5 395.4 171.4 403.2 189.5C405.1 192.3 403.8 193.9 400.1 194.8zM48.3 200.4C47.05 200.4 46.74 199.8 47.36 198.8L53.91 190.4C54.53 189.5 56.09 188.9 57.34 188.9H168.6C169.8 188.9 170.1 189.8 169.5 190.7L164.2 198.8C163.6 199.8 162 200.7 161.1 200.7L48.3 200.4zM1.246 229.1C0 229.1-.3116 228.4 .3116 227.5L6.855 219.1C7.479 218.2 9.037 217.5 10.28 217.5H152.4C153.6 217.5 154.2 218.5 153.9 219.4L151.4 226.9C151.1 228.1 149.9 228.8 148.6 228.8L1.246 229.1zM75.72 255.9C75.1 256.8 75.41 257.7 76.65 257.7L144.6 258C145.5 258 146.8 257.1 146.8 255.9L147.4 248.4C147.4 247.1 146.8 246.2 145.5 246.2H83.2C81.95 246.2 80.71 247.1 80.08 248.1L75.72 255.9zM577.2 237.9C577 235.3 576.9 233.1 576.5 230.9C570.9 200.1 542.5 182.6 512.9 189.5C483.9 196 465.2 214.4 458.4 243.7C452.8 268 464.6 292.6 487 302.6C504.2 310.1 521.3 309.2 537.8 300.7C562.4 287.1 575.8 268 577.4 241.2C577.3 240 577.3 238.9 577.2 237.9z',
			),
		),
		'label'             => __( 'Go', 'astra' ),
		'custom_categories' => array(),
	),
	'golf-ball-tee'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M96 399.1c0 17.67 14.33 31.1 32 31.1s32 14.33 32 31.1v48h64v-48c0-17.67 14.33-31.1 32-31.1s32-14.33 32-31.1v-16H96V399.1zM192 .0001c-106 0-192 86.68-192 193.6c0 65.78 32.82 123.5 82.52 158.4h218.1C351.2 317.1 384 259.4 384 193.6C384 86.68 298 .0001 192 .0001zM179 205.1C183 206.9 187.4 208 192 208c17.53 0 31.74-14.33 31.74-31.1c0-4.688-1.111-9.062-2.904-13.07c11.03 5.016 18.77 16.08 18.77 29.07c0 17.67-14.21 31.1-31.74 31.1C194.1 224 184 216.2 179 205.1zM223.7 303.1c-12.88 0-23.86-7.812-28.83-18.93c3.977 1.809 8.316 2.93 12.96 2.93c17.53 0 31.74-14.33 31.74-31.1c0-4.688-1.109-9.062-2.904-13.07c11.03 5.016 18.77 16.08 18.77 29.07C255.5 289.7 241.3 303.1 223.7 303.1zM287.2 240c-12.88 0-23.86-7.812-28.83-18.93c3.977 1.809 8.316 2.93 12.96 2.93c17.53 0 31.73-14.33 31.73-31.1c0-4.688-1.109-9.062-2.902-13.07C311.2 183.9 318.9 195 318.9 208C318.9 225.7 304.7 240 287.2 240z',
			),
		),
		'label'             => __( 'Golf Ball Tee', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'goodreads'                            => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M299.9 191.2c5.1 37.3-4.7 79-35.9 100.7-22.3 15.5-52.8 14.1-70.8 5.7-37.1-17.3-49.5-58.6-46.8-97.2 4.3-60.9 40.9-87.9 75.3-87.5 46.9-.2 71.8 31.8 78.2 78.3zM448 88v336c0 30.9-25.1 56-56 56H56c-30.9 0-56-25.1-56-56V88c0-30.9 25.1-56 56-56h336c30.9 0 56 25.1 56 56zM330 313.2s-.1-34-.1-217.3h-29v40.3c-.8 .3-1.2-.5-1.6-1.2-9.6-20.7-35.9-46.3-76-46-51.9 .4-87.2 31.2-100.6 77.8-4.3 14.9-5.8 30.1-5.5 45.6 1.7 77.9 45.1 117.8 112.4 115.2 28.9-1.1 54.5-17 69-45.2 .5-1 1.1-1.9 1.7-2.9 .2 .1 .4 .1 .6 .2 .3 3.8 .2 30.7 .1 34.5-.2 14.8-2 29.5-7.2 43.5-7.8 21-22.3 34.7-44.5 39.5-17.8 3.9-35.6 3.8-53.2-1.2-21.5-6.1-36.5-19-41.1-41.8-.3-1.6-1.3-1.3-2.3-1.3h-26.8c.8 10.6 3.2 20.3 8.5 29.2 24.2 40.5 82.7 48.5 128.2 37.4 49.9-12.3 67.3-54.9 67.4-106.3z',
			),
		),
		'label'             => __( 'Goodreads', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'goodreads-g'                          => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M42.6 403.3h2.8c12.7 0 25.5 0 38.2 .1 1.6 0 3.1-.4 3.6 2.1 7.1 34.9 30 54.6 62.9 63.9 26.9 7.6 54.1 7.8 81.3 1.8 33.8-7.4 56-28.3 68-60.4 8-21.5 10.7-43.8 11-66.5 .1-5.8 .3-47-.2-52.8l-.9-.3c-.8 1.5-1.7 2.9-2.5 4.4-22.1 43.1-61.3 67.4-105.4 69.1-103 4-169.4-57-172-176.2-.5-23.7 1.8-46.9 8.3-69.7C58.3 47.7 112.3 .6 191.6 0c61.3-.4 101.5 38.7 116.2 70.3 .5 1.1 1.3 2.3 2.4 1.9V10.6h44.3c0 280.3 .1 332.2 .1 332.2-.1 78.5-26.7 143.7-103 162.2-69.5 16.9-159 4.8-196-57.2-8-13.5-11.8-28.3-13-44.5zM188.9 36.5c-52.5-.5-108.5 40.7-115 133.8-4.1 59 14.8 122.2 71.5 148.6 27.6 12.9 74.3 15 108.3-8.7 47.6-33.2 62.7-97 54.8-154-9.7-71.1-47.8-120-119.6-119.7z',
			),
		),
		'label'             => __( 'Goodreads G', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'google'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 488,
				'height' => 512,
				'path'   => 'M488 261.8C488 403.3 391.1 504 248 504 110.8 504 0 393.2 0 256S110.8 8 248 8c66.8 0 123 24.5 166.3 64.9l-67.5 64.9C258.5 52.6 94.3 116.6 94.3 256c0 86.5 69.1 156.6 153.7 156.6 98.2 0 135-70.4 140.8-106.9H248v-85.3h236.1c2.3 12.7 3.9 24.9 3.9 41.4z',
			),
		),
		'label'             => __( 'Google Logo', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'google-drive'                         => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M339 314.9L175.4 32h161.2l163.6 282.9H339zm-137.5 23.6L120.9 480h310.5L512 338.5H201.5zM154.1 67.4L0 338.5 80.6 480 237 208.8 154.1 67.4z',
			),
		),
		'label'             => __( 'Google Drive', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'google-pay'                           => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M105.7 215v41.25h57.1a49.66 49.66 0 0 1 -21.14 32.6c-9.54 6.55-21.72 10.28-36 10.28-27.6 0-50.93-18.91-59.3-44.22a65.61 65.61 0 0 1 0-41l0 0c8.37-25.46 31.7-44.37 59.3-44.37a56.43 56.43 0 0 1 40.51 16.08L176.5 155a101.2 101.2 0 0 0 -70.75-27.84 105.6 105.6 0 0 0 -94.38 59.11 107.6 107.6 0 0 0 0 96.18v.15a105.4 105.4 0 0 0 94.38 59c28.47 0 52.55-9.53 70-25.91 20-18.61 31.41-46.15 31.41-78.91A133.8 133.8 0 0 0 205.4 215zm389.4-4c-10.13-9.38-23.93-14.14-41.39-14.14-22.46 0-39.34 8.34-50.5 24.86l20.85 13.26q11.45-17 31.26-17a34.05 34.05 0 0 1 22.75 8.79A28.14 28.14 0 0 1 487.8 248v5.51c-9.1-5.07-20.55-7.75-34.64-7.75-16.44 0-29.65 3.88-39.49 11.77s-14.82 18.31-14.82 31.56a39.74 39.74 0 0 0 13.94 31.27c9.25 8.34 21 12.51 34.79 12.51 16.29 0 29.21-7.3 39-21.89h1v17.72h22.61V250C510.3 233.4 505.3 220.3 495.1 211zM475.9 300.3a37.32 37.32 0 0 1 -26.57 11.16A28.61 28.61 0 0 1 431 305.2a19.41 19.41 0 0 1 -7.77-15.63c0-7 3.22-12.81 9.54-17.42s14.53-7 24.07-7C470 265 480.3 268 487.6 273.9 487.6 284.1 483.7 292.9 475.9 300.3zm-93.65-142A55.71 55.71 0 0 0 341.7 142H279.1V328.7H302.7V253.1h39c16 0 29.5-5.36 40.51-15.93 .88-.89 1.76-1.79 2.65-2.68A54.45 54.45 0 0 0 382.3 158.3zm-16.58 62.23a30.65 30.65 0 0 1 -23.34 9.68H302.7V165h39.63a32 32 0 0 1 22.6 9.23A33.18 33.18 0 0 1 365.7 220.5zM614.3 201 577.8 292.7h-.45L539.9 201H514.2L566 320.5l-29.35 64.32H561L640 201z',
			),
		),
		'label'             => __( 'Google Pay', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'brands',
			'brands',
			'social',
		),
	),
	'google-play'                          => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M325.3 234.3L104.6 13l280.8 161.2-60.1 60.1zM47 0C34 6.8 25.3 19.2 25.3 35.3v441.3c0 16.1 8.7 28.5 21.7 35.3l256.6-256L47 0zm425.2 225.6l-58.9-34.1-65.7 64.5 65.7 64.5 60.1-34.1c18-14.3 18-46.5-1.2-60.8zM104.6 499l280.8-161.2-60.1-60.1L104.6 499z',
			),
		),
		'label'             => __( 'Google Play', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'google-plus'                          => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 8C119.1 8 8 119.1 8 256S119.1 504 256 504 504 392.9 504 256 392.9 8 256 8zM185.3 380a124 124 0 0 1 0-248c31.3 0 60.1 11 83 32.3l-33.6 32.6c-13.2-12.9-31.3-19.1-49.4-19.1-42.9 0-77.2 35.5-77.2 78.1S142.3 334 185.3 334c32.6 0 64.9-19.1 70.1-53.3H185.3V238.1H302.2a109.2 109.2 0 0 1 1.9 20.7c0 70.8-47.5 121.2-118.8 121.2zM415.5 273.8v35.5H380V273.8H344.5V238.3H380V202.8h35.5v35.5h35.2v35.5z',
			),
		),
		'label'             => __( 'Google Plus', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'google-plus-g'                        => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M386.1 228.5c1.834 9.692 3.143 19.38 3.143 31.96C389.2 370.2 315.6 448 204.8 448c-106.1 0-192-85.92-192-192s85.92-192 192-192c51.86 0 95.08 18.86 128.6 50.29l-52.13 50.03c-14.15-13.62-39.03-29.6-76.49-29.6-65.48 0-118.9 54.22-118.9 121.3 0 67.06 53.44 121.3 118.9 121.3 75.96 0 104.5-54.74 108.1-82.77H204.8v-66.01h181.3zm185.4 6.437V179.2h-56v55.73h-55.73v56h55.73v55.73h56v-55.73H627.2v-56h-55.73z',
			),
		),
		'label'             => __( 'Google Plus G', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'google-plus-square'                   => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM164 356c-55.3 0-100-44.7-100-100s44.7-100 100-100c27 0 49.5 9.8 67 26.2l-27.1 26.1c-7.4-7.1-20.3-15.4-39.8-15.4-34.1 0-61.9 28.2-61.9 63.2 0 34.9 27.8 63.2 61.9 63.2 39.6 0 54.4-28.5 56.8-43.1H164v-34.4h94.4c1 5 1.6 10.1 1.6 16.6 0 57.1-38.3 97.6-96 97.6zm220-81.8h-29v29h-29.2v-29h-29V245h29v-29H355v29h29v29.2z',
			),
		),
		'label'             => __( 'Dribbble', 'astra' ),
		'custom_categories' => array(),
	),
	'google-wallet'                        => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M156.8 126.8c37.6 60.6 64.2 113.1 84.3 162.5-8.3 33.8-18.8 66.5-31.3 98.3-13.2-52.3-26.5-101.3-56-148.5 6.5-36.4 2.3-73.6 3-112.3zM109.3 200H16.1c-6.5 0-10.5 7.5-6.5 12.7C51.8 267 81.3 330.5 101.3 400h103.5c-16.2-69.7-38.7-133.7-82.5-193.5-3-4-8-6.5-13-6.5zm47.8-88c68.5 108 130 234.5 138.2 368H409c-12-138-68.4-265-143.2-368H157.1zm251.8-68.5c-1.8-6.8-8.2-11.5-15.2-11.5h-88.3c-5.3 0-9 5-7.8 10.3 13.2 46.5 22.3 95.5 26.5 146 48.2 86.2 79.7 178.3 90.6 270.8 15.8-60.5 25.3-133.5 25.3-203 0-73.6-12.1-145.1-31.1-212.6z',
			),
		),
		'label'             => __( 'Google Wallet', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'brands',
			'brands',
			'social',
		),
	),
	'gopuram'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M120 0C133.3 0 144 10.75 144 24V32H184V24C184 10.75 194.7 0 208 0C221.3 0 232 10.75 232 24V32H280V24C280 10.75 290.7 0 304 0C317.3 0 328 10.75 328 24V32H368V24C368 10.75 378.7 0 392 0C405.3 0 416 10.75 416 24V128C433.7 128 448 142.3 448 160V224C465.7 224 480 238.3 480 256V352C497.7 352 512 366.3 512 384V480C512 497.7 497.7 512 480 512H416V352H384V224H352V128H320V224H352V352H384V512H304V464C304 437.5 282.5 416 256 416C229.5 416 208 437.5 208 464V512H128V352H160V224H192V128H160V224H128V352H96V512H32C14.33 512 0 497.7 0 480V384C0 366.3 14.33 352 32 352V256C32 238.3 46.33 224 64 224V160C64 142.3 78.33 128 96 128V24C96 10.75 106.7 0 120 0zM256 272C238.3 272 224 286.3 224 304V352H288V304C288 286.3 273.7 272 256 272zM224 224H288V192C288 174.3 273.7 160 256 160C238.3 160 224 174.3 224 192V224z',
			),
		),
		'label'             => __( 'Gopuram', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'graduation-cap'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M623.1 136.9l-282.7-101.2c-13.73-4.91-28.7-4.91-42.43 0L16.05 136.9C6.438 140.4 0 149.6 0 160s6.438 19.65 16.05 23.09L76.07 204.6c-11.89 15.8-20.26 34.16-24.55 53.95C40.05 263.4 32 274.8 32 288c0 9.953 4.814 18.49 11.94 24.36l-24.83 149C17.48 471.1 25 480 34.89 480H93.11c9.887 0 17.41-8.879 15.78-18.63l-24.83-149C91.19 306.5 96 297.1 96 288c0-10.29-5.174-19.03-12.72-24.89c4.252-17.76 12.88-33.82 24.94-47.03l190.6 68.23c13.73 4.91 28.7 4.91 42.43 0l282.7-101.2C633.6 179.6 640 170.4 640 160S633.6 140.4 623.1 136.9zM351.1 314.4C341.7 318.1 330.9 320 320 320c-10.92 0-21.69-1.867-32-5.555L142.8 262.5L128 405.3C128 446.6 213.1 480 320 480c105.1 0 192-33.4 192-74.67l-14.78-142.9L351.1 314.4z',
			),
		),
		'label'             => __( 'Graduation Cap', 'astra' ),
		'custom_categories' => array(
			'education',
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'gratipay'                             => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M248 8C111.1 8 0 119.1 0 256s111.1 248 248 248 248-111.1 248-248S384.9 8 248 8zm114.6 226.4l-113 152.7-112.7-152.7c-8.7-11.9-19.1-50.4 13.6-72 28.1-18.1 54.6-4.2 68.5 11.9 15.9 17.9 46.6 16.9 61.7 0 13.9-16.1 40.4-30 68.1-11.9 32.9 21.6 22.6 60 13.8 72z',
			),
		),
		'label'             => __( 'Gratipay (Gittip)', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'grav'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M301.1 212c4.4 4.4 4.4 11.9 0 16.3l-9.7 9.7c-4.4 4.7-11.9 4.7-16.6 0l-10.5-10.5c-4.4-4.7-4.4-11.9 0-16.6l9.7-9.7c4.4-4.4 11.9-4.4 16.6 0l10.5 10.8zm-30.2-19.7c3-3 3-7.8 0-10.5-2.8-3-7.5-3-10.5 0-2.8 2.8-2.8 7.5 0 10.5 3.1 2.8 7.8 2.8 10.5 0zm-26 5.3c-3 2.8-3 7.5 0 10.2 2.8 3 7.5 3 10.5 0 2.8-2.8 2.8-7.5 0-10.2-3-3-7.7-3-10.5 0zm72.5-13.3c-19.9-14.4-33.8-43.2-11.9-68.1 21.6-24.9 40.7-17.2 59.8 .8 11.9 11.3 29.3 24.9 17.2 48.2-12.5 23.5-45.1 33.2-65.1 19.1zm47.7-44.5c-8.9-10-23.3 6.9-15.5 16.1 7.4 9 32.1 2.4 15.5-16.1zM504 256c0 137-111 248-248 248S8 393 8 256 119 8 256 8s248 111 248 248zm-66.2 42.6c2.5-16.1-20.2-16.6-25.2-25.7-13.6-24.1-27.7-36.8-54.5-30.4 11.6-8 23.5-6.1 23.5-6.1 .3-6.4 0-13-9.4-24.9 3.9-12.5 .3-22.4 .3-22.4 15.5-8.6 26.8-24.4 29.1-43.2 3.6-31-18.8-59.2-49.8-62.8-22.1-2.5-43.7 7.7-54.3 25.7-23.2 40.1 1.4 70.9 22.4 81.4-14.4-1.4-34.3-11.9-40.1-34.3-6.6-25.7 2.8-49.8 8.9-61.4 0 0-4.4-5.8-8-8.9 0 0-13.8 0-24.6 5.3 11.9-15.2 25.2-14.4 25.2-14.4 0-6.4-.6-14.9-3.6-21.6-5.4-11-23.8-12.9-31.7 2.8 .1-.2 .3-.4 .4-.5-5 11.9-1.1 55.9 16.9 87.2-2.5 1.4-9.1 6.1-13 10-21.6 9.7-56.2 60.3-56.2 60.3-28.2 10.8-77.2 50.9-70.6 79.7 .3 3 1.4 5.5 3 7.5-2.8 2.2-5.5 5-8.3 8.3-11.9 13.8-5.3 35.2 17.7 24.4 15.8-7.2 29.6-20.2 36.3-30.4 0 0-5.5-5-16.3-4.4 27.7-6.6 34.3-9.4 46.2-9.1 8 3.9 8-34.3 8-34.3 0-14.7-2.2-31-11.1-41.5 12.5 12.2 29.1 32.7 28 60.6-.8 18.3-15.2 23-15.2 23-9.1 16.6-43.2 65.9-30.4 106 0 0-9.7-14.9-10.2-22.1-17.4 19.4-46.5 52.3-24.6 64.5 26.6 14.7 108.8-88.6 126.2-142.3 34.6-20.8 55.4-47.3 63.9-65 22 43.5 95.3 94.5 101.1 59z',
			),
		),
		'label'             => __( 'Grav', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'greater-than'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M32.03 448c-11.75 0-23.05-6.469-28.66-17.69c-7.906-15.81-1.5-35.03 14.31-42.94l262.8-131.4L17.69 124.6C1.875 116.7-4.531 97.51 3.375 81.7c7.891-15.81 27.06-22.19 42.94-14.31l320 160C377.2 232.8 384 243.9 384 256c0 12.12-6.844 23.19-17.69 28.63l-320 160C41.72 446.9 36.83 448 32.03 448z',
			),
		),
		'label'             => __( 'Greater Than', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'greater-than-equal'                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M34.28 331.9c5.016 12.53 17.03 20.12 29.73 20.12c3.953 0 7.969-.7187 11.88-2.281l320-127.1C408 216.9 416 205.1 416 192s-7.969-24.85-20.11-29.72l-320-128c-16.47-6.594-35.05 1.406-41.61 17.84C27.72 68.55 35.7 87.17 52.11 93.73l245.7 98.28L52.11 290.3C35.7 296.9 27.72 315.5 34.28 331.9zM416 416H32c-17.67 0-32 14.31-32 31.99s14.33 32.01 32 32.01h384c17.67 0 32-14.32 32-32.01S433.7 416 416 416z',
			),
		),
		'label'             => __( 'Greater Than Equal', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'grip'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M128 184C128 206.1 110.1 224 88 224H40C17.91 224 0 206.1 0 184V136C0 113.9 17.91 96 40 96H88C110.1 96 128 113.9 128 136V184zM128 376C128 398.1 110.1 416 88 416H40C17.91 416 0 398.1 0 376V328C0 305.9 17.91 288 40 288H88C110.1 288 128 305.9 128 328V376zM160 136C160 113.9 177.9 96 200 96H248C270.1 96 288 113.9 288 136V184C288 206.1 270.1 224 248 224H200C177.9 224 160 206.1 160 184V136zM288 376C288 398.1 270.1 416 248 416H200C177.9 416 160 398.1 160 376V328C160 305.9 177.9 288 200 288H248C270.1 288 288 305.9 288 328V376zM320 136C320 113.9 337.9 96 360 96H408C430.1 96 448 113.9 448 136V184C448 206.1 430.1 224 408 224H360C337.9 224 320 206.1 320 184V136zM448 376C448 398.1 430.1 416 408 416H360C337.9 416 320 398.1 320 376V328C320 305.9 337.9 288 360 288H408C430.1 288 448 305.9 448 328V376z',
			),
		),
		'label'             => __( 'Grip', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'grip-lines'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M416 288C433.7 288 448 302.3 448 320C448 337.7 433.7 352 416 352H32C14.33 352 0 337.7 0 320C0 302.3 14.33 288 32 288H416zM416 160C433.7 160 448 174.3 448 192C448 209.7 433.7 224 416 224H32C14.33 224 0 209.7 0 192C0 174.3 14.33 160 32 160H416z',
			),
		),
		'label'             => __( 'Grip Lines', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'grip-lines-vertical'                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 192,
				'height' => 512,
				'path'   => 'M64 448C64 465.7 49.67 480 32 480C14.33 480 0 465.7 0 448V64C0 46.33 14.33 32 32 32C49.67 32 64 46.33 64 64V448zM192 448C192 465.7 177.7 480 160 480C142.3 480 128 465.7 128 448V64C128 46.33 142.3 32 160 32C177.7 32 192 46.33 192 64V448z',
			),
		),
		'label'             => __( 'Grip Lines Vertical', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'grip-vertical'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M88 352C110.1 352 128 369.9 128 392V440C128 462.1 110.1 480 88 480H40C17.91 480 0 462.1 0 440V392C0 369.9 17.91 352 40 352H88zM280 352C302.1 352 320 369.9 320 392V440C320 462.1 302.1 480 280 480H232C209.9 480 192 462.1 192 440V392C192 369.9 209.9 352 232 352H280zM40 320C17.91 320 0 302.1 0 280V232C0 209.9 17.91 192 40 192H88C110.1 192 128 209.9 128 232V280C128 302.1 110.1 320 88 320H40zM280 192C302.1 192 320 209.9 320 232V280C320 302.1 302.1 320 280 320H232C209.9 320 192 302.1 192 280V232C192 209.9 209.9 192 232 192H280zM40 160C17.91 160 0 142.1 0 120V72C0 49.91 17.91 32 40 32H88C110.1 32 128 49.91 128 72V120C128 142.1 110.1 160 88 160H40zM280 32C302.1 32 320 49.91 320 72V120C320 142.1 302.1 160 280 160H232C209.9 160 192 142.1 192 120V72C192 49.91 209.9 32 232 32H280z',
			),
		),
		'label'             => __( 'Grip Vertical', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'gripfire'                             => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M112.5 301.4c0-73.8 105.1-122.5 105.1-203 0-47.1-34-88-39.1-90.4 .4 3.3 .6 6.7 .6 10C179.1 110.1 32 171.9 32 286.6c0 49.8 32.2 79.2 66.5 108.3 65.1 46.7 78.1 71.4 78.1 86.6 0 10.1-4.8 17-4.8 22.3 13.1-16.7 17.4-31.9 17.5-46.4 0-29.6-21.7-56.3-44.2-86.5-16-22.3-32.6-42.6-32.6-69.5zm205.3-39c-12.1-66.8-78-124.4-94.7-130.9l4 7.2c2.4 5.1 3.4 10.9 3.4 17.1 0 44.7-54.2 111.2-56.6 116.7-2.2 5.1-3.2 10.5-3.2 15.8 0 20.1 15.2 42.1 17.9 42.1 2.4 0 56.6-55.4 58.1-87.7 6.4 11.7 9.1 22.6 9.1 33.4 0 41.2-41.8 96.9-41.8 96.9 0 11.6 31.9 53.2 35.5 53.2 1 0 2.2-1.4 3.2-2.4 37.9-39.3 67.3-85 67.3-136.8 0-8-.7-16.2-2.2-24.6z',
			),
		),
		'label'             => __( 'Gripfire, Inc.', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'group-arrows-rotate'                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M159.7 89.85C159.9 91.87 159.1 93.93 159.1 96C159.1 131.3 131.3 160 95.1 160C93.92 160 91.87 159.9 89.85 159.7C82.34 172.6 76.29 186.5 71.94 201.1C66.9 218.1 49.08 227.7 32.15 222.7C15.21 217.6 5.562 199.8 10.6 182.9C17.01 161.4 26.15 141 37.64 122.3C34.02 114.3 31.1 105.4 31.1 96C31.1 60.65 60.65 32 95.1 32C105.4 32 114.3 34.02 122.3 37.64C141 26.16 161.4 17.01 182.9 10.61C199.8 5.566 217.6 15.21 222.7 32.15C227.7 49.09 218.1 66.91 201.1 71.95C186.5 76.3 172.6 82.34 159.7 89.85V89.85zM389.7 37.64C397.7 34.02 406.6 32 415.1 32C451.3 32 479.1 60.65 479.1 96C479.1 105.4 477.1 114.3 474.4 122.3C485.8 141 494.1 161.4 501.4 182.9C506.4 199.8 496.8 217.6 479.8 222.7C462.9 227.7 445.1 218.1 440.1 201.1C435.7 186.5 429.7 172.6 422.1 159.7C420.1 159.9 418.1 160 416 160C380.7 160 352 131.3 352 96C352 93.93 352.1 91.87 352.3 89.85C339.4 82.34 325.5 76.3 310.9 71.95C293.9 66.91 284.3 49.09 289.3 32.15C294.4 15.21 312.2 5.566 329.1 10.61C350.6 17.01 370.1 26.16 389.7 37.64L389.7 37.64zM89.85 352.3C91.87 352.1 93.92 352 95.1 352C131.3 352 159.1 380.7 159.1 416C159.1 418.1 159.9 420.1 159.7 422.2C172.6 429.7 186.5 435.7 201.1 440.1C218.1 445.1 227.7 462.9 222.7 479.9C217.6 496.8 199.8 506.4 182.9 501.4C161.4 494.1 141 485.8 122.3 474.4C114.3 477.1 105.4 480 95.1 480C60.65 480 31.1 451.3 31.1 416C31.1 406.6 34.02 397.7 37.64 389.7C26.15 370.1 17.01 350.6 10.6 329.1C5.562 312.2 15.21 294.4 32.15 289.3C49.08 284.3 66.9 293.9 71.94 310.9C76.29 325.5 82.34 339.4 89.85 352.3L89.85 352.3zM474.4 389.7C477.1 397.7 479.1 406.6 479.1 416C479.1 451.3 451.3 480 415.1 480C406.6 480 397.7 477.1 389.7 474.4C370.1 485.8 350.6 494.1 329.1 501.4C312.2 506.4 294.4 496.8 289.3 479.9C284.3 462.9 293.9 445.1 310.9 440.1C325.5 435.7 339.4 429.7 352.3 422.2C352.1 420.1 351.1 418.1 351.1 416C351.1 380.7 380.7 352 415.1 352C418.1 352 420.1 352.1 422.2 352.3C429.7 339.4 435.7 325.5 440.1 310.9C445.1 293.9 462.9 284.3 479.8 289.3C496.8 294.4 506.4 312.2 501.4 329.1C494.1 350.6 485.8 370.1 474.4 389.7H474.4zM192.8 256.8C192.8 281.6 206.9 303.2 227.7 313.8C239.5 319.9 244.2 334.3 238.2 346.1C232.1 357.9 217.7 362.6 205.9 356.6C169.7 338.1 144.8 300.4 144.8 256.8C144.8 227.9 155.7 201.6 173.7 181.7L162.5 170.6C155.1 163.1 160.6 152.8 169.9 152.8H230.4C236.1 152.8 240.8 157.5 240.8 163.2V223.7C240.8 232.1 229.6 237.6 223 231L207.7 215.7C198.4 226.8 192.8 241.1 192.8 256.8V256.8zM275.4 165.9C281.5 154.1 295.9 149.4 307.7 155.4C343.9 173.9 368.8 211.6 368.8 255.2C368.8 284.1 357.8 310.5 339.9 330.3L351 341.5C357.6 348 352.1 359.2 343.7 359.2H283.2C277.5 359.2 272.8 354.6 272.8 348.8V288.3C272.8 279 284 274.4 290.6 280.1L305.9 296.3C315.2 285.2 320.8 270.9 320.8 255.2C320.8 230.4 306.6 208.8 285.9 198.2C274.1 192.1 269.4 177.7 275.4 165.9V165.9z',
			),
		),
		'label'             => __( 'Group Arrows Rotate', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'grunt'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M61.3 189.3c-1.1 10 5.2 19.1 5.2 19.1 .7-7.5 2.2-12.8 4-16.6 .4 10.3 3.2 23.5 12.8 34.1 6.9 7.6 35.6 23.3 54.9 6.1 1 2.4 2.1 5.3 3 8.5 2.9 10.3-2.7 25.3-2.7 25.3s15.1-17.1 13.9-32.5c10.8-.5 21.4-8.4 21.1-19.5 0 0-18.9 10.4-35.5-8.8-9.7-11.2-40.9-42-83.1-31.8 4.3 1 8.9 2.4 13.5 4.1h-.1c-4.2 2-6.5 7.1-7 12zm28.3-1.8c19.5 11 37.4 25.7 44.9 37-5.7 3.3-21.7 10.4-38-1.7-10.3-7.6-9.8-26.2-6.9-35.3zm142.1 45.8c-1.2 15.5 13.9 32.5 13.9 32.5s-5.6-15-2.7-25.3c.9-3.2 2-6 3-8.5 19.3 17.3 48 1.5 54.8-6.1 9.6-10.6 12.3-23.8 12.8-34.1 1.8 3.8 3.4 9.1 4 16.6 0 0 6.4-9.1 5.2-19.1-.6-5-2.9-10-7-11.8h-.1c4.6-1.8 9.2-3.2 13.5-4.1-42.3-10.2-73.4 20.6-83.1 31.8-16.7 19.2-35.5 8.8-35.5 8.8-.2 10.9 10.4 18.9 21.2 19.3zm62.7-45.8c3 9.1 3.4 27.7-7 35.4-16.3 12.1-32.2 5-37.9 1.6 7.5-11.4 25.4-26 44.9-37zM160 418.5h-29.4c-5.5 0-8.2 1.6-9.5 2.9-1.9 2-2.2 4.7-.9 8.1 3.5 9.1 11.4 16.5 13.7 18.6 3.1 2.7 7.5 4.3 11.8 4.3 4.4 0 8.3-1.7 11-4.6 7.5-8.2 11.9-17.1 13-19.8 .6-1.5 1.3-4.5-.9-6.8-1.8-1.8-4.7-2.7-8.8-2.7zm189.2-101.2c-2.4 17.9-13 33.8-24.6 43.7-3.1-22.7-3.7-55.5-3.7-62.4 0-14.7 9.5-24.5 12.2-26.1 2.5-1.5 5.4-3 8.3-4.6 18-9.6 40.4-21.6 40.4-43.7 0-16.2-9.3-23.2-15.4-27.8-.8-.6-1.5-1.1-2.2-1.7-2.1-1.7-3.7-3-4.3-4.4-4.4-9.8-3.6-34.2-1.7-37.6 .6-.6 16.7-20.9 11.8-39.2-2-7.4-6.9-13.3-14.1-17-5.3-2.7-11.9-4.2-19.5-4.5-.1-2-.5-3.9-.9-5.9-.6-2.6-1.1-5.3-.9-8.1 .4-4.7 .8-9 2.2-11.3 8.4-13.3 28.8-17.6 29-17.6l12.3-2.4-8.1-9.5c-.1-.2-17.3-17.5-46.3-17.5-7.9 0-16 1.3-24.1 3.9-24.2 7.8-42.9 30.5-49.4 39.3-3.1-1-6.3-1.9-9.6-2.7-4.2-15.8 9-38.5 9-38.5s-13.6-3-33.7 15.2c-2.6-6.5-8.1-20.5-1.8-37.2C184.6 10.1 177.2 26 175 40.4c-7.6-5.4-6.7-23.1-7.2-27.6-7.5 .9-29.2 21.9-28.2 48.3-2 .5-3.9 1.1-5.9 1.7-6.5-8.8-25.1-31.5-49.4-39.3-7.9-2.2-16-3.5-23.9-3.5-29 0-46.1 17.3-46.3 17.5L6 46.9l12.3 2.4c.2 0 20.6 4.3 29 17.6 1.4 2.2 1.8 6.6 2.2 11.3 .2 2.8-.4 5.5-.9 8.1-.4 1.9-.8 3.9-.9 5.9-7.7 .3-14.2 1.8-19.5 4.5-7.2 3.7-12.1 9.6-14.1 17-5 18.2 11.2 38.5 11.8 39.2 1.9 3.4 2.7 27.8-1.7 37.6-.6 1.4-2.2 2.7-4.3 4.4-.7 .5-1.4 1.1-2.2 1.7-6.1 4.6-15.4 11.7-15.4 27.8 0 22.1 22.4 34.1 40.4 43.7 3 1.6 5.8 3.1 8.3 4.6 2.7 1.6 12.2 11.4 12.2 26.1 0 6.9-.6 39.7-3.7 62.4-11.6-9.9-22.2-25.9-24.6-43.8 0 0-29.2 22.6-20.6 70.8 5.2 29.5 23.2 46.1 47 54.7 8.8 19.1 29.4 45.7 67.3 49.6C143 504.3 163 512 192.2 512h.2c29.1 0 49.1-7.7 63.6-19.5 37.9-3.9 58.5-30.5 67.3-49.6 23.8-8.7 41.7-25.2 47-54.7 8.2-48.4-21.1-70.9-21.1-70.9zM305.7 37.7c5.6-1.8 11.6-2.7 17.7-2.7 11 0 19.9 3 24.7 5-3.1 1.4-6.4 3.2-9.7 5.3-2.4-.4-5.6-.8-9.2-.8-10.5 0-20.5 3.1-28.7 8.9-12.3 8.7-18 16.9-20.7 22.4-2.2-1.3-4.5-2.5-7.1-3.7-1.6-.8-3.1-1.5-4.7-2.2 6.1-9.1 19.9-26.5 37.7-32.2zm21 18.2c-.8 1-1.6 2.1-2.3 3.2-3.3 5.2-3.9 11.6-4.4 17.8-.5 6.4-1.1 12.5-4.4 17-4.2 .8-8.1 1.7-11.5 2.7-2.3-3.1-5.6-7-10.5-11.2 1.4-4.8 5.5-16.1 13.5-22.5 5.6-4.3 12.2-6.7 19.6-7zM45.6 45.3c-3.3-2.2-6.6-4-9.7-5.3 4.8-2 13.7-5 24.7-5 6.1 0 12 .9 17.7 2.7 17.8 5.8 31.6 23.2 37.7 32.1-1.6 .7-3.2 1.4-4.8 2.2-2.5 1.2-4.9 2.5-7.1 3.7-2.6-5.4-8.3-13.7-20.7-22.4-8.3-5.8-18.2-8.9-28.8-8.9-3.4 .1-6.6 .5-9 .9zm44.7 40.1c-4.9 4.2-8.3 8-10.5 11.2-3.4-.9-7.3-1.9-11.5-2.7C65 89.5 64.5 83.4 64 77c-.5-6.2-1.1-12.6-4.4-17.8-.7-1.1-1.5-2.2-2.3-3.2 7.4 .3 14 2.6 19.5 7 8 6.3 12.1 17.6 13.5 22.4zM58.1 259.9c-2.7-1.6-5.6-3.1-8.4-4.6-14.9-8-30.2-16.3-30.2-30.5 0-11.1 4.3-14.6 8.9-18.2l.5-.4c.7-.6 1.4-1.2 2.2-1.8-.9 7.2-1.9 13.3-2.7 14.9 0 0 12.1-15 15.7-44.3 1.4-11.5-1.1-34.3-5.1-43 .2 4.9 0 9.8-.3 14.4-.4-.8-.8-1.6-1.3-2.2-3.2-4-11.8-17.5-9.4-26.6 .9-3.5 3.1-6 6.7-7.8 3.8-1.9 8.8-2.9 15.1-2.9 12.3 0 25.9 3.7 32.9 6 25.1 8 55.4 30.9 64.1 37.7 .2 .2 .4 .3 .4 .3l5.6 3.9-3.5-5.8c-.2-.3-19.1-31.4-53.2-46.5 2-2.9 7.4-8.1 21.6-15.1 21.4-10.5 46.5-15.8 74.3-15.8 27.9 0 52.9 5.3 74.3 15.8 14.2 6.9 19.6 12.2 21.6 15.1-34 15.1-52.9 46.2-53.1 46.5l-3.5 5.8 5.6-3.9s.2-.1 .4-.3c8.7-6.8 39-29.8 64.1-37.7 7-2.2 20.6-6 32.9-6 6.3 0 11.3 1 15.1 2.9 3.5 1.8 5.7 4.4 6.7 7.8 2.5 9.1-6.1 22.6-9.4 26.6-.5 .6-.9 1.3-1.3 2.2-.3-4.6-.5-9.5-.3-14.4-4 8.8-6.5 31.5-5.1 43 3.6 29.3 15.7 44.3 15.7 44.3-.8-1.6-1.8-7.7-2.7-14.9 .7 .6 1.5 1.2 2.2 1.8l.5 .4c4.6 3.7 8.9 7.1 8.9 18.2 0 14.2-15.4 22.5-30.2 30.5-2.9 1.5-5.7 3.1-8.4 4.6-8.7 5-18 16.7-19.1 34.2-.9 14.6 .9 49.9 3.4 75.9-12.4 4.8-26.7 6.4-39.7 6.8-2-4.1-3.9-8.5-5.5-13.1-.7-2-19.6-51.1-26.4-62.2 5.5 39 17.5 73.7 23.5 89.6-3.5-.5-7.3-.7-11.7-.7h-117c-4.4 0-8.3 .3-11.7 .7 6-15.9 18.1-50.6 23.5-89.6-6.8 11.2-25.7 60.3-26.4 62.2-1.6 4.6-3.5 9-5.5 13.1-13-.4-27.2-2-39.7-6.8 2.5-26 4.3-61.2 3.4-75.9-.9-17.4-10.3-29.2-19-34.2zM34.8 404.6c-12.1-20-8.7-54.1-3.7-59.1 10.9 34.4 47.2 44.3 74.4 45.4-2.7 4.2-5.2 7.6-7 10l-1.4 1.4c-7.2 7.8-8.6 18.5-4.1 31.8-22.7-.1-46.3-9.8-58.2-29.5zm45.7 43.5c6 1.1 12.2 1.9 18.6 2.4 3.5 8 7.4 15.9 12.3 23.1-14.4-5.9-24.4-16-30.9-25.5zM192 498.2c-60.6-.1-78.3-45.8-84.9-64.7-3.7-10.5-3.4-18.2 .9-23.1 2.9-3.3 9.5-7.2 24.6-7.2h118.8c15.1 0 21.8 3.9 24.6 7.2 4.2 4.8 4.5 12.6 .9 23.1-6.6 18.8-24.3 64.6-84.9 64.7zm80.6-24.6c4.9-7.2 8.8-15.1 12.3-23.1 6.4-.5 12.6-1.3 18.6-2.4-6.5 9.5-16.5 19.6-30.9 25.5zm76.6-69c-12 19.7-35.6 29.3-58.1 29.7 4.5-13.3 3.1-24.1-4.1-31.8-.4-.5-.9-1-1.4-1.5-1.8-2.4-4.3-5.8-7-10 27.2-1.2 63.5-11 74.4-45.4 5 5 8.4 39.1-3.8 59zM191.9 187.7h.2c12.7-.1 27.2-17.8 27.2-17.8-9.9 6-18.8 8.1-27.3 8.3-8.5-.2-17.4-2.3-27.3-8.3 0 0 14.5 17.6 27.2 17.8zm61.7 230.7h-29.4c-4.2 0-7.2 .9-8.9 2.7-2.2 2.3-1.5 5.2-.9 6.7 1 2.6 5.5 11.3 13 19.3 2.7 2.9 6.6 4.5 11 4.5s8.7-1.6 11.8-4.2c2.3-2 10.2-9.2 13.7-18.1 1.3-3.3 1-6-.9-7.9-1.3-1.3-4-2.9-9.4-3z',
			),
		),
		'label'             => __( 'Grunt', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'guarani-sign'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M224 32V66.66C263.5 73.3 299 92.03 326.4 118.9C339 131.3 339.2 151.5 326.9 164.1C314.5 176.8 294.2 176.1 281.6 164.6C265.8 149.1 246.1 137.7 224 132V224H352C369.7 224 384 238.3 384 256C384 351.1 314.8 430.1 224 445.3V480C224 497.7 209.7 512 192 512C174.3 512 160 497.7 160 480V445.3C69.19 430.1 0 351.1 0 256C0 160.9 69.19 81.89 160 66.65V32C160 14.33 174.3 0 192 0C209.7 0 224 14.33 224 32H224zM160 132C104.8 146.2 64 196.4 64 256C64 315.6 104.8 365.8 160 379.1V132zM224 379.1C268.1 368.4 304.4 332.1 315.1 288H224V379.1z',
			),
		),
		'label'             => __( 'Guarani Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'guilded'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M443.4 64H4.571c0 103.3 22.19 180.1 43.42 222.4C112 414.1 224 448 225.3 448a312.8 312.8 0 0 0 140.6-103.5c25.91-33.92 53.1-87.19 65.92-145.8H171.8c4.14 36.43 22.18 67.95 45.1 86.94h88.59c-17.01 28.21-48.19 54.4-80.46 69.48-31.23-13.26-69.09-46.54-96.55-98.36-26.73-53.83-27.09-105.9-27.09-105.9H437.6A625.9 625.9 0 0 0 443.4 64z',
			),
		),
		'label'             => __( 'Guilded', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'guitar'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M502.7 39.02L473 9.37c-12.5-12.5-32.74-12.49-45.24 .0106l-46.24 46.37c-3.875 3.875-6.848 8.506-8.598 13.76l-12.19 36.51L284.5 182.3C272.4 173.5 259 166.5 244.4 163.1C211 155.4 177.4 162.3 154.5 185.1C145.3 194.5 138.3 206 134.3 218.6C128.3 237.1 111.1 251.3 92.14 253C68.52 255.4 46.39 264.5 29.52 281.5c-45.62 45.5-37.38 127.5 18.12 183c55.37 55.38 137.4 63.51 182.9 18c16.1-16.88 26.25-38.85 28.5-62.72c1.75-18.75 15.84-36.16 34.47-42.16c12.5-3.875 24.03-10.87 33.4-20.25c22.87-22.88 29.75-56.38 21.1-89.76c-3.375-14.63-10.39-27.99-19.14-40.11l76.25-76.26l36.53-12.17c5.125-1.75 9.894-4.715 13.77-8.59l46.36-46.29C515.2 71.72 515.2 51.52 502.7 39.02zM208 352c-26.5 0-48-21.5-48-48c0-26.5 21.5-48 48-48s47.1 21.5 47.1 48C256 330.5 234.5 352 208 352z',
			),
		),
		'label'             => __( 'Guitar', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'gulp'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 256,
				'height' => 512,
				'path'   => 'M209.8 391.1l-14.1 24.6-4.6 80.2c0 8.9-28.3 16.1-63.1 16.1s-63.1-7.2-63.1-16.1l-5.8-79.4-14.9-25.4c41.2 17.3 126 16.7 165.6 0zm-196-253.3l13.6 125.5c5.9-20 20.8-47 40-55.2 6.3-2.7 12.7-2.7 18.7 .9 5.2 3 9.6 9.3 10.1 11.8 1.2 6.5-2 9.1-4.5 9.1-3 0-5.3-4.6-6.8-7.3-4.1-7.3-10.3-7.6-16.9-2.8-6.9 5-12.9 13.4-17.1 20.7-5.1 8.8-9.4 18.5-12 28.2-1.5 5.6-2.9 14.6-.6 19.9 1 2.2 2.5 3.6 4.9 3.6 5 0 12.3-6.6 15.8-10.1 4.5-4.5 10.3-11.5 12.5-16l5.2-15.5c2.6-6.8 9.9-5.6 9.9 0 0 10.2-3.7 13.6-10 34.7-5.8 19.5-7.6 25.8-7.6 25.8-.7 2.8-3.4 7.5-6.3 7.5-1.2 0-2.1-.4-2.6-1.2-1-1.4-.9-5.3-.8-6.3 .2-3.2 6.3-22.2 7.3-25.2-2 2.2-4.1 4.4-6.4 6.6-5.4 5.1-14.1 11.8-21.5 11.8-3.4 0-5.6-.9-7.7-2.4l7.6 79.6c2 5 39.2 17.1 88.2 17.1 49.1 0 86.3-12.2 88.2-17.1l10.9-94.6c-5.7 5.2-12.3 11.6-19.6 14.8-5.4 2.3-17.4 3.8-17.4-5.7 0-5.2 9.1-14.8 14.4-21.5 1.4-1.7 4.7-5.9 4.7-8.1 0-2.9-6-2.2-11.7 2.5-3.2 2.7-6.2 6.3-8.7 9.7-4.3 6-6.6 11.2-8.5 15.5-6.2 14.2-4.1 8.6-9.1 22-5 13.3-4.2 11.8-5.2 14-.9 1.9-2.2 3.5-4 4.5-1.9 1-4.5 .9-6.1-.3-.9-.6-1.3-1.9-1.3-3.7 0-.9 .1-1.8 .3-2.7 1.5-6.1 7.8-18.1 15-34.3 1.6-3.7 1-2.6 .8-2.3-6.2 6-10.9 8.9-14.4 10.5-5.8 2.6-13 2.6-14.5-4.1-.1-.4-.1-.8-.2-1.2-11.8 9.2-24.3 11.7-20-8.1-4.6 8.2-12.6 14.9-22.4 14.9-4.1 0-7.1-1.4-8.6-5.1-2.3-5.5 1.3-14.9 4.6-23.8 1.7-4.5 4-9.9 7.1-16.2 1.6-3.4 4.2-5.4 7.6-4.5 .6 .2 1.1 .4 1.6 .7 2.6 1.8 1.6 4.5 .3 7.2-3.8 7.5-7.1 13-9.3 20.8-.9 3.3-2 9 1.5 9 2.4 0 4.7-.8 6.9-2.4 4.6-3.4 8.3-8.5 11.1-13.5 2-3.6 4.4-8.3 5.6-12.3 .5-1.7 1.1-3.3 1.8-4.8 1.1-2.5 2.6-5.1 5.2-5.1 1.3 0 2.4 .5 3.2 1.5 1.7 2.2 1.3 4.5 .4 6.9-2 5.6-4.7 10.6-6.9 16.7-1.3 3.5-2.7 8-2.7 11.7 0 3.4 3.7 2.6 6.8 1.2 2.4-1.1 4.8-2.8 6.8-4.5 1.2-4.9 .9-3.8 26.4-68.2 1.3-3.3 3.7-4.7 6.1-4.7 1.2 0 2.2 .4 3.2 1.1 1.7 1.3 1.7 4.1 1 6.2-.7 1.9-.6 1.3-4.5 10.5-5.2 12.1-8.6 20.8-13.2 31.9-1.9 4.6-7.7 18.9-8.7 22.3-.6 2.2-1.3 5.8 1 5.8 5.4 0 19.3-13.1 23.1-17 .2-.3 .5-.4 .9-.6 .6-1.9 1.2-3.7 1.7-5.5 1.4-3.8 2.7-8.2 5.3-11.3 .8-1 1.7-1.6 2.7-1.6 2.8 0 4.2 1.2 4.2 4 0 1.1-.7 5.1-1.1 6.2 1.4-1.5 2.9-3 4.5-4.5 15-13.9 25.7-6.8 25.7 .2 0 7.4-8.9 17.7-13.8 23.4-1.6 1.9-4.9 5.4-5 6.4 0 1.3 .9 1.8 2.2 1.8 2 0 6.4-3.5 8-4.7 5-3.9 11.8-9.9 16.6-14.1l14.8-136.8c-30.5 17.1-197.6 17.2-228.3 .2zm229.7-8.5c0 21-231.2 21-231.2 0 0-8.8 51.8-15.9 115.6-15.9 9 0 17.8 .1 26.3 .4l12.6-48.7L228.1 .6c1.4-1.4 5.8-.2 9.9 3.5s6.6 7.9 5.3 9.3l-.1 .1L185.9 74l-10 40.7c39.9 2.6 67.6 8.1 67.6 14.6zm-69.4 4.6c0-.8-.9-1.5-2.5-2.1l-.2 .8c0 1.3-5 2.4-11.1 2.4s-11.1-1.1-11.1-2.4c0-.1 0-.2 .1-.3l.2-.7c-1.8 .6-3 1.4-3 2.3 0 2.1 6.2 3.7 13.7 3.7 7.7 .1 13.9-1.6 13.9-3.7z',
			),
		),
		'label'             => __( 'Gulp', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'gun'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M544 64h-16V56C528 42.74 517.3 32 504 32S480 42.74 480 56V64H43.17C19.33 64 0 83.33 0 107.2v89.66C0 220.7 19.33 240 43.17 240c21.26 0 36.61 20.35 30.77 40.79l-40.69 158.4C27.41 459.6 42.76 480 64.02 480h103.8c14.29 0 26.84-9.469 30.77-23.21L226.4 352h94.58c24.16 0 45.5-15.41 53.13-38.28L398.6 240h36.1c8.486 0 16.62-3.369 22.63-9.373L480 208h64c17.67 0 32-14.33 32-32V96C576 78.33 561.7 64 544 64zM328.5 298.6C327.4 301.8 324.4 304 320.9 304H239.1L256 240h92.02L328.5 298.6zM480 160H64V128h416V160z',
			),
		),
		'label'             => __( 'Gun', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'h'                                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M384 64.01v384c0 17.67-14.33 32-32 32s-32-14.33-32-32v-192H64v192c0 17.67-14.33 32-32 32s-32-14.33-32-32v-384C0 46.34 14.33 32.01 32 32.01S64 46.34 64 64.01v128h256v-128c0-17.67 14.33-32 32-32S384 46.34 384 64.01z',
			),
		),
		'label'             => __( 'H', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'hacker-news'                          => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M0 32v448h448V32H0zm21.2 197.2H21c.1-.1 .2-.3 .3-.4 0 .1 0 .3-.1 .4zm218 53.9V384h-31.4V281.3L128 128h37.3c52.5 98.3 49.2 101.2 59.3 125.6 12.3-27 5.8-24.4 60.6-125.6H320l-80.8 155.1z',
			),
		),
		'label'             => __( 'Hacker News', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'hacker-news-square'                   => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM21.2 229.2H21c.1-.1 .2-.3 .3-.4 0 .1 0 .3-.1 .4zm218 53.9V384h-31.4V281.3L128 128h37.3c52.5 98.3 49.2 101.2 59.3 125.6 12.3-27 5.8-24.4 60.6-125.6H320l-80.8 155.1z',
			),
		),
		'label'             => __( 'Dribbble', 'astra' ),
		'custom_categories' => array(),
	),
	'hackerrank'                           => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M477.5 128C463 103.1 285.1 0 256.2 0S49.25 102.8 34.84 128s-14.49 230.8 0 256 192.4 128 221.3 128S463 409.1 477.5 384s14.51-231 .01-256zM316.1 414.2c-4 0-40.91-35.77-38-38.69 .87-.87 6.26-1.48 17.55-1.83 0-26.23 .59-68.59 .94-86.32 0-2-.44-3.43-.44-5.85h-79.93c0 7.1-.46 36.2 1.37 72.88 .23 4.54-1.58 6-5.74 5.94-10.13 0-20.27-.11-30.41-.08-4.1 0-5.87-1.53-5.74-6.11 .92-33.44 3-84-.15-212.7v-3.17c-9.67-.35-16.38-1-17.26-1.84-2.92-2.92 34.54-38.69 38.49-38.69s41.17 35.78 38.27 38.69c-.87 .87-7.9 1.49-16.77 1.84v3.16c-2.42 25.75-2 79.59-2.63 105.4h80.26c0-4.55 .39-34.74-1.2-83.64-.1-3.39 .95-5.17 4.21-5.2 11.07-.08 22.15-.13 33.23-.06 3.46 0 4.57 1.72 4.5 5.38C333 354.6 336 341.3 336 373.7c8.87 .35 16.82 1 17.69 1.84 2.88 2.91-33.62 38.69-37.58 38.69z',
			),
		),
		'label'             => __( 'Hackerrank', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'hammer'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M568.1 196.3l-22.62-22.62c-4.533-4.533-10.56-7.029-16.97-7.029s-12.44 2.496-16.97 7.029l-5.654 5.656l-20.12-20.12c4.596-23.46-2.652-47.9-19.47-64.73l-45.25-45.25C390.2 17.47 347.1 0 303.1 0C258.2 0 216 17.47 184.3 49.21L176.5 57.05L272.5 105.1v13.81c0 18.95 7.688 37.5 21.09 50.91l49.16 49.14c13.44 13.45 31.39 20.86 50.54 20.86c4.758 0 9.512-.4648 14.18-1.387l20.12 20.12l-5.654 5.654c-9.357 9.357-9.357 24.58-.002 33.94l22.62 22.62c4.535 4.533 10.56 7.031 16.97 7.031s12.44-2.498 16.97-7.031l90.53-90.5C578.3 220.8 578.3 205.6 568.1 196.3zM270.9 192.4c-3.846-3.846-7.197-8.113-10.37-12.49l-239.5 209.2c-28.12 28.12-28.16 73.72-.0371 101.8C35.12 505 53.56 512 71.1 512s36.84-7.031 50.91-21.09l209.1-239.4c-4.141-3.061-8.184-6.289-11.89-9.996L270.9 192.4z',
			),
		),
		'label'             => __( 'Hammer', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'hamsa'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M509.4 307.2C504.3 295.5 492.8 288 480 288h-64l.0001-208c0-21.1-18-40-40-40c-22 0-40 18-40 40l-.0001 134C336 219.5 331.5 224 326 224h-20c-5.5 0-10-4.5-10-9.1V40c0-21.1-17.1-40-39.1-40S215.1 18 215.1 40v174C215.1 219.5 211.5 224 205.1 224H185.1C180.5 224 175.1 219.5 175.1 214L175.1 80c0-21.1-18-40-40-40S95.1 58 95.1 80L95.1 288H31.99C19.24 288 7.743 295.5 2.618 307.2C-2.382 318.9-.1322 332.5 8.618 341.9l102.6 110C146.1 490.1 199.8 512 256 512s108.1-21.88 144.8-60.13l102.6-110C512.1 332.5 514.4 318.9 509.4 307.2zM256 416c-53 0-96.01-64-96.01-64s43-64 96.01-64s96.01 64 96.01 64S309 416 256 416zM256 320c-17.63 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S273.6 320 256 320z',
			),
		),
		'label'             => __( 'Hamsa', 'astra' ),
		'custom_categories' => array(),
	),
	'hand'                                 => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M480 128v208c0 97.05-78.95 176-176 176h-37.72c-53.42 0-103.7-20.8-141.4-58.58l-113.1-113.1C3.906 332.5 0 322.2 0 312C0 290.7 17.15 272 40 272c10.23 0 20.47 3.906 28.28 11.72L128 343.4V64c0-17.67 14.33-32 32-32s32 14.33 32 32l.0729 176C192.1 248.8 199.2 256 208 256s16.07-7.164 16.07-16L224 32c0-17.67 14.33-32 32-32s32 14.33 32 32l.0484 208c0 8.836 7.111 16 15.95 16S320 248.8 320 240L320 64c0-17.67 14.33-32 32-32s32 14.33 32 32l.0729 176c0 8.836 7.091 16 15.93 16S416 248.8 416 240V128c0-17.67 14.33-32 32-32S480 110.3 480 128z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M408 80c-3.994 0-7.91 .3262-11.73 .9551c-9.586-28.51-36.57-49.11-68.27-49.11c-6.457 0-12.72 .8555-18.68 2.457C296.6 13.73 273.9 0 248 0C222.1 0 199.3 13.79 186.6 34.44C180.7 32.85 174.5 32 168.1 32C128.4 32 96.01 64.3 96.01 104v121.6C90.77 224.6 85.41 224 80.01 224c-.0026 0 .0026 0 0 0C36.43 224 0 259.2 0 304.1c0 20.29 7.558 39.52 21.46 54.45l81.25 87.24C141.9 487.9 197.4 512 254.9 512h33.08C393.9 512 480 425.9 480 320V152C480 112.3 447.7 80 408 80zM432 320c0 79.41-64.59 144-143.1 144H254.9c-44.41 0-86.83-18.46-117.1-50.96l-79.76-85.63c-6.202-6.659-9.406-15.4-9.406-23.1c0-22.16 18.53-31.4 31.35-31.4c8.56 0 17.1 3.416 23.42 10.18l26.72 28.69C131.8 312.7 133.9 313.4 135.9 313.4c4.106 0 8.064-3.172 8.064-8.016V104c0-13.25 10.75-24 23.1-24c13.25 0 23.1 10.75 23.1 24v152C192 264.8 199.2 272 208 272s15.1-7.163 15.1-15.1L224 72c0-13.25 10.75-24 23.1-24c13.25 0 23.1 10.75 23.1 24v184C272 264.8 279.2 272 288 272s15.99-7.164 15.99-15.1l.0077-152.2c0-13.25 10.75-24 23.1-24c13.25 0 23.1 10.75 23.1 24v152.2C352 264.8 359.2 272 368 272s15.1-7.163 15.1-15.1V152c0-13.25 10.75-24 23.1-24c13.25 0 23.1 10.75 23.1 24V320z',
			),
		),
		'label'             => __( 'Hand', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
		),
	),
	'hand-back-fist'                       => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M448 144v120.4C448 314.2 422.6 358.1 384 384v128H128v-128l-53.19-38.67C48 325.8 32 294.3 32 261.2V192c0-14.58 6.625-28.38 17.1-37.48L80 130.5V176C80 184.8 87.16 192 96 192s16-7.164 16-16v-128C112 21.48 133.5 0 160 0c25.38 0 45.96 19.77 47.67 44.73C216.2 36.9 227.5 32 240 32C266.5 32 288 53.48 288 80v5.531C296.6 72.57 311.3 64 328 64c23.47 0 42.94 16.87 47.11 39.14C382.4 98.7 390.9 96 400 96C426.5 96 448 117.5 448 144z',
			),
			'regular' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M377.1 68.05C364.4 50.65 343.7 40 321.2 40h-13.53c-3.518 0-7.039 .2754-10.53 .8184C284.8 31.33 269.6 26 253.5 26H240c-3.977 0-7.904 .3691-11.75 1.084C216.7 10.71 197.6 0 176 0H160C124.7 0 96 28.65 96 64v49.71L63.04 143.3C43.3 160 32 184.6 32 210.9v78.97c0 32.1 17.11 61.65 44.65 77.12L112 386.9v101.1C112 501.3 122.7 512 135.1 512S160 501.3 160 488v-129.9c-1.316-.6543-2.775-.9199-4.062-1.639l-55.78-31.34C87.72 318.2 80 304.6 80 289.9V210.9c0-12.31 5.281-23.77 14.5-31.39L112 163.8V208C112 216.8 119.2 224 128 224s16-7.156 16-16V64c0-8.828 7.188-16 16-16h16C184.8 48 192 55.17 192 64v16c0 9.578 7.942 16.04 16.15 16.04c6.432 0 12.31-4.018 14.73-10.17C223.3 84.84 228.3 74 240 74h13.53c20.97 0 17.92 19.58 34.27 19.58c8.177 0 9.9-5.584 19.88-5.584h13.53c25.54 0 18.27 28.23 38.66 28.23c.1562 0 .3125-.002 .4668-.0078L375.4 116C388.1 116 400 127.7 400 142V272c0 36.15-19.54 67.32-48 83.69v132.3C352 501.3 362.7 512 375.1 512S400 501.3 400 488v-108.1C430.1 352.8 448 313.6 448 272V142C448 102.1 416.8 69.44 377.1 68.05z',
			),
		),
		'label'             => __( 'Hand Back Fist', 'astra' ),
		'custom_categories' => array(),
	),
	'hand-dots'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M448 96c-17.67 0-32 14.33-32 32v112C416 248.8 408.8 256 400 256s-15.93-7.164-15.93-16L384 64c0-17.67-14.33-32-32-32s-32 14.33-32 32l.0498 176c0 8.836-7.219 16-16.06 16s-15.95-7.164-15.95-16L288 32c0-17.67-14.33-32-32-32S224 14.33 224 32l.0729 208C224.1 248.8 216.8 256 208 256S192.1 248.8 192.1 240L192 64c0-17.67-14.33-32-32-32S128 46.33 128 64v279.4L68.28 283.7C60.47 275.9 50.23 272 40 272C18.68 272 0 289.2 0 312c0 10.23 3.906 20.47 11.72 28.28l113.1 113.1C162.6 491.2 212.9 512 266.3 512H304c97.05 0 176-78.95 176-176V128C480 110.3 465.7 96 448 96zM192 416c-8.836 0-16-7.164-16-16C176 391.2 183.2 384 192 384s16 7.162 16 16C208 408.8 200.8 416 192 416zM256 448c-8.836 0-16-7.164-16-16c0-8.838 7.164-16 16-16s16 7.162 16 16C272 440.8 264.8 448 256 448zM256 352c-8.836 0-16-7.164-16-16c0-8.838 7.164-16 16-16s16 7.162 16 16C272 344.8 264.8 352 256 352zM320 384c-8.836 0-16-7.164-16-16c0-8.838 7.164-16 16-16s16 7.162 16 16C336 376.8 328.8 384 320 384zM352 448c-8.836 0-16-7.164-16-16c0-8.838 7.164-16 16-16s16 7.162 16 16C368 440.8 360.8 448 352 448zM384 352c-8.836 0-16-7.164-16-16c0-8.838 7.164-16 16-16s16 7.162 16 16C400 344.8 392.8 352 384 352z',
			),
		),
		'label'             => __( 'Hand Dots', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'hand-fist'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M224 180.4V32c0-17.67-14.31-32-32-32S160 14.33 160 32v144h40C208.5 176 216.5 177.7 224 180.4zM128 176V64c0-17.67-14.31-32-32-32S64 46.33 64 64v112.8C66.66 176.5 69.26 176 72 176H128zM288 192c17.69 0 32-14.33 32-32V64c0-17.67-14.31-32-32-32s-32 14.33-32 32v96C256 177.7 270.3 192 288 192zM384 96c-17.69 0-32 14.33-32 32v64c0 17.67 14.31 32 32 32s32-14.34 32-32.02V128C416 110.3 401.7 96 384 96zM350.9 246.2c-12.43-7.648-21.94-19.31-26.88-33.25C313.7 219.9 301.3 223.9 288 223.9c-7.641 0-14.87-1.502-21.66-3.957C269.1 228.6 272 238.1 272 248c0 39.77-32.25 72-72 72H128c-8.836 0-16-7.164-16-16C112 295.2 119.2 288 128 288h72c22.09 0 40-17.91 40-40S222.1 208 200 208h-128C49.91 208 32 225.9 32 248v63.41c0 33.13 16 64.56 42.81 84.13L128 434.2V512h224v-85.09c38.3-24.09 64-66.42 64-114.9V247.1C406.6 252.6 395.7 256 384 256C371.7 256 360.5 252.2 350.9 246.2z',
			),
		),
		'label'             => __( 'Hand Fist', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'hand-holding'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M559.7 392.2l-135.1 99.51C406.9 504.8 385 512 362.1 512H15.1c-8.749 0-15.1-7.246-15.1-15.99l0-95.99c0-8.748 7.25-16.02 15.1-16.02l55.37 .0238l46.5-37.74c20.1-16.1 47.12-26.25 74.12-26.25h159.1c19.5 0 34.87 17.37 31.62 37.37c-2.625 15.75-17.37 26.62-33.37 26.62H271.1c-8.749 0-15.1 7.249-15.1 15.1s7.25 15.1 15.1 15.1h120.6l119.7-88.17c17.8-13.19 42.81-9.342 55.93 8.467C581.3 354.1 577.5 379.1 559.7 392.2z',
			),
		),
		'label'             => __( 'Hand Holding', 'astra' ),
		'custom_categories' => array(),
	),
	'hand-holding-dollar'                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M568.2 336.3c-13.12-17.81-38.14-21.66-55.93-8.469l-119.7 88.17h-120.6c-8.748 0-15.1-7.25-15.1-15.99c0-8.75 7.25-16 15.1-16h78.25c15.1 0 30.75-10.88 33.37-26.62c3.25-20-12.12-37.38-31.62-37.38H191.1c-26.1 0-53.12 9.25-74.12 26.25l-46.5 37.74L15.1 383.1C7.251 383.1 0 391.3 0 400v95.98C0 504.8 7.251 512 15.1 512h346.1c22.03 0 43.92-7.188 61.7-20.27l135.1-99.52C577.5 379.1 581.3 354.1 568.2 336.3zM279.3 175C271.7 173.9 261.7 170.3 252.9 167.1L248 165.4C235.5 160.1 221.8 167.5 217.4 179.1s2.121 26.2 14.59 30.64l4.655 1.656c8.486 3.061 17.88 6.095 27.39 8.312V232c0 13.25 10.73 24 23.98 24s24-10.75 24-24V221.6c25.27-5.723 42.88-21.85 46.1-45.72c8.688-50.05-38.89-63.66-64.42-70.95L288.4 103.1C262.1 95.64 263.6 92.42 264.3 88.31c1.156-6.766 15.3-10.06 32.21-7.391c4.938 .7813 11.37 2.547 19.65 5.422c12.53 4.281 26.21-2.312 30.52-14.84s-2.309-26.19-14.84-30.53c-7.602-2.627-13.92-4.358-19.82-5.721V24c0-13.25-10.75-24-24-24s-23.98 10.75-23.98 24v10.52C238.8 40.23 221.1 56.25 216.1 80.13C208.4 129.6 256.7 143.8 274.9 149.2l6.498 1.875c31.66 9.062 31.15 11.89 30.34 16.64C310.6 174.5 296.5 177.8 279.3 175z',
			),
		),
		'label'             => __( 'Hand Holding Dollar', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'hand-holding-droplet'                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M287.1 256c53 0 95.1-42.13 95.1-93.1c0-40-57.12-120.8-83.25-155.6c-6.375-8.5-19.12-8.5-25.5 0C249.1 41.25 191.1 122 191.1 162C191.1 213.9 234.1 256 287.1 256zM568.2 336.3c-13.12-17.81-38.14-21.66-55.93-8.469l-119.7 88.17h-120.6c-8.748 0-15.1-7.25-15.1-15.99c0-8.75 7.25-16 15.1-16h78.25c15.1 0 30.75-10.88 33.37-26.62c3.25-20-12.12-37.38-31.62-37.38H191.1c-26.1 0-53.12 9.25-74.12 26.25l-46.5 37.74L15.1 383.1c-8.748 0-15.1 7.274-15.1 16.02L.0001 496C.0001 504.8 7.251 512 15.1 512h346.1c22.03 0 43.92-7.188 61.7-20.27l135.1-99.52C577.5 379.1 581.3 354.1 568.2 336.3z',
			),
		),
		'label'             => __( 'Hand Holding Droplet', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'hand-holding-hand'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M328.7 52.28L431.7 119.8C449.5 132.9 453.3 157.9 440.2 175.7C427.1 193.5 402.1 197.3 384.3 184.2L296.6 127.1H191.1C183.2 127.1 175.1 135.2 175.1 143.1C175.1 152.7 183.2 159.1 191.1 159.1H254.2C270.2 159.1 284.1 170.9 287.6 186.6C290.8 206.6 275.5 223.1 255.1 223.1H143.1C116.1 223.1 90.87 214.7 69.87 197.7L23.37 159.1L15.1 160C7.25 160 0 152.7 0 143.1V47.99C0 39.25 7.25 32 15.1 32H266.1C289 32 310.9 39.19 328.7 52.28L328.7 52.28zM151.3 459.7L16.27 360.2C-1.509 347.1-5.305 322.1 7.803 304.3C20.93 286.5 45.94 282.7 63.74 295.8L183.4 384H304C312.8 384 320 376.8 320 368C320 359.3 312.8 352 304 352H225.8C209.8 352 195 341.1 192.4 325.4C189.2 305.4 204.5 288 224 288H352C379 288 405.1 297.3 426.1 314.3L472.6 352L496 352C504.7 352 512 359.3 512 368V464C512 472.8 504.7 480 496 480H213C190.1 480 169.1 472.8 151.3 459.7V459.7z',
			),
		),
		'label'             => __( 'Hand Holding Hand', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'hand-holding-heart'                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M275.2 250.5c7 7.375 18.5 7.375 25.5 0l108.1-114.2c31.5-33.12 29.72-88.1-5.65-118.7c-30.88-26.75-76.75-21.9-104.9 7.724L287.1 36.91L276.8 25.28C248.7-4.345 202.7-9.194 171.1 17.56C136.7 48.18 134.7 103.2 166.4 136.3L275.2 250.5zM568.2 336.3c-13.12-17.81-38.14-21.66-55.93-8.469l-119.7 88.17h-120.6c-8.748 0-15.1-7.25-15.1-15.1c0-8.746 7.25-15.1 15.1-15.1h78.25c15.1 0 30.75-10.87 33.37-26.62c3.25-19.1-12.12-37.37-31.62-37.37H191.1c-26.1 0-53.12 9.25-74.12 26.25l-46.5 37.74l-55.37-.0253c-8.748 0-15.1 7.275-15.1 16.02L.0001 496C.0001 504.8 7.251 512 15.1 512h346.1c22.03 0 43.92-7.187 61.7-20.28l135.1-99.51C577.5 379.1 581.3 354.1 568.2 336.3z',
			),
		),
		'label'             => __( 'Hand Holding Heart', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'hand-holding-medical'                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M568.2 336.3c-13.12-17.81-38.14-21.66-55.93-8.469l-119.7 88.17h-120.6c-8.748 0-15.1-7.25-15.1-15.99c0-8.75 7.25-16 15.1-16h78.25c15.1 0 30.75-10.88 33.37-26.62c3.25-20-12.12-37.38-31.62-37.38H191.1c-26.1 0-53.12 9.25-74.12 26.25l-46.5 37.74L15.1 383.1C7.251 383.1 0 391.3 0 400v95.98C0 504.8 7.251 512 15.1 512h346.1c22.03 0 43.92-7.188 61.7-20.27l135.1-99.52C577.5 379.1 581.3 354.1 568.2 336.3zM160 176h64v64C224 248.8 231.2 256 240 256h64C312.8 256 320 248.8 320 240v-64h64c8.836 0 16-7.164 16-16V96c0-8.838-7.164-16-16-16h-64v-64C320 7.162 312.8 0 304 0h-64C231.2 0 224 7.162 224 16v64H160C151.2 80 144 87.16 144 96v64C144 168.8 151.2 176 160 176z',
			),
		),
		'label'             => __( 'Hand Holding Medical', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'hand-lizard'                          => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 329.1V432c0 8.836-7.164 16-16 16H368c-8.836 0-16-7.164-16-16V416l-85.33-64H95.1c-16.47 0-31.44-13.44-31.96-29.9C62.87 285.8 91.96 256 127.1 256h104.9c13.77 0 26-8.811 30.36-21.88l10.67-32C280.9 181.4 265.4 160 243.6 160H63.1C27.95 160-1.129 130.2 .0352 93.9C.5625 77.44 15.53 64 31.1 64h271.2c26.26 0 50.84 12.88 65.79 34.47l128.8 185.1C507 297.8 512 313.7 512 329.1z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 331.8V424c0 13.25-10.75 24-24 24c-13.25 0-24-10.75-24-24v-92.17c0-10.09-3.031-19.8-8.766-28.08l-118.6-170.5C327.4 119.1 312.2 112 295.1 112H53.32c-2.5 0-5.25 2.453-5.313 4.172c-.2969 9.5 3.156 18.47 9.75 25.28C64.36 148.3 73.2 152 82.67 152h161.8c17.09 0 33.4 8.281 43.4 22.14c9.984 13.88 12.73 31.83 7.328 48.05l-9.781 29.34C278.2 273.3 257.8 288 234.9 288H138.7C129.2 288 120.4 291.8 113.8 298.5c-6.594 6.812-10.05 15.78-9.75 25.28C104.1 325.5 106.8 328 109.3 328h156.6c5.188 0 10.14 1.688 14.3 4.797l78.22 58.67c6.031 4.531 9.594 11.66 9.594 19.2L367.1 424c0 13.25-10.75 24-24 24s-24-10.75-24-24v-1.328L257.8 376H109.3c-28.48 0-52.39-22.72-53.28-50.64c-.7187-22.61 7.531-43.98 23.23-60.2C94.1 248.9 116.1 240 138.7 240h96.19c2.297 0 4.328-1.469 5.063-3.656l9.781-29.33c.7031-2.141-.0156-3.797-.7344-4.797C248.2 201.2 246.9 200 244.6 200H82.67c-22.58 0-43.67-8.938-59.39-25.16C7.575 158.6-.6755 137.3 .0433 114.6C.9339 86.72 24.84 64 53.32 64h242.7c31.94 0 61.86 15.67 80.05 41.92l118.6 170.5C506 292.8 512 311.9 512 331.8z',
			),
		),
		'label'             => __( 'Hand Lizard', 'astra' ),
		'custom_categories' => array(),
	),
	'hand-middle-finger'                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M448 288v96c0 70.69-57.31 128-128 128H184c-50.35 0-97.76-23.7-127.1-63.98l-14.43-19.23C35.37 420.5 32 410.4 32 400v-48.02c0-14.58 6.629-28.37 18.02-37.48L80 290.5V336C80 344.8 87.16 352 96 352s16-7.164 16-16v-96C112 213.5 133.5 192 160 192s48 21.48 48 48V40C208 17.91 225.9 0 248 0S288 17.91 288 40v189.5C296.6 216.6 311.3 208 328 208c23.48 0 42.94 16.87 47.11 39.14C382.4 242.7 390.8 240 400 240C426.5 240 448 261.5 448 288z',
			),
		),
		'label'             => __( 'Hand Middle Finger', 'astra' ),
		'custom_categories' => array(),
	),
	'hand-peace'                           => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 287.4V32c0-17.67-14.31-32-32-32S192 14.33 192 32v216.3C218.7 248.4 243.7 263.1 256 287.4zM170.8 251.2c2.514-.7734 5.043-1.027 7.57-1.516L93.41 51.39C88.21 39.25 76.34 31.97 63.97 31.97c-20.97 0-31.97 18.01-31.97 32.04c0 4.207 .8349 8.483 2.599 12.6l81.97 191.3L170.8 251.2zM416 224c-17.69 0-32 14.33-32 32v64c0 17.67 14.31 32 32 32s32-14.33 32-32V256C448 238.3 433.7 224 416 224zM320 352c17.69 0 32-14.33 32-32V224c0-17.67-14.31-32-32-32s-32 14.33-32 32v96C288 337.7 302.3 352 320 352zM368 361.9C356.3 375.3 339.2 384 320 384c-27.41 0-50.62-17.32-59.73-41.55c-7.059 21.41-23.9 39.23-47.08 46.36l-47.96 14.76c-1.562 .4807-3.147 .7105-4.707 .7105c-6.282 0-12.18-3.723-14.74-9.785c-.8595-2.038-1.264-4.145-1.264-6.213c0-6.79 4.361-13.16 11.3-15.3l46.45-14.29c17.2-5.293 29.76-20.98 29.76-38.63c0-34.19-32.54-40.07-40.02-40.07c-3.89 0-7.848 .5712-11.76 1.772l-104 32c-18.23 5.606-28.25 22.21-28.25 38.22c0 4.266 .6825 8.544 2.058 12.67L68.19 419C86.71 474.5 138.7 512 197.2 512H272c82.54 0 151.8-57.21 170.7-134C434.6 381.8 425.6 384 416 384C396.8 384 379.7 375.3 368 361.9z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M412 160c-8.326 0-16.3 1.51-23.68 4.27C375.1 151.8 358.9 144 340 144c-11.64 0-22.44 3.223-32.03 8.418l11.12-68.95c.6228-3.874 .9243-7.725 .9243-11.53c0-36.08-28.91-71.95-72.09-71.95c-34.68 0-65.31 25.16-71.03 60.54L173.4 82.22L168.9 72.77c-12.4-25.75-38.07-40.78-64.89-40.78c-40.8 0-72.01 33.28-72.01 72.07c0 10.48 2.296 21.11 7.144 31.18L89.05 238.9C64.64 250.4 48 275.7 48 303.1v80c0 22.06 10.4 43.32 27.83 56.86l45.95 35.74c29.35 22.83 65.98 35.41 103.2 35.41l78.81 .0352C400.9 512 480 432.1 480 335.8v-107.5C480 189.6 447.9 160 412 160zM320 212.3C320 201.1 328.1 192 340 192c11.02 0 20 9.078 20 20.25v55.5C360 278.9 351 288 340 288C328.1 288 320 278.9 320 267.8V212.3zM247.9 47.98c12.05 0 24.13 9.511 24.13 23.98c0 1.277-.1022 2.57-.3134 3.871L248.4 220.5C240.7 217.6 232.4 215.1 223.9 215.1c0 0 .002 0 0 0c-4.475 0-8.967 .4199-13.38 1.254l-10.55 1.627l24.32-150.7C226.2 56.42 236.4 47.98 247.9 47.98zM79.1 104c0-13.27 10.79-24.04 24.02-24.04c8.937 0 17.5 5.023 21.61 13.61l61.29 127.3L137.3 228.5L82.38 114.4C80.76 111.1 79.1 107.5 79.1 104zM303.8 464l-78.81-.0352c-26.56 0-52.72-8.984-73.69-25.3l-45.97-35.75C99.47 398.4 96 391.3 96 383.1v-80c0-11.23 7.969-21.11 17.59-23.22l105.3-16.23C220.6 264.2 222.3 263.1 223.9 263.1c11.91 0 24.09 9.521 24.09 24.06c0 11.04-7.513 20.95-17.17 23.09L172.8 319c-12.03 1.633-20.78 11.92-20.78 23.75c0 20.21 18.82 24.08 23.7 24.08c2.645 0 64.61-8.619 65.54-8.826c23.55-5.227 41.51-22.23 49.73-43.64C303.3 327.5 320.6 336 340 336c8.326 0 16.31-1.51 23.69-4.27C376 344.2 393.1 352 412 352c.1992 0 10.08-.4453 18.65-2.92C423.9 413.5 369.9 464 303.8 464zM432 283.8C432 294.9 423 304 412 304c-11.02 0-20-9.078-20-20.25v-55.5C392 217.1 400.1 208 412 208c11.02 0 20 9.078 20 20.25V283.8z',
			),
		),
		'label'             => __( 'Hand Peace', 'astra' ),
		'custom_categories' => array(),
	),
	'hand-point-down'                      => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M256 256v64c0 17.67 14.31 32 32 32s32-14.33 32-32V256c0-17.67-14.31-32-32-32S256 238.3 256 256zM200 272H160V352c0 17.67 14.31 32 32 32s32-14.33 32-32V267.6C216.5 270.3 208.5 272 200 272zM72 272C69.26 272 66.66 271.5 64 271.2V480c0 17.67 14.31 32 32 32s32-14.33 32-32V272H72zM416 288V224c0-17.67-14.31-32-32-32s-32 14.33-32 32v64c0 17.67 14.31 32 32 32S416 305.7 416 288zM384 160c11.72 0 22.55 3.381 32 8.879V136C416 60.89 355.1 0 280 0L191.3 0C162.5 0 134.5 9.107 111.2 26.02L74.81 52.47C48 72.03 32 103.5 32 136.6V200C32 222.1 49.91 240 72 240h128c22.09 0 39.1-17.91 39.1-39.1c0-28.73-26.72-40-42.28-40l-69.72 0C119.2 160 112 152.8 112 144S119.2 128 127.1 128H200c37.87 0 68.59 29.35 71.45 66.51C276.8 193.1 282.2 192 288 192c13.28 0 25.6 4.047 35.83 10.97C332.6 178 356.1 160 384 160z',
			),
			'regular' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M448 248V144C448 64.6 385.1 0 307.7 0H199.8C176.4 0 153.1 6.104 132.5 17.65L76.63 49C49.1 64.47 32 94.02 32 126.1V176c0 27.23 12.51 51.53 32 67.69V440C64 479.7 96.3 512 136 512s72-32.3 72-72v-56.44C210.6 383.9 213.3 384 216 384c25.95 0 48.73-13.79 61.4-34.43C283.3 351.2 289.6 352 296 352c25.95 0 48.73-13.79 61.4-34.43C363.3 319.2 369.6 320 376 320C415.7 320 448 287.7 448 248zM272 232c0-13.23 10.78-24 24-24S320 218.9 320 232.1V280c0 13.23-10.78 24-24 24S272 293.2 272 280V232zM192 264h12c12.39 0 23.93-3.264 34.27-8.545C239.3 258.1 240 260.1 240 264v48c0 13.23-10.78 24-24 24S192 325.2 192 312V264zM112 264c0-.2813 .1504-.5137 .1602-.793C114.8 263.4 117.3 264 120 264H160v176c0 13.23-10.78 24-24 24S112 453.2 112 440V264zM397.9 123.8C390.9 121.6 383.7 120 376 120c-29.04 0-53.96 17.37-65.34 42.18C305.8 161.2 301 160 296 160c-7.139 0-13.96 1.273-20.46 3.355C265.2 133.6 237.2 112 204 112H152C138.8 112 128 122.8 128 136S138.8 160 152 160h52c15.44 0 28 12.56 28 28S219.4 216 204 216H120C97.94 216 80 198.1 80 176V126.1c0-14.77 7.719-28.28 20.16-35.27l55.78-31.34C169.4 51.98 184.6 48 199.8 48h107.9C351.9 48 388.9 80.56 397.9 123.8zM400 248c0 13.23-10.78 24-24 24S352 261.2 352 248V192c0-13.23 10.78-24 24-24S400 178.8 400 192V248z',
			),
		),
		'label'             => __( 'Hand Point Down', 'astra' ),
		'custom_categories' => array(),
	),
	'hand-point-left'                      => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 288H192c-17.67 0-32 14.31-32 32s14.33 32 32 32h64c17.67 0 32-14.31 32-32S273.7 288 256 288zM240 232V192H160C142.3 192 128 206.3 128 224s14.33 32 32 32h84.41C241.7 248.5 240 240.5 240 232zM240 104C240 101.3 240.5 98.66 240.8 96H32C14.33 96 0 110.3 0 128s14.33 32 32 32h208V104zM224 448h64c17.67 0 32-14.31 32-32s-14.33-32-32-32H224c-17.67 0-32 14.31-32 32S206.3 448 224 448zM352 416c0 11.72-3.381 22.55-8.879 32H376C451.1 448 512 387.1 512 312V223.3c0-28.76-9.107-56.79-26.02-80.06l-26.45-36.41C439.1 80 408.5 64 375.4 64H312c-22.09 0-40 17.91-40 40v128c0 22.09 17.91 39.1 39.1 39.1c28.73 0 40-26.72 40-42.28L352 159.1C352 151.2 359.2 144 368 144S384 151.2 384 159.1V232c0 37.87-29.35 68.59-66.51 71.45C318.9 308.8 320 314.2 320 320c0 13.28-4.047 25.6-10.97 35.83C333.1 364.6 352 388.1 352 416z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M264 480h104c79.4 0 144-62.95 144-140.3V231.8c0-23.44-6.104-46.73-17.65-67.35L462.1 108.6C447.5 81.1 417.1 64 385.9 64H336c-27.23 0-51.53 12.51-67.69 32H72C32.3 96 0 128.3 0 168S32.3 240 72 240h56.44C128.1 242.6 128 245.3 128 248c0 25.95 13.79 48.73 34.43 61.4C160.8 315.3 160 321.6 160 328c0 25.95 13.79 48.73 34.43 61.4C192.8 395.3 192 401.6 192 408C192 447.7 224.3 480 264 480zM280 304c13.23 0 24 10.78 24 24S293.1 352 279.9 352H232c-13.23 0-24-10.78-24-24S218.8 304 232 304H280zM248 224v12c0 12.39 3.264 23.93 8.545 34.27C253.9 271.3 251 272 248 272h-48C186.8 272 176 261.2 176 248S186.8 224 200 224H248zM248 144c.2813 0 .5137 .1504 .793 .1602C248.6 146.8 248 149.3 248 152V192h-176C58.77 192 48 181.2 48 168S58.77 144 72 144H248zM388.2 429.9C390.4 422.9 392 415.7 392 408c0-29.04-17.37-53.96-42.18-65.34C350.8 337.8 352 333 352 328c0-7.139-1.273-13.96-3.355-20.46C378.4 297.2 400 269.2 400 236V184C400 170.8 389.3 160 376 160S352 170.8 352 184v52c0 15.44-12.56 28-28 28S296 251.4 296 236V152c0-22.06 17.94-40 40-40h49.88c14.77 0 28.28 7.719 35.27 20.16l31.34 55.78C460 201.4 464 216.6 464 231.8v107.9C464 383.9 431.4 420.9 388.2 429.9zM264 432c-13.23 0-24-10.78-24-24S250.8 384 264 384H320c13.23 0 24 10.78 24 24S333.2 432 320 432H264z',
			),
		),
		'label'             => __( 'Hand Point Left', 'astra' ),
		'custom_categories' => array(),
	),
	'hand-point-right'                     => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M224 320c0 17.69 14.33 32 32 32h64c17.67 0 32-14.31 32-32s-14.33-32-32-32h-64C238.3 288 224 302.3 224 320zM267.6 256H352c17.67 0 32-14.31 32-32s-14.33-32-32-32h-80v40C272 240.5 270.3 248.5 267.6 256zM272 160H480c17.67 0 32-14.31 32-32s-14.33-32-32-32h-208.8C271.5 98.66 272 101.3 272 104V160zM320 416c0-17.69-14.33-32-32-32H224c-17.67 0-32 14.31-32 32s14.33 32 32 32h64C305.7 448 320 433.7 320 416zM202.1 355.8C196 345.6 192 333.3 192 320c0-5.766 1.08-11.24 2.51-16.55C157.4 300.6 128 269.9 128 232V159.1C128 151.2 135.2 144 143.1 144S160 151.2 159.1 159.1l0 69.72C159.1 245.2 171.3 271.1 200 271.1C222.1 271.1 240 254.1 240 232v-128C240 81.91 222.1 64 200 64H136.6C103.5 64 72.03 80 52.47 106.8L26.02 143.2C9.107 166.5 0 194.5 0 223.3V312C0 387.1 60.89 448 136 448h32.88C163.4 438.6 160 427.7 160 416C160 388.1 178 364.6 202.1 355.8z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M320 408c0-6.428-.8457-12.66-2.434-18.6C338.2 376.7 352 353.9 352 328c0-6.428-.8457-12.66-2.434-18.6C370.2 296.7 384 273.9 384 248c0-2.705-.1484-5.373-.4414-8H440C479.7 240 512 207.7 512 168S479.7 96 440 96H243.7C227.5 76.51 203.2 64 176 64H126.1C94.02 64 64.47 81.1 49 108.6L17.65 164.5C6.104 185.1 0 208.4 0 231.8v107.9C0 417.1 64.6 480 144 480h104C287.7 480 320 447.7 320 408zM280 304c13.23 0 24 10.78 24 24S293.2 352 280 352H232.1C218.9 352 208 341.2 208 328S218.8 304 232 304H280zM312 224c13.23 0 24 10.78 24 24S325.2 272 312 272h-48c-3.029 0-5.875-.7012-8.545-1.73C260.7 259.9 264 248.4 264 236V224H312zM440 144c13.23 0 24 10.78 24 24S453.2 192 440 192h-176V152c0-2.686-.5566-5.217-.793-7.84C263.5 144.2 263.7 144 264 144H440zM48 339.7V231.8c0-15.25 3.984-30.41 11.52-43.88l31.34-55.78C97.84 119.7 111.4 112 126.1 112H176c22.06 0 40 17.94 40 40v84c0 15.44-12.56 28-28 28S160 251.4 160 236V184C160 170.8 149.3 160 136 160S112 170.8 112 184v52c0 33.23 21.58 61.25 51.36 71.54C161.3 314 160 320.9 160 328c0 5.041 1.166 9.836 2.178 14.66C137.4 354 120 378.1 120 408c0 7.684 1.557 14.94 3.836 21.87C80.56 420.9 48 383.9 48 339.7zM192 432c-13.23 0-24-10.78-24-24S178.8 384 192 384h56c13.23 0 24 10.78 24 24s-10.77 24-24 24H192z',
			),
		),
		'label'             => __( 'Hand Point Right', 'astra' ),
		'custom_categories' => array(),
	),
	'hand-point-up'                        => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M288 288c17.69 0 32-14.33 32-32V192c0-17.67-14.31-32-32-32s-32 14.33-32 32v64C256 273.7 270.3 288 288 288zM224 244.4V160c0-17.67-14.31-32-32-32S160 142.3 160 160v80h40C208.5 240 216.5 241.7 224 244.4zM128 240V32c0-17.67-14.31-32-32-32S64 14.33 64 32v208.8C66.66 240.5 69.26 240 72 240H128zM384 192c-17.69 0-32 14.33-32 32v64c0 17.67 14.31 32 32 32s32-14.33 32-32V224C416 206.3 401.7 192 384 192zM323.8 309C313.6 315.1 301.3 320 288 320c-5.766 0-11.24-1.08-16.55-2.51C268.6 354.6 237.9 384 200 384H127.1C119.2 384 112 376.8 112 368S119.2 352 127.1 352l69.72 .0001c15.52 0 42.28-11.29 42.28-40C239.1 289.9 222.1 272 200 272h-128C49.91 272 32 289.9 32 312v63.41c0 33.13 16 64.56 42.81 84.13l36.41 26.45C134.5 502.9 162.5 512 191.3 512H280c75.11 0 136-60.89 136-136v-32.88C406.6 348.6 395.7 352 384 352C356.1 352 332.6 333.1 323.8 309z',
			),
			'regular' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M376 192c-6.428 0-12.66 .8457-18.6 2.434C344.7 173.8 321.9 160 296 160c-6.428 0-12.66 .8457-18.6 2.434C264.7 141.8 241.9 128 216 128C213.3 128 210.6 128.1 208 128.4V72C208 32.3 175.7 0 136 0S64 32.3 64 72v196.3C44.51 284.5 32 308.8 32 336v49.88c0 32.1 17.1 61.65 44.63 77.12l55.83 31.35C153.1 505.9 176.4 512 199.8 512h107.9C385.1 512 448 447.4 448 368V264C448 224.3 415.7 192 376 192zM272 232c0-13.23 10.78-24 24-24S320 218.8 320 232v47.91C320 293.1 309.2 304 296 304S272 293.2 272 280V232zM192 200C192 186.8 202.8 176 216 176s24 10.77 24 24v48c0 3.029-.7012 5.875-1.73 8.545C227.9 251.3 216.4 248 204 248H192V200zM112 72c0-13.23 10.78-24 24-24S160 58.77 160 72v176H120c-2.686 0-5.217 .5566-7.84 .793C112.2 248.5 112 248.3 112 248V72zM307.7 464H199.8c-15.25 0-30.41-3.984-43.88-11.52l-55.78-31.34C87.72 414.2 80 400.6 80 385.9V336c0-22.06 17.94-40 40-40h84c15.44 0 28 12.56 28 28S219.4 352 204 352H152C138.8 352 128 362.8 128 376s10.75 24 24 24h52c33.23 0 61.25-21.58 71.54-51.36C282 350.7 288.9 352 296 352c5.041 0 9.836-1.166 14.66-2.178C322 374.6 346.1 392 376 392c7.684 0 14.94-1.557 21.87-3.836C388.9 431.4 351.9 464 307.7 464zM400 320c0 13.23-10.78 24-24 24S352 333.2 352 320V264c0-13.23 10.78-24 24-24s24 10.77 24 24V320z',
			),
		),
		'label'             => __( 'Hand Point Up', 'astra' ),
		'custom_categories' => array(),
	),
	'hand-pointer'                         => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M400 224c-9.148 0-17.62 2.697-24.89 7.143C370.9 208.9 351.5 192 328 192c-17.38 0-32.46 9.33-40.89 23.17C282.1 192.9 263.5 176 240 176c-12.35 0-23.49 4.797-32 12.46V40c0-22.09-17.9-40-39.1-40C145.9 0 128 17.91 128 40v322.7L72 288C64.15 277.5 52.13 272 39.97 272c-21.22 0-39.97 17.06-39.97 40.02c0 8.356 2.608 16.78 8.005 23.98l91.22 121.6C124.8 491.7 165.5 512 208 512h96C383.4 512 448 447.4 448 368v-96C448 245.5 426.5 224 400 224zM240 400c0 8.844-7.156 16-16 16s-16-7.156-16-16v-96C208 295.2 215.2 288 224 288s16 7.156 16 16V400zM304 400c0 8.844-7.156 16-16 16s-16-7.156-16-16v-96C272 295.2 279.2 288 288 288s16 7.156 16 16V400zM368 400c0 8.844-7.156 16-16 16s-16-7.156-16-16v-96C336 295.2 343.2 288 352 288s16 7.156 16 16V400z',
			),
			'regular' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M208 288C199.2 288 192 295.2 192 304v96C192 408.8 199.2 416 208 416s16-7.164 16-16v-96C224 295.2 216.8 288 208 288zM272 288C263.2 288 256 295.2 256 304v96c0 8.836 7.162 16 15.1 16S288 408.8 288 400l-.0013-96C287.1 295.2 280.8 288 272 288zM376.9 201.2c-13.74-17.12-34.8-27.45-56.92-27.45h-13.72c-3.713 0-7.412 .291-11.07 .8652C282.7 165.1 267.4 160 251.4 160h-11.44V72c0-39.7-32.31-72-72.01-72c-39.7 0-71.98 32.3-71.98 72v168.5C84.85 235.1 75.19 235.4 69.83 235.4c-44.35 0-69.83 37.23-69.83 69.85c0 14.99 4.821 29.51 13.99 41.69l78.14 104.2C120.7 489.3 166.2 512 213.7 512h109.7c6.309 0 12.83-.957 18.14-2.645c28.59-5.447 53.87-19.41 73.17-40.44C436.1 446.3 448 416.2 448 384.2V274.3C448 234.6 416.3 202.3 376.9 201.2zM400 384.2c0 19.62-7.219 38.06-20.44 52.06c-12.53 13.66-29.03 22.67-49.69 26.56C327.4 463.6 325.3 464 323.4 464H213.7c-32.56 0-63.65-15.55-83.18-41.59L52.36 318.2C49.52 314.4 48.02 309.8 48.02 305.2c0-16.32 14.5-21.75 21.72-21.75c4.454 0 12.01 1.55 17.34 8.703l28.12 37.5c3.093 4.105 7.865 6.419 12.8 6.419c11.94 0 16.01-10.7 16.01-16.01V72c0-13.23 10.78-24 23.1-24c13.22 0 24 10.77 24 24v130.7c0 6.938 5.451 16.01 16.03 16.01C219.5 218.7 220.1 208 237.7 208h13.72c21.5 0 18.56 19.21 34.7 19.21c8.063 0 9.805-5.487 20.15-5.487h13.72c26.96 0 17.37 27.43 40.77 27.43l14.07-.0037c13.88 0 25.16 11.28 25.16 25.14V384.2zM336 288C327.2 288 320 295.2 320 304v96c0 8.836 7.164 16 16 16s16-7.164 16-16v-96C352 295.2 344.8 288 336 288z',
			),
		),
		'label'             => __( 'Hand Pointer', 'astra' ),
		'custom_categories' => array(),
	),
	'hand-scissors'                        => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 192v111.1C512 383.4 447.4 448 368 448H288c-26.52 0-48-21.48-48-47.99c0-9.152 2.697-17.61 7.139-24.89C224.9 370.1 208 351.5 208 328c0-16.72 8.561-31.4 21.52-39.1H40c-22.09 0-40-17.9-40-39.99s17.91-39.1 40-39.1h229.5L60 142.2C42.93 136.8 31.99 121.1 31.99 104c0-3.973 .5967-8.014 1.851-12.01c5.35-17.07 21.08-28.04 38.06-28.04c4 0 8.071 .6085 12.09 1.889l279.2 87.22C364.8 153.6 366.4 153.8 368 153.8c6.812 0 13.12-4.375 15.27-11.23c.4978-1.588 .7346-3.195 .7346-4.777c0-6.807-4.388-13.12-11.23-15.25l-72.54-22.67l14.29-17.85C323.6 70.67 337.4 64.04 352 64.04h48c10.39 0 20.48 3.359 28.8 9.592l38.41 28.79c25.2 18.91 40.53 47.97 43.55 79.04C511.5 184.9 512 188.4 512 192z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M270.1 480h97.92C447.4 480 512 417.1 512 339.7V231.8c0-23.45-6.106-46.73-17.66-67.33l-31.35-55.85C447.5 81.1 417.1 64 385.9 64h-46.97c-26.63 0-51.56 11.63-68.4 31.93l-15.46 18.71L127.3 68.44C119 65.46 110.5 64.05 102.1 64.05c-30.02 0-58.37 18.06-69.41 47.09C15.06 156.8 46.19 194 76.75 204.9l2.146 .7637L68.79 206.4C30.21 209 0 241.2 0 279.3c0 39.7 33.27 72.09 73.92 72.09c1.745 0 3.501-.0605 5.268-.1833l88.79-6.135v8.141c0 22.11 10.55 43.11 28.05 56.74C197.4 448.8 230.2 480 270.1 480zM269.1 432c-14.34 0-26-11.03-26-24.62c0 0 .0403-14.31 .0403-14.71c0-6.894-4.102-14.2-10.67-16.39c-10.39-3.5-17.38-12.78-17.38-23.06v-13.53c0-16.98 13.7-16.4 13.7-29.89c0-9.083-7.392-15.96-15.96-15.96c-.3646 0-.7311 .0125-1.099 .0377c0 0-138.1 9.505-138.7 9.505c-14.32 0-25.93-11.04-25.93-24.49c0-13.28 10.7-23.74 24.1-24.64l163.2-11.28c2.674-.1882 14.92-2.907 14.92-16.18c0-6.675-4.284-12.58-10.65-14.85L92.84 159.7C85.39 156.1 75.97 149.4 75.97 136.7c0-11.14 9.249-24.66 25.97-24.66c3.043 0 6.141 .5115 9.166 1.59l234.1 85.03c1.801 .6581 3.644 .9701 5.456 .9701c8.96 0 16-7.376 16-15.1c0-6.514-4.068-12.69-10.59-15.04l-64.81-23.47l15.34-18.56C315.2 117.3 326.6 112 338.9 112h46.97c14.77 0 28.28 7.719 35.27 20.16L452.5 188c7.531 13.41 11.52 28.56 11.52 43.81v107.9c0 50.91-43.06 92.31-96 92.31H269.1z',
			),
		),
		'label'             => __( 'Hand Scissors', 'astra' ),
		'custom_categories' => array(),
	),
	'hand-sparkles'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M448 432c0-14.25 8.547-28.14 21.28-34.55l39.56-16.56l15.64-37.52c4.461-9.037 11.45-15.37 19.43-19.23L544 128c0-17.67-14.33-32-32-32s-32 14.33-32 32l-.0156 112c0 8.836-7.148 16-15.98 16s-16.07-7.164-16.07-16L448 64c0-17.67-14.33-32-32-32s-32 14.33-32 32l-.0635 176c0 8.836-7.106 16-15.94 16S351.9 248.8 351.9 240L352 32c0-17.67-14.33-32-32-32S288 14.33 288 32L287.9 240C287.9 248.8 280.8 256 272 256S255.9 248.8 255.9 240L256 64c0-17.67-14.33-32-32-32S192 46.33 192 64v279.4L132.3 283.7C124.5 275.9 114.2 272 104 272C82.68 272 64 289.2 64 312c0 10.23 3.906 20.47 11.72 28.28l113.1 113.1C226.6 491.2 276.9 512 330.3 512H368c42.72 0 81.91-15.32 112.4-40.73l-9.049-3.773C456.6 460.1 448 446.3 448 432zM349.8 371.6L320 383.1l-12.42 29.78C306.1 415 305.4 416 304 416s-2.969-.9941-3.578-2.219L288 383.1l-29.79-12.42C256.1 370.1 256 369.4 256 367.1c0-1.365 .9922-2.967 2.209-3.577L288 352l12.42-29.79C301 320.1 302.6 320 304 320s2.967 .9902 3.578 2.217L320 352l29.79 12.42C351 365 352 366.6 352 367.1C352 369.4 351 370.1 349.8 371.6zM80 224c2.277 0 4.943-1.656 5.959-3.699l20.7-49.63l49.65-20.71c2.027-1.014 3.682-3.696 3.686-5.958C159.1 141.7 158.3 139.1 156.3 138L106.7 117.4L85.96 67.7C84.94 65.65 82.28 64 80 64C77.72 64 75.05 65.65 74.04 67.7L53.34 117.3L3.695 138C1.668 139.1 .0117 141.7 .0078 143.1c.0039 2.262 1.662 4.953 3.688 5.967l49.57 20.67l20.77 49.67C75.05 222.3 77.72 224 80 224zM639.1 432c-.0039-2.275-1.657-4.952-3.687-5.968l-49.57-20.67l-20.77-49.67C564.9 353.7 562.3 352 560 352c-2.281 0-4.959 1.652-5.975 3.695l-20.7 49.63l-49.64 20.71c-2.027 1.016-3.682 3.683-3.686 5.958c.0039 2.262 1.661 4.954 3.686 5.968l49.57 20.67l20.77 49.67C555.1 510.3 557.7 512 560 512c2.277 0 4.933-1.656 5.949-3.699l20.7-49.63l49.65-20.71C638.3 436.9 639.1 434.3 639.1 432z',
			),
		),
		'label'             => __( 'Hand Sparkles', 'astra' ),
		'custom_categories' => array(),
	),
	'hand-spock'                           => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M543.6 128.6c0-8.999-6.115-32.58-31.68-32.58c-14.1 0-27.02 9.324-30.92 23.56l-34.36 125.1c-1.682 6.16-7.275 10.43-13.66 10.43c-7.981 0-14.16-6.518-14.16-14.13c0-.9844 .1034-1.987 .3197-2.996l35.71-166.6c.5233-2.442 .7779-4.911 .7779-7.362c0-13.89-9.695-32.86-31.7-32.86c-14.79 0-28.12 10.26-31.34 25.29l-37.77 176.2c-2.807 13.1-14.38 22.46-27.77 22.46c-13.04 0-24.4-8.871-27.56-21.52l-52.11-208.5C243.6 11.2 230.5-.0013 215.6-.0013c-26.71 0-31.78 25.71-31.78 31.98c0 2.569 .3112 5.18 .9617 7.786l50.55 202.2c.2326 .9301 .3431 1.856 .3431 2.764c0 6.051-4.911 11.27-11.3 11.27c-4.896 0-9.234-3.154-10.74-7.812L166.9 103.9C162.4 89.1 149.5 80.02 135.5 80.02c-15.68 0-31.63 12.83-31.63 31.97c0 3.273 .5059 6.602 1.57 9.884l69.93 215.7c.2903 .8949 .4239 1.766 .4239 2.598c0 4.521-3.94 7.915-8.119 7.915c-1.928 0-3.906-.7219-5.573-2.388L101.7 285.3c-8.336-8.336-19.63-12.87-30.81-12.87c-23.56 0-39.07 19.69-39.07 39.55c0 10.23 3.906 20.47 11.72 28.28l122.5 122.5C197.6 494.3 240.3 512 284.9 512h50.98c23.5 0 108.4-14.57 132.5-103l73.96-271.2C543.2 134.8 543.6 131.7 543.6 128.6z',
			),
			'regular' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M234.9 48.02c10.43 0 20.72 5.834 24.13 19.17l47.33 184.1c2.142 8.456 9.174 12.62 16.21 12.62c7.326 0 14.66-4.505 16.51-13.37l31.72-155.1c2.921-14.09 13.76-20.57 24.67-20.57c13.01 0 26.14 9.19 26.14 25.62c0 2.19-.2333 4.508-.7313 6.951l-28.48 139.2c-.2389 1.156-.3514 2.265-.3514 3.323c0 8.644 7.504 13.9 14.86 13.9c5.869 0 11.65-3.341 13.46-10.98l24.73-104.2c.2347-.9802 4.12-19.76 24.28-19.76c13.21 0 26.64 9.4 26.64 24.79c0 2.168-.2665 4.455-.8378 6.852l-48.06 204.7c-13.59 57.85-65.15 98.74-124.5 98.74l-48.79-.0234c-40.7-.0196-79.86-15.58-109.5-43.51l-75.93-71.55c-5.938-5.584-8.419-11.1-8.419-18.2c0-13.88 12.45-26.69 26.38-26.69c5.756 0 11.76 2.182 17.26 7.376l51.08 48.14c1.682 1.569 3.599 2.249 5.448 2.249c4.192 0 8.04-3.49 8.04-8.001c0-23.76-3.372-47.39-10.12-70.28L142 161.1C141.2 159.1 140.8 156.3 140.8 153.7c0-15.23 13.48-24.82 26.75-24.82c10.11 0 20.1 5.559 23.94 18.42l31.22 105.8c2.231 7.546 8.029 10.8 13.9 10.8c7.752 0 15.64-5.659 15.64-14.57c0-1.339-.1783-2.752-.562-4.23L209.3 80.06C208.7 77.45 208.3 74.97 208.3 72.62C208.3 57.33 221.7 48.02 234.9 48.02zM234.9 0C201.5 0 160.4 25.24 160.4 72.72c0 2.807 .1579 5.632 .4761 8.463C129.9 83.9 92.84 108.9 92.84 153.8c0 7.175 1.038 14.47 3.148 21.68l24.33 81.94C115.8 256.5 111.1 256 106.4 256C65.74 256 32 290.6 32 330.8c0 19.59 8.162 38.58 23.6 53.1l75.89 71.51c38.68 36.45 89.23 56.53 142.3 56.56L322.6 512c82.1 0 152.5-55.83 171.3-135.8l48.06-204.7C543.3 165.7 544 159.7 544 153.9c0-54.55-49.55-72.95-74.59-72.95c-.7689 0-1.534 .0117-2.297 .0352c-10.49-39.43-46.46-54.11-71.62-54.11c-34.1 0-64.45 24.19-71.63 58.83L319.2 108.5l-13.7-53.29C297.1 22.22 268.7 0 234.9 0z',
			),
		),
		'label'             => __( 'Hand Spock', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'handcuffs'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M304 32C304 49.67 289.7 64 272 64C254.3 64 240 49.67 240 32C240 14.33 254.3 0 272 0C289.7 0 304 14.33 304 32zM160 80C160 62.33 174.3 48 192 48C209.7 48 224 62.33 224 80C224 97.67 209.7 112 192 112C174.3 112 160 97.67 160 80zM160 128C177.7 128 192 142.3 192 160H200C213.3 160 224 170.7 224 184V200C224 201.7 223.8 203.4 223.5 205.1C280.3 229.6 320 286.2 320 352C320 440.4 248.4 512 160 512C71.63 512 0 440.4 0 352C0 286.2 39.74 229.6 96.54 205.1C96.19 203.4 96 201.7 96 200V184C96 170.7 106.7 160 120 160H128C128 142.3 142.3 128 160 128zM160 448C213 448 256 405 256 352C256 298.1 213 256 160 256C106.1 256 64 298.1 64 352C64 405 106.1 448 160 448zM337.6 278.9C354.5 246.1 382.5 219.8 416.5 205.1C416.2 203.4 416 201.7 416 199.1V183.1C416 170.7 426.7 159.1 440 159.1H448C448 142.3 462.3 127.1 480 127.1C497.7 127.1 512 142.3 512 159.1H520C533.3 159.1 544 170.7 544 183.1V199.1C544 201.7 543.8 203.4 543.5 205.1C600.3 229.6 640 286.2 640 352C640 440.4 568.4 512 480 512C417.1 512 364.2 476.7 337.6 425.1C346.9 402.5 352 377.9 352 352C352 326.1 346.9 301.5 337.6 278.9V278.9zM480 256C426.1 256 384 298.1 384 352C384 405 426.1 448 480 448C533 448 576 405 576 352C576 298.1 533 256 480 256zM336 32C336 14.33 350.3 0 368 0C385.7 0 400 14.33 400 32C400 49.67 385.7 64 368 64C350.3 64 336 49.67 336 32zM416 80C416 62.33 430.3 48 448 48C465.7 48 480 62.33 480 80C480 97.67 465.7 112 448 112C430.3 112 416 97.67 416 80z',
			),
		),
		'label'             => __( 'Handcuffs', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'hands'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M330.8 242.3L223.1 209.1C210.3 205.2 197 212.3 193.1 224.9C189.2 237.6 196.3 251 208.9 254.9L256 272H56.9c-11.61 0-22.25 7.844-24.44 19.24C29.51 306.6 41.19 320 56 320h128C188.4 320 192 323.6 192 328S188.4 336 184 336H24.9c-11.61 0-22.25 7.844-24.44 19.24C-2.49 370.6 9.193 384 24 384h160C188.4 384 192 387.6 192 392S188.4 400 184 400H56.9c-11.61 0-22.25 7.844-24.44 19.24C29.51 434.6 41.19 448 56 448h128C188.4 448 192 451.6 192 456S188.4 464 184 464H88.9c-11.61 0-22.25 7.844-24.44 19.24C61.51 498.6 73.19 512 88 512h208c66.28 0 120-53.73 120-120v-32.03C416 306.6 381.1 259.4 330.8 242.3zM197.1 179.5c5.986-2.148 12.32-3.482 18.98-3.482c5.508 0 10.99 .8105 16.5 2.471l16.11 4.975L227.7 117.2C224.2 106.2 213.6 98.39 202 99.74c-15.51 1.807-24.79 16.99-20.33 31.11L197.1 179.5zM487.1 144.5c-13.27 .0977-23.95 10.91-23.86 24.16l-2.082 50.04l-59.98-189.8c-3.496-11.07-14.18-18.86-25.71-17.51c-15.51 1.807-24.79 16.99-20.33 31.11l38.56 122.1c1.332 4.213-1.004 8.707-5.219 10.04c-4.213 1.332-8.707-1.004-10.04-5.217l-47.93-151.7c-3.496-11.07-14.18-18.86-25.71-17.51c-15.51 1.807-24.79 16.99-20.33 31.11l43.37 137.8c1.33 4.213-1.006 8.707-5.219 10.04c-4.213 1.332-8.707-1.004-10.04-5.217l-33.46-106.4C275.6 56.39 264.9 48.6 253.4 49.94c-15.51 1.807-24.79 16.99-20.33 31.11l34.15 108.1l73.7 22.76C404.1 233.3 448 292.8 448 359.9v27.91c38.27-21.17 63.28-61.24 64-106.7V168.4C511.8 155.1 500.3 144.5 487.1 144.5z',
			),
		),
		'label'             => __( 'Hands', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'hands-asl-interpreting'               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M200 240c16.94 0 32.09 10.72 37.73 26.67c5.891 16.66 24.17 25.39 40.84 19.5c16.66-5.891 25.39-24.17 19.5-40.84C287.2 214.7 262.8 191.6 233.1 181.5l79.68-22.76c16.98-4.859 26.83-22.56 21.97-39.56C329.9 102.2 312.2 92.35 295.2 97.24L196 125.6l80.82-69.28c13.42-11.5 14.97-31.7 3.469-45.12C268.8-2.24 248.6-3.803 235.2 7.713l-100.4 86.09l22.33-48.39c7.391-16.05 .3906-35.06-15.66-42.47C125.4-4.412 106.4 2.525 98.94 18.6L14.92 206.6C5.082 228.6 0 252.5 0 276.6C0 335.9 48.1 384 107.4 384l99.9-.0064c31.87-2.289 61.15-19.35 79.13-46.18c9.828-14.69 5.891-34.56-8.781-44.41C263 283.6 243.1 287.5 233.3 302.2C225.8 313.3 213.4 320 200 320c-22.06 0-40-17.94-40-40C160 257.9 177.9 240 200 240zM532.6 128l-99.9 .004c-31.87 2.289-61.15 19.35-79.13 46.18c-9.828 14.69-5.891 34.56 8.781 44.41c14.66 9.812 34.55 5.906 44.41-8.781C414.2 198.7 426.6 191.1 440 191.1c22.06 0 40 17.94 40 40c0 22.06-17.94 39.1-40 39.1c-16.94 0-32.09-10.72-37.73-26.67c-5.891-16.66-24.17-25.39-40.84-19.5c-16.66 5.891-25.39 24.17-19.5 40.84c10.84 30.64 35.23 53.77 64.96 63.8l-79.68 22.76c-16.98 4.859-26.83 22.56-21.97 39.56c4.844 16.98 22.56 26.86 39.56 21.97l99.2-28.34l-80.82 69.28c-13.42 11.5-14.97 31.7-3.469 45.12c11.52 13.42 31.73 14.98 45.13 3.469l100.4-86.09l-22.33 48.39c-7.391 16.05-.3906 35.06 15.66 42.47c16.02 7.359 35.05 .4219 42.47-15.65l84.02-188C634.9 283.4 640 259.5 640 235.4C640 176.1 591.9 128 532.6 128z',
			),
		),
		'label'             => __( 'Hands Asl Interpreting', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
		),
	),
	'hands-bound'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M95.1 144.8L165.3 237.2C170.1 244.7 181.4 246.8 189.6 242C199.3 236.3 201.7 223.3 194.6 214.5L167 179.1C156.2 166.4 158.1 146.7 171.4 135.5C184.6 124.4 204.4 125.8 215.9 138.7L262.6 191.3C278.1 209.7 287.1 233.4 287.1 258.1V352H352V258.1C352 233.4 361 209.7 377.4 191.3L424.1 138.7C435.6 125.8 455.4 124.4 468.6 135.5C481.9 146.7 483.8 166.4 472.1 179.1L445.4 214.5C438.3 223.3 440.7 236.3 450.4 242C458.6 246.8 469 244.7 474.7 237.2L544 144.8V32C544 14.33 558.3 0 576 0C593.7 0 608 14.33 608 32V213.9C608 228 602.9 241.8 593.7 252.5L508.4 352H512C525.3 352 536 362.7 536 376C536 389.3 525.3 400 512 400H128C114.7 400 104 389.3 104 376C104 362.7 114.7 352 128 352H131.6L46.31 252.5C37.07 241.8 32 228 32 213.9V32C32 14.33 46.33 0 64 0C81.67 0 96 14.33 96 32L95.1 144.8zM127.1 480C114.7 480 103.1 469.3 103.1 456C103.1 442.7 114.7 432 127.1 432H512C525.3 432 536 442.7 536 456C536 469.3 525.3 480 512 480H480V512H352V480H287.1V512H159.1V480H127.1z',
			),
		),
		'label'             => __( 'Hands Bound', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'hands-bubbles'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M416 64c17.67 0 32-14.33 32-31.1c0-17.67-14.33-32-32-32c-17.67 0-32 14.33-32 32C384 49.67 398.3 64 416 64zM519.1 336H360c-4.418 0-8-3.582-8-8s3.582-8 8-8h128c14.81 0 26.49-13.42 23.54-28.76c-2.191-11.4-12.84-19.24-24.44-19.24H288l47.09-17.06c12.66-3.906 19.75-17.34 15.84-30.03c-3.938-12.62-17.28-19.69-30.03-15.84L213.2 242.3C162 259.4 128 306.6 128 359.1v25.65c36.47 7.434 64 39.75 64 78.38c0 10.71-2.193 20.91-6.031 30.25C204.1 505.3 225.2 512 248 512h208c14.81 0 26.49-13.42 23.54-28.76c-2.191-11.4-12.84-19.24-24.44-19.24H360c-4.418 0-8-3.582-8-8s3.582-8 8-8h128c14.81 0 26.49-13.42 23.54-28.76c-2.191-11.4-12.84-19.24-24.44-19.24H360c-4.418 0-8-3.582-8-8s3.582-8 8-8h160c14.81 0 26.49-13.42 23.54-28.76C541.3 343.8 530.7 336 519.1 336zM311.5 178.4c5.508-1.66 10.99-2.471 16.5-2.471c6.662 0 12.1 1.334 18.98 3.482l15.36-48.61c4.461-14.12-4.82-29.3-20.33-31.11c-11.53-1.344-22.21 6.443-25.71 17.51l-20.9 66.17L311.5 178.4zM496 224c26.51 0 48-21.49 48-47.1s-21.49-48-48-48S448 149.5 448 176S469.5 224 496 224zM93.65 386.3C94.45 386.1 95.19 385.8 96 385.6v-25.69c0-67.17 43.03-126.7 107.1-148l73.7-22.76l34.15-108.1c4.459-14.12-4.82-29.3-20.33-31.11C279.1 48.6 268.4 56.39 264.9 67.46L231.4 173.9c-1.332 4.213-5.826 6.549-10.04 5.217C217.2 177.8 214.8 173.3 216.2 169.1l43.37-137.8c4.461-14.12-4.82-29.3-20.33-31.11c-11.53-1.344-22.21 6.445-25.71 17.51L165.6 169.4C164.2 173.6 159.7 175.9 155.5 174.6C151.3 173.3 148.1 168.8 150.3 164.6l38.56-122.1c4.459-14.12-4.82-29.3-20.33-31.11C157 10.04 146.3 17.83 142.8 28.9L82.84 218.7L80.76 168.7C80.85 155.5 70.17 144.6 56.9 144.5C43.67 144.5 32.18 155.1 32 168.4v112.7C32.71 325.6 56.76 364.8 93.65 386.3zM112 416c-26.51 0-48 21.49-48 47.1s21.49 48 48 48S160 490.5 160 464S138.5 416 112 416z',
			),
		),
		'label'             => __( 'Hands Bubbles', 'astra' ),
		'custom_categories' => array(),
	),
	'hands-clapping'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M320 96c8.844 0 16-7.156 16-16v-64C336 7.156 328.8 0 320 0s-16 7.156-16 16v64C304 88.84 311.2 96 320 96zM383.4 96c5.125 0 10.16-2.453 13.25-7.016l32.56-48c1.854-2.746 2.744-5.865 2.744-8.951c0-8.947-7.273-16.04-15.97-16.04c-5.125 0-10.17 2.465-13.27 7.02l-32.56 48C368.3 73.76 367.4 76.88 367.4 79.97C367.4 88.88 374.7 96 383.4 96zM384 357.5l0-163.9c0-6.016-4.672-33.69-32-33.69c-17.69 0-32.07 14.33-32.07 31.1L320 268.1L169.2 117.3C164.5 112.6 158.3 110.3 152.2 110.3c-13.71 0-24 11.21-24 24c0 6.141 2.344 12.28 7.031 16.97l89.3 89.3C227.4 243.4 228.9 247.2 228.9 251c0 3.8-1.45 7.6-4.349 10.5c-2.899 2.899-6.7 4.349-10.5 4.349c-3.8 0-7.6-1.45-10.5-4.349l-107.6-107.6C91.22 149.2 85.08 146.9 78.94 146.9c-13.71 0-24 11.21-24 24c0 6.141 2.344 12.28 7.031 16.97l107.6 107.6C172.5 298.4 173.9 302.2 173.9 305.1c0 3.8-1.45 7.6-4.349 10.5c-2.899 2.9-6.7 4.349-10.5 4.349c-3.8 0-7.6-1.45-10.5-4.349L59.28 227.2C54.59 222.5 48.45 220.1 42.31 220.1c-13.71 0-24 11.21-24 24c0 6.141 2.344 12.28 7.031 16.97l89.3 89.3c2.9 2.899 4.349 6.7 4.349 10.5c0 3.8-1.45 7.6-4.349 10.5c-2.899 2.899-6.7 4.349-10.5 4.349c-3.8 0-7.6-1.45-10.5-4.349L40.97 318.7C36.28 314 30.14 311.7 24 311.7c-13.71 0-23.99 11.26-23.99 24.05c0 6.141 2.332 12.23 7.02 16.92C112.6 458.2 151.3 512 232.3 512C318.1 512 384 440.9 384 357.5zM243.3 88.98C246.4 93.55 251.4 96 256.6 96c8.762 0 15.99-7.117 15.99-16.03c0-3.088-.8906-6.205-2.744-8.951l-32.56-48C234.2 18.46 229.1 15.98 223.1 15.98c-8.664 0-15.98 7.074-15.98 16.05c0 3.086 .8906 6.205 2.744 8.951L243.3 88.98zM480 160c-17.69 0-32 14.33-32 32v76.14l-32-32v121.4c0 94.01-63.31 141.5-78.32 152.2C345.1 510.9 352.6 512 360.3 512C446.1 512 512 440.9 512 357.5l-.0625-165.6C511.9 174.3 497.7 160 480 160z',
			),
		),
		'label'             => __( 'Hands Clapping', 'astra' ),
		'custom_categories' => array(),
	),
	'hands-holding'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M216.1 236C205.1 222.3 185.8 219.1 172 231c-13.81 11.06-16.05 31.19-5 45l18.86 30.56C194.8 317.7 193.9 333.7 183.8 343.8c-11.79 11.79-31.2 10.71-41.61-2.305L80 256.8V104C80 81.91 62.09 64 40 64S0 81.91 0 104v204.7c0 14.54 4.949 28.65 14.03 40l120.1 151.3C141.1 507.6 150.3 512 159.1 512H256c17.67 0 32.03-14.35 32.03-32.02L288 358.4c0-21.79-7.414-42.93-21.02-59.94L216.1 236zM600 64c-22.09 0-40 17.91-40 40v152.8l-62.2 84.73c-10.41 13.02-29.83 14.09-41.61 2.305c-10.08-10.07-10.97-26.11-2.068-37.24l18.86-30.56c11.05-13.81 8.812-33.94-5-45c-13.77-11.03-33.94-8.75-44.97 5l-49.99 62.5C359.4 315.5 352 336.6 352 358.4l-.0313 121.5C351.1 497.7 366.3 512 384 512h96.02c9.713 0 18.9-4.414 24.96-12l120.1-151.3C635.1 337.4 640 323.3 640 308.7V104C640 81.91 622.1 64 600 64z',
			),
		),
		'label'             => __( 'Hands Holding', 'astra' ),
		'custom_categories' => array(),
	),
	'hands-holding-child'                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M280 40C280 17.91 297.9 0 320 0C342.1 0 360 17.91 360 40C360 62.09 342.1 80 320 80C297.9 80 280 62.09 280 40zM375.8 253C377.5 266.2 368.1 278.2 354.1 279.8C341.8 281.5 329.8 272.1 328.2 258.1L323.8 223.1H316.2L311.8 258.1C310.2 272.1 298.2 281.5 285 279.8C271.9 278.2 262.5 266.2 264.2 253L275.3 164.3L255.5 180.1C245.4 189.6 230.2 188.3 221.7 178.2C213.1 168 214.4 152.9 224.5 144.3L266 109.2C276.1 100.7 288.9 96 302.2 96H337.8C351.1 96 363.9 100.7 373.1 109.2L415.5 144.3C425.6 152.9 426.9 168 418.3 178.2C409.8 188.3 394.6 189.6 384.5 180.1L364.7 164.3L375.8 253zM80 258.7L140.3 339C149.7 351.6 167.7 353.8 179.9 343.8C190.4 335.1 193.1 319.1 186 308.3L164.6 272.5C155.9 258 159.9 239.3 173.7 229.7C187.6 220.1 206.5 222.9 216.1 236L263.5 294.1C279.3 313.1 288 338.6 288 364.1V480C288 497.7 273.7 512 256 512H160C150.3 512 141.1 507.6 135 499.1L14.02 348.8C4.946 337.4 0 323.3 0 308.8V103.1C0 81.91 17.91 63.1 40 63.1C62.09 63.1 80 81.91 80 103.1V258.7zM640 104V308.8C640 323.3 635.1 337.4 625.1 348.8L504.1 499.1C498.9 507.6 489.7 512 480 512H384C366.3 512 352 497.7 352 480V364.1C352 338.6 360.7 313.1 376.5 294.1L423 236C433.5 222.9 452.4 220.1 466.3 229.7C480.1 239.3 484.1 258 475.4 272.5L453.1 308.3C446.9 319.1 449.6 335.1 460.2 343.8C472.3 353.8 490.3 351.6 499.7 339L560 258.7V104C560 81.91 577.9 64 600 64C622.1 64 640 81.91 640 104V104z',
			),
		),
		'label'             => __( 'Hands Holding Child', 'astra' ),
		'custom_categories' => array(
			'business',
			'education',
			'science-and-technology',
		),
	),
	'hands-holding-circle'                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M208 112C208 50.14 258.1 0 320 0C381.9 0 432 50.14 432 112C432 173.9 381.9 224 320 224C258.1 224 208 173.9 208 112zM80 258.7L140.3 339C149.7 351.6 167.7 353.8 179.9 343.8C190.4 335.1 193.1 319.1 186 308.3L164.6 272.5C155.9 258 159.9 239.3 173.7 229.7C187.6 220.1 206.5 222.9 216.1 236L263.5 294.1C279.3 313.1 288 338.6 288 364.1V480C288 497.7 273.7 512 256 512H160C150.3 512 141.1 507.6 135 499.1L14.02 348.8C4.946 337.4 0 323.3 0 308.8V103.1C0 81.91 17.91 63.1 40 63.1C62.09 63.1 80 81.91 80 103.1V258.7zM640 104V308.8C640 323.3 635.1 337.4 625.1 348.8L504.1 499.1C498.9 507.6 489.7 512 480 512H384C366.3 512 352 497.7 352 480V364.1C352 338.6 360.7 313.1 376.5 294.1L423 236C433.5 222.9 452.4 220.1 466.3 229.7C480.1 239.3 484.1 258 475.4 272.5L453.1 308.3C446.9 319.1 449.6 335.1 460.2 343.8C472.3 353.8 490.3 351.6 499.7 339L560 258.7V104C560 81.91 577.9 64 600 64C622.1 64 640 81.91 640 104V104z',
			),
		),
		'label'             => __( 'Hands Holding Circle', 'astra' ),
		'custom_categories' => array(
			'business',
			'science-and-technology',
		),
	),
	'hands-praying'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M272 191.9c-17.62 0-32 14.35-32 31.97V303.9c0 8.875-7.125 16-16 16s-16-7.125-16-16V227.4c0-17.37 4.75-34.5 13.75-49.37L299.5 48.41c9-15.12 4.125-34.76-11-43.88C273.1-4.225 255.8 .1289 246.1 13.63C245.1 13.88 245.5 13.88 245.4 14.13L128.1 190C117.5 205.9 112 224.3 112 243.3v80.24l-90.13 29.1C8.75 357.9 0 370.1 0 383.9v95.99c0 10.88 8.5 31.1 32 31.1c2.75 0 5.375-.25 8-1l179.3-46.62C269.1 450 304 403.8 304 351.9V223.9C304 206.3 289.6 191.9 272 191.9zM618.1 353.6L528 323.6V243.4c0-19-5.5-37.37-16.12-53.25l-117.3-175.9c-.125-.25-.6251-.2487-.75-.4987c-9.625-13.5-27.88-17.85-42.38-9.229c-15.12 9.125-20 28.76-11 44.01l77.75 129.5C427.3 193 432 210 432 227.5v76.49c0 8.875-7.125 16-16 16s-16-7.125-16-16V223.1c0-17.62-14.38-31.97-32-31.97s-32 14.38-32 31.1v127.1c0 51.87 34.88 98.12 84.75 112.4L600 511C602.6 511.6 605.4 512 608 512c23.5 0 32-21.25 32-31.1v-95.99C640 370.3 631.3 358 618.1 353.6z',
			),
		),
		'label'             => __( 'Hands Praying', 'astra' ),
		'custom_categories' => array(),
	),
	'handshake'                            => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M0 383.9l64 .0404c17.75 0 32-14.29 32-32.03V128.3L0 128.3V383.9zM48 320.1c8.75 0 16 7.118 16 15.99c0 8.742-7.25 15.99-16 15.99S32 344.8 32 336.1C32 327.2 39.25 320.1 48 320.1zM348.8 64c-7.941 0-15.66 2.969-21.52 8.328L228.9 162.3C228.8 162.5 228.8 162.7 228.6 162.7C212 178.3 212.3 203.2 226.5 218.7c12.75 13.1 39.38 17.62 56.13 2.75C282.8 221.3 282.9 221.3 283 221.2l79.88-73.1c6.5-5.871 16.75-5.496 22.62 1c6 6.496 5.5 16.62-1 22.62l-26.12 23.87L504 313.7c2.875 2.496 5.5 4.996 7.875 7.742V127.1c-40.98-40.96-96.48-63.88-154.4-63.88L348.8 64zM334.6 217.4l-30 27.49c-29.75 27.11-75.25 24.49-101.8-4.371C176 211.2 178.1 165.7 207.3 138.9L289.1 64H282.5C224.7 64 169.1 87.08 128.2 127.9L128 351.8l18.25 .0369l90.5 81.82c27.5 22.37 67.75 18.12 90-9.246l18.12 15.24c15.88 12.1 39.38 10.5 52.38-5.371l31.38-38.6l5.374 4.498c13.75 11 33.88 9.002 45-4.748l9.538-11.78c11.12-13.75 9.036-33.78-4.694-44.93L334.6 217.4zM544 128.4v223.6c0 17.62 14.25 32.05 31.1 32.05L640 384V128.1L544 128.4zM592 352c-8.75 0-16-7.246-16-15.99c0-8.875 7.25-15.99 16-15.99S608 327.2 608 336.1C608 344.8 600.8 352 592 352z',
			),
			'regular' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M506.1 127.1c-17.97-20.17-61.46-61.65-122.7-71.1c-22.5-3.354-45.39 3.606-63.41 18.21C302 60.47 279.1 53.42 256.5 56.86C176.8 69.17 126.7 136.2 124.6 139.1c-7.844 10.69-5.531 25.72 5.125 33.57c4.281 3.157 9.281 4.657 14.19 4.657c7.406 0 14.69-3.375 19.38-9.782c.4062-.5626 40.19-53.91 100.5-63.23c7.457-.9611 14.98 .67 21.56 4.483L227.2 168.2C214.8 180.5 207.1 196.1 207.1 214.5c0 17.5 6.812 33.94 19.16 46.29C239.5 273.2 255.9 279.1 273.4 279.1s33.94-6.813 46.31-19.19l11.35-11.35l124.2 100.9c2.312 1.875 2.656 5.251 .5 7.97l-27.69 35.75c-1.844 2.25-5.25 2.594-7.156 1.063l-22.22-18.69l-26.19 27.75c-2.344 2.875-5.344 3.563-6.906 3.719c-1.656 .1562-4.562 .125-6.812-1.719l-32.41-27.66L310.7 392.3l-2.812 2.938c-5.844 7.157-14.09 11.66-23.28 12.6c-9.469 .8126-18.25-1.75-24.5-6.782L170.3 319.8H96V128.3L0 128.3v255.6l64 .0404c11.74 0 21.57-6.706 27.14-16.14h60.64l77.06 69.66C243.7 449.6 261.9 456 280.8 456c2.875 0 5.781-.125 8.656-.4376c13.62-1.406 26.41-6.063 37.47-13.5l.9062 .8126c12.03 9.876 27.28 14.41 42.69 12.78c13.19-1.375 25.28-7.032 33.91-15.35c21.09 8.188 46.09 2.344 61.25-16.47l27.69-35.75c18.47-22.82 14.97-56.48-7.844-75.01l-120.3-97.76l8.381-8.382c9.375-9.376 9.375-24.57 0-33.94c-9.375-9.376-24.56-9.376-33.94 0L285.8 226.8C279.2 233.5 267.7 233.5 261.1 226.8c-3.312-3.282-5.125-7.657-5.125-12.31c0-4.688 1.812-9.064 5.281-12.53l85.91-87.64c7.812-7.845 18.53-11.75 28.94-10.03c59.75 9.22 100.2 62.73 100.6 63.29c3.088 4.155 7.264 6.946 11.84 8.376H544v175.1c0 17.67 14.33 32.05 31.1 32.05L640 384V128.1L506.1 127.1zM48 352c-8.75 0-16-7.245-16-15.99c0-8.876 7.25-15.99 16-15.99S64 327.2 64 336.1C64 344.8 56.75 352 48 352zM592 352c-8.75 0-16-7.245-16-15.99c0-8.876 7.25-15.99 16-15.99s16 7.117 16 15.99C608 344.8 600.8 352 592 352z',
			),
		),
		'label'             => __( 'Handshake', 'astra' ),
		'custom_categories' => array(
			'business',
			'lifestyle-and-hobbies',
		),
	),
	'handshake-angle'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M488 191.1h-152l.0001 51.86c.0001 37.66-27.08 72-64.55 75.77c-43.09 4.333-79.45-29.42-79.45-71.63V126.4l-24.51 14.73C123.2 167.8 96.04 215.7 96.04 267.5L16.04 313.8c-15.25 8.751-20.63 28.38-11.75 43.63l80 138.6c8.875 15.25 28.5 20.5 43.75 11.75l103.4-59.75h136.6c35.25 0 64-28.75 64-64c26.51 0 48-21.49 48-48V288h8c13.25 0 24-10.75 24-24l.0001-48C512 202.7 501.3 191.1 488 191.1zM635.7 154.5l-79.95-138.6c-8.875-15.25-28.5-20.5-43.75-11.75l-103.4 59.75h-62.57c-37.85 0-74.93 10.61-107.1 30.63C229.7 100.4 224 110.6 224 121.6l-.0004 126.4c0 22.13 17.88 40 40 40c22.13 0 40-17.88 40-40V159.1h184c30.93 0 56 25.07 56 56v28.5l80-46.25C639.3 189.4 644.5 169.8 635.7 154.5z',
			),
		),
		'label'             => __( 'Handshake Angle', 'astra' ),
		'custom_categories' => array(
			'business',
			'design',
		),
	),
	'handshake-simple'                     => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M334.6 217.4l-30 27.49C264 282.1 217.8 256.8 202.9 240.6C176 211.2 178.1 165.7 207.3 138.9L289.1 64H282.5C224.7 64 169.1 86.95 128.2 127.8L32 128.1c-17.6 0-32 14.39-32 31.98v159.8c0 17.59 14.4 32.04 31.1 32.04l114.3-.0604l90.5 81.82c27.5 22.37 67.75 18.11 90-9.255l18.12 15.25c15.88 12.1 39.38 10.5 52.38-5.369l31.38-38.6l5.374 4.498c13.75 11 33.88 9.002 45-4.748l9.576-11.83c11.08-13.7 8.979-33.75-4.701-44.86L334.6 217.4zM608 128.1l-96-.1257c-40.98-40.96-96.56-63.88-154.5-63.88L348.9 64c-8 0-15.62 3.197-21.62 8.568L229 162.3C228.9 162.5 228.8 162.7 228.8 162.7C212 178.5 212.4 203.3 226.6 218.7c9.625 10.5 35 21.62 56.13 2.75c0-.125 .25-.125 .375-.25l80-73.1c6.5-5.871 16.62-5.496 22.62 1s5.5 16.62-1 22.62l-26.12 23.87l145.6 118.1c12.12 9.992 19.5 23.49 22.12 37.98L608 351.7c17.6 0 32-14.38 32-31.98V160.1C640 142.4 625.7 128.1 608 128.1z',
			),
		),
		'label'             => __( 'Handshake Simple', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'handshake-simple-slash'               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M358.6 195.6l145.6 118.1c12.12 9.992 19.5 23.49 22.12 37.98h81.62c17.6 0 31.1-14.39 31.1-31.99V159.1c0-17.67-14.33-31.99-31.1-31.99h-95.1c-40.98-40.96-96.56-63.98-154.5-63.98h-8.613c-7.1 0-15.63 3.002-21.63 8.373l-93.44 85.57L208.3 137.9L289.1 64.01L282.5 64c-43.48 0-85.19 13.66-120.8 37.44l-122.9-96.33C34.41 1.672 29.19 0 24.03 0c-7.125 0-14.19 3.156-18.91 9.187c-8.187 10.44-6.375 25.53 4.062 33.7L601.2 506.9c10.5 8.203 25.56 6.328 33.69-4.078c8.187-10.44 6.375-25.53-4.062-33.7l-135.5-106.2c-.1719-9.086-3.789-18.03-11.39-24.2l-149.2-121.2l-11.47 10.51L297.6 207.1l65.51-59.85c6.5-5.871 16.62-5.496 22.62 .1c5.1 6.496 5.5 16.62-.1 22.62L358.6 195.6zM32 127.1c-17.6 0-31.1 14.4-31.1 31.99v159.8c0 17.59 14.4 32.06 31.1 32.06l114.2-.0712l90.5 81.85c27.5 22.37 67.75 18.12 89.1-9.25l18.12 15.25c15.87 12.1 39.37 10.5 52.37-5.371l13.02-16.03L39.93 127.1L32 127.1z',
			),
		),
		'label'             => __( 'Handshake Simple Slash', 'astra' ),
		'custom_categories' => array(),
	),
	'handshake-slash'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M543.1 128.2l.0002 223.8c0 17.62 14.25 31.99 31.1 31.99h64V128.1L543.1 128.2zM591.1 352c-8.75 0-16-7.251-16-15.99c0-8.875 7.25-15.1 16-15.1c8.75 0 15.1 7.122 15.1 15.1C607.1 344.8 600.7 352 591.1 352zM.0005 128.2v255.7l63.1 .0446c17.75 0 32-14.28 32-32.03L96 171.9l-55.77-43.71H.0005zM64 336c0 8.742-7.25 15.99-15.1 15.99s-15.1-7.251-15.1-15.99c0-8.875 7.25-15.1 15.1-15.1S64 327.2 64 336zM128 351.8h18.25l90.5 81.85c27.5 22.37 67.75 18.12 89.1-9.25l18.12 15.25c15.87 12.1 39.37 10.5 52.37-5.371l13.02-16.03L128 196.1V351.8zM495.2 362.8c-.1875-9.101-3.824-18.05-11.44-24.24l-149.2-121.1l-11.47 10.51L297.5 207.9l65.33-59.79c6.5-5.871 16.75-5.496 22.62 1c5.1 6.496 5.5 16.62-1 22.62l-26.12 23.87l145.6 118.1c2.875 2.496 5.5 4.996 7.875 7.742V127.1c-40.98-40.96-96.52-63.98-154.5-63.98h-8.613c-7.941 0-15.64 2.97-21.5 8.329L233.7 157.9L208.3 137.9l80.85-73.92L282.5 64c-43.47 0-85.16 13.68-120.8 37.45L38.81 5.109C34.41 1.672 29.19 0 24.03 0C16.91 0 9.846 3.156 5.127 9.187C-3.06 19.62-1.248 34.72 9.19 42.89l591.1 463.1c10.5 8.203 25.56 6.328 33.69-4.078c8.187-10.44 6.375-25.53-4.062-33.7L495.2 362.8z',
			),
		),
		'label'             => __( 'Handshake Slash', 'astra' ),
		'custom_categories' => array(),
	),
	'hanukiah'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M231.1 159.9C227.6 159.9 224 163.6 224 168V288h32V168C256 163.6 252.4 160 248 160L231.1 159.9zM167.1 159.9C163.6 159.9 160 163.6 160 168V288h32V168C192 163.6 188.4 160 184 160L167.1 159.9zM392 160C387.6 160 384 163.6 384 168V288h32V168c0-4.375-3.625-8.061-8-8.061L392 160zM456 160C451.6 160 448 163.6 448 168V288h32V168c0-4.375-3.625-8.061-8-8.061L456 160zM544 168c0-4.375-3.625-8.061-8-8.061L520 160C515.6 160 512 163.6 512 168V288h32V168zM103.1 159.9C99.62 159.9 96 163.6 96 168V288h32V168C128 163.6 124.4 160 120 160L103.1 159.9zM624 160h-31.98c-8.837 0-16.03 7.182-16.03 16.02L576 288c0 17.6-14.4 32-32 32h-192V128c0-8.837-7.151-16.01-15.99-16.01H303.1C295.2 111.1 288 119.2 288 128v192H96c-17.6 0-32-14.4-32-32l.0065-112C64.01 167.2 56.85 160 48.02 160H16C7.163 160 0 167.2 0 176V288c0 53.02 42.98 96 96 96h192v64H175.1C149.5 448 128 469.5 128 495.1C128 504.8 135.2 512 143.1 512h352C504.9 512 512 504.9 512 496C512 469.5 490.5 448 464 448H352v-64h192c53.02 0 96-42.98 96-96V176C640 167.2 632.8 160 624 160zM607.1 127.9C621.2 127.9 632 116 632 101.4C632 86.62 608 48 608 48s-24 38.62-24 53.38C584 116 594.7 127.9 607.1 127.9zM31.1 127.9C45.25 127.9 56 116 56 101.4C56 86.62 32 48 32 48S8 86.62 8 101.4C8 116 18.75 127.9 31.1 127.9zM319.1 79.94c13.25 0 24-11.94 24-26.57C344 38.62 320 0 320 0S296 38.62 296 53.38C296 67.1 306.7 79.94 319.1 79.94zM112 128c13.25 0 24-12 24-26.62C136 86.62 112 48 112 48S88 86.62 88 101.4C88 115.1 98.75 128 112 128zM176 128c13.25 0 24-12 24-26.62C200 86.62 176 48 176 48S152 86.62 152 101.4C152 115.1 162.8 128 176 128zM240 128c13.25 0 24-12 24-26.62C264 86.62 240 48 240 48S216 86.62 216 101.4C216 115.1 226.8 128 240 128zM400 128c13.25 0 24-12 24-26.62C424 86.62 400 48 400 48s-24 38.62-24 53.38C376 115.1 386.8 128 400 128zM464 128c13.25 0 24-12 24-26.62C488 86.62 464 48 464 48s-24 38.62-24 53.38C440 115.1 450.8 128 464 128zM528 128c13.25 0 24-12 24-26.62C552 86.62 528 48 528 48s-24 38.62-24 53.38C504 115.1 514.8 128 528 128z',
			),
		),
		'label'             => __( 'Hanukiah', 'astra' ),
		'custom_categories' => array(),
	),
	'hard-drive'                           => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M464 288h-416C21.5 288 0 309.5 0 336v96C0 458.5 21.5 480 48 480h416c26.5 0 48-21.5 48-48v-96C512 309.5 490.5 288 464 288zM320 416c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S337.6 416 320 416zM416 416c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S433.6 416 416 416zM464 32h-416C21.5 32 0 53.5 0 80v192.4C13.41 262.3 29.92 256 48 256h416c18.08 0 34.59 6.254 48 16.41V80C512 53.5 490.5 32 464 32z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M304 344c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C328 354.7 317.3 344 304 344zM448 32h-384c-35.35 0-64 28.65-64 64v320c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V96C512 60.65 483.3 32 448 32zM464 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16v-96c0-8.822 7.178-16 16-16h384C456.8 304 464 311.2 464 320V416zM464 258.3C458.9 256.9 453.6 256 448 256H64C58.44 256 53.14 256.9 48 258.3V96c0-8.822 7.178-16 16-16h384c8.822 0 16 7.178 16 16V258.3zM400 344c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C424 354.7 413.3 344 400 344z',
			),
		),
		'label'             => __( 'Hard Drive', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'hashnode'                             => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M35.19 171.1C-11.72 217.1-11.72 294 35.19 340.9L171.1 476.8C217.1 523.7 294 523.7 340.9 476.8L476.8 340.9C523.7 294 523.7 217.1 476.8 171.1L340.9 35.19C294-11.72 217.1-11.72 171.1 35.19L35.19 171.1zM315.5 315.5C282.6 348.3 229.4 348.3 196.6 315.5C163.7 282.6 163.7 229.4 196.6 196.6C229.4 163.7 282.6 163.7 315.5 196.6C348.3 229.4 348.3 282.6 315.5 315.5z',
			),
		),
		'label'             => __( 'Hashnode', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'hashtag'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M416 127.1h-58.23l9.789-58.74c2.906-17.44-8.875-33.92-26.3-36.83c-17.53-2.875-33.92 8.891-36.83 26.3L292.9 127.1H197.8l9.789-58.74c2.906-17.44-8.875-33.92-26.3-36.83c-17.53-2.875-33.92 8.891-36.83 26.3L132.9 127.1H64c-17.67 0-32 14.33-32 32C32 177.7 46.33 191.1 64 191.1h58.23l-21.33 128H32c-17.67 0-32 14.33-32 32c0 17.67 14.33 31.1 32 31.1h58.23l-9.789 58.74c-2.906 17.44 8.875 33.92 26.3 36.83C108.5 479.9 110.3 480 112 480c15.36 0 28.92-11.09 31.53-26.73l11.54-69.27h95.12l-9.789 58.74c-2.906 17.44 8.875 33.92 26.3 36.83C268.5 479.9 270.3 480 272 480c15.36 0 28.92-11.09 31.53-26.73l11.54-69.27H384c17.67 0 32-14.33 32-31.1c0-17.67-14.33-32-32-32h-58.23l21.33-128H416c17.67 0 32-14.32 32-31.1C448 142.3 433.7 127.1 416 127.1zM260.9 319.1H165.8L187.1 191.1h95.12L260.9 319.1z',
			),
		),
		'label'             => __( 'Hashtag', 'astra' ),
		'custom_categories' => array(
			'social',
			'brands',
			'brands',
			'social',
		),
	),
	'hat-cowboy'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M489.1 264.9C480.5 207.5 450.5 32 392.3 32c-14 0-26.58 5.875-37.08 14c-20.75 15.87-49.62 15.87-70.5 0C274.2 38 261.7 32 247.7 32c-58.25 0-88.27 175.5-97.77 232.9C188.7 277.5 243.7 288 319.1 288S451.2 277.5 489.1 264.9zM632.9 227.7c-6.125-4.125-14.2-3.51-19.7 1.49c-1 .875-101.3 90.77-293.1 90.77c-190.9 0-292.2-89.99-293.2-90.86c-5.5-4.875-13.71-5.508-19.71-1.383c-6.125 4.125-8.587 11.89-6.087 18.77C1.749 248.5 78.37 448 319.1 448s318.2-199.5 318.1-201.5C641.5 239.6 639 231.9 632.9 227.7z',
			),
		),
		'label'             => __( 'Hat Cowboy', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'hat-cowboy-side'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M260.8 260C232.1 237.1 198.8 225 164.4 225c-77.38 0-142.9 62.75-163 156c-3.5 16.62-.375 33.88 8.625 47.38c8.75 13.12 21.88 20.62 35.88 20.62H592c-103.2 0-155-37.13-233.2-104.5L260.8 260zM495.5 241.8l-27.13-156.5c-2.875-17.25-12.75-32.5-27.12-42.25c-14.37-9.75-32.24-13.3-49.24-9.675L200.9 74.02C173.7 79.77 153.5 102.3 150.5 129.8L143.6 195c6.875-.875 13.62-2 20.75-2c41.87 0 82 14.5 117.4 42.88l98 84.37c71 61.25 115.1 96.75 212.2 96.75c26.5 0 48-21.5 48-48C640 343.6 610.4 249.6 495.5 241.8z',
			),
		),
		'label'             => __( 'Hat Cowboy Side', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'hat-wizard'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M200 376l-49.23-16.41c-7.289-2.434-7.289-12.75 0-15.18L200 328l16.41-49.23c2.434-7.289 12.75-7.289 15.18 0L248 328l49.23 16.41c7.289 2.434 7.289 12.75 0 15.18L248 376L240 416H448l-86.38-201.6C355.4 200 354.8 183.8 359.8 168.9L416 0L228.4 107.3C204.8 120.8 185.1 141.4 175 166.4L64 416h144L200 376zM231.2 172.4L256 160l12.42-24.84c1.477-2.949 5.68-2.949 7.156 0L288 160l24.84 12.42c2.949 1.477 2.949 5.68 0 7.156L288 192l-12.42 24.84c-1.477 2.949-5.68 2.949-7.156 0L256 192L231.2 179.6C228.2 178.1 228.2 173.9 231.2 172.4zM496 448h-480C7.164 448 0 455.2 0 464C0 490.5 21.49 512 48 512h416c26.51 0 48-21.49 48-48C512 455.2 504.8 448 496 448z',
			),
		),
		'label'             => __( 'Hat Wizard', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'head-side-cough'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M608 359.1c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S621.3 359.1 608 359.1zM477.2 275c-21-47.13-48.49-151.8-73.11-186.8C365.6 33.63 302.5 0 234.1 0L192 0C86 0 0 86 0 192c0 56.75 24.75 107.6 64 142.9L64 512h223.1v-32h64.01c35.38 0 64-28.62 64-63.1L320 416c-17.67 0-32-14.33-32-32s14.33-32 32-32h95.98l-.003-32h31.99C471.1 320 486.6 296.1 477.2 275zM336 224c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S353.6 224 336 224zM480 359.1c-13.25 0-23.1 10.75-23.1 24s10.75 24 23.1 24s24-10.75 24-24S493.3 359.1 480 359.1zM608 311.1c13.25 0 24-10.75 24-24s-10.75-24-24-24s-24 10.75-24 24S594.8 311.1 608 311.1zM544 311.1c-13.25 0-23.1 10.75-23.1 24s10.75 24 23.1 24s24-10.75 24-24S557.3 311.1 544 311.1zM544 407.1c-13.25 0-23.1 10.75-23.1 24s10.75 24 23.1 24s24-10.75 24-24S557.3 407.1 544 407.1zM608 455.1c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S621.3 455.1 608 455.1z',
			),
		),
		'label'             => __( 'Head Side Cough', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'head-side-cough-slash'                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M607.1 311.1c13.25 0 24-10.75 24-23.1s-10.75-23.1-24-23.1s-23.1 10.75-23.1 23.1S594.7 311.1 607.1 311.1zM607.1 407.1c13.25 0 24-10.78 24-24.03c0-13.25-10.75-23.1-24-23.1s-24 10.78-24 24.03C583.1 397.2 594.7 407.1 607.1 407.1zM630.8 469.1l-190.2-149.1h7.4c23.12 0 38.62-23.87 29.25-44.1c-20.1-47.12-48.49-151.7-73.11-186.7C365.6 33.63 302.5 0 234.1 0H192C149.9 0 111.5 14.26 79.88 37.29L38.81 5.109C34.41 1.672 29.19 0 24.03 0C16.91 0 9.845 3.156 5.126 9.187c-8.187 10.44-6.375 25.53 4.062 33.7l591.1 463.1c10.5 8.203 25.56 6.328 33.69-4.078C643.1 492.4 641.2 477.3 630.8 469.1zM320 415.1c-17.67 0-31.1-14.33-31.1-31.1S302.3 351.1 320 351.1l5.758-.0009L18.16 110.9C6.631 135.6 .0006 162.1 .0006 191.1c0 56.75 24.75 107.6 64 142.9L64 511.1h223.1l0-31.1l64.01 .001c33.25 0 60.2-25.38 63.37-57.78l-7.932-6.217H320zM543.1 359.1c13.25 0 24-10.78 24-24.03s-10.75-23.1-24-23.1c-13.25 0-24 10.78-24 24.03C519.1 349.2 530.7 359.1 543.1 359.1z',
			),
		),
		'label'             => __( 'Head Side Cough Slash', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'head-side-mask'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M.1465 184.4C-2.166 244.2 23.01 298 63.99 334.9L63.99 512h160L224 316.5L3.674 156.2C1.871 165.4 .5195 174.8 .1465 184.4zM336 368H496L512 320h-255.1l.0178 192h145.9c27.55 0 52-17.63 60.71-43.76L464 464h-127.1c-8.836 0-16-7.164-16-16c0-8.838 7.164-16 16-16h138.7l10.67-32h-149.3c-8.836 0-16-7.164-16-16C320 375.2 327.2 368 336 368zM509.2 275c-20.1-47.13-48.49-151.8-73.11-186.8C397.6 33.63 334.5 0 266.1 0H200C117.1 0 42.48 50.57 13.25 123.7L239.2 288h272.6C511.8 283.7 511.1 279.3 509.2 275zM352 224c-17.62 0-32-14.38-32-32s14.38-32 32-32c17.62 0 31.1 14.38 31.1 32S369.6 224 352 224z',
			),
		),
		'label'             => __( 'Head Side Mask', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'head-side-virus'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M208 175.1c-8.836 0-16 7.162-16 16c0 8.836 7.163 15.1 15.1 15.1s16-7.164 16-16C224 183.2 216.8 175.1 208 175.1zM272 239.1c-8.836 0-15.1 7.163-15.1 16c0 8.836 7.165 16 16 16s16-7.164 16-16C288 247.2 280.8 239.1 272 239.1zM509.2 275c-20.94-47.13-48.46-151.7-73.1-186.8C397.7 33.59 334.6 0 266.1 0H192C85.95 0 0 85.95 0 192c0 56.8 24.8 107.7 64 142.8L64 512h256l-.0044-64h63.99c35.34 0 63.1-28.65 63.1-63.1V320h31.98C503.1 320 518.6 296.2 509.2 275zM368 240h-12.12c-28.51 0-42.79 34.47-22.63 54.63l8.576 8.576c6.25 6.25 6.25 16.38 0 22.62c-3.125 3.125-7.219 4.688-11.31 4.688s-8.188-1.562-11.31-4.688l-8.576-8.576c-20.16-20.16-54.63-5.881-54.63 22.63V352c0 8.844-7.156 16-16 16s-16-7.156-16-16v-12.12c0-28.51-34.47-42.79-54.63-22.63l-8.576 8.576c-3.125 3.125-7.219 4.688-11.31 4.688c-4.096 0-8.188-1.562-11.31-4.688c-6.25-6.25-6.25-16.38 0-22.62l8.577-8.576C166.9 274.5 152.6 240 124.1 240H112c-8.844 0-16-7.156-16-16s7.157-16 16-16L124.1 208c28.51 0 42.79-34.47 22.63-54.63L138.2 144.8c-6.25-6.25-6.25-16.38 0-22.62s16.38-6.25 22.63 0L169.4 130.7c20.16 20.16 54.63 5.881 54.63-22.63V96c0-8.844 7.156-16 16-16S256 87.16 256 96v12.12c0 28.51 34.47 42.79 54.63 22.63l8.576-8.576c6.25-6.25 16.38-6.25 22.63 0s6.25 16.38 0 22.62L333.3 153.4C313.1 173.5 327.4 208 355.9 208l12.12-.0004c8.844 0 15.1 7.157 15.1 16S376.8 240 368 240z',
			),
		),
		'label'             => __( 'Head Side Virus', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'heading'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M448 448c0 17.69-14.33 32-32 32h-96c-17.67 0-32-14.31-32-32s14.33-32 32-32h16v-144h-224v144H128c17.67 0 32 14.31 32 32s-14.33 32-32 32H32c-17.67 0-32-14.31-32-32s14.33-32 32-32h16v-320H32c-17.67 0-32-14.31-32-32s14.33-32 32-32h96c17.67 0 32 14.31 32 32s-14.33 32-32 32H112v112h224v-112H320c-17.67 0-32-14.31-32-32s14.33-32 32-32h96c17.67 0 32 14.31 32 32s-14.33 32-32 32h-16v320H416C433.7 416 448 430.3 448 448z',
			),
		),
		'label'             => __( 'Heading', 'astra' ),
		'custom_categories' => array(),
	),
	'headphones'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 287.9l-.0042 112C511.1 444.1 476.1 480 432 480c-26.47 0-48-21.56-48-48.06V304.1C384 277.6 405.5 256 432 256c10.83 0 20.91 2.723 30.3 6.678C449.7 159.1 362.1 80.13 256 80.13S62.29 159.1 49.7 262.7C59.09 258.7 69.17 256 80 256C106.5 256 128 277.6 128 304.1v127.9C128 458.4 106.5 480 80 480c-44.11 0-79.1-35.88-79.1-80.06L0 288c0-141.2 114.8-256 256-256c140.9 0 255.6 114.5 255.1 255.3C511.1 287.5 511.1 287.7 512 287.9z',
			),
		),
		'label'             => __( 'Headphones', 'astra' ),
		'custom_categories' => array(
			'communication',
			'lifestyle-and-hobbies',
			'science-and-technology',
		),
	),
	'headphones-simple'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 32C112.9 32 4.563 151.1 0 288v104C0 405.3 10.75 416 23.1 416S48 405.3 48 392V288c0-114.7 93.34-207.8 208-207.8C370.7 80.2 464 173.3 464 288v104C464 405.3 474.7 416 488 416S512 405.3 512 392V287.1C507.4 151.1 399.1 32 256 32zM160 288L144 288c-35.34 0-64 28.7-64 64.13v63.75C80 451.3 108.7 480 144 480L160 480c17.66 0 32-14.34 32-32.05v-127.9C192 302.3 177.7 288 160 288zM368 288L352 288c-17.66 0-32 14.32-32 32.04v127.9c0 17.7 14.34 32.05 32 32.05L368 480c35.34 0 64-28.7 64-64.13v-63.75C432 316.7 403.3 288 368 288z',
			),
		),
		'label'             => __( 'Headphones Simple', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'headset'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M191.1 224c0-17.72-14.34-32.04-32-32.04L144 192c-35.34 0-64 28.66-64 64.08v47.79C80 339.3 108.7 368 144 368H160c17.66 0 32-14.36 32-32.06L191.1 224zM256 0C112.9 0 4.583 119.1 .0208 256L0 296C0 309.3 10.75 320 23.1 320S48 309.3 48 296V256c0-114.7 93.34-207.8 208-207.8C370.7 48.2 464 141.3 464 256v144c0 22.09-17.91 40-40 40h-110.7C305 425.7 289.7 416 272 416H241.8c-23.21 0-44.5 15.69-48.87 38.49C187 485.2 210.4 512 239.1 512H272c17.72 0 33.03-9.711 41.34-24H424c48.6 0 88-39.4 88-88V256C507.4 119.1 399.1 0 256 0zM368 368c35.34 0 64-28.7 64-64.13V256.1C432 220.7 403.3 192 368 192l-16 0c-17.66 0-32 14.34-32 32.04L320 335.9C320 353.7 334.3 368 352 368H368z',
			),
		),
		'label'             => __( 'Headset', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'heart'                                => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 190.9V185.1C0 115.2 50.52 55.58 119.4 44.1C164.1 36.51 211.4 51.37 244 84.02L256 96L267.1 84.02C300.6 51.37 347 36.51 392.6 44.1C461.5 55.58 512 115.2 512 185.1V190.9C512 232.4 494.8 272.1 464.4 300.4L283.7 469.1C276.2 476.1 266.3 480 256 480C245.7 480 235.8 476.1 228.3 469.1L47.59 300.4C17.23 272.1 .0003 232.4 .0003 190.9L0 190.9z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M244 84L255.1 96L267.1 84.02C300.6 51.37 347 36.51 392.6 44.1C461.5 55.58 512 115.2 512 185.1V190.9C512 232.4 494.8 272.1 464.4 300.4L283.7 469.1C276.2 476.1 266.3 480 256 480C245.7 480 235.8 476.1 228.3 469.1L47.59 300.4C17.23 272.1 0 232.4 0 190.9V185.1C0 115.2 50.52 55.58 119.4 44.1C164.1 36.51 211.4 51.37 244 84C243.1 84 244 84.01 244 84L244 84zM255.1 163.9L210.1 117.1C188.4 96.28 157.6 86.4 127.3 91.44C81.55 99.07 48 138.7 48 185.1V190.9C48 219.1 59.71 246.1 80.34 265.3L256 429.3L431.7 265.3C452.3 246.1 464 219.1 464 190.9V185.1C464 138.7 430.4 99.07 384.7 91.44C354.4 86.4 323.6 96.28 301.9 117.1L255.1 163.9z',
			),
		),
		'label'             => __( 'Heart', 'astra' ),
		'custom_categories' => array(
			'business',
			'design',
			'lifestyle-and-hobbies',
			'science-and-technology',
			'social',
			'travel',
		),
	),
	'heart-circle-bolt'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M256 368C256 403.7 266.6 436.9 284.9 464.6L279.4 470.3C266.4 483.2 245.5 483.2 233.5 470.3L39.71 270.5C-16.22 212.5-13.23 116.6 49.7 62.68C103.6 15.73 186.5 24.72 236.5 75.67L256.4 96.64L275.4 75.67C325.4 24.72 407.3 15.73 463.2 62.68C506.1 100.1 520.7 157.6 507 208.7C484.3 198 458.8 192 432 192C334.8 192 256 270.8 256 368zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM464.8 286.4L368.8 358.4C364.7 361.5 362.1 366.9 364.6 371.8C366.2 376.7 370.8 380 376 380H411.6L381.5 434.2C378.8 439.1 379.8 445.3 384.1 449C388.4 452.8 394.7 452.1 399.2 449.6L495.2 377.6C499.3 374.5 501 369.1 499.4 364.2C497.8 359.3 493.2 356 488 356H452.4L482.5 301.8C485.2 296.9 484.2 290.7 479.9 286.1C475.6 283.2 469.3 283 464.8 286.4V286.4z',
			),
		),
		'label'             => __( 'Heart Circle Bolt', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'heart-circle-check'                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M256 368C256 403.7 266.6 436.9 284.9 464.6L279.4 470.3C266.4 483.2 245.5 483.2 233.5 470.3L39.71 270.5C-16.22 212.5-13.23 116.6 49.7 62.68C103.6 15.73 186.5 24.72 236.5 75.67L256.4 96.64L275.4 75.67C325.4 24.72 407.3 15.73 463.2 62.68C506.1 100.1 520.7 157.6 507 208.7C484.3 198 458.8 192 432 192C334.8 192 256 270.8 256 368zM576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368zM476.7 324.7L416 385.4L387.3 356.7C381.1 350.4 370.9 350.4 364.7 356.7C358.4 362.9 358.4 373.1 364.7 379.3L404.7 419.3C410.9 425.6 421.1 425.6 427.3 419.3L499.3 347.3C505.6 341.1 505.6 330.9 499.3 324.7C493.1 318.4 482.9 318.4 476.7 324.7H476.7z',
			),
		),
		'label'             => __( 'Heart Circle Check', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'heart-circle-exclamation'             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M256 368C256 403.7 266.6 436.9 284.9 464.6L279.4 470.3C266.4 483.2 245.5 483.2 233.5 470.3L39.71 270.5C-16.22 212.5-13.23 116.6 49.7 62.68C103.6 15.73 186.5 24.72 236.5 75.67L256.4 96.64L275.4 75.67C325.4 24.72 407.3 15.73 463.2 62.68C506.1 100.1 520.7 157.6 507 208.7C484.3 198 458.8 192 432 192C334.8 192 256 270.8 256 368zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM432 464C445.3 464 456 453.3 456 440C456 426.7 445.3 416 432 416C418.7 416 408 426.7 408 440C408 453.3 418.7 464 432 464zM415.1 288V368C415.1 376.8 423.2 384 431.1 384C440.8 384 447.1 376.8 447.1 368V288C447.1 279.2 440.8 272 431.1 272C423.2 272 415.1 279.2 415.1 288z',
			),
		),
		'label'             => __( 'Heart Circle Exclamation', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'heart-circle-minus'                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M256 368C256 403.7 266.6 436.9 284.9 464.6L279.4 470.3C266.4 483.2 245.5 483.2 233.5 470.3L39.71 270.5C-16.22 212.5-13.23 116.6 49.7 62.68C103.6 15.73 186.5 24.72 236.5 75.67L256.4 96.64L275.4 75.67C325.4 24.72 407.3 15.73 463.2 62.68C506.1 100.1 520.7 157.6 507 208.7C484.3 198 458.8 192 432 192C334.8 192 256 270.8 256 368zM576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368zM496 351.1H368C359.2 351.1 352 359.2 352 367.1C352 376.8 359.2 383.1 368 383.1H496C504.8 383.1 512 376.8 512 367.1C512 359.2 504.8 351.1 496 351.1z',
			),
		),
		'label'             => __( 'Heart Circle Minus', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'heart-circle-plus'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M256 368C256 403.7 266.6 436.9 284.9 464.6L279.4 470.3C266.4 483.2 245.5 483.2 233.5 470.3L39.71 270.5C-16.22 212.5-13.23 116.6 49.7 62.68C103.6 15.73 186.5 24.72 236.5 75.67L256.4 96.64L275.4 75.67C325.4 24.72 407.3 15.73 463.2 62.68C506.1 100.1 520.7 157.6 507 208.7C484.3 198 458.8 192 432 192C334.8 192 256 270.8 256 368zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM448 303.1C448 295.2 440.8 287.1 432 287.1C423.2 287.1 416 295.2 416 303.1V351.1H368C359.2 351.1 352 359.2 352 367.1C352 376.8 359.2 383.1 368 383.1H416V431.1C416 440.8 423.2 447.1 432 447.1C440.8 447.1 448 440.8 448 431.1V383.1H496C504.8 383.1 512 376.8 512 367.1C512 359.2 504.8 351.1 496 351.1H448V303.1z',
			),
		),
		'label'             => __( 'Heart Circle Plus', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'heart-circle-xmark'                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M256 368C256 403.7 266.6 436.9 284.9 464.6L279.4 470.3C266.4 483.2 245.5 483.2 233.5 470.3L39.71 270.5C-16.22 212.5-13.23 116.6 49.7 62.68C103.6 15.73 186.5 24.72 236.5 75.67L256.4 96.64L275.4 75.67C325.4 24.72 407.3 15.73 463.2 62.68C506.1 100.1 520.7 157.6 507 208.7C484.3 198 458.8 192 432 192C334.8 192 256 270.8 256 368zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM491.3 331.3C497.6 325.1 497.6 314.9 491.3 308.7C485.1 302.4 474.9 302.4 468.7 308.7L432 345.4L395.3 308.7C389.1 302.4 378.9 302.4 372.7 308.7C366.4 314.9 366.4 325.1 372.7 331.3L409.4 368L372.7 404.7C366.4 410.9 366.4 421.1 372.7 427.3C378.9 433.6 389.1 433.6 395.3 427.3L432 390.6L468.7 427.3C474.9 433.6 485.1 433.6 491.3 427.3C497.6 421.1 497.6 410.9 491.3 404.7L454.6 368L491.3 331.3z',
			),
		),
		'label'             => __( 'Heart Circle Xmark', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'heart-crack'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M119.4 44.1C142.7 40.22 166.2 42.2 187.1 49.43L237.8 126.9L162.3 202.3C160.8 203.9 159.1 205.1 160 208.2C160 210.3 160.1 212.4 162.6 213.9L274.6 317.9C277.5 320.6 281.1 320.7 285.1 318.2C288.2 315.6 288.9 311.2 286.8 307.8L226.4 209.7L317.1 134.1C319.7 131.1 320.7 128.5 319.5 125.3L296.8 61.74C325.4 45.03 359.2 38.53 392.6 44.1C461.5 55.58 512 115.2 512 185.1V190.9C512 232.4 494.8 272.1 464.4 300.4L283.7 469.1C276.2 476.1 266.3 480 256 480C245.7 480 235.8 476.1 228.3 469.1L47.59 300.4C17.23 272.1 0 232.4 0 190.9V185.1C0 115.2 50.52 55.58 119.4 44.09V44.1z',
			),
		),
		'label'             => __( 'Heart Crack', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'heart-pulse'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M352.4 243.8l-49.83 99.5c-6.009 12-23.41 11.62-28.92-.625L216.7 216.3l-30.05 71.75L88.55 288l176.4 182.2c12.66 13.07 33.36 13.07 46.03 0l176.4-182.2l-112.1 .0052L352.4 243.8zM495.2 62.86c-54.36-46.98-137.5-38.5-187.5 13.06L288 96.25L268.3 75.92C218.3 24.36 135.2 15.88 80.81 62.86C23.37 112.5 16.84 197.6 60.18 256h105l35.93-86.25c5.508-12.88 23.66-13.12 29.54-.375l58.21 129.4l49.07-98c5.884-11.75 22.78-11.75 28.67 0l27.67 55.25h121.5C559.2 197.6 552.6 112.5 495.2 62.86z',
			),
		),
		'label'             => __( 'Heart Pulse', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'science-and-technology',
			'travel',
		),
	),
	'helicopter'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M127.1 32C127.1 14.33 142.3 0 159.1 0H544C561.7 0 576 14.33 576 32C576 49.67 561.7 64 544 64H384V128H416C504.4 128 576 199.6 576 288V352C576 369.7 561.7 384 544 384H303.1C293.9 384 284.4 379.3 278.4 371.2L191.1 256L47.19 198.1C37.65 194.3 30.52 186.1 28.03 176.1L4.97 83.88C2.445 73.78 10.08 64 20.49 64H47.1C58.07 64 67.56 68.74 73.6 76.8L111.1 128H319.1V64H159.1C142.3 64 127.1 49.67 127.1 32V32zM384 320H512V288C512 234.1 469 192 416 192H384V320zM630.6 470.6L626.7 474.5C602.7 498.5 570.2 512 536.2 512H255.1C238.3 512 223.1 497.7 223.1 480C223.1 462.3 238.3 448 255.1 448H536.2C553.2 448 569.5 441.3 581.5 429.3L585.4 425.4C597.9 412.9 618.1 412.9 630.6 425.4C643.1 437.9 643.1 458.1 630.6 470.6L630.6 470.6z',
			),
		),
		'label'             => __( 'Helicopter', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'helicopter-symbol'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M320 66.66V1.985C435.8 16.42 527.6 108.2 542 224H477.3C463.9 143.6 400.4 80.15 320 66.66V66.66zM320 510V445.4C400.4 431.9 463.9 368.4 477.3 288H542C527.6 403.8 435.8 495.6 320 510V510zM33.98 288H98.65C112.1 368.4 175.6 431.9 256 445.4V510C140.2 495.6 48.42 403.8 33.98 288zM256 1.984V66.66C175.6 80.15 112.1 143.6 98.66 224H33.98C48.42 108.2 140.2 16.42 256 1.985V1.984zM240 224H336V160C336 142.3 350.3 128 368 128C385.7 128 400 142.3 400 160V352C400 369.7 385.7 384 368 384C350.3 384 336 369.7 336 352V288H240V352C240 369.7 225.7 384 208 384C190.3 384 176 369.7 176 352V160C176 142.3 190.3 128 208 128C225.7 128 240 142.3 240 160V224z',
			),
		),
		'label'             => __( 'Helicopter Symbol', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'helmet-safety'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M544 280.9c0-89.17-61.83-165.4-139.6-197.4L352 174.2V49.78C352 39.91 344.1 32 334.2 32H241.8C231.9 32 224 39.91 224 49.78v124.4L171.6 83.53C93.83 115.5 32 191.7 32 280.9L31.99 352h512L544 280.9zM574.7 393.7C572.2 387.8 566.4 384 560 384h-544c-6.375 0-12.16 3.812-14.69 9.656c-2.531 5.875-1.344 12.69 3.062 17.34C7.031 413.8 72.02 480 287.1 480s280.1-66.19 283.6-69C576 406.3 577.2 399.5 574.7 393.7z',
			),
		),
		'label'             => __( 'Helmet Safety', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'helmet-un'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M480 224C497.7 224 512 238.3 512 256C512 273.7 497.7 288 480 288H368V462.5L369.5 464H456C469.3 464 480 474.7 480 488C480 501.3 469.3 512 456 512H360C353.9 512 347.1 509.7 343.5 505.4L214.9 384H87.65C39.24 384 0 344.8 0 296.3V240C0 107.5 107.5 0 240 0C367.2 0 471.2 98.91 479.5 224H480zM320 288H274.4L241.1 343.5L320 417.2V288zM285.3 103.1C281.4 97.26 274.1 94.64 267.4 96.69C260.6 98.73 256 104.9 256 112V208C256 216.8 263.2 224 272 224C280.8 224 288 216.8 288 208V164.8L322.7 216.9C326.6 222.7 333.9 225.4 340.6 223.3C347.4 221.3 352 215.1 352 208V112C352 103.2 344.8 96 336 96C327.2 96 320 103.2 320 112V155.2L285.3 103.1zM160 112C160 103.2 152.8 96 144 96C135.2 96 128 103.2 128 112V176C128 202.5 149.5 224 176 224C202.5 224 224 202.5 224 176V112C224 103.2 216.8 96 208 96C199.2 96 192 103.2 192 112V176C192 184.8 184.8 192 176 192C167.2 192 160 184.8 160 176V112z',
			),
		),
		'label'             => __( 'Helmet Un', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'highlighter'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M143.1 320V248.3C143.1 233 151.2 218.7 163.5 209.6L436.6 8.398C444 2.943 452.1 0 462.2 0C473.6 0 484.5 4.539 492.6 12.62L547.4 67.38C555.5 75.46 559.1 86.42 559.1 97.84C559.1 107 557.1 115.1 551.6 123.4L350.4 396.5C341.3 408.8 326.1 416 311.7 416H239.1L214.6 441.4C202.1 453.9 181.9 453.9 169.4 441.4L118.6 390.6C106.1 378.1 106.1 357.9 118.6 345.4L143.1 320zM489.4 99.92L460.1 70.59L245 229L330.1 314.1L489.4 99.92zM23.03 466.3L86.06 403.3L156.7 473.9L125.7 504.1C121.2 509.5 115.1 512 108.7 512H40C26.75 512 16 501.3 16 488V483.3C16 476.1 18.53 470.8 23.03 466.3V466.3z',
			),
		),
		'label'             => __( 'Highlighter', 'astra' ),
		'custom_categories' => array(
			'business',
			'design',
		),
	),
	'hill-avalanche'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M161.4 91.58C160.5 87.87 160 83.99 160 80C160 53.49 181.5 32 208 32C229.9 32 248.3 46.62 254.1 66.62C268.5 45.7 292.7 32 320 32C364.2 32 400 67.82 400 112C400 119.4 398.1 126.6 397.1 133.5C426.9 145.1 448 174.1 448 208C448 236.4 433.2 261.3 410.9 275.5L492.6 357.2C508.2 372.8 533.6 372.8 549.2 357.2C564.8 341.6 564.8 316.2 549.2 300.6C533.6 284.1 508.2 284.1 492.6 300.6L458.7 266.7C493 232.3 548.8 232.3 583.1 266.7C617.5 301 617.5 356.8 583.1 391.1C552.8 421.4 505.9 425 471.7 401.9L161.4 91.58zM512 64C512 81.67 497.7 96 480 96C462.3 96 448 81.67 448 64C448 46.33 462.3 32 480 32C497.7 32 512 46.33 512 64zM480 160C480 142.3 494.3 128 512 128C529.7 128 544 142.3 544 160C544 177.7 529.7 192 512 192C494.3 192 480 177.7 480 160zM456.1 443.7C482.2 468.9 464.3 512 428.7 512H112C67.82 512 32 476.2 32 432V115.3C32 79.68 75.09 61.83 100.3 87.03L456.1 443.7z',
			),
		),
		'label'             => __( 'Hill Avalanche', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'hill-rockslide'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M252.4 103.8C249.7 98.97 249.7 93.03 252.4 88.16L279.4 40.16C282.2 35.12 287.6 32 293.4 32H346.6C352.4 32 357.8 35.12 360.6 40.16L387.6 88.16C390.3 93.03 390.3 98.97 387.6 103.8L360.6 151.8C357.8 156.9 352.4 160 346.6 160H293.4C287.6 160 282.2 156.9 279.4 151.8L252.4 103.8zM424.1 443.7C450.2 468.9 432.3 512 396.7 512H80C35.82 512 0 476.2 0 432V115.3C0 79.68 43.09 61.83 68.28 87.03L424.1 443.7zM456.2 376.6C451.1 373.8 448 368.4 448 362.6V309.4C448 303.6 451.1 298.2 456.2 295.4L504.2 268.4C509 265.7 514.1 265.7 519.8 268.4L567.8 295.4C572.9 298.2 576 303.6 576 309.4V362.6C576 368.4 572.9 373.8 567.8 376.6L519.8 403.6C514.1 406.3 509 406.3 504.2 403.6L456.2 376.6zM192 64C192 81.67 177.7 96 160 96C142.3 96 128 81.67 128 64C128 46.33 142.3 32 160 32C177.7 32 192 46.33 192 64zM352 256C352 238.3 366.3 224 384 224C401.7 224 416 238.3 416 256C416 273.7 401.7 288 384 288C366.3 288 352 273.7 352 256z',
			),
		),
		'label'             => __( 'Hill Rockslide', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'hippo'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M584.2 96.36c-28.88-1.701-54.71 17.02-79.74 26.49C490 88.22 455.9 64 416 64c-11.25 0-22 2.252-32 5.877V56C384 42.75 373.2 32 360 32h-16C330.8 32 320 42.75 320 56v49C285.1 79.62 241.2 64 192 64C85.1 64 0 135.6 0 224v232C0 469.3 10.75 480 24 480h48C85.25 480 96 469.3 96 456v-62.87C128.4 407.5 166.8 416 208 416s79.63-8.492 112-22.87V456c0 13.25 10.75 24 24 24h48c13.25 0 24-10.75 24-24V288h128v32c0 8.837 7.163 16 16 16h32c8.837 0 16-7.163 16-16V288c17.62 0 32-14.38 32-32l-.0001-96.07C639.1 127.8 616.4 98.25 584.2 96.36zM447.1 176c-8.875 0-16-7.125-16-16S439.1 144 448 144s16 7.125 16 16S456.9 176 447.1 176z',
			),
		),
		'label'             => __( 'Hippo', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'hips'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M251.6 157.6c0-1.9-.9-2.8-2.8-2.8h-40.9c-1.6 0-2.7 1.4-2.7 2.8v201.8c0 1.4 1.1 2.8 2.7 2.8h40.9c1.9 0 2.8-.9 2.8-2.8zM156.5 168c-16.1-11.8-36.3-17.9-60.3-18-18.1-.1-34.6 3.7-49.8 11.4V80.2c0-1.8-.9-2.7-2.8-2.7H2.7c-1.8 0-2.7 .9-2.7 2.7v279.2c0 1.9 .9 2.8 2.7 2.8h41c1.9 0 2.8-.9 2.8-2.8V223.3c0-.8-2.8-27 45.8-27 48.5 0 45.8 26.1 45.8 27v122.6c0 9 7.3 16.3 16.4 16.3h27.3c1.8 0 2.7-.9 2.7-2.8V223.3c0-23.4-9.3-41.8-28-55.3zm478.4 110.1c-6.8-15.7-18.4-27-34.9-34.1l-57.6-25.3c-8.6-3.6-9.2-11.2-2.6-16.1 7.4-5.5 44.3-13.9 84 6.8 1.7 1 4-.3 4-2.4v-44.7c0-1.3-.6-2.1-1.9-2.6-17.7-6.6-36.1-9.9-55.1-9.9-26.5 0-45.3 5.8-58.5 15.4-.5 .4-28.4 20-22.7 53.7 3.4 19.6 15.8 34.2 37.2 43.6l53.6 23.5c11.6 5.1 15.2 13.3 12.2 21.2-3.7 9.1-13.2 13.6-36.5 13.6-24.3 0-44.7-8.9-58.4-19.1-2.1-1.4-4.4 .2-4.4 2.3v34.4c0 10.4 4.9 17.3 14.6 20.7 15.6 5.5 31.6 8.2 48.2 8.2 12.7 0 25.8-1.2 36.3-4.3 .7-.3 36-8.9 45.6-45.8 3.5-13.5 2.4-26.5-3.1-39.1zM376.2 149.8c-31.7 0-104.2 20.1-104.2 103.5v183.5c0 .8 .6 2.7 2.7 2.7h40.9c1.9 0 2.8-.9 2.8-2.7V348c16.5 12.7 35.8 19.1 57.7 19.1 60.5 0 108.7-48.5 108.7-108.7 .1-60.3-48.2-108.6-108.6-108.6zm0 170.9c-17.2 0-31.9-6.1-44-18.2-12.2-12.2-18.2-26.8-18.2-44 0-34.5 27.6-62.2 62.2-62.2 34.5 0 62.2 27.6 62.2 62.2 .1 34.3-27.3 62.2-62.2 62.2zM228.3 72.5c-15.9 0-28.8 12.9-28.9 28.9 0 15.6 12.7 28.9 28.9 28.9s28.9-13.1 28.9-28.9c0-16.2-13-28.9-28.9-28.9z',
			),
		),
		'label'             => __( 'Hips', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'hire-a-helper'                        => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M443.1 0H71.9C67.9 37.3 37.4 67.8 0 71.7v371.5c37.4 4.9 66 32.4 71.9 68.8h372.2c3-36.4 32.5-65.8 67.9-69.8V71.7c-36.4-5.9-65-35.3-68.9-71.7zm-37 404.9c-36.3 0-18.8-2-55.1-2-35.8 0-21 2-56.1 2-5.9 0-4.9-8.2 0-9.8 22.8-7.6 22.9-10.2 24.6-12.8 10.4-15.6 5.9-83 5.9-113 0-5.3-6.4-12.8-13.8-12.8H200.4c-7.4 0-13.8 7.5-13.8 12.8 0 30-4.5 97.4 5.9 113 1.7 2.5 1.8 5.2 24.6 12.8 4.9 1.6 6 9.8 0 9.8-35.1 0-20.3-2-56.1-2-36.3 0-18.8 2-55.1 2-7.9 0-5.8-10.8 0-10.8 10.2-3.4 13.5-3.5 21.7-13.8 7.7-12.9 7.9-44.4 7.9-127.8V151.3c0-22.2-12.2-28.3-28.6-32.4-8.8-2.2-4-11.8 1-11.8 36.5 0 20.6 2 57.1 2 32.7 0 16.5-2 49.2-2 3.3 0 8.5 8.3 1 10.8-4.9 1.6-27.6 3.7-27.6 39.3 0 45.6-.2 55.8 1 68.8 0 1.3 2.3 12.8 12.8 12.8h109.2c10.5 0 12.8-11.5 12.8-12.8 1.2-13 1-23.2 1-68.8 0-35.6-22.7-37.7-27.6-39.3-7.5-2.5-2.3-10.8 1-10.8 32.7 0 16.5 2 49.2 2 36.5 0 20.6-2 57.1-2 4.9 0 9.9 9.6 1 11.8-16.4 4.1-28.6 10.3-28.6 32.4v101.2c0 83.4 .1 114.9 7.9 127.8 8.2 10.2 11.4 10.4 21.7 13.8 5.8 0 7.8 10.8 0 10.8z',
			),
		),
		'label'             => __( 'HireAHelper', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'hive'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M260.4 254.9 131.5 33.1a2.208 2.208 0 0 0 -3.829 .009L.3 254.9A2.234 2.234 0 0 0 .3 257.1L129.1 478.9a2.208 2.208 0 0 0 3.83-.009L260.4 257.1A2.239 2.239 0 0 0 260.4 254.9zm39.08-25.71a2.19 2.19 0 0 0 1.9 1.111h66.51a2.226 2.226 0 0 0 1.9-3.341L259.1 33.11a2.187 2.187 0 0 0 -1.9-1.111H190.7a2.226 2.226 0 0 0 -1.9 3.341zM511.7 254.9 384.9 33.11A2.2 2.2 0 0 0 382.1 32h-66.6a2.226 2.226 0 0 0 -1.906 3.34L440.7 256 314.5 476.7a2.226 2.226 0 0 0 1.906 3.34h66.6a2.2 2.2 0 0 0 1.906-1.112L511.7 257.1A2.243 2.243 0 0 0 511.7 254.9zM366 284.9H299.5a2.187 2.187 0 0 0 -1.9 1.111l-108.8 190.6a2.226 2.226 0 0 0 1.9 3.341h66.51a2.187 2.187 0 0 0 1.9-1.111l108.8-190.6A2.226 2.226 0 0 0 366 284.9z',
			),
		),
		'label'             => __( 'Hive Blockchain Network', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'hockey-puck'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 160c0-53 114.6-96 256-96s256 43 256 96s-114.6 96-256 96S0 213 0 160zM255.1 303.1C156.4 303.1 56.73 283.4 0 242.2V352c0 53 114.6 96 256 96s256-43 256-96V242.2C455.3 283.4 355.6 303.1 255.1 303.1z',
			),
		),
		'label'             => __( 'Hockey Puck', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'holly-berry'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M287.1 143.1c0 26.5 21.5 47.1 47.1 47.1c26.5 0 48-21.5 48-47.1s-21.5-47.1-48-47.1C309.5 95.99 287.1 117.5 287.1 143.1zM176 191.1c26.5 0 47.1-21.5 47.1-47.1S202.5 95.96 176 95.96c-26.5 0-47.1 21.5-47.1 47.1S149.5 191.1 176 191.1zM303.1 47.1C303.1 21.5 282.5 0 255.1 0c-26.5 0-47.1 21.5-47.1 47.1S229.5 95.99 255.1 95.99C282.5 95.99 303.1 74.5 303.1 47.1zM243.7 242.6C245.3 229.7 231.9 220.1 219.5 225.5C179.7 242.8 137.8 251.4 96.72 250.8C86.13 250.6 78.49 260.7 81.78 270.4C86.77 285.7 90.33 301.4 92.44 317.7c2.133 16.15-9.387 31.26-26.12 34.23c-16.87 2.965-33.7 4.348-50.48 4.152c-10.6-.0586-18.37 10.05-15.08 19.74c12.4 35.79 16.57 74.93 12.12 114.7c-1.723 14.96 13.71 25.67 28.02 19.8c38.47-15.95 78.77-23.81 118.2-23.34c10.58 .1953 18.36-9.91 15.07-19.6c-5.141-15.15-8.68-31.06-10.79-47.34c-2.133-16.16 9.371-31.13 26.24-34.09c16.73-2.973 33.57-4.496 50.36-4.301c10.73 .0781 18.51-10.03 15.22-19.72C242.5 324.7 238.5 283.9 243.7 242.6zM496.2 356.1c-16.78 .1953-33.61-1.188-50.48-4.152c-16.73-2.973-28.25-18.08-26.12-34.23c2.115-16.28 5.67-32.05 10.66-47.32c3.289-9.691-4.35-19.81-14.93-19.62c-41.11 .6484-83.01-7.965-122.7-25.23c-6.85-2.969-13.71-1.18-18.47 2.953c1.508 5.836 2.102 11.93 1.332 18.05c-4.539 36.23-1.049 72.56 10.12 105.1c3.395 9.988 3.029 20.73-.4766 30.52c12.44 .5 24.89 1.602 37.28 3.801c16.87 2.957 28.37 17.93 26.24 34.09c-2.115 16.27-5.654 32.19-10.79 47.34c-3.289 9.691 4.486 19.8 15.07 19.6c39.47-.4766 79.77 7.383 118.2 23.34c14.31 5.867 29.74-4.844 28.02-19.8c-4.451-39.81-.2832-78.95 12.12-114.7C514.5 366.1 506.8 356 496.2 356.1z',
			),
		),
		'label'             => __( 'Holly Berry', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'hooli'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M144.5 352l38.3 .8c-13.2-4.6-26-10.2-38.3-16.8zm57.7-5.3v5.3l-19.4 .8c36.5 12.5 69.9 14.2 94.7 7.2-19.9 .2-45.8-2.6-75.3-13.3zm408.9-115.2c15.9 0 28.9-12.9 28.9-28.9s-12.9-24.5-28.9-24.5c-15.9 0-28.9 8.6-28.9 24.5s12.9 28.9 28.9 28.9zm-29 120.5H640V241.5h-57.9zm-73.7 0h57.9V156.7L508.4 184zm-31-119.4c-18.2-18.2-50.4-17.1-50.4-17.1s-32.3-1.1-50.4 17.1c-18.2 18.2-16.8 33.9-16.8 52.6s-1.4 34.3 16.8 52.5 50.4 17.1 50.4 17.1 32.3 1.1 50.4-17.1c18.2-18.2 16.8-33.8 16.8-52.5-.1-18.8 1.3-34.5-16.8-52.6zm-39.8 71.9c0 3.6-1.8 12.5-10.7 12.5s-10.7-8.9-10.7-12.5v-40.4c0-8.7 7.3-10.9 10.7-10.9s10.7 2.1 10.7 10.9zm-106.2-71.9c-18.2-18.2-50.4-17.1-50.4-17.1s-32.2-1.1-50.4 17.1c-1.9 1.9-3.7 3.9-5.3 6-38.2-29.6-72.5-46.5-102.1-61.1v-20.7l-22.5 10.6c-54.4-22.1-89-18.2-97.3 .1 0 0-24.9 32.8 61.8 110.8V352h57.9v-28.6c-6.5-4.2-13-8.7-19.4-13.6-14.8-11.2-27.4-21.6-38.4-31.4v-31c13.1 14.7 30.5 31.4 53.4 50.3l4.5 3.6v-29.8c0-6.9 1.7-18.2 10.8-18.2s10.6 6.9 10.6 15V317c18 12.2 37.3 22.1 57.7 29.6v-93.9c0-18.7-13.4-37.4-40.6-37.4-15.8-.1-30.5 8.2-38.5 21.9v-54.3c41.9 20.9 83.9 46.5 99.9 58.3-10.2 14.6-9.3 28.1-9.3 43.7 0 18.7-1.4 34.3 16.8 52.5s50.4 17.1 50.4 17.1 32.3 1.1 50.4-17.1c18.2-18.2 16.7-33.8 16.7-52.5 0-18.5 1.5-34.2-16.7-52.3zM65.2 184v63.3c-48.7-54.5-38.9-76-35.2-79.1 13.5-11.4 37.5-8 64.4 2.1zm226.5 120.5c0 3.6-1.8 12.5-10.7 12.5s-10.7-8.9-10.7-12.5v-40.4c0-8.7 7.3-10.9 10.7-10.9s10.7 2.1 10.7 10.9z',
			),
		),
		'label'             => __( 'Hooli', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'hornbill'                             => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M76.38 370.3a37.8 37.8 0 1 1 -32.07-32.42c-78.28-111.3 52-190.5 52-190.5-5.86 43-8.24 91.16-8.24 91.16-67.31 41.49 .93 64.06 39.81 72.87a140.4 140.4 0 0 0 131.7 91.94c1.92 0 3.77-.21 5.67-.28l.11 18.86c-99.22 1.39-158.7-29.14-188.9-51.6zm108-327.7A37.57 37.57 0 0 0 181 21.45a37.95 37.95 0 1 0 -31.17 54.22c-22.55 29.91-53.83 89.57-52.42 190l21.84-.15c0-.9-.14-1.77-.14-2.68A140.4 140.4 0 0 1 207 132.7c8-37.71 30.7-114.3 73.8-44.29 0 0 48.14 2.38 91.18 8.24 0 0-77.84-128-187.6-54.06zm304.2 134.2a37.94 37.94 0 1 0 -53.84-28.7C403 126.1 344.9 99 251.3 100.3l.14 22.5c2.7-.15 5.39-.41 8.14-.41a140.4 140.4 0 0 1 130.5 88.76c39.1 9 105.1 31.58 38.46 72.54 0 0-2.34 48.13-8.21 91.16 0 0 133.4-81.16 49-194.6a37.45 37.45 0 0 0 19.31-3.5zM374.1 436.2c21.43-32.46 46.42-89.69 45.14-179.7l-19.52 .14c.08 2.06 .3 4.07 .3 6.15a140.3 140.3 0 0 1 -91.39 131.4c-8.85 38.95-31.44 106.7-72.77 39.49 0 0-48.12-2.34-91.19-8.22 0 0 79.92 131.3 191.9 51a37.5 37.5 0 0 0 3.64 14 37.93 37.93 0 1 0 33.89-54.29z',
			),
		),
		'label'             => __( 'Hornbill', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'horse'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M575.9 76.61c0-8.125-3.05-15.84-8.55-21.84c-3.875-4-8.595-9.125-13.72-14.5c11.12-6.75 19.47-17.51 22.22-30.63c.9999-5-2.849-9.641-7.974-9.641L447.9 0c-70.62 0-127.9 57.25-127.9 128L159.1 128c-28.87 0-54.38 12.1-72 33.12L87.1 160C39.5 160 .0001 199.5 .0001 248L0 304c0 8.875 7.125 15.1 15.1 15.1L31.1 320c8.874 0 15.1-7.125 15.1-16l.0005-56c0-13.25 6.884-24.4 16.76-31.65c-.125 2.5-.758 5.024-.758 7.649c0 27.62 11.87 52.37 30.5 69.87l-25.65 68.61c-4.586 12.28-5.312 25.68-2.128 38.4l21.73 86.89C92.02 502 104.8 512 119.5 512h32.98c20.81 0 36.08-19.55 31.05-39.74L162.2 386.9l23.78-63.61l133.1 22.34L319.1 480c0 17.67 14.33 32 31.1 32h31.1c17.67 0 31.1-14.33 31.1-32l.0166-161.8C435.7 297.1 447.1 270.5 447.1 240c0-.25-.1025-.3828-.1025-.6328V136.9L463.9 144l18.95 37.72c7.481 14.86 25.08 21.55 40.52 15.34l32.54-13.05c12.13-4.878 20.11-16.67 20.09-29.74L575.9 76.61zM511.9 96c-8.75 0-15.1-7.125-15.1-16S503.1 64 511.9 64c8.874 0 15.1 7.125 15.1 16S520.8 96 511.9 96z',
			),
		),
		'label'             => __( 'Horse', 'astra' ),
		'custom_categories' => array(
			'environment',
			'travel',
		),
	),
	'horse-head'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M509.8 332.5l-69.89-164.3c-14.88-41.25-50.38-70.98-93.01-79.24c18-10.63 46.35-35.9 34.23-82.29c-1.375-5.001-7.112-7.972-11.99-6.097l-202.3 75.66C35.89 123.4 0 238.9 0 398.8v81.24C0 497.7 14.25 512 32 512h236.2c23.75 0 39.3-25.03 28.55-46.28l-40.78-81.71V383.3c-45.63-3.5-84.66-30.7-104.3-69.58c-1.625-3.125-.9342-6.951 1.566-9.327l12.11-12.11c3.875-3.875 10.64-2.692 12.89 2.434c14.88 33.63 48.17 57.38 87.42 57.38c17.13 0 33.05-5.091 46.8-13.22l46 63.9c6 8.501 15.75 13.34 26 13.34h50.28c8.501 0 16.61-3.388 22.61-9.389l45.34-39.84C511.6 357.7 514.4 344.2 509.8 332.5zM328.1 223.1c-13.25 0-23.96-10.75-23.96-24c0-13.25 10.75-23.92 24-23.92s23.94 10.73 23.94 23.98C352 213.3 341.3 223.1 328.1 223.1z',
			),
		),
		'label'             => __( 'Horse Head', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'hospital'                             => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M192 48C192 21.49 213.5 0 240 0H400C426.5 0 448 21.49 448 48V512H368V432C368 405.5 346.5 384 320 384C293.5 384 272 405.5 272 432V512H192V48zM312 64C303.2 64 296 71.16 296 80V104H272C263.2 104 256 111.2 256 120V136C256 144.8 263.2 152 272 152H296V176C296 184.8 303.2 192 312 192H328C336.8 192 344 184.8 344 176V152H368C376.8 152 384 144.8 384 136V120C384 111.2 376.8 104 368 104H344V80C344 71.16 336.8 64 328 64H312zM160 96V512H48C21.49 512 0 490.5 0 464V320H80C88.84 320 96 312.8 96 304C96 295.2 88.84 288 80 288H0V224H80C88.84 224 96 216.8 96 208C96 199.2 88.84 192 80 192H0V144C0 117.5 21.49 96 48 96H160zM592 96C618.5 96 640 117.5 640 144V192H560C551.2 192 544 199.2 544 208C544 216.8 551.2 224 560 224H640V288H560C551.2 288 544 295.2 544 304C544 312.8 551.2 320 560 320H640V464C640 490.5 618.5 512 592 512H480V96H592z',
			),
			'regular' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M296 96C296 87.16 303.2 80 312 80H328C336.8 80 344 87.16 344 96V120H368C376.8 120 384 127.2 384 136V152C384 160.8 376.8 168 368 168H344V192C344 200.8 336.8 208 328 208H312C303.2 208 296 200.8 296 192V168H272C263.2 168 256 160.8 256 152V136C256 127.2 263.2 120 272 120H296V96zM408 0C447.8 0 480 32.24 480 72V80H568C607.8 80 640 112.2 640 152V440C640 479.8 607.8 512 568 512H71.98C32.19 512 0 479.8 0 440V152C0 112.2 32.24 80 72 80H160V72C160 32.24 192.2 0 232 0L408 0zM480 128V464H568C581.3 464 592 453.3 592 440V336H536C522.7 336 512 325.3 512 312C512 298.7 522.7 288 536 288H592V240H536C522.7 240 512 229.3 512 216C512 202.7 522.7 192 536 192H592V152C592 138.7 581.3 128 568 128H480zM48 152V192H104C117.3 192 128 202.7 128 216C128 229.3 117.3 240 104 240H48V288H104C117.3 288 128 298.7 128 312C128 325.3 117.3 336 104 336H48V440C48 453.3 58.74 464 71.98 464H160V128H72C58.75 128 48 138.7 48 152V152zM208 464H272V400C272 373.5 293.5 352 320 352C346.5 352 368 373.5 368 400V464H432V72C432 58.75 421.3 48 408 48H232C218.7 48 208 58.75 208 72V464z',
			),
		),
		'label'             => __( 'Hospital', 'astra' ),
		'custom_categories' => array(
			'business',
			'science-and-technology',
			'travel',
		),
	),
	'hospital-user'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M272 0C298.5 0 320 21.49 320 48V367.8C281.8 389.2 256 430 256 476.9C256 489.8 259.6 501.8 265.9 512H48C21.49 512 0 490.5 0 464V384H144C152.8 384 160 376.8 160 368C160 359.2 152.8 352 144 352H0V288H144C152.8 288 160 280.8 160 272C160 263.2 152.8 256 144 256H0V48C0 21.49 21.49 0 48 0H272zM152 64C143.2 64 136 71.16 136 80V104H112C103.2 104 96 111.2 96 120V136C96 144.8 103.2 152 112 152H136V176C136 184.8 143.2 192 152 192H168C176.8 192 184 184.8 184 176V152H208C216.8 152 224 144.8 224 136V120C224 111.2 216.8 104 208 104H184V80C184 71.16 176.8 64 168 64H152zM512 272C512 316.2 476.2 352 432 352C387.8 352 352 316.2 352 272C352 227.8 387.8 192 432 192C476.2 192 512 227.8 512 272zM288 477.1C288 425.7 329.7 384 381.1 384H482.9C534.3 384 576 425.7 576 477.1C576 496.4 560.4 512 541.1 512H322.9C303.6 512 288 496.4 288 477.1V477.1z',
			),
		),
		'label'             => __( 'Hospital User', 'astra' ),
		'custom_categories' => array(
			'business',
			'science-and-technology',
		),
	),
	'hot-tub-person'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M414.3 177.6C415.3 185.9 421.1 192 429.1 192h16.13c9.5 0 17-8.625 16-18.38C457.8 134.5 439.6 99.12 412 76.5c-17.38-14.12-28.88-36.75-32-62.12C379 6.125 372.3 0 364.3 0h-16.12c-9.5 0-17.12 8.625-16 18.38c4.375 39.12 22.38 74.5 50.13 97.13C399.6 129.6 411 152.2 414.3 177.6zM306.3 177.6C307.3 185.9 313.1 192 321.1 192h16.13c9.5 0 17-8.625 16-18.38C349.8 134.5 331.6 99.12 304 76.5c-17.38-14.12-28.88-36.75-32-62.12C271 6.125 264.3 0 256.3 0h-16.17C230.6 0 223 8.625 224.1 18.38C228.5 57.5 246.5 92.88 274.3 115.5C291.6 129.6 303 152.2 306.3 177.6zM480 256h-224L145.1 172.8C133.1 164.5 120.5 160 106.6 160H64C28.62 160 0 188.6 0 224v224c0 35.38 28.62 64 64 64h384c35.38 0 64-28.62 64-64V288C512 270.4 497.6 256 480 256zM128 440C128 444.4 124.4 448 120 448h-16C99.62 448 96 444.4 96 440v-112C96 323.6 99.62 320 104 320h16C124.4 320 128 323.6 128 328V440zM224 440C224 444.4 220.4 448 216 448h-16C195.6 448 192 444.4 192 440v-112C192 323.6 195.6 320 200 320h16C220.4 320 224 323.6 224 328V440zM320 440c0 4.375-3.625 8-8 8h-16C291.6 448 288 444.4 288 440v-112c0-4.375 3.625-8 8-8h16c4.375 0 8 3.625 8 8V440zM416 440c0 4.375-3.625 8-8 8h-16C387.6 448 384 444.4 384 440v-112c0-4.375 3.625-8 8-8h16c4.375 0 8 3.625 8 8V440zM64 128c35.38 0 64-28.62 64-64S99.38 0 64 0S0 28.62 0 64S28.62 128 64 128z',
			),
		),
		'label'             => __( 'Hot Tub Person', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'hotdog'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M488.6 23.44c-31.06-31.19-81.76-31.16-112.8 .0313L24.46 374.8c-20.83 19.96-29.19 49.66-21.83 77.6c7.36 27.94 29.07 49.65 57.02 57.01c27.94 7.36 57.64-1 77.6-21.83l351.3-351.3C519.7 105.2 519.8 54.5 488.6 23.44zM438.8 118.4c-19.59 19.59-37.39 22.52-51.74 25.01c-12.97 2.246-22.33 3.867-34.68 16.22c-12.35 12.35-13.97 21.71-16.22 34.69c-2.495 14.35-5.491 32.19-25.08 51.78c-19.59 19.59-37.43 22.58-51.78 25.08C246.3 273.4 236.9 275.1 224.6 287.4c-12.35 12.35-13.97 21.71-16.22 34.68C205.9 336.4 202.9 354.3 183.3 373.9c-19.59 19.59-37.43 22.58-51.78 25.08C118.5 401.2 109.2 402.8 96.83 415.2c-6.238 6.238-16.34 6.238-22.58 0c-6.238-6.238-6.238-16.35 0-22.58c19.59-19.59 37.43-22.58 51.78-25.07c12.97-2.245 22.33-3.869 34.68-16.22c12.35-12.35 13.97-21.71 16.22-34.69c2.495-14.35 5.492-32.19 25.08-51.78s37.43-22.58 51.78-25.08c12.97-2.246 22.33-3.869 34.68-16.22s13.97-21.71 16.22-34.68c2.495-14.35 5.492-32.19 25.08-51.78c19.59-19.59 37.43-22.58 51.78-25.07c12.97-2.246 22.28-3.815 34.63-16.17c6.238-6.238 16.36-6.238 22.59 0C444.1 102.1 444.1 112.2 438.8 118.4zM32.44 321.5l290-290l-11.48-11.6c-24.95-24.95-63.75-26.57-86.58-3.743L17.1 223.4C-5.73 246.3-4.108 285.1 20.84 310L32.44 321.5zM480.6 189.5l-290 290l11.48 11.6c24.95 24.95 63.75 26.57 86.58 3.743l207.3-207.3c22.83-22.83 21.21-61.63-3.743-86.58L480.6 189.5z',
			),
		),
		'label'             => __( 'Hotdog', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'hotel'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M480 0C497.7 0 512 14.33 512 32C512 49.67 497.7 64 480 64V448C497.7 448 512 462.3 512 480C512 497.7 497.7 512 480 512H304V448H208V512H32C14.33 512 0 497.7 0 480C0 462.3 14.33 448 32 448V64C14.33 64 0 49.67 0 32C0 14.33 14.33 0 32 0H480zM112 96C103.2 96 96 103.2 96 112V144C96 152.8 103.2 160 112 160H144C152.8 160 160 152.8 160 144V112C160 103.2 152.8 96 144 96H112zM224 144C224 152.8 231.2 160 240 160H272C280.8 160 288 152.8 288 144V112C288 103.2 280.8 96 272 96H240C231.2 96 224 103.2 224 112V144zM368 96C359.2 96 352 103.2 352 112V144C352 152.8 359.2 160 368 160H400C408.8 160 416 152.8 416 144V112C416 103.2 408.8 96 400 96H368zM96 240C96 248.8 103.2 256 112 256H144C152.8 256 160 248.8 160 240V208C160 199.2 152.8 192 144 192H112C103.2 192 96 199.2 96 208V240zM240 192C231.2 192 224 199.2 224 208V240C224 248.8 231.2 256 240 256H272C280.8 256 288 248.8 288 240V208C288 199.2 280.8 192 272 192H240zM352 240C352 248.8 359.2 256 368 256H400C408.8 256 416 248.8 416 240V208C416 199.2 408.8 192 400 192H368C359.2 192 352 199.2 352 208V240zM256 288C211.2 288 173.5 318.7 162.1 360.2C159.7 373.1 170.7 384 184 384H328C341.3 384 352.3 373.1 349 360.2C338.5 318.7 300.8 288 256 288z',
			),
		),
		'label'             => __( 'Hotel', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'hotjar'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M414.9 161.5C340.2 29 121.1 0 121.1 0S222.2 110.4 93 197.7C11.3 252.8-21 324.4 14 402.6c26.8 59.9 83.5 84.3 144.6 93.4-29.2-55.1-6.6-122.4-4.1-129.6 57.1 86.4 165 0 110.8-93.9 71 15.4 81.6 138.6 27.1 215.5 80.5-25.3 134.1-88.9 148.8-145.6 15.5-59.3 3.7-127.9-26.3-180.9z',
			),
		),
		'label'             => __( 'Hotjar', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'hourglass'                            => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M352 0C369.7 0 384 14.33 384 32C384 49.67 369.7 64 352 64V74.98C352 117.4 335.1 158.1 305.1 188.1L237.3 256L305.1 323.9C335.1 353.9 352 394.6 352 437V448C369.7 448 384 462.3 384 480C384 497.7 369.7 512 352 512H32C14.33 512 0 497.7 0 480C0 462.3 14.33 448 32 448V437C32 394.6 48.86 353.9 78.86 323.9L146.7 256L78.86 188.1C48.86 158.1 32 117.4 32 74.98V64C14.33 64 0 49.67 0 32C0 14.33 14.33 0 32 0H352zM111.1 128H272C282.4 112.4 288 93.98 288 74.98V64H96V74.98C96 93.98 101.6 112.4 111.1 128zM111.1 384H272C268.5 378.7 264.5 373.7 259.9 369.1L192 301.3L124.1 369.1C119.5 373.7 115.5 378.7 111.1 384V384z',
			),
			'regular' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M0 24C0 10.75 10.75 0 24 0H360C373.3 0 384 10.75 384 24C384 37.25 373.3 48 360 48H352V66.98C352 107.3 335.1 145.1 307.5 174.5L225.9 256L307.5 337.5C335.1 366 352 404.7 352 445V464H360C373.3 464 384 474.7 384 488C384 501.3 373.3 512 360 512H24C10.75 512 0 501.3 0 488C0 474.7 10.75 464 24 464H32V445C32 404.7 48.01 366 76.52 337.5L158.1 256L76.52 174.5C48.01 145.1 32 107.3 32 66.98V48H24C10.75 48 0 37.25 0 24V24zM99.78 384H284.2C281 379.6 277.4 375.4 273.5 371.5L192 289.9L110.5 371.5C106.6 375.4 102.1 379.6 99.78 384H99.78zM284.2 128C296.1 110.4 304 89.03 304 66.98V48H80V66.98C80 89.03 87 110.4 99.78 128H284.2z',
			),
		),
		'label'             => __( 'Hourglass', 'astra' ),
		'custom_categories' => array(),
	),
	'hourglass-empty'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M0 32C0 14.33 14.33 0 32 0H352C369.7 0 384 14.33 384 32C384 49.67 369.7 64 352 64V74.98C352 117.4 335.1 158.1 305.1 188.1L237.3 256L305.1 323.9C335.1 353.9 352 394.6 352 437V448C369.7 448 384 462.3 384 480C384 497.7 369.7 512 352 512H32C14.33 512 0 497.7 0 480C0 462.3 14.33 448 32 448V437C32 394.6 48.86 353.9 78.86 323.9L146.7 256L78.86 188.1C48.86 158.1 32 117.4 32 74.98V64C14.33 64 0 49.67 0 32zM96 64V74.98C96 100.4 106.1 124.9 124.1 142.9L192 210.7L259.9 142.9C277.9 124.9 288 100.4 288 74.98V64H96zM96 448H288V437C288 411.6 277.9 387.1 259.9 369.1L192 301.3L124.1 369.1C106.1 387.1 96 411.6 96 437V448z',
			),
		),
		'label'             => __( 'Dribbble', 'astra' ),
		'custom_categories' => array(),
	),
	'hourglass-end'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M352 0C369.7 0 384 14.33 384 32C384 49.67 369.7 64 352 64V74.98C352 117.4 335.1 158.1 305.1 188.1L237.3 256L305.1 323.9C335.1 353.9 352 394.6 352 437V448C369.7 448 384 462.3 384 480C384 497.7 369.7 512 352 512H32C14.33 512 0 497.7 0 480C0 462.3 14.33 448 32 448V437C32 394.6 48.86 353.9 78.86 323.9L146.7 256L78.86 188.1C48.86 158.1 32 117.4 32 74.98V64C14.33 64 0 49.67 0 32C0 14.33 14.33 0 32 0H352zM124.1 142.9L192 210.7L259.9 142.9C277.9 124.9 288 100.4 288 74.98V64H96V74.98C96 100.4 106.1 124.9 124.1 142.9z',
			),
		),
		'label'             => __( 'Hourglass End', 'astra' ),
		'custom_categories' => array(),
	),
	'hourglass-start'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M352 0C369.7 0 384 14.33 384 32C384 49.67 369.7 64 352 64V74.98C352 117.4 335.1 158.1 305.1 188.1L237.3 256L305.1 323.9C335.1 353.9 352 394.6 352 437V448C369.7 448 384 462.3 384 480C384 497.7 369.7 512 352 512H32C14.33 512 0 497.7 0 480C0 462.3 14.33 448 32 448V437C32 394.6 48.86 353.9 78.86 323.9L146.7 256L78.86 188.1C48.86 158.1 32 117.4 32 74.98V64C14.33 64 0 49.67 0 32C0 14.33 14.33 0 32 0H352zM259.9 369.1L192 301.3L124.1 369.1C106.1 387.1 96 411.6 96 437V448H288V437C288 411.6 277.9 387.1 259.9 369.1V369.1z',
			),
		),
		'label'             => __( 'Hourglass Start', 'astra' ),
		'custom_categories' => array(),
	),
	'house'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M575.8 255.5C575.8 273.5 560.8 287.6 543.8 287.6H511.8L512.5 447.7C512.5 450.5 512.3 453.1 512 455.8V472C512 494.1 494.1 512 472 512H456C454.9 512 453.8 511.1 452.7 511.9C451.3 511.1 449.9 512 448.5 512H392C369.9 512 352 494.1 352 472V384C352 366.3 337.7 352 320 352H256C238.3 352 224 366.3 224 384V472C224 494.1 206.1 512 184 512H128.1C126.6 512 125.1 511.9 123.6 511.8C122.4 511.9 121.2 512 120 512H104C81.91 512 64 494.1 64 472V360C64 359.1 64.03 358.1 64.09 357.2V287.6H32.05C14.02 287.6 0 273.5 0 255.5C0 246.5 3.004 238.5 10.01 231.5L266.4 8.016C273.4 1.002 281.4 0 288.4 0C295.4 0 303.4 2.004 309.5 7.014L564.8 231.5C572.8 238.5 576.9 246.5 575.8 255.5L575.8 255.5z',
			),
		),
		'label'             => __( 'House', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'house-chimney'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M511.8 287.6L512.5 447.7C512.5 450.5 512.3 453.1 512 455.8V472C512 494.1 494.1 512 472 512H456C454.9 512 453.8 511.1 452.7 511.9C451.3 511.1 449.9 512 448.5 512H392C369.9 512 352 494.1 352 472V384C352 366.3 337.7 352 320 352H256C238.3 352 224 366.3 224 384V472C224 494.1 206.1 512 184 512H128.1C126.6 512 125.1 511.9 123.6 511.8C122.4 511.9 121.2 512 120 512H104C81.91 512 64 494.1 64 472V360C64 359.1 64.03 358.1 64.09 357.2V287.6H32.05C14.02 287.6 0 273.5 0 255.5C0 246.5 3.004 238.5 10.01 231.5L266.4 8.016C273.4 1.002 281.4 0 288.4 0C295.4 0 303.4 2.004 309.5 7.014L416 100.7V64C416 46.33 430.3 32 448 32H480C497.7 32 512 46.33 512 64V185L564.8 231.5C572.8 238.5 576.9 246.5 575.8 255.5C575.8 273.5 560.8 287.6 543.8 287.6L511.8 287.6z',
			),
		),
		'label'             => __( 'House Chimney', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'house-chimney-crack'                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M575.8 255.5C575.8 273.5 560.8 287.6 543.8 287.6H511.8L512.5 447.7C512.6 483.2 483.9 512 448.5 512H326.4L288 448L368.8 380.7C376.6 374.1 376.5 362.1 368.5 355.8L250.6 263.2C235.1 251.7 216.8 270.1 227.8 285.2L288 368L202.5 439.2C196.5 444.3 194.1 452.1 199.1 459.8L230.4 512H128.1C92.75 512 64.09 483.3 64.09 448V287.6H32.05C14.02 287.6 0 273.5 0 255.5C0 246.5 3.004 238.5 10.01 231.5L266.4 8.016C273.4 1.002 281.4 0 288.4 0C295.4 0 303.4 2.004 309.5 7.014L416 100.7V64C416 46.33 430.3 32 448 32H480C497.7 32 512 46.33 512 64V185L564.8 231.5C572.8 238.5 576.9 246.5 575.8 255.5L575.8 255.5z',
			),
		),
		'label'             => __( 'House Chimney Crack', 'astra' ),
		'custom_categories' => array(
			'business',
			'environment',
		),
	),
	'house-chimney-medical'                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M511.8 287.6L512.5 447.7C512.6 483.2 483.9 512 448.5 512H128.1C92.75 512 64.09 483.3 64.09 448V287.6H32.05C14.02 287.6 0 273.5 0 255.5C0 246.5 3.004 238.5 10.01 231.5L266.4 8.016C273.4 1.002 281.4 0 288.4 0C295.4 0 303.4 2.004 309.5 7.014L416 100.7V64C416 46.33 430.3 32 448 32H480C497.7 32 512 46.33 512 64V185L564.8 231.5C572.8 238.5 576.9 246.5 575.8 255.5C575.8 273.5 560.8 287.6 543.8 287.6L511.8 287.6zM400 248C400 239.2 392.8 232 384 232H328V176C328 167.2 320.8 160 312 160H264C255.2 160 248 167.2 248 176V232H192C183.2 232 176 239.2 176 248V296C176 304.8 183.2 312 192 312H248V368C248 376.8 255.2 384 264 384H312C320.8 384 328 376.8 328 368V312H384C392.8 312 400 304.8 400 296V248z',
			),
		),
		'label'             => __( 'House Chimney Medical', 'astra' ),
		'custom_categories' => array(
			'business',
			'science-and-technology',
		),
	),
	'house-chimney-user'                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M511.8 287.6L512.5 447.7C512.6 483.2 483.9 512 448.5 512H128.1C92.75 512 64.09 483.3 64.09 448V287.6H32.05C14.02 287.6 0 273.5 0 255.5C0 246.5 3.004 238.5 10.01 231.5L266.4 8.016C273.4 1.002 281.4 0 288.4 0C295.4 0 303.4 2.004 309.5 7.014L416 100.7V64C416 46.33 430.3 32 448 32H480C497.7 32 512 46.33 512 64V185L564.8 231.5C572.8 238.5 576.9 246.5 575.8 255.5C575.8 273.5 560.8 287.6 543.8 287.6L511.8 287.6zM288 288C323.3 288 352 259.3 352 224C352 188.7 323.3 160 288 160C252.7 160 224 188.7 224 224C224 259.3 252.7 288 288 288zM192 416H384C392.8 416 400 408.8 400 400C400 355.8 364.2 320 320 320H256C211.8 320 176 355.8 176 400C176 408.8 183.2 416 192 416z',
			),
		),
		'label'             => __( 'House Chimney User', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'house-chimney-window'                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M575.8 255.5C575.8 273.5 560.8 287.6 543.8 287.6H511.8L512.5 447.7C512.6 483.2 483.9 512 448.5 512H128.1C92.75 512 64.09 483.3 64.09 448V287.6H32.05C14.02 287.6 0 273.5 0 255.5C0 246.5 3.004 238.5 10.01 231.5L266.4 8.016C273.4 1.002 281.4 0 288.4 0C295.4 0 303.4 2.004 309.5 7.014L416 100.7V64C416 46.33 430.3 32 448 32H480C497.7 32 512 46.33 512 64V185L564.8 231.5C572.8 238.5 576.9 246.5 575.8 255.5L575.8 255.5zM248 192C234.7 192 224 202.7 224 216V296C224 309.3 234.7 320 248 320H328C341.3 320 352 309.3 352 296V216C352 202.7 341.3 192 328 192H248z',
			),
		),
		'label'             => __( 'House Chimney Window', 'astra' ),
		'custom_categories' => array(
			'business',
			'lifestyle-and-hobbies',
		),
	),
	'house-circle-check'                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M320 352H256C238.3 352 224 366.3 224 384V472C224 494.1 206.1 512 184 512H128.1C126.6 512 125.1 511.9 123.6 511.8C122.4 511.9 121.2 512 120 512H104C81.91 512 64 494.1 64 472V360C64 359.1 64.03 358.1 64.09 357.2V287.6H32.05C14.02 287.6 0 273.5 0 255.5C0 246.5 3.004 238.5 10.01 231.5L266.4 8.016C273.4 1.002 281.4 0 288.4 0C295.4 0 303.4 2.004 309.5 7.014L522.1 193.9C513.6 192.7 504.9 192 496 192C404.2 192 328.8 262.3 320.7 352L320 352zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM540.7 324.7L480 385.4L451.3 356.7C445.1 350.4 434.9 350.4 428.7 356.7C422.4 362.9 422.4 373.1 428.7 379.3L468.7 419.3C474.9 425.6 485.1 425.6 491.3 419.3L563.3 347.3C569.6 341.1 569.6 330.9 563.3 324.7C557.1 318.4 546.9 318.4 540.7 324.7H540.7z',
			),
		),
		'label'             => __( 'House Circle Check', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'house-circle-exclamation'             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M320 352H256C238.3 352 224 366.3 224 384V472C224 494.1 206.1 512 184 512H128.1C126.6 512 125.1 511.9 123.6 511.8C122.4 511.9 121.2 512 120 512H104C81.91 512 64 494.1 64 472V360C64 359.1 64.03 358.1 64.09 357.2V287.6H32.05C14.02 287.6 0 273.5 0 255.5C0 246.5 3.004 238.5 10.01 231.5L266.4 8.016C273.4 1.002 281.4 0 288.4 0C295.4 0 303.4 2.004 309.5 7.014L522.1 193.9C513.6 192.7 504.9 192 496 192C404.2 192 328.8 262.3 320.7 352L320 352zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 464C509.3 464 520 453.3 520 440C520 426.7 509.3 416 496 416C482.7 416 472 426.7 472 440C472 453.3 482.7 464 496 464zM479.1 288V368C479.1 376.8 487.2 384 495.1 384C504.8 384 511.1 376.8 511.1 368V288C511.1 279.2 504.8 272 495.1 272C487.2 272 479.1 279.2 479.1 288z',
			),
		),
		'label'             => __( 'House Circle Exclamation', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'house-circle-xmark'                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M320 352H256C238.3 352 224 366.3 224 384V472C224 494.1 206.1 512 184 512H128.1C126.6 512 125.1 511.9 123.6 511.8C122.4 511.9 121.2 512 120 512H104C81.91 512 64 494.1 64 472V360C64 359.1 64.03 358.1 64.09 357.2V287.6H32.05C14.02 287.6 0 273.5 0 255.5C0 246.5 3.004 238.5 10.01 231.5L266.4 8.016C273.4 1.002 281.4 0 288.4 0C295.4 0 303.4 2.004 309.5 7.014L522.1 193.9C513.6 192.7 504.9 192 496 192C404.2 192 328.8 262.3 320.7 352L320 352zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM555.3 331.3C561.6 325.1 561.6 314.9 555.3 308.7C549.1 302.4 538.9 302.4 532.7 308.7L496 345.4L459.3 308.7C453.1 302.4 442.9 302.4 436.7 308.7C430.4 314.9 430.4 325.1 436.7 331.3L473.4 368L436.7 404.7C430.4 410.9 430.4 421.1 436.7 427.3C442.9 433.6 453.1 433.6 459.3 427.3L496 390.6L532.7 427.3C538.9 433.6 549.1 433.6 555.3 427.3C561.6 421.1 561.6 410.9 555.3 404.7L518.6 368L555.3 331.3z',
			),
		),
		'label'             => __( 'House Circle Xmark', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'house-crack'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M511.8 287.6L512.5 447.7C512.6 483.2 483.9 512 448.5 512H326.4L288 448L368.8 380.7C376.6 374.1 376.5 362.1 368.5 355.8L250.6 263.2C235.1 251.7 216.8 270.1 227.8 285.2L288 368L202.5 439.2C196.5 444.3 194.1 452.1 199.1 459.8L230.4 512H128.1C92.75 512 64.09 483.3 64.09 448V287.6H32.05C14.02 287.6 0 273.5 0 255.5C0 246.5 3.004 238.5 10.01 231.5L266.4 8.016C273.4 1.002 281.4 0 288.4 0C295.4 0 303.4 2.004 309.5 7.014L564.8 231.5C572.8 238.5 576.9 246.5 575.8 255.5C575.8 273.5 560.8 287.6 543.8 287.6H511.8z',
			),
		),
		'label'             => __( 'House Crack', 'astra' ),
		'custom_categories' => array(
			'business',
			'environment',
		),
	),
	'house-fire'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M288 350.1L288 352H256C238.3 352 224 366.3 224 384V472C224 494.1 206.1 512 184 512H128.1C126.6 512 125.1 511.9 123.6 511.8C122.4 511.9 121.2 512 120 512H104C81.91 512 64 494.1 64 472V360C64 359.1 64.03 358.1 64.09 357.2V287.6H32.05C14.02 287.6 0 273.5 0 255.5C0 246.5 3.004 238.5 10.01 231.5L266.4 8.016C273.4 1.002 281.4 0 288.4 0C295.4 0 303.4 2.004 309.5 7.014L447.3 128.1C434.9 127.2 422.3 131.1 412.5 139.9C377.1 171.5 346.9 207.6 325.2 242.7C304.3 276.5 288 314.9 288 350.1H288zM509 221.5C516.9 211.6 525.8 200.8 535.5 191.1C541.1 186.9 549.9 186.9 555.5 192C580.2 214.7 601.1 244.7 615.8 273.2C630.4 301.2 640 329.9 640 350.1C640 437.9 568.7 512 480 512C390.3 512 320 437.8 320 350.1C320 323.7 332.7 291.5 352.4 259.5C372.4 227.2 400.5 193.4 433.8 163.7C439.4 158.7 447.1 158.8 453.5 163.8C473.3 181.6 491.8 200.7 509 221.5V221.5zM550 336.1C548 332.1 546 328.1 543 324.1L507 367C507 367 449 293 445 288C415 324.1 400 346 400 370C400 419 436 448 481 448C499 448 515 443 530 432.1C560 412 568 370 550 336.1z',
			),
		),
		'label'             => __( 'House Fire', 'astra' ),
		'custom_categories' => array(
			'business',
			'environment',
			'lifestyle-and-hobbies',
			'science-and-technology',
		),
	),
	'house-flag'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M480 0C497.7 0 512 14.33 512 32H624C632.8 32 640 39.16 640 48V176C640 184.8 632.8 192 624 192H512V512H448V32C448 14.33 462.3 0 480 0V0zM416 512H416.1L416.8 512H352C334.3 512 320 497.7 320 480V384C320 366.3 305.7 352 288 352H224C206.3 352 192 366.3 192 384V480C192 497.7 177.7 512 160 512H96C78.33 512 64 497.7 64 480V288H31.1C18.61 288 6.631 279.7 1.985 267.1C-2.661 254.5 1.005 240.4 11.17 231.7L235.2 39.7C247.2 29.43 264.8 29.43 276.8 39.7L416 159V512z',
			),
		),
		'label'             => __( 'House Flag', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'house-flood-water'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M482.8 134.1C494 142.3 498.7 156.7 494.4 169.9C490.1 183.1 477.9 192 464 192H447.4L447.7 265.2C446.1 266.1 444.6 267.1 443.2 268.1C425.2 280.5 403 288.5 384 288.5C364.4 288.5 343.2 280.8 324.8 268.1C302.8 252.6 273.3 252.6 251.2 268.1C234 279.9 213.2 288.5 192 288.5C172.1 288.5 150.8 280.5 132.9 268.1C131.3 267 129.7 265.1 128 265V192H112C98.14 192 85.86 183.1 81.57 169.9C77.28 156.7 81.97 142.3 93.18 134.1L269.2 6.12C280.4-2.04 295.6-2.04 306.8 6.12L482.8 134.1zM269.5 309.9C280.6 302 295.4 302 306.5 309.9C328.1 325.4 356.5 336 384 336C410.9 336 439.4 325.2 461.4 309.9L461.5 309.9C473.4 301.4 489.5 302.1 500.7 311.6C515 323.5 533.2 332.6 551.3 336.8C568.5 340.8 579.2 358.1 575.2 375.3C571.2 392.5 553.1 403.2 536.7 399.2C512.2 393.4 491.9 382.6 478.5 374.2C449.5 389.7 417 400 384 400C352.1 400 323.4 390.1 303.6 381.1C297.7 378.5 292.5 375.8 288 373.4C283.5 375.8 278.3 378.5 272.4 381.1C252.6 390.1 223.9 400 192 400C158.1 400 126.5 389.7 97.5 374.2C84.12 382.6 63.79 393.4 39.27 399.2C22.06 403.2 4.854 392.5 .8426 375.3C-3.169 358.1 7.532 340.8 24.74 336.8C42.84 332.6 60.96 323.5 75.31 311.6C86.46 302.1 102.6 301.4 114.5 309.9L114.6 309.9C136.7 325.2 165.1 336 192 336C219.5 336 247 325.4 269.5 309.9H269.5zM461.4 421.9L461.5 421.9C473.4 413.4 489.5 414.1 500.7 423.6C515 435.5 533.2 444.6 551.3 448.8C568.5 452.8 579.2 470.1 575.2 487.3C571.2 504.5 553.1 515.2 536.7 511.2C512.2 505.4 491.9 494.6 478.5 486.2C449.5 501.7 417 512 384 512C352.1 512 323.4 502.1 303.6 493.1C297.7 490.5 292.5 487.8 288 485.4C283.5 487.8 278.3 490.5 272.4 493.1C252.6 502.1 223.9 512 192 512C158.1 512 126.5 501.7 97.5 486.2C84.12 494.6 63.79 505.4 39.27 511.2C22.06 515.2 4.853 504.5 .8422 487.3C-3.169 470.1 7.532 452.8 24.74 448.8C42.84 444.6 60.96 435.5 75.31 423.6C86.46 414.1 102.6 413.4 114.5 421.9L114.6 421.9C136.7 437.2 165.1 448 192 448C219.5 448 247 437.4 269.5 421.9C280.6 414 295.4 414 306.5 421.9C328.1 437.4 356.5 448 384 448C410.9 448 439.4 437.2 461.4 421.9H461.4z',
			),
		),
		'label'             => __( 'House Flood Water', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'house-flood-water-circle-arrow-right' => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M288 144C288 223.5 223.5 288 144 288C64.47 288 0 223.5 0 144C0 64.47 64.47 .0002 144 .0002C223.5 .0002 288 64.47 288 144zM140.7 99.31L169.4 128H80C71.16 128 64 135.2 64 144C64 152.8 71.16 160 80 160H169.4L140.7 188.7C134.4 194.9 134.4 205.1 140.7 211.3C146.9 217.6 157.1 217.6 163.3 211.3L219.3 155.3C225.6 149.1 225.6 138.9 219.3 132.7L163.3 76.69C157.1 70.44 146.9 70.44 140.7 76.69C134.4 82.94 134.4 93.07 140.7 99.31V99.31zM301 64.42L381.2 6.12C392.4-2.04 407.6-2.04 418.8 6.12L594.8 134.1C606 142.3 610.7 156.7 606.4 169.9C602.1 183.1 589.9 192 576 192H559.4L559.7 276.4C557.5 274.8 555.3 273.2 553.2 271.5C531 252.8 498.9 251.4 475.2 268.1C457.2 280.5 435 288.5 416 288.5C396.4 288.5 375.2 280.8 356.8 268.1C334.8 252.6 305.3 252.6 283.2 268.1C273.2 274.1 262 280.7 250.2 284.3C292.6 252.2 319.1 201.3 319.1 144C319.1 115.4 313.2 88.32 301 64.42V64.42zM416 336C442.9 336 471.4 325.2 493.4 309.9L493.5 309.9C505.4 301.4 521.5 302.1 532.7 311.6C547 323.5 565.2 332.6 583.3 336.8C600.5 340.8 611.2 358.1 607.2 375.3C603.2 392.5 585.1 403.2 568.7 399.2C544.2 393.4 523.9 382.6 510.5 374.2C481.5 389.7 449 400 416 400C384.1 400 355.4 390.1 335.6 381.1C329.7 378.5 324.5 375.8 320 373.4C315.5 375.8 310.3 378.5 304.4 381.1C284.6 390.1 255.9 400 224 400C190.1 400 158.5 389.7 129.5 374.2C116.1 382.6 95.79 393.4 71.27 399.2C54.06 403.2 36.85 392.5 32.84 375.3C28.83 358.1 39.53 340.8 56.74 336.8C74.84 332.6 92.96 323.5 107.3 311.6C118.5 302.1 134.6 301.4 146.5 309.9L146.6 309.9C168.7 325.2 197.1 336 224 336C251.5 336 279 325.4 301.5 309.9C312.6 302 327.4 302 338.5 309.9C360.1 325.4 388.5 336 416 336H416zM338.5 421.9C360.1 437.4 388.5 448 416 448C442.9 448 471.4 437.2 493.4 421.9L493.5 421.9C505.4 413.4 521.5 414.1 532.7 423.6C547 435.5 565.2 444.6 583.3 448.8C600.5 452.8 611.2 470.1 607.2 487.3C603.2 504.5 585.1 515.2 568.7 511.2C544.2 505.4 523.9 494.6 510.5 486.2C481.5 501.7 449 512 416 512C384.1 512 355.4 502.1 335.6 493.1C329.7 490.5 324.5 487.8 320 485.4C315.5 487.8 310.3 490.5 304.4 493.1C284.6 502.1 255.9 512 224 512C190.1 512 158.5 501.7 129.5 486.2C116.1 494.6 95.79 505.4 71.27 511.2C54.06 515.2 36.85 504.5 32.84 487.3C28.83 470.1 39.53 452.8 56.74 448.8C74.84 444.6 92.96 435.5 107.3 423.6C118.5 414.1 134.6 413.4 146.5 421.9L146.6 421.9C168.7 437.2 197.1 448 224 448C251.5 448 279 437.4 301.5 421.9C312.6 414 327.4 414 338.5 421.9H338.5z',
			),
		),
		'label'             => __( 'House Flood Water Circle Arrow Right', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'house-laptop'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M218.3 8.486C230.6-2.829 249.4-2.829 261.7 8.486L469.7 200.5C476.4 206.7 480 215.2 480 224H336C316.9 224 299.7 232.4 288 245.7V208C288 199.2 280.8 192 272 192H208C199.2 192 192 199.2 192 208V272C192 280.8 199.2 288 208 288H271.1V416H112C85.49 416 64 394.5 64 368V256H32C18.83 256 6.996 247.9 2.198 235.7C-2.6 223.4 .6145 209.4 10.3 200.5L218.3 8.486zM336 256H560C577.7 256 592 270.3 592 288V448H624C632.8 448 640 455.2 640 464C640 490.5 618.5 512 592 512H303.1C277.5 512 255.1 490.5 255.1 464C255.1 455.2 263.2 448 271.1 448H303.1V288C303.1 270.3 318.3 256 336 256zM352 304V448H544V304H352z',
			),
		),
		'label'             => __( 'House Laptop', 'astra' ),
		'custom_categories' => array(
			'business',
			'lifestyle-and-hobbies',
			'science-and-technology',
		),
	),
	'house-lock'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M384 480C384 491.7 387.1 502.6 392.6 512H392C369.9 512 352 494.1 352 472V384C352 366.3 337.7 352 320 352H256C238.3 352 224 366.3 224 384V472C224 494.1 206.1 512 184 512H128.1C126.6 512 125.1 511.9 123.6 511.8C122.4 511.9 121.2 512 120 512H104C81.91 512 64 494.1 64 472V360C64 359.1 64.03 358.1 64.09 357.2V287.6H32.05C14.02 287.6 0 273.5 0 255.5C0 246.5 3.004 238.5 10.01 231.5L266.4 8.016C273.4 1.002 281.4 0 288.4 0C295.4 0 303.4 2.004 309.5 7.014L490.7 166.3C447.2 181.7 416 223.2 416 272V296.6C396.9 307.6 384 328.3 384 352L384 480zM528 192C572.2 192 608 227.8 608 272V320C625.7 320 640 334.3 640 352V480C640 497.7 625.7 512 608 512H448C430.3 512 416 497.7 416 480V352C416 334.3 430.3 320 448 320V272C448 227.8 483.8 192 528 192zM528 240C510.3 240 496 254.3 496 272V320H560V272C560 254.3 545.7 240 528 240z',
			),
		),
		'label'             => __( 'House Lock', 'astra' ),
		'custom_categories' => array(
			'business',
			'lifestyle-and-hobbies',
			'science-and-technology',
		),
	),
	'house-medical'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M575.8 255.5C575.8 273.5 560.8 287.6 543.8 287.6H511.8L512.5 447.7C512.6 483.2 483.9 512 448.5 512H128.1C92.75 512 64.09 483.3 64.09 448V287.6H32.05C14.02 287.6 0 273.5 0 255.5C0 246.5 3.004 238.5 10.01 231.5L266.4 8.016C273.4 1.002 281.4 0 288.4 0C295.4 0 303.4 2.004 309.5 7.014L564.8 231.5C572.8 238.5 576.9 246.5 575.8 255.5H575.8zM328 232V176C328 167.2 320.8 160 312 160H264C255.2 160 248 167.2 248 176V232H192C183.2 232 176 239.2 176 248V296C176 304.8 183.2 312 192 312H248V368C248 376.8 255.2 384 264 384H312C320.8 384 328 376.8 328 368V312H384C392.8 312 400 304.8 400 296V248C400 239.2 392.8 232 384 232H328z',
			),
		),
		'label'             => __( 'House Medical', 'astra' ),
		'custom_categories' => array(
			'business',
			'science-and-technology',
		),
	),
	'house-medical-circle-check'           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M320.5 381.5C324.6 435.5 353 482.6 394.8 512H128.1C92.75 512 64.09 483.3 64.09 448V287.6H32.05C14.02 287.6 0 273.5 0 255.5C0 246.5 3.004 238.5 10.01 231.5L266.4 8.016C273.4 1.002 281.4 0 288.4 0C295.4 0 303.4 2.004 309.5 7.014L522.1 193.9C513.6 192.7 504.9 192 496 192C453.6 192 414.7 207 384.3 232L384 232H328V176C328 167.2 320.8 160 311.1 160H263.1C255.2 160 247.1 167.2 247.1 176V232H191.1C183.2 232 175.1 239.2 175.1 248V296C175.1 304.8 183.2 312 191.1 312H247.1V368C247.1 376.8 255.2 384 263.1 384H311.1C315.1 384 318 383.1 320.5 381.5H320.5zM328 312H329.1C328.7 313.1 328.4 314.3 328 315.4V312zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM540.7 324.7L480 385.4L451.3 356.7C445.1 350.4 434.9 350.4 428.7 356.7C422.4 362.9 422.4 373.1 428.7 379.3L468.7 419.3C474.9 425.6 485.1 425.6 491.3 419.3L563.3 347.3C569.6 341.1 569.6 330.9 563.3 324.7C557.1 318.4 546.9 318.4 540.7 324.7H540.7z',
			),
		),
		'label'             => __( 'House Medical Circle Check', 'astra' ),
		'custom_categories' => array(
			'business',
			'science-and-technology',
		),
	),
	'house-medical-circle-exclamation'     => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M320.5 381.5C324.6 435.5 353 482.6 394.8 512H128.1C92.75 512 64.09 483.3 64.09 448V287.6H32.05C14.02 287.6 0 273.5 0 255.5C0 246.5 3.004 238.5 10.01 231.5L266.4 8.016C273.4 1.002 281.4 0 288.4 0C295.4 0 303.4 2.004 309.5 7.014L522.1 193.9C513.6 192.7 504.9 192 496 192C453.6 192 414.7 207 384.3 232L384 232H328V176C328 167.2 320.8 160 311.1 160H263.1C255.2 160 247.1 167.2 247.1 176V232H191.1C183.2 232 175.1 239.2 175.1 248V296C175.1 304.8 183.2 312 191.1 312H247.1V368C247.1 376.8 255.2 384 263.1 384H311.1C315.1 384 318 383.1 320.5 381.5H320.5zM328 312H329.1C328.7 313.1 328.4 314.3 328 315.4V312zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 464C509.3 464 520 453.3 520 440C520 426.7 509.3 416 496 416C482.7 416 472 426.7 472 440C472 453.3 482.7 464 496 464zM479.1 288V368C479.1 376.8 487.2 384 495.1 384C504.8 384 511.1 376.8 511.1 368V288C511.1 279.2 504.8 272 495.1 272C487.2 272 479.1 279.2 479.1 288z',
			),
		),
		'label'             => __( 'House Medical Circle Exclamation', 'astra' ),
		'custom_categories' => array(
			'business',
			'science-and-technology',
		),
	),
	'house-medical-circle-xmark'           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M320.5 381.5C324.6 435.5 353 482.6 394.8 512H128.1C92.75 512 64.09 483.3 64.09 448V287.6H32.05C14.02 287.6 0 273.5 0 255.5C0 246.5 3.004 238.5 10.01 231.5L266.4 8.016C273.4 1.002 281.4 0 288.4 0C295.4 0 303.4 2.004 309.5 7.014L522.1 193.9C513.6 192.7 504.9 192 496 192C453.6 192 414.7 207 384.3 232L384 232H328V176C328 167.2 320.8 160 311.1 160H263.1C255.2 160 247.1 167.2 247.1 176V232H191.1C183.2 232 175.1 239.2 175.1 248V296C175.1 304.8 183.2 312 191.1 312H247.1V368C247.1 376.8 255.2 384 263.1 384H311.1C315.1 384 318 383.1 320.5 381.5H320.5zM328 312H329.1C328.7 313.1 328.4 314.3 328 315.4V312zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM555.3 331.3C561.6 325.1 561.6 314.9 555.3 308.7C549.1 302.4 538.9 302.4 532.7 308.7L496 345.4L459.3 308.7C453.1 302.4 442.9 302.4 436.7 308.7C430.4 314.9 430.4 325.1 436.7 331.3L473.4 368L436.7 404.7C430.4 410.9 430.4 421.1 436.7 427.3C442.9 433.6 453.1 433.6 459.3 427.3L496 390.6L532.7 427.3C538.9 433.6 549.1 433.6 555.3 427.3C561.6 421.1 561.6 410.9 555.3 404.7L518.6 368L555.3 331.3z',
			),
		),
		'label'             => __( 'House Medical Circle Xmark', 'astra' ),
		'custom_categories' => array(
			'business',
			'science-and-technology',
		),
	),
	'house-medical-flag'                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M480 0C497.7 0 512 14.33 512 32H624C632.8 32 640 39.16 640 48V176C640 184.8 632.8 192 624 192H512V512H448V32C448 14.33 462.3 0 480 0V0zM416 512H416.1L416.8 512H96C78.33 512 64 497.7 64 480V288H31.1C18.61 288 6.631 279.7 1.985 267.1C-2.661 254.5 1.005 240.4 11.17 231.7L235.2 39.7C247.2 29.43 264.8 29.43 276.8 39.7L416 159V512zM223.1 256H175.1C167.2 256 159.1 263.2 159.1 272V304C159.1 312.8 167.2 320 175.1 320H223.1V368C223.1 376.8 231.2 384 239.1 384H271.1C280.8 384 287.1 376.8 287.1 368V320H336C344.8 320 352 312.8 352 304V272C352 263.2 344.8 256 336 256H287.1V208C287.1 199.2 280.8 192 271.1 192H239.1C231.2 192 223.1 199.2 223.1 208V256z',
			),
		),
		'label'             => __( 'House Medical Flag', 'astra' ),
		'custom_categories' => array(
			'business',
			'science-and-technology',
		),
	),
	'house-signal'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M314.3 8.486C326.6-2.829 345.4-2.829 357.7 8.486L565.7 200.5C575.4 209.4 578.6 223.4 573.8 235.7C569 247.9 557.2 256 544 256H512V368C512 394.5 490.5 416 464 416H296.4C272.7 317.5 195.4 239.1 97.06 215.8C98.58 210.1 101.7 204.7 106.3 200.5L314.3 8.486zM304 192C295.2 192 287.1 199.2 287.1 208V272C287.1 280.8 295.2 288 304 288H368C376.8 288 384 280.8 384 272V208C384 199.2 376.8 192 368 192H304zM256 488C256 501.3 245.3 512 232 512C218.7 512 208 501.3 208 488C208 386.4 125.6 304 24 304C10.75 304 0 293.3 0 280C0 266.7 10.75 256 24 256C152.1 256 256 359.9 256 488zM0 480C0 462.3 14.33 448 32 448C49.67 448 64 462.3 64 480C64 497.7 49.67 512 32 512C14.33 512 0 497.7 0 480zM0 376C0 362.7 10.75 352 24 352C99.11 352 160 412.9 160 488C160 501.3 149.3 512 136 512C122.7 512 112 501.3 112 488C112 439.4 72.6 400 24 400C10.75 400 0 389.3 0 376z',
			),
		),
		'label'             => __( 'House Signal', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'science-and-technology',
			'travel',
		),
	),
	'house-tsunami'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M184.4 96C207.4 96 229.3 101.1 248.1 110.3C264.1 117.7 271.9 136.8 264.4 152.8C256.1 168.8 237.9 175.7 221.9 168.3C210.6 162.1 197.9 160 184.4 160C135.5 160 95.1 199.5 95.1 248C95.1 287 121.6 320.2 157.1 331.7C167.1 334.5 179.6 336 191.1 336C192 336 192.1 336 192.1 336C219.6 335.1 247.1 325.4 269.5 309.9C280.6 302 295.4 302 306.5 309.9C328.1 325.4 356.5 336 384 336C410.9 336 439.4 325.2 461.4 309.9L461.5 309.9C473.4 301.4 489.5 302.1 500.7 311.6C515 323.5 533.2 332.6 551.3 336.8C568.5 340.8 579.2 358.1 575.2 375.3C571.2 392.5 553.1 403.2 536.7 399.2C512.2 393.4 491.9 382.6 478.5 374.2C449.5 389.7 417 400 384 400C352.1 400 323.4 390.1 303.6 381.1C297.7 378.5 292.5 375.8 288 373.4C283.5 375.8 278.3 378.5 272.4 381.1C252.6 390.1 223.9 400 192 400C190.2 400 188.3 399.1 186.5 399.9C185.8 399.1 185.1 400 184.4 400C169.8 400 155.6 397.9 142.2 394.1C53.52 372.1 .0006 291.6 .0006 200C.0006 87.99 95.18 0 209 0C232.8 0 255.8 3.823 277.2 10.9C294 16.44 303.1 34.54 297.6 51.32C292 68.1 273.9 77.21 257.2 71.67C242.2 66.72 225.1 64 209 64C152.6 64 104.9 93.82 80.81 136.5C108 111.4 144.4 96 184.4 96H184.4zM428.8 46.43C440.2 37.88 455.8 37.9 467.2 46.47L562.7 118.4C570.7 124.5 575.4 133.9 575.5 143.9L575.8 287.9C575.8 290.8 575.4 293.6 574.7 296.3C569.8 293.6 564.3 291.5 558.5 290.1C545.4 287.1 531.8 280.3 521.2 271.5C499 252.8 466.9 251.4 443.2 268.1C425.2 280.5 403 288.5 384 288.5C364.4 288.5 343.2 280.8 324.8 268.1C323.3 267 321.6 265.1 320 265V143.1C320 133.9 324.7 124.4 332.8 118.4L428.8 46.43zM461.4 421.9L461.5 421.9C473.4 413.4 489.5 414.1 500.7 423.6C515 435.5 533.2 444.6 551.3 448.8C568.5 452.8 579.2 470.1 575.2 487.3C571.2 504.5 553.1 515.2 536.7 511.2C512.2 505.4 491.9 494.6 478.5 486.2C449.5 501.7 417 512 384 512C352.1 512 323.4 502.1 303.6 493.1C297.7 490.5 292.5 487.8 288 485.4C283.5 487.8 278.3 490.5 272.4 493.1C252.6 502.1 223.9 512 192 512C158.1 512 126.5 501.7 97.5 486.2C84.12 494.6 63.79 505.4 39.27 511.2C22.06 515.2 4.853 504.5 .8422 487.3C-3.169 470.1 7.532 452.8 24.74 448.8C42.84 444.6 60.96 435.5 75.31 423.6C86.46 414.1 102.6 413.4 114.5 421.9L114.6 421.9C136.7 437.2 165.1 448 192 448C219.5 448 247 437.4 269.5 421.9C280.6 414 295.4 414 306.5 421.9C328.1 437.4 356.5 448 384 448C410.9 448 439.4 437.2 461.4 421.9H461.4z',
			),
		),
		'label'             => __( 'House Tsunami', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'house-user'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M575.8 255.5C575.8 273.5 560.8 287.6 543.8 287.6H511.8L512.5 447.7C512.6 483.2 483.9 512 448.5 512H128.1C92.75 512 64.09 483.3 64.09 448V287.6H32.05C14.02 287.6 0 273.5 0 255.5C0 246.5 3.004 238.5 10.01 231.5L266.4 8.016C273.4 1.002 281.4 0 288.4 0C295.4 0 303.4 2.004 309.5 7.014L564.8 231.5C572.8 238.5 576.9 246.5 575.8 255.5H575.8zM288 160C252.7 160 224 188.7 224 224C224 259.3 252.7 288 288 288C323.3 288 352 259.3 352 224C352 188.7 323.3 160 288 160zM256 320C211.8 320 176 355.8 176 400C176 408.8 183.2 416 192 416H384C392.8 416 400 408.8 400 400C400 355.8 364.2 320 320 320H256z',
			),
		),
		'label'             => __( 'House User', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'houzz'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M275.9 330.7H171.3V480H17V32h109.5v104.5l305.1 85.6V480H275.9z',
			),
		),
		'label'             => __( 'Houzz', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'hryvnia-sign'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M115.1 120.1C102.2 132 82.05 129.8 71.01 115.1C59.97 102.2 62.21 82.05 76.01 71.01L81.94 66.27C109.7 44.08 144.1 32 179.6 32H223C285.4 32 336 82.59 336 144.1C336 155.6 334.5 166.1 331.7 176H352C369.7 176 384 190.3 384 208C384 225.7 369.7 240 352 240H284.2C282.5 241.1 280.8 242.1 279.1 243.1L228.5 272H352C369.7 272 384 286.3 384 304C384 321.7 369.7 336 352 336H123.1C116 344.6 112 355.5 112 367C112 394.1 133.9 416 160.1 416H204.4C225.3 416 245.7 408.9 262.1 395.8L268 391C281.8 379.1 301.9 382.2 312.1 396C324 409.8 321.8 429.9 307.1 440.1L302.1 445.7C274.3 467.9 239.9 480 204.4 480H160.1C98.59 480 48 429.4 48 367C48 356.4 49.49 345.9 52.33 336H32C14.33 336 0 321.7 0 304C0 286.3 14.33 272 32 272H99.82C101.5 270.9 103.2 269.9 104.9 268.9L155.5 240H32C14.33 240 0 225.7 0 208C0 190.3 14.33 176 32 176H260.9C267.1 167.4 272 156.5 272 144.1C272 117.9 250.1 96 223 96H179.6C158.7 96 138.3 103.1 121.9 116.2L115.1 120.1z',
			),
		),
		'label'             => __( 'Hryvnia Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'html5'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M0 32l34.9 395.8L191.5 480l157.6-52.2L384 32H0zm308.2 127.9H124.4l4.1 49.4h175.6l-13.6 148.4-97.9 27v.3h-1.1l-98.7-27.3-6-75.8h47.7L138 320l53.5 14.5 53.7-14.5 6-62.2H84.3L71.5 112.2h241.1l-4.4 47.7z',
			),
		),
		'label'             => __( 'HTML 5 Logo', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'hubspot'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M267.4 211.6c-25.1 23.7-40.8 57.3-40.8 94.6 0 29.3 9.7 56.3 26 78L203.1 434c-4.4-1.6-9.1-2.5-14-2.5-10.8 0-20.9 4.2-28.5 11.8-7.6 7.6-11.8 17.8-11.8 28.6s4.2 20.9 11.8 28.5c7.6 7.6 17.8 11.6 28.5 11.6 10.8 0 20.9-3.9 28.6-11.6 7.6-7.6 11.8-17.8 11.8-28.5 0-4.2-.6-8.2-1.9-12.1l50-50.2c22 16.9 49.4 26.9 79.3 26.9 71.9 0 130-58.3 130-130.2 0-65.2-47.7-119.2-110.2-128.7V116c17.5-7.4 28.2-23.8 28.2-42.9 0-26.1-20.9-47.9-47-47.9S311.2 47 311.2 73.1c0 19.1 10.7 35.5 28.2 42.9v61.2c-15.2 2.1-29.6 6.7-42.7 13.6-27.6-20.9-117.5-85.7-168.9-124.8 1.2-4.4 2-9 2-13.8C129.8 23.4 106.3 0 77.4 0 48.6 0 25.2 23.4 25.2 52.2c0 28.9 23.4 52.3 52.2 52.3 9.8 0 18.9-2.9 26.8-7.6l163.2 114.7zm89.5 163.6c-38.1 0-69-30.9-69-69s30.9-69 69-69 69 30.9 69 69-30.9 69-69 69z',
			),
		),
		'label'             => __( 'HubSpot', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'hurricane'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M224 223.1c-17.75 0-32 14.25-32 32c0 17.75 14.25 32 32 32s32-14.25 32-32C256 238.2 241.8 223.1 224 223.1zM208 95.98l24.5-74.74c3.75-11.25-5.615-22.49-17.36-21.11C112 12.38 32 101.6 32 208c0 114.9 93.13 208 208 208l-24.5 74.73c-3.75 11.25 5.615 22.5 17.36 21.12C335.1 499.6 416 410.4 416 304C416 189.1 322.9 95.98 208 95.98zM224 351.1c-53 0-96-43-96-96s43-96 96-96s96 43 96 96S277 351.1 224 351.1z',
			),
		),
		'label'             => __( 'Hurricane', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'i'                                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M320 448c0 17.67-14.31 32-32 32H32c-17.69 0-32-14.33-32-32s14.31-32 32-32h96v-320H32c-17.69 0-32-14.33-32-32s14.31-32 32-32h256c17.69 0 32 14.33 32 32s-14.31 32-32 32h-96v320h96C305.7 416 320 430.3 320 448z',
			),
		),
		'label'             => __( 'I', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'i-cursor'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 256,
				'height' => 512,
				'path'   => 'M256 480c0 17.69-14.33 31.1-32 31.1c-38.41 0-72.52-17.35-96-44.23c-23.48 26.88-57.59 44.23-96 44.23c-17.67 0-32-14.31-32-31.1s14.33-32 32-32c35.3 0 64-28.72 64-64V288H64C46.33 288 32 273.7 32 256s14.33-32 32-32h32V128c0-35.28-28.7-64-64-64C14.33 64 0 49.69 0 32s14.33-32 32-32c38.41 0 72.52 17.35 96 44.23c23.48-26.88 57.59-44.23 96-44.23c17.67 0 32 14.31 32 32s-14.33 32-32 32c-35.3 0-64 28.72-64 64v96h32c17.67 0 32 14.31 32 32s-14.33 32-32 32h-32v96c0 35.28 28.7 64 64 64C241.7 448 256 462.3 256 480z',
			),
		),
		'label'             => __( 'I Cursor', 'astra' ),
		'custom_categories' => array(),
	),
	'ice-cream'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M96.06 288.3H351.9L252.6 493.8C250.1 499.2 246 503.8 240.1 507.1C235.9 510.3 230 512 224 512C217.1 512 212.1 510.3 207 507.1C201.1 503.8 197.9 499.2 195.4 493.8L96.06 288.3zM386.3 164C392.1 166.4 397.4 169.9 401.9 174.4C406.3 178.8 409.9 184.1 412.3 189.9C414.7 195.7 415.1 201.1 416 208.3C416 214.5 414.8 220.8 412.4 226.6C409.1 232.4 406.5 237.7 402 242.2C397.6 246.6 392.3 250.2 386.5 252.6C380.7 255 374.4 256.3 368.1 256.3H79.88C67.16 256.3 54.96 251.2 45.98 242.2C37 233.2 31.97 220.1 32 208.3C32.03 195.5 37.1 183.4 46.12 174.4C55.14 165.4 67.35 160.4 80.07 160.4H81.06C80.4 154.9 80.06 149.4 80.04 143.8C80.04 105.7 95.2 69.11 122.2 42.13C149.2 15.15 185.8 0 223.1 0C262.1 0 298.7 15.15 325.7 42.13C352.7 69.11 367.9 105.7 367.9 143.8C367.9 149.4 367.6 154.9 366.9 160.4H367.9C374.2 160.4 380.5 161.6 386.3 164z',
			),
		),
		'label'             => __( 'Ice Cream', 'astra' ),
		'custom_categories' => array(
			'education',
			'lifestyle-and-hobbies',
		),
	),
	'icicles'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M511.4 37.87l-87.54 467.6c-1.625 8.623-14.04 8.634-15.67 .0104L341.4 141.7L295.7 314.2c-2.375 7.624-12.98 7.624-15.36 0L246.3 180.9l-46.49 196.9c-1.875 8.373-13.64 8.373-15.51 0L139.1 190.5L103.6 314.5c-2.375 7.124-12.64 7.198-15.14 .0744L1.357 41.24C-4.768 20.75 10.61 0 31.98 0h448C500 0 515.2 18.25 511.4 37.87z',
			),
		),
		'label'             => __( 'Icicles', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'icons'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M500.3 7.251C507.7 13.33 512 22.41 512 31.1V175.1C512 202.5 483.3 223.1 447.1 223.1C412.7 223.1 383.1 202.5 383.1 175.1C383.1 149.5 412.7 127.1 447.1 127.1V71.03L351.1 90.23V207.1C351.1 234.5 323.3 255.1 287.1 255.1C252.7 255.1 223.1 234.5 223.1 207.1C223.1 181.5 252.7 159.1 287.1 159.1V63.1C287.1 48.74 298.8 35.61 313.7 32.62L473.7 .6198C483.1-1.261 492.9 1.173 500.3 7.251H500.3zM74.66 303.1L86.5 286.2C92.43 277.3 102.4 271.1 113.1 271.1H174.9C185.6 271.1 195.6 277.3 201.5 286.2L213.3 303.1H239.1C266.5 303.1 287.1 325.5 287.1 351.1V463.1C287.1 490.5 266.5 511.1 239.1 511.1H47.1C21.49 511.1-.0019 490.5-.0019 463.1V351.1C-.0019 325.5 21.49 303.1 47.1 303.1H74.66zM143.1 359.1C117.5 359.1 95.1 381.5 95.1 407.1C95.1 434.5 117.5 455.1 143.1 455.1C170.5 455.1 191.1 434.5 191.1 407.1C191.1 381.5 170.5 359.1 143.1 359.1zM440.3 367.1H496C502.7 367.1 508.6 372.1 510.1 378.4C513.3 384.6 511.6 391.7 506.5 396L378.5 508C372.9 512.1 364.6 513.3 358.6 508.9C352.6 504.6 350.3 496.6 353.3 489.7L391.7 399.1H336C329.3 399.1 323.4 395.9 321 389.6C318.7 383.4 320.4 376.3 325.5 371.1L453.5 259.1C459.1 255 467.4 254.7 473.4 259.1C479.4 263.4 481.6 271.4 478.7 278.3L440.3 367.1zM116.7 219.1L19.85 119.2C-8.112 90.26-6.614 42.31 24.85 15.34C51.82-8.137 93.26-3.642 118.2 21.83L128.2 32.32L137.7 21.83C162.7-3.642 203.6-8.137 231.6 15.34C262.6 42.31 264.1 90.26 236.1 119.2L139.7 219.1C133.2 225.6 122.7 225.6 116.7 219.1H116.7z',
			),
		),
		'label'             => __( 'Icons', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
			'social',
		),
	),
	'id-badge'                             => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M336 0h-288C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h288c26.51 0 48-21.49 48-48v-416C384 21.49 362.5 0 336 0zM192 160c35.35 0 64 28.65 64 64s-28.65 64-64 64S128 259.3 128 224S156.7 160 192 160zM288 416H96c-8.836 0-16-7.164-16-16C80 355.8 115.8 320 160 320h64c44.18 0 80 35.82 80 80C304 408.8 296.8 416 288 416zM240 96h-96C135.2 96 128 88.84 128 80S135.2 64 144 64h96C248.8 64 256 71.16 256 80S248.8 96 240 96z',
			),
			'regular' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M320 0H64C28.65 0 0 28.65 0 64v384c0 35.35 28.65 64 64 64h256c35.35 0 64-28.65 64-64V64C384 28.65 355.3 0 320 0zM336 448c0 8.836-7.164 16-16 16H64c-8.836 0-16-7.164-16-16V64c0-8.838 7.164-16 16-16h64V64c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32V48h64c8.836 0 16 7.162 16 16V448zM192 288c35.35 0 64-28.65 64-64s-28.65-64-64-64C156.7 160 128 188.7 128 224S156.7 288 192 288zM224 320H160c-44.18 0-80 35.82-80 80C80 408.8 87.16 416 96 416h192c8.836 0 16-7.164 16-16C304 355.8 268.2 320 224 320z',
			),
		),
		'label'             => __( 'Id Badge', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
			'science-and-technology',
		),
	),
	'id-card'                              => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M528 32h-480C21.49 32 0 53.49 0 80V96h576V80C576 53.49 554.5 32 528 32zM0 432C0 458.5 21.49 480 48 480h480c26.51 0 48-21.49 48-48V128H0V432zM368 192h128C504.8 192 512 199.2 512 208S504.8 224 496 224h-128C359.2 224 352 216.8 352 208S359.2 192 368 192zM368 256h128C504.8 256 512 263.2 512 272S504.8 288 496 288h-128C359.2 288 352 280.8 352 272S359.2 256 368 256zM368 320h128c8.836 0 16 7.164 16 16S504.8 352 496 352h-128c-8.836 0-16-7.164-16-16S359.2 320 368 320zM176 192c35.35 0 64 28.66 64 64s-28.65 64-64 64s-64-28.66-64-64S140.7 192 176 192zM112 352h128c26.51 0 48 21.49 48 48c0 8.836-7.164 16-16 16h-192C71.16 416 64 408.8 64 400C64 373.5 85.49 352 112 352z',
			),
			'regular' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M368 344h96c13.25 0 24-10.75 24-24s-10.75-24-24-24h-96c-13.25 0-24 10.75-24 24S354.8 344 368 344zM208 320c35.35 0 64-28.65 64-64c0-35.35-28.65-64-64-64s-64 28.65-64 64C144 291.3 172.7 320 208 320zM512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM528 416c0 8.822-7.178 16-16 16h-192c0-44.18-35.82-80-80-80h-64C131.8 352 96 387.8 96 432H64c-8.822 0-16-7.178-16-16V160h480V416zM368 264h96c13.25 0 24-10.75 24-24s-10.75-24-24-24h-96c-13.25 0-24 10.75-24 24S354.8 264 368 264z',
			),
		),
		'label'             => __( 'Id Card', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
			'science-and-technology',
		),
	),
	'id-card-clip'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M256 128h64c17.67 0 32-14.33 32-32V32c0-17.67-14.33-32-32-32H256C238.3 0 224 14.33 224 32v64C224 113.7 238.3 128 256 128zM528 64H384v48C384 138.5 362.5 160 336 160h-96C213.5 160 192 138.5 192 112V64H48C21.49 64 0 85.49 0 112v352C0 490.5 21.49 512 48 512h480c26.51 0 48-21.49 48-48v-352C576 85.49 554.5 64 528 64zM288 224c35.35 0 64 28.66 64 64s-28.65 64-64 64s-64-28.66-64-64S252.7 224 288 224zM384 448H192c-8.836 0-16-7.164-16-16C176 405.5 197.5 384 224 384h128c26.51 0 48 21.49 48 48C400 440.8 392.8 448 384 448z',
			),
		),
		'label'             => __( 'Id Card Clip', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'ideal'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M125.6 165.5a49.07 49.07 0 1 0 49.06 49.06A49.08 49.08 0 0 0 125.6 165.5zM86.15 425.8h78.94V285.3H86.15zm151.5-211.6c0-20-10-22.53-18.74-22.53H204.8V237.5h14.05C228.6 237.5 237.6 234.7 237.6 214.2zm201.7 46V168.9h22.75V237.5h33.69C486.5 113.1 388.6 86.19 299.7 86.19H204.8V169h14c25.6 0 41.5 17.35 41.5 45.26 0 28.81-15.52 46-41.5 46h-14V425.9h94.83c144.6 0 194.9-67.16 196.7-165.6zm-109.8 0H273.3V169h54.43v22.73H296v10.58h30V225H296V237.5h33.51zm74.66 0-5.16-17.67H369.3l-5.18 17.67H340.5L368 168.9h32.35l27.53 91.34zM299.6 32H32V480H299.6c161.9 0 251-79.73 251-224.5C550.6 172 518 32 299.6 32zm0 426.9H53.07V53.07H299.6c142.1 0 229.9 64.61 229.9 202.4C529.5 389.6 448.5 458.9 299.6 458.9zm83.86-264.9L376 219.9H392.4l-7.52-25.81z',
			),
		),
		'label'             => __( 'iDeal', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'igloo'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M320 160H48.5C100.2 82.82 188.1 32 288 32C298.8 32 309.5 32.6 320 33.76V160zM352 39.14C424.9 55.67 487.2 99.82 527.5 160H352V39.14zM96 192V320H0C0 274 10.77 230.6 29.94 192H96zM192 320H128V192H448V320H384V352H576V432C576 458.5 554.5 480 528 480H352V352C352 316.7 323.3 288 288 288C252.7 288 224 316.7 224 352V480H48C21.49 480 0 458.5 0 432V352H192V320zM480 192H546.1C565.2 230.6 576 274 576 320H480V192z',
			),
		),
		'label'             => __( 'Igloo', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'image'                                => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M447.1 32h-384C28.64 32-.0091 60.65-.0091 96v320c0 35.35 28.65 64 63.1 64h384c35.35 0 64-28.65 64-64V96C511.1 60.65 483.3 32 447.1 32zM111.1 96c26.51 0 48 21.49 48 48S138.5 192 111.1 192s-48-21.49-48-48S85.48 96 111.1 96zM446.1 407.6C443.3 412.8 437.9 416 432 416H82.01c-6.021 0-11.53-3.379-14.26-8.75c-2.73-5.367-2.215-11.81 1.334-16.68l70-96C142.1 290.4 146.9 288 152 288s9.916 2.441 12.93 6.574l32.46 44.51l93.3-139.1C293.7 194.7 298.7 192 304 192s10.35 2.672 13.31 7.125l128 192C448.6 396 448.9 402.3 446.1 407.6z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M152 120c-26.51 0-48 21.49-48 48s21.49 48 48 48s48-21.49 48-48S178.5 120 152 120zM447.1 32h-384C28.65 32-.0091 60.65-.0091 96v320c0 35.35 28.65 64 63.1 64h384c35.35 0 64-28.65 64-64V96C511.1 60.65 483.3 32 447.1 32zM463.1 409.3l-136.8-185.9C323.8 218.8 318.1 216 312 216c-6.113 0-11.82 2.768-15.21 7.379l-106.6 144.1l-37.09-46.1c-3.441-4.279-8.934-6.809-14.77-6.809c-5.842 0-11.33 2.529-14.78 6.809l-75.52 93.81c0-.0293 0 .0293 0 0L47.99 96c0-8.822 7.178-16 16-16h384c8.822 0 16 7.178 16 16V409.3z',
			),
		),
		'label'             => __( 'Image', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
			'social',
			'travel',
		),
	),
	'image-portrait'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M336 0h-288c-26.51 0-48 21.49-48 48v416C0 490.5 21.49 512 48 512h288c26.51 0 48-21.49 48-48v-416C384 21.49 362.5 0 336 0zM192 128c35.35 0 64 28.65 64 64s-28.65 64-64 64S128 227.3 128 192S156.7 128 192 128zM288 384H96c-8.836 0-16-7.164-16-16C80 323.8 115.8 288 160 288h64c44.18 0 80 35.82 80 80C304 376.8 296.8 384 288 384z',
			),
		),
		'label'             => __( 'Image Portrait', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
		),
	),
	'images'                               => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M528 32H144c-26.51 0-48 21.49-48 48v256c0 26.51 21.49 48 48 48H528c26.51 0 48-21.49 48-48v-256C576 53.49 554.5 32 528 32zM223.1 96c17.68 0 32 14.33 32 32S241.7 160 223.1 160c-17.67 0-32-14.33-32-32S206.3 96 223.1 96zM494.1 311.6C491.3 316.8 485.9 320 480 320H192c-6.023 0-11.53-3.379-14.26-8.75c-2.73-5.367-2.215-11.81 1.332-16.68l70-96C252.1 194.4 256.9 192 262 192c5.111 0 9.916 2.441 12.93 6.574l22.35 30.66l62.74-94.11C362.1 130.7 367.1 128 373.3 128c5.348 0 10.34 2.672 13.31 7.125l106.7 160C496.6 300 496.9 306.3 494.1 311.6zM456 432H120c-39.7 0-72-32.3-72-72v-240C48 106.8 37.25 96 24 96S0 106.8 0 120v240C0 426.2 53.83 480 120 480h336c13.25 0 24-10.75 24-24S469.3 432 456 432z',
			),
			'regular' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M512 32H160c-35.35 0-64 28.65-64 64v224c0 35.35 28.65 64 64 64H512c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM528 320c0 8.822-7.178 16-16 16h-16l-109.3-160.9C383.7 170.7 378.7 168 373.3 168c-5.352 0-10.35 2.672-13.31 7.125l-62.74 94.11L274.9 238.6C271.9 234.4 267.1 232 262 232c-5.109 0-9.914 2.441-12.93 6.574L176 336H160c-8.822 0-16-7.178-16-16V96c0-8.822 7.178-16 16-16H512c8.822 0 16 7.178 16 16V320zM224 112c-17.67 0-32 14.33-32 32s14.33 32 32 32c17.68 0 32-14.33 32-32S241.7 112 224 112zM456 480H120C53.83 480 0 426.2 0 360v-240C0 106.8 10.75 96 24 96S48 106.8 48 120v240c0 39.7 32.3 72 72 72h336c13.25 0 24 10.75 24 24S469.3 480 456 480z',
			),
		),
		'label'             => __( 'Images', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
			'social',
			'travel',
		),
	),
);

